"use strict";
// https://www.terraform.io/docs/providers/aws/r/sqs_queue.html
// generated from terraform resource schema
Object.defineProperty(exports, "__esModule", { value: true });
exports.SqsQueue = void 0;
const cdktf_1 = require("cdktf");
// Resource
class SqsQueue extends cdktf_1.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    constructor(scope, id, config = {}) {
        super(scope, id, {
            terraformResourceType: 'aws_sqs_queue',
            terraformGeneratorMetadata: {
                providerName: 'aws'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._contentBasedDeduplication = config.contentBasedDeduplication;
        this._delaySeconds = config.delaySeconds;
        this._fifoQueue = config.fifoQueue;
        this._kmsDataKeyReusePeriodSeconds = config.kmsDataKeyReusePeriodSeconds;
        this._kmsMasterKeyId = config.kmsMasterKeyId;
        this._maxMessageSize = config.maxMessageSize;
        this._messageRetentionSeconds = config.messageRetentionSeconds;
        this._name = config.name;
        this._namePrefix = config.namePrefix;
        this._policy = config.policy;
        this._receiveWaitTimeSeconds = config.receiveWaitTimeSeconds;
        this._redrivePolicy = config.redrivePolicy;
        this._tags = config.tags;
        this._visibilityTimeoutSeconds = config.visibilityTimeoutSeconds;
    }
    // ==========
    // ATTRIBUTES
    // ==========
    // arn - computed: true, optional: false, required: true
    get arn() {
        return this.getStringAttribute('arn');
    }
    get contentBasedDeduplication() {
        return this._contentBasedDeduplication;
    }
    set contentBasedDeduplication(value) {
        this._contentBasedDeduplication = value;
    }
    get delaySeconds() {
        return this._delaySeconds;
    }
    set delaySeconds(value) {
        this._delaySeconds = value;
    }
    get fifoQueue() {
        return this._fifoQueue;
    }
    set fifoQueue(value) {
        this._fifoQueue = value;
    }
    get id() {
        var _a;
        return (_a = this._id) !== null && _a !== void 0 ? _a : this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    get kmsDataKeyReusePeriodSeconds() {
        var _a;
        return (_a = this._kmsDataKeyReusePeriodSeconds) !== null && _a !== void 0 ? _a : this.getNumberAttribute('kms_data_key_reuse_period_seconds');
    }
    set kmsDataKeyReusePeriodSeconds(value) {
        this._kmsDataKeyReusePeriodSeconds = value;
    }
    get kmsMasterKeyId() {
        return this._kmsMasterKeyId;
    }
    set kmsMasterKeyId(value) {
        this._kmsMasterKeyId = value;
    }
    get maxMessageSize() {
        return this._maxMessageSize;
    }
    set maxMessageSize(value) {
        this._maxMessageSize = value;
    }
    get messageRetentionSeconds() {
        return this._messageRetentionSeconds;
    }
    set messageRetentionSeconds(value) {
        this._messageRetentionSeconds = value;
    }
    get name() {
        var _a;
        return (_a = this._name) !== null && _a !== void 0 ? _a : this.getStringAttribute('name');
    }
    set name(value) {
        this._name = value;
    }
    get namePrefix() {
        return this._namePrefix;
    }
    set namePrefix(value) {
        this._namePrefix = value;
    }
    get policy() {
        var _a;
        return (_a = this._policy) !== null && _a !== void 0 ? _a : this.getStringAttribute('policy');
    }
    set policy(value) {
        this._policy = value;
    }
    get receiveWaitTimeSeconds() {
        return this._receiveWaitTimeSeconds;
    }
    set receiveWaitTimeSeconds(value) {
        this._receiveWaitTimeSeconds = value;
    }
    get redrivePolicy() {
        return this._redrivePolicy;
    }
    set redrivePolicy(value) {
        this._redrivePolicy = value;
    }
    get tags() {
        return this._tags;
    }
    set tags(value) {
        this._tags = value;
    }
    get visibilityTimeoutSeconds() {
        return this._visibilityTimeoutSeconds;
    }
    set visibilityTimeoutSeconds(value) {
        this._visibilityTimeoutSeconds = value;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            content_based_deduplication: this._contentBasedDeduplication,
            delay_seconds: this._delaySeconds,
            fifo_queue: this._fifoQueue,
            kms_data_key_reuse_period_seconds: this._kmsDataKeyReusePeriodSeconds,
            kms_master_key_id: this._kmsMasterKeyId,
            max_message_size: this._maxMessageSize,
            message_retention_seconds: this._messageRetentionSeconds,
            name: this._name,
            name_prefix: this._namePrefix,
            policy: this._policy,
            receive_wait_time_seconds: this._receiveWaitTimeSeconds,
            redrive_policy: this._redrivePolicy,
            tags: this._tags,
            visibility_timeout_seconds: this._visibilityTimeoutSeconds,
        };
    }
}
exports.SqsQueue = SqsQueue;
//# sourceMappingURL=data:application/json;base64,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