import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface SsmActivationConfig extends TerraformMetaArguments {
    readonly description?: string;
    readonly expirationDate?: string;
    readonly iamRole: string;
    readonly name?: string;
    readonly registrationLimit?: number;
    readonly tags?: {
        [key: string]: string;
    };
}
export declare class SsmActivation extends TerraformResource {
    constructor(scope: Construct, id: string, config: SsmActivationConfig);
    get activationCode(): string;
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    private _expirationDate?;
    get expirationDate(): string | undefined;
    set expirationDate(value: string | undefined);
    get expired(): boolean;
    private _iamRole;
    get iamRole(): string;
    set iamRole(value: string);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _name?;
    get name(): string | undefined;
    set name(value: string | undefined);
    get registrationCount(): number;
    private _registrationLimit?;
    get registrationLimit(): number | undefined;
    set registrationLimit(value: number | undefined);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
