import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface SsmAssociationConfig extends TerraformMetaArguments {
    readonly associationName?: string;
    readonly automationTargetParameterName?: string;
    readonly complianceSeverity?: string;
    readonly documentVersion?: string;
    readonly instanceId?: string;
    readonly maxConcurrency?: string;
    readonly maxErrors?: string;
    readonly name: string;
    readonly parameters?: {
        [key: string]: string;
    };
    readonly scheduleExpression?: string;
    /** output_location block */
    readonly outputLocation?: SsmAssociationOutputLocation[];
    /** targets block */
    readonly targets?: SsmAssociationTargets[];
}
export interface SsmAssociationOutputLocation {
    readonly s3BucketName: string;
    readonly s3KeyPrefix?: string;
}
export interface SsmAssociationTargets {
    readonly key: string;
    readonly values: string[];
}
export declare class SsmAssociation extends TerraformResource {
    constructor(scope: Construct, id: string, config: SsmAssociationConfig);
    get associationId(): string;
    private _associationName?;
    get associationName(): string | undefined;
    set associationName(value: string | undefined);
    private _automationTargetParameterName?;
    get automationTargetParameterName(): string | undefined;
    set automationTargetParameterName(value: string | undefined);
    private _complianceSeverity?;
    get complianceSeverity(): string | undefined;
    set complianceSeverity(value: string | undefined);
    private _documentVersion?;
    get documentVersion(): string | undefined;
    set documentVersion(value: string | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _instanceId?;
    get instanceId(): string | undefined;
    set instanceId(value: string | undefined);
    private _maxConcurrency?;
    get maxConcurrency(): string | undefined;
    set maxConcurrency(value: string | undefined);
    private _maxErrors?;
    get maxErrors(): string | undefined;
    set maxErrors(value: string | undefined);
    private _name;
    get name(): string;
    set name(value: string);
    private _parameters?;
    get parameters(): {
        [key: string]: string;
    } | undefined;
    set parameters(value: {
        [key: string]: string;
    } | undefined);
    private _scheduleExpression?;
    get scheduleExpression(): string | undefined;
    set scheduleExpression(value: string | undefined);
    private _outputLocation?;
    get outputLocation(): SsmAssociationOutputLocation[] | undefined;
    set outputLocation(value: SsmAssociationOutputLocation[] | undefined);
    private _targets?;
    get targets(): SsmAssociationTargets[] | undefined;
    set targets(value: SsmAssociationTargets[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
