import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
import { ComplexComputedList } from "cdktf";
export interface SsmDocumentConfig extends TerraformMetaArguments {
    readonly content: string;
    readonly documentFormat?: string;
    readonly documentType: string;
    readonly name: string;
    readonly permissions?: {
        [key: string]: string;
    };
    readonly tags?: {
        [key: string]: string;
    };
    readonly targetType?: string;
    /** attachments_source block */
    readonly attachmentsSource?: SsmDocumentAttachmentsSource[];
}
export declare class SsmDocumentParameter extends ComplexComputedList {
    get defaultValue(): string;
    get description(): string;
    get name(): string;
    get type(): string;
}
export interface SsmDocumentAttachmentsSource {
    readonly key: string;
    readonly name?: string;
    readonly values: string[];
}
export declare class SsmDocument extends TerraformResource {
    constructor(scope: Construct, id: string, config: SsmDocumentConfig);
    get arn(): string;
    private _content;
    get content(): string;
    set content(value: string);
    get createdDate(): string;
    get defaultVersion(): string;
    get description(): string;
    private _documentFormat?;
    get documentFormat(): string | undefined;
    set documentFormat(value: string | undefined);
    private _documentType;
    get documentType(): string;
    set documentType(value: string);
    get documentVersion(): string;
    get hash(): string;
    get hashType(): string;
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    get latestVersion(): string;
    private _name;
    get name(): string;
    set name(value: string);
    get owner(): string;
    parameter(index: string): SsmDocumentParameter;
    private _permissions?;
    get permissions(): {
        [key: string]: string;
    } | undefined;
    set permissions(value: {
        [key: string]: string;
    } | undefined);
    get platformTypes(): string[];
    get schemaVersion(): string;
    get status(): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _targetType?;
    get targetType(): string | undefined;
    set targetType(value: string | undefined);
    private _attachmentsSource?;
    get attachmentsSource(): SsmDocumentAttachmentsSource[] | undefined;
    set attachmentsSource(value: SsmDocumentAttachmentsSource[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
