import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface SsmMaintenanceWindowTargetConfig extends TerraformMetaArguments {
    readonly description?: string;
    readonly name?: string;
    readonly ownerInformation?: string;
    readonly resourceType: string;
    readonly windowId: string;
    /** targets block */
    readonly targets: SsmMaintenanceWindowTargetTargets[];
}
export interface SsmMaintenanceWindowTargetTargets {
    readonly key: string;
    readonly values: string[];
}
export declare class SsmMaintenanceWindowTarget extends TerraformResource {
    constructor(scope: Construct, id: string, config: SsmMaintenanceWindowTargetConfig);
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _name?;
    get name(): string | undefined;
    set name(value: string | undefined);
    private _ownerInformation?;
    get ownerInformation(): string | undefined;
    set ownerInformation(value: string | undefined);
    private _resourceType;
    get resourceType(): string;
    set resourceType(value: string);
    private _windowId;
    get windowId(): string;
    set windowId(value: string);
    private _targets;
    get targets(): SsmMaintenanceWindowTargetTargets[];
    set targets(value: SsmMaintenanceWindowTargetTargets[]);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
