import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface SsmMaintenanceWindowTaskConfig extends TerraformMetaArguments {
    readonly description?: string;
    readonly maxConcurrency: string;
    readonly maxErrors: string;
    readonly name?: string;
    readonly priority?: number;
    readonly serviceRoleArn: string;
    readonly taskArn: string;
    readonly taskType: string;
    readonly windowId: string;
    /** logging_info block */
    readonly loggingInfo?: SsmMaintenanceWindowTaskLoggingInfo[];
    /** targets block */
    readonly targets: SsmMaintenanceWindowTaskTargets[];
    /** task_invocation_parameters block */
    readonly taskInvocationParameters?: SsmMaintenanceWindowTaskTaskInvocationParameters[];
    /** task_parameters block */
    readonly taskParameters?: SsmMaintenanceWindowTaskTaskParameters[];
}
export interface SsmMaintenanceWindowTaskLoggingInfo {
    readonly s3BucketName: string;
    readonly s3BucketPrefix?: string;
    readonly s3Region: string;
}
export interface SsmMaintenanceWindowTaskTargets {
    readonly key: string;
    readonly values: string[];
}
export interface SsmMaintenanceWindowTaskTaskInvocationParametersAutomationParametersParameter {
    readonly name: string;
    readonly values: string[];
}
export interface SsmMaintenanceWindowTaskTaskInvocationParametersAutomationParameters {
    readonly documentVersion?: string;
    /** parameter block */
    readonly parameter?: SsmMaintenanceWindowTaskTaskInvocationParametersAutomationParametersParameter[];
}
export interface SsmMaintenanceWindowTaskTaskInvocationParametersLambdaParameters {
    readonly clientContext?: string;
    readonly payload?: string;
    readonly qualifier?: string;
}
export interface SsmMaintenanceWindowTaskTaskInvocationParametersRunCommandParametersNotificationConfig {
    readonly notificationArn?: string;
    readonly notificationEvents?: string[];
    readonly notificationType?: string;
}
export interface SsmMaintenanceWindowTaskTaskInvocationParametersRunCommandParametersParameter {
    readonly name: string;
    readonly values: string[];
}
export interface SsmMaintenanceWindowTaskTaskInvocationParametersRunCommandParameters {
    readonly comment?: string;
    readonly documentHash?: string;
    readonly documentHashType?: string;
    readonly outputS3Bucket?: string;
    readonly outputS3KeyPrefix?: string;
    readonly serviceRoleArn?: string;
    readonly timeoutSeconds?: number;
    /** notification_config block */
    readonly notificationConfig?: SsmMaintenanceWindowTaskTaskInvocationParametersRunCommandParametersNotificationConfig[];
    /** parameter block */
    readonly parameter?: SsmMaintenanceWindowTaskTaskInvocationParametersRunCommandParametersParameter[];
}
export interface SsmMaintenanceWindowTaskTaskInvocationParametersStepFunctionsParameters {
    readonly input?: string;
    readonly name?: string;
}
export interface SsmMaintenanceWindowTaskTaskInvocationParameters {
    /** automation_parameters block */
    readonly automationParameters?: SsmMaintenanceWindowTaskTaskInvocationParametersAutomationParameters[];
    /** lambda_parameters block */
    readonly lambdaParameters?: SsmMaintenanceWindowTaskTaskInvocationParametersLambdaParameters[];
    /** run_command_parameters block */
    readonly runCommandParameters?: SsmMaintenanceWindowTaskTaskInvocationParametersRunCommandParameters[];
    /** step_functions_parameters block */
    readonly stepFunctionsParameters?: SsmMaintenanceWindowTaskTaskInvocationParametersStepFunctionsParameters[];
}
export interface SsmMaintenanceWindowTaskTaskParameters {
    readonly name: string;
    readonly values: string[];
}
export declare class SsmMaintenanceWindowTask extends TerraformResource {
    constructor(scope: Construct, id: string, config: SsmMaintenanceWindowTaskConfig);
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _maxConcurrency;
    get maxConcurrency(): string;
    set maxConcurrency(value: string);
    private _maxErrors;
    get maxErrors(): string;
    set maxErrors(value: string);
    private _name?;
    get name(): string | undefined;
    set name(value: string | undefined);
    private _priority?;
    get priority(): number | undefined;
    set priority(value: number | undefined);
    private _serviceRoleArn;
    get serviceRoleArn(): string;
    set serviceRoleArn(value: string);
    private _taskArn;
    get taskArn(): string;
    set taskArn(value: string);
    private _taskType;
    get taskType(): string;
    set taskType(value: string);
    private _windowId;
    get windowId(): string;
    set windowId(value: string);
    private _loggingInfo?;
    get loggingInfo(): SsmMaintenanceWindowTaskLoggingInfo[] | undefined;
    set loggingInfo(value: SsmMaintenanceWindowTaskLoggingInfo[] | undefined);
    private _targets;
    get targets(): SsmMaintenanceWindowTaskTargets[];
    set targets(value: SsmMaintenanceWindowTaskTargets[]);
    private _taskInvocationParameters?;
    get taskInvocationParameters(): SsmMaintenanceWindowTaskTaskInvocationParameters[] | undefined;
    set taskInvocationParameters(value: SsmMaintenanceWindowTaskTaskInvocationParameters[] | undefined);
    private _taskParameters?;
    get taskParameters(): SsmMaintenanceWindowTaskTaskParameters[] | undefined;
    set taskParameters(value: SsmMaintenanceWindowTaskTaskParameters[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
