"use strict";
// https://www.terraform.io/docs/providers/aws/r/ssm_maintenance_window_task.html
// generated from terraform resource schema
Object.defineProperty(exports, "__esModule", { value: true });
exports.SsmMaintenanceWindowTask = void 0;
const cdktf_1 = require("cdktf");
// Resource
class SsmMaintenanceWindowTask extends cdktf_1.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'aws_ssm_maintenance_window_task',
            terraformGeneratorMetadata: {
                providerName: 'aws'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._description = config.description;
        this._maxConcurrency = config.maxConcurrency;
        this._maxErrors = config.maxErrors;
        this._name = config.name;
        this._priority = config.priority;
        this._serviceRoleArn = config.serviceRoleArn;
        this._taskArn = config.taskArn;
        this._taskType = config.taskType;
        this._windowId = config.windowId;
        this._loggingInfo = config.loggingInfo;
        this._targets = config.targets;
        this._taskInvocationParameters = config.taskInvocationParameters;
        this._taskParameters = config.taskParameters;
    }
    get description() {
        return this._description;
    }
    set description(value) {
        this._description = value;
    }
    get id() {
        var _a;
        return (_a = this._id) !== null && _a !== void 0 ? _a : this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    get maxConcurrency() {
        return this._maxConcurrency;
    }
    set maxConcurrency(value) {
        this._maxConcurrency = value;
    }
    get maxErrors() {
        return this._maxErrors;
    }
    set maxErrors(value) {
        this._maxErrors = value;
    }
    get name() {
        return this._name;
    }
    set name(value) {
        this._name = value;
    }
    get priority() {
        return this._priority;
    }
    set priority(value) {
        this._priority = value;
    }
    get serviceRoleArn() {
        return this._serviceRoleArn;
    }
    set serviceRoleArn(value) {
        this._serviceRoleArn = value;
    }
    get taskArn() {
        return this._taskArn;
    }
    set taskArn(value) {
        this._taskArn = value;
    }
    get taskType() {
        return this._taskType;
    }
    set taskType(value) {
        this._taskType = value;
    }
    get windowId() {
        return this._windowId;
    }
    set windowId(value) {
        this._windowId = value;
    }
    get loggingInfo() {
        return this._loggingInfo;
    }
    set loggingInfo(value) {
        this._loggingInfo = value;
    }
    get targets() {
        return this._targets;
    }
    set targets(value) {
        this._targets = value;
    }
    get taskInvocationParameters() {
        return this._taskInvocationParameters;
    }
    set taskInvocationParameters(value) {
        this._taskInvocationParameters = value;
    }
    get taskParameters() {
        return this._taskParameters;
    }
    set taskParameters(value) {
        this._taskParameters = value;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            description: this._description,
            max_concurrency: this._maxConcurrency,
            max_errors: this._maxErrors,
            name: this._name,
            priority: this._priority,
            service_role_arn: this._serviceRoleArn,
            task_arn: this._taskArn,
            task_type: this._taskType,
            window_id: this._windowId,
            logging_info: this._loggingInfo,
            targets: this._targets,
            task_invocation_parameters: this._taskInvocationParameters,
            task_parameters: this._taskParameters,
        };
    }
}
exports.SsmMaintenanceWindowTask = SsmMaintenanceWindowTask;
//# sourceMappingURL=data:application/json;base64,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