import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface SsmMaintenanceWindowConfig extends TerraformMetaArguments {
    readonly allowUnassociatedTargets?: boolean;
    readonly cutoff: number;
    readonly description?: string;
    readonly duration: number;
    readonly enabled?: boolean;
    readonly endDate?: string;
    readonly name: string;
    readonly schedule: string;
    readonly scheduleTimezone?: string;
    readonly startDate?: string;
    readonly tags?: {
        [key: string]: string;
    };
}
export declare class SsmMaintenanceWindow extends TerraformResource {
    constructor(scope: Construct, id: string, config: SsmMaintenanceWindowConfig);
    private _allowUnassociatedTargets?;
    get allowUnassociatedTargets(): boolean | undefined;
    set allowUnassociatedTargets(value: boolean | undefined);
    private _cutoff;
    get cutoff(): number;
    set cutoff(value: number);
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    private _duration;
    get duration(): number;
    set duration(value: number);
    private _enabled?;
    get enabled(): boolean | undefined;
    set enabled(value: boolean | undefined);
    private _endDate?;
    get endDate(): string | undefined;
    set endDate(value: string | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _name;
    get name(): string;
    set name(value: string);
    private _schedule;
    get schedule(): string;
    set schedule(value: string);
    private _scheduleTimezone?;
    get scheduleTimezone(): string | undefined;
    set scheduleTimezone(value: string | undefined);
    private _startDate?;
    get startDate(): string | undefined;
    set startDate(value: string | undefined);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
