import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface SsmParameterConfig extends TerraformMetaArguments {
    readonly allowedPattern?: string;
    readonly description?: string;
    readonly keyId?: string;
    readonly name: string;
    readonly overwrite?: boolean;
    readonly tags?: {
        [key: string]: string;
    };
    readonly tier?: string;
    readonly type: string;
    readonly value: string;
}
export declare class SsmParameter extends TerraformResource {
    constructor(scope: Construct, id: string, config: SsmParameterConfig);
    private _allowedPattern?;
    get allowedPattern(): string | undefined;
    set allowedPattern(value: string | undefined);
    private _arn?;
    get arn(): string | undefined;
    set arn(value: string | undefined);
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _keyId?;
    get keyId(): string | undefined;
    set keyId(value: string | undefined);
    private _name;
    get name(): string;
    set name(value: string);
    private _overwrite?;
    get overwrite(): boolean | undefined;
    set overwrite(value: boolean | undefined);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _tier?;
    get tier(): string | undefined;
    set tier(value: string | undefined);
    private _type;
    get type(): string;
    set type(value: string);
    private _value;
    get value(): string;
    set value(value: string);
    get version(): number;
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
