import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface SsmPatchBaselineConfig extends TerraformMetaArguments {
    readonly approvedPatches?: string[];
    readonly approvedPatchesComplianceLevel?: string;
    readonly description?: string;
    readonly name: string;
    readonly operatingSystem?: string;
    readonly rejectedPatches?: string[];
    readonly tags?: {
        [key: string]: string;
    };
    /** approval_rule block */
    readonly approvalRule?: SsmPatchBaselineApprovalRule[];
    /** global_filter block */
    readonly globalFilter?: SsmPatchBaselineGlobalFilter[];
}
export interface SsmPatchBaselineApprovalRulePatchFilter {
    readonly key: string;
    readonly values: string[];
}
export interface SsmPatchBaselineApprovalRule {
    readonly approveAfterDays: number;
    readonly complianceLevel?: string;
    readonly enableNonSecurity?: boolean;
    /** patch_filter block */
    readonly patchFilter: SsmPatchBaselineApprovalRulePatchFilter[];
}
export interface SsmPatchBaselineGlobalFilter {
    readonly key: string;
    readonly values: string[];
}
export declare class SsmPatchBaseline extends TerraformResource {
    constructor(scope: Construct, id: string, config: SsmPatchBaselineConfig);
    private _approvedPatches?;
    get approvedPatches(): string[] | undefined;
    set approvedPatches(value: string[] | undefined);
    private _approvedPatchesComplianceLevel?;
    get approvedPatchesComplianceLevel(): string | undefined;
    set approvedPatchesComplianceLevel(value: string | undefined);
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _name;
    get name(): string;
    set name(value: string);
    private _operatingSystem?;
    get operatingSystem(): string | undefined;
    set operatingSystem(value: string | undefined);
    private _rejectedPatches?;
    get rejectedPatches(): string[] | undefined;
    set rejectedPatches(value: string[] | undefined);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _approvalRule?;
    get approvalRule(): SsmPatchBaselineApprovalRule[] | undefined;
    set approvalRule(value: SsmPatchBaselineApprovalRule[] | undefined);
    private _globalFilter?;
    get globalFilter(): SsmPatchBaselineGlobalFilter[] | undefined;
    set globalFilter(value: SsmPatchBaselineGlobalFilter[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
