"use strict";
// https://www.terraform.io/docs/providers/aws/r/ssm_patch_baseline.html
// generated from terraform resource schema
Object.defineProperty(exports, "__esModule", { value: true });
exports.SsmPatchBaseline = void 0;
const cdktf_1 = require("cdktf");
// Resource
class SsmPatchBaseline extends cdktf_1.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'aws_ssm_patch_baseline',
            terraformGeneratorMetadata: {
                providerName: 'aws'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._approvedPatches = config.approvedPatches;
        this._approvedPatchesComplianceLevel = config.approvedPatchesComplianceLevel;
        this._description = config.description;
        this._name = config.name;
        this._operatingSystem = config.operatingSystem;
        this._rejectedPatches = config.rejectedPatches;
        this._tags = config.tags;
        this._approvalRule = config.approvalRule;
        this._globalFilter = config.globalFilter;
    }
    get approvedPatches() {
        return this._approvedPatches;
    }
    set approvedPatches(value) {
        this._approvedPatches = value;
    }
    get approvedPatchesComplianceLevel() {
        return this._approvedPatchesComplianceLevel;
    }
    set approvedPatchesComplianceLevel(value) {
        this._approvedPatchesComplianceLevel = value;
    }
    get description() {
        return this._description;
    }
    set description(value) {
        this._description = value;
    }
    get id() {
        var _a;
        return (_a = this._id) !== null && _a !== void 0 ? _a : this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    get name() {
        return this._name;
    }
    set name(value) {
        this._name = value;
    }
    get operatingSystem() {
        return this._operatingSystem;
    }
    set operatingSystem(value) {
        this._operatingSystem = value;
    }
    get rejectedPatches() {
        return this._rejectedPatches;
    }
    set rejectedPatches(value) {
        this._rejectedPatches = value;
    }
    get tags() {
        return this._tags;
    }
    set tags(value) {
        this._tags = value;
    }
    get approvalRule() {
        return this._approvalRule;
    }
    set approvalRule(value) {
        this._approvalRule = value;
    }
    get globalFilter() {
        return this._globalFilter;
    }
    set globalFilter(value) {
        this._globalFilter = value;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            approved_patches: this._approvedPatches,
            approved_patches_compliance_level: this._approvedPatchesComplianceLevel,
            description: this._description,
            name: this._name,
            operating_system: this._operatingSystem,
            rejected_patches: this._rejectedPatches,
            tags: this._tags,
            approval_rule: this._approvalRule,
            global_filter: this._globalFilter,
        };
    }
}
exports.SsmPatchBaseline = SsmPatchBaseline;
//# sourceMappingURL=data:application/json;base64,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