import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface SsmResourceDataSyncConfig extends TerraformMetaArguments {
    readonly name: string;
    /** s3_destination block */
    readonly s3Destination: SsmResourceDataSyncS3Destination[];
}
export interface SsmResourceDataSyncS3Destination {
    readonly bucketName: string;
    readonly kmsKeyArn?: string;
    readonly prefix?: string;
    readonly region: string;
    readonly syncFormat?: string;
}
export declare class SsmResourceDataSync extends TerraformResource {
    constructor(scope: Construct, id: string, config: SsmResourceDataSyncConfig);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _name;
    get name(): string;
    set name(value: string);
    private _s3Destination;
    get s3Destination(): SsmResourceDataSyncS3Destination[];
    set s3Destination(value: SsmResourceDataSyncS3Destination[]);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
