import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface StoragegatewayCachedIscsiVolumeConfig extends TerraformMetaArguments {
    readonly gatewayArn: string;
    readonly networkInterfaceId: string;
    readonly snapshotId?: string;
    readonly sourceVolumeArn?: string;
    readonly tags?: {
        [key: string]: string;
    };
    readonly targetName: string;
    readonly volumeSizeInBytes: number;
}
export declare class StoragegatewayCachedIscsiVolume extends TerraformResource {
    constructor(scope: Construct, id: string, config: StoragegatewayCachedIscsiVolumeConfig);
    get arn(): string;
    get chapEnabled(): boolean;
    private _gatewayArn;
    get gatewayArn(): string;
    set gatewayArn(value: string);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    get lunNumber(): number;
    private _networkInterfaceId;
    get networkInterfaceId(): string;
    set networkInterfaceId(value: string);
    get networkInterfacePort(): number;
    private _snapshotId?;
    get snapshotId(): string | undefined;
    set snapshotId(value: string | undefined);
    private _sourceVolumeArn?;
    get sourceVolumeArn(): string | undefined;
    set sourceVolumeArn(value: string | undefined);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    get targetArn(): string;
    private _targetName;
    get targetName(): string;
    set targetName(value: string);
    get volumeArn(): string;
    get volumeId(): string;
    private _volumeSizeInBytes;
    get volumeSizeInBytes(): number;
    set volumeSizeInBytes(value: number);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
