import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface StoragegatewayGatewayConfig extends TerraformMetaArguments {
    readonly activationKey?: string;
    readonly cloudwatchLogGroupArn?: string;
    readonly gatewayIpAddress?: string;
    readonly gatewayName: string;
    readonly gatewayTimezone: string;
    readonly gatewayType?: string;
    readonly gatewayVpcEndpoint?: string;
    readonly mediumChangerType?: string;
    readonly smbGuestPassword?: string;
    readonly tags?: {
        [key: string]: string;
    };
    readonly tapeDriveType?: string;
    /** smb_active_directory_settings block */
    readonly smbActiveDirectorySettings?: StoragegatewayGatewaySmbActiveDirectorySettings[];
    /** timeouts block */
    readonly timeouts?: StoragegatewayGatewayTimeouts;
}
export interface StoragegatewayGatewaySmbActiveDirectorySettings {
    readonly domainName: string;
    readonly password: string;
    readonly username: string;
}
export interface StoragegatewayGatewayTimeouts {
    readonly create?: string;
}
export declare class StoragegatewayGateway extends TerraformResource {
    constructor(scope: Construct, id: string, config: StoragegatewayGatewayConfig);
    private _activationKey?;
    get activationKey(): string | undefined;
    set activationKey(value: string | undefined);
    get arn(): string;
    private _cloudwatchLogGroupArn?;
    get cloudwatchLogGroupArn(): string | undefined;
    set cloudwatchLogGroupArn(value: string | undefined);
    get gatewayId(): string;
    private _gatewayIpAddress?;
    get gatewayIpAddress(): string | undefined;
    set gatewayIpAddress(value: string | undefined);
    private _gatewayName;
    get gatewayName(): string;
    set gatewayName(value: string);
    private _gatewayTimezone;
    get gatewayTimezone(): string;
    set gatewayTimezone(value: string);
    private _gatewayType?;
    get gatewayType(): string | undefined;
    set gatewayType(value: string | undefined);
    private _gatewayVpcEndpoint?;
    get gatewayVpcEndpoint(): string | undefined;
    set gatewayVpcEndpoint(value: string | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _mediumChangerType?;
    get mediumChangerType(): string | undefined;
    set mediumChangerType(value: string | undefined);
    private _smbGuestPassword?;
    get smbGuestPassword(): string | undefined;
    set smbGuestPassword(value: string | undefined);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _tapeDriveType?;
    get tapeDriveType(): string | undefined;
    set tapeDriveType(value: string | undefined);
    private _smbActiveDirectorySettings?;
    get smbActiveDirectorySettings(): StoragegatewayGatewaySmbActiveDirectorySettings[] | undefined;
    set smbActiveDirectorySettings(value: StoragegatewayGatewaySmbActiveDirectorySettings[] | undefined);
    private _timeouts?;
    get timeouts(): StoragegatewayGatewayTimeouts | undefined;
    set timeouts(value: StoragegatewayGatewayTimeouts | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
