"use strict";
// https://www.terraform.io/docs/providers/aws/r/storagegateway_gateway.html
// generated from terraform resource schema
Object.defineProperty(exports, "__esModule", { value: true });
exports.StoragegatewayGateway = void 0;
const cdktf_1 = require("cdktf");
// Resource
class StoragegatewayGateway extends cdktf_1.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'aws_storagegateway_gateway',
            terraformGeneratorMetadata: {
                providerName: 'aws'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._activationKey = config.activationKey;
        this._cloudwatchLogGroupArn = config.cloudwatchLogGroupArn;
        this._gatewayIpAddress = config.gatewayIpAddress;
        this._gatewayName = config.gatewayName;
        this._gatewayTimezone = config.gatewayTimezone;
        this._gatewayType = config.gatewayType;
        this._gatewayVpcEndpoint = config.gatewayVpcEndpoint;
        this._mediumChangerType = config.mediumChangerType;
        this._smbGuestPassword = config.smbGuestPassword;
        this._tags = config.tags;
        this._tapeDriveType = config.tapeDriveType;
        this._smbActiveDirectorySettings = config.smbActiveDirectorySettings;
        this._timeouts = config.timeouts;
    }
    get activationKey() {
        var _a;
        return (_a = this._activationKey) !== null && _a !== void 0 ? _a : this.getStringAttribute('activation_key');
    }
    set activationKey(value) {
        this._activationKey = value;
    }
    // arn - computed: true, optional: false, required: true
    get arn() {
        return this.getStringAttribute('arn');
    }
    get cloudwatchLogGroupArn() {
        return this._cloudwatchLogGroupArn;
    }
    set cloudwatchLogGroupArn(value) {
        this._cloudwatchLogGroupArn = value;
    }
    // gateway_id - computed: true, optional: false, required: true
    get gatewayId() {
        return this.getStringAttribute('gateway_id');
    }
    get gatewayIpAddress() {
        var _a;
        return (_a = this._gatewayIpAddress) !== null && _a !== void 0 ? _a : this.getStringAttribute('gateway_ip_address');
    }
    set gatewayIpAddress(value) {
        this._gatewayIpAddress = value;
    }
    get gatewayName() {
        return this._gatewayName;
    }
    set gatewayName(value) {
        this._gatewayName = value;
    }
    get gatewayTimezone() {
        return this._gatewayTimezone;
    }
    set gatewayTimezone(value) {
        this._gatewayTimezone = value;
    }
    get gatewayType() {
        return this._gatewayType;
    }
    set gatewayType(value) {
        this._gatewayType = value;
    }
    get gatewayVpcEndpoint() {
        return this._gatewayVpcEndpoint;
    }
    set gatewayVpcEndpoint(value) {
        this._gatewayVpcEndpoint = value;
    }
    get id() {
        var _a;
        return (_a = this._id) !== null && _a !== void 0 ? _a : this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    get mediumChangerType() {
        return this._mediumChangerType;
    }
    set mediumChangerType(value) {
        this._mediumChangerType = value;
    }
    get smbGuestPassword() {
        return this._smbGuestPassword;
    }
    set smbGuestPassword(value) {
        this._smbGuestPassword = value;
    }
    get tags() {
        return this._tags;
    }
    set tags(value) {
        this._tags = value;
    }
    get tapeDriveType() {
        return this._tapeDriveType;
    }
    set tapeDriveType(value) {
        this._tapeDriveType = value;
    }
    get smbActiveDirectorySettings() {
        return this._smbActiveDirectorySettings;
    }
    set smbActiveDirectorySettings(value) {
        this._smbActiveDirectorySettings = value;
    }
    get timeouts() {
        return this._timeouts;
    }
    set timeouts(value) {
        this._timeouts = value;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            activation_key: this._activationKey,
            cloudwatch_log_group_arn: this._cloudwatchLogGroupArn,
            gateway_ip_address: this._gatewayIpAddress,
            gateway_name: this._gatewayName,
            gateway_timezone: this._gatewayTimezone,
            gateway_type: this._gatewayType,
            gateway_vpc_endpoint: this._gatewayVpcEndpoint,
            medium_changer_type: this._mediumChangerType,
            smb_guest_password: this._smbGuestPassword,
            tags: this._tags,
            tape_drive_type: this._tapeDriveType,
            smb_active_directory_settings: this._smbActiveDirectorySettings,
            timeouts: this._timeouts,
        };
    }
}
exports.StoragegatewayGateway = StoragegatewayGateway;
//# sourceMappingURL=data:application/json;base64,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