import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface StoragegatewayNfsFileShareConfig extends TerraformMetaArguments {
    readonly clientList: string[];
    readonly defaultStorageClass?: string;
    readonly gatewayArn: string;
    readonly guessMimeTypeEnabled?: boolean;
    readonly kmsEncrypted?: boolean;
    readonly kmsKeyArn?: string;
    readonly locationArn: string;
    readonly objectAcl?: string;
    readonly readOnly?: boolean;
    readonly requesterPays?: boolean;
    readonly roleArn: string;
    readonly squash?: string;
    readonly tags?: {
        [key: string]: string;
    };
    /** nfs_file_share_defaults block */
    readonly nfsFileShareDefaults?: StoragegatewayNfsFileShareNfsFileShareDefaults[];
    /** timeouts block */
    readonly timeouts?: StoragegatewayNfsFileShareTimeouts;
}
export interface StoragegatewayNfsFileShareNfsFileShareDefaults {
    readonly directoryMode?: string;
    readonly fileMode?: string;
    readonly groupId?: number;
    readonly ownerId?: number;
}
export interface StoragegatewayNfsFileShareTimeouts {
    readonly create?: string;
    readonly delete?: string;
    readonly update?: string;
}
export declare class StoragegatewayNfsFileShare extends TerraformResource {
    constructor(scope: Construct, id: string, config: StoragegatewayNfsFileShareConfig);
    get arn(): string;
    private _clientList;
    get clientList(): string[];
    set clientList(value: string[]);
    private _defaultStorageClass?;
    get defaultStorageClass(): string | undefined;
    set defaultStorageClass(value: string | undefined);
    get fileshareId(): string;
    private _gatewayArn;
    get gatewayArn(): string;
    set gatewayArn(value: string);
    private _guessMimeTypeEnabled?;
    get guessMimeTypeEnabled(): boolean | undefined;
    set guessMimeTypeEnabled(value: boolean | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _kmsEncrypted?;
    get kmsEncrypted(): boolean | undefined;
    set kmsEncrypted(value: boolean | undefined);
    private _kmsKeyArn?;
    get kmsKeyArn(): string | undefined;
    set kmsKeyArn(value: string | undefined);
    private _locationArn;
    get locationArn(): string;
    set locationArn(value: string);
    private _objectAcl?;
    get objectAcl(): string | undefined;
    set objectAcl(value: string | undefined);
    get path(): string;
    private _readOnly?;
    get readOnly(): boolean | undefined;
    set readOnly(value: boolean | undefined);
    private _requesterPays?;
    get requesterPays(): boolean | undefined;
    set requesterPays(value: boolean | undefined);
    private _roleArn;
    get roleArn(): string;
    set roleArn(value: string);
    private _squash?;
    get squash(): string | undefined;
    set squash(value: string | undefined);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _nfsFileShareDefaults?;
    get nfsFileShareDefaults(): StoragegatewayNfsFileShareNfsFileShareDefaults[] | undefined;
    set nfsFileShareDefaults(value: StoragegatewayNfsFileShareNfsFileShareDefaults[] | undefined);
    private _timeouts?;
    get timeouts(): StoragegatewayNfsFileShareTimeouts | undefined;
    set timeouts(value: StoragegatewayNfsFileShareTimeouts | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
