import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface StoragegatewaySmbFileShareConfig extends TerraformMetaArguments {
    readonly authentication?: string;
    readonly defaultStorageClass?: string;
    readonly gatewayArn: string;
    readonly guessMimeTypeEnabled?: boolean;
    readonly invalidUserList?: string[];
    readonly kmsEncrypted?: boolean;
    readonly kmsKeyArn?: string;
    readonly locationArn: string;
    readonly objectAcl?: string;
    readonly readOnly?: boolean;
    readonly requesterPays?: boolean;
    readonly roleArn: string;
    readonly tags?: {
        [key: string]: string;
    };
    readonly validUserList?: string[];
    /** timeouts block */
    readonly timeouts?: StoragegatewaySmbFileShareTimeouts;
}
export interface StoragegatewaySmbFileShareTimeouts {
    readonly create?: string;
    readonly delete?: string;
    readonly update?: string;
}
export declare class StoragegatewaySmbFileShare extends TerraformResource {
    constructor(scope: Construct, id: string, config: StoragegatewaySmbFileShareConfig);
    get arn(): string;
    private _authentication?;
    get authentication(): string | undefined;
    set authentication(value: string | undefined);
    private _defaultStorageClass?;
    get defaultStorageClass(): string | undefined;
    set defaultStorageClass(value: string | undefined);
    get fileshareId(): string;
    private _gatewayArn;
    get gatewayArn(): string;
    set gatewayArn(value: string);
    private _guessMimeTypeEnabled?;
    get guessMimeTypeEnabled(): boolean | undefined;
    set guessMimeTypeEnabled(value: boolean | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _invalidUserList?;
    get invalidUserList(): string[] | undefined;
    set invalidUserList(value: string[] | undefined);
    private _kmsEncrypted?;
    get kmsEncrypted(): boolean | undefined;
    set kmsEncrypted(value: boolean | undefined);
    private _kmsKeyArn?;
    get kmsKeyArn(): string | undefined;
    set kmsKeyArn(value: string | undefined);
    private _locationArn;
    get locationArn(): string;
    set locationArn(value: string);
    private _objectAcl?;
    get objectAcl(): string | undefined;
    set objectAcl(value: string | undefined);
    get path(): string;
    private _readOnly?;
    get readOnly(): boolean | undefined;
    set readOnly(value: boolean | undefined);
    private _requesterPays?;
    get requesterPays(): boolean | undefined;
    set requesterPays(value: boolean | undefined);
    private _roleArn;
    get roleArn(): string;
    set roleArn(value: string);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _validUserList?;
    get validUserList(): string[] | undefined;
    set validUserList(value: string[] | undefined);
    private _timeouts?;
    get timeouts(): StoragegatewaySmbFileShareTimeouts | undefined;
    set timeouts(value: StoragegatewaySmbFileShareTimeouts | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
