import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface SubnetConfig extends TerraformMetaArguments {
    readonly assignIpv6AddressOnCreation?: boolean;
    readonly availabilityZone?: string;
    readonly availabilityZoneId?: string;
    readonly cidrBlock: string;
    readonly ipv6CidrBlock?: string;
    readonly mapPublicIpOnLaunch?: boolean;
    readonly outpostArn?: string;
    readonly tags?: {
        [key: string]: string;
    };
    readonly vpcId: string;
    /** timeouts block */
    readonly timeouts?: SubnetTimeouts;
}
export interface SubnetTimeouts {
    readonly create?: string;
    readonly delete?: string;
}
export declare class Subnet extends TerraformResource {
    constructor(scope: Construct, id: string, config: SubnetConfig);
    get arn(): string;
    private _assignIpv6AddressOnCreation?;
    get assignIpv6AddressOnCreation(): boolean | undefined;
    set assignIpv6AddressOnCreation(value: boolean | undefined);
    private _availabilityZone?;
    get availabilityZone(): string | undefined;
    set availabilityZone(value: string | undefined);
    private _availabilityZoneId?;
    get availabilityZoneId(): string | undefined;
    set availabilityZoneId(value: string | undefined);
    private _cidrBlock;
    get cidrBlock(): string;
    set cidrBlock(value: string);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _ipv6CidrBlock?;
    get ipv6CidrBlock(): string | undefined;
    set ipv6CidrBlock(value: string | undefined);
    get ipv6CidrBlockAssociationId(): string;
    private _mapPublicIpOnLaunch?;
    get mapPublicIpOnLaunch(): boolean | undefined;
    set mapPublicIpOnLaunch(value: boolean | undefined);
    private _outpostArn?;
    get outpostArn(): string | undefined;
    set outpostArn(value: string | undefined);
    get ownerId(): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _vpcId;
    get vpcId(): string;
    set vpcId(value: string);
    private _timeouts?;
    get timeouts(): SubnetTimeouts | undefined;
    set timeouts(value: SubnetTimeouts | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
