import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface SwfDomainConfig extends TerraformMetaArguments {
    readonly description?: string;
    readonly name?: string;
    readonly namePrefix?: string;
    readonly tags?: {
        [key: string]: string;
    };
    readonly workflowExecutionRetentionPeriodInDays: string;
}
export declare class SwfDomain extends TerraformResource {
    constructor(scope: Construct, id: string, config: SwfDomainConfig);
    get arn(): string;
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _name?;
    get name(): string | undefined;
    set name(value: string | undefined);
    private _namePrefix?;
    get namePrefix(): string | undefined;
    set namePrefix(value: string | undefined);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _workflowExecutionRetentionPeriodInDays;
    get workflowExecutionRetentionPeriodInDays(): string;
    set workflowExecutionRetentionPeriodInDays(value: string);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
