import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface TransferServerConfig extends TerraformMetaArguments {
    readonly endpointType?: string;
    readonly forceDestroy?: boolean;
    readonly hostKey?: string;
    readonly identityProviderType?: string;
    readonly invocationRole?: string;
    readonly loggingRole?: string;
    readonly tags?: {
        [key: string]: string;
    };
    readonly url?: string;
    /** endpoint_details block */
    readonly endpointDetails?: TransferServerEndpointDetails[];
}
export interface TransferServerEndpointDetails {
    readonly vpcEndpointId: string;
}
export declare class TransferServer extends TerraformResource {
    constructor(scope: Construct, id: string, config?: TransferServerConfig);
    get arn(): string;
    get endpoint(): string;
    private _endpointType?;
    get endpointType(): string | undefined;
    set endpointType(value: string | undefined);
    private _forceDestroy?;
    get forceDestroy(): boolean | undefined;
    set forceDestroy(value: boolean | undefined);
    private _hostKey?;
    get hostKey(): string | undefined;
    set hostKey(value: string | undefined);
    get hostKeyFingerprint(): string;
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _identityProviderType?;
    get identityProviderType(): string | undefined;
    set identityProviderType(value: string | undefined);
    private _invocationRole?;
    get invocationRole(): string | undefined;
    set invocationRole(value: string | undefined);
    private _loggingRole?;
    get loggingRole(): string | undefined;
    set loggingRole(value: string | undefined);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _url?;
    get url(): string | undefined;
    set url(value: string | undefined);
    private _endpointDetails?;
    get endpointDetails(): TransferServerEndpointDetails[] | undefined;
    set endpointDetails(value: TransferServerEndpointDetails[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
