import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface TransferUserConfig extends TerraformMetaArguments {
    readonly homeDirectory?: string;
    readonly policy?: string;
    readonly role: string;
    readonly serverId: string;
    readonly tags?: {
        [key: string]: string;
    };
    readonly userName: string;
}
export declare class TransferUser extends TerraformResource {
    constructor(scope: Construct, id: string, config: TransferUserConfig);
    get arn(): string;
    private _homeDirectory?;
    get homeDirectory(): string | undefined;
    set homeDirectory(value: string | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _policy?;
    get policy(): string | undefined;
    set policy(value: string | undefined);
    private _role;
    get role(): string;
    set role(value: string);
    private _serverId;
    get serverId(): string;
    set serverId(value: string);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _userName;
    get userName(): string;
    set userName(value: string);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
