import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface VpcDhcpOptionsConfig extends TerraformMetaArguments {
    readonly domainName?: string;
    readonly domainNameServers?: string[];
    readonly netbiosNameServers?: string[];
    readonly netbiosNodeType?: string;
    readonly ntpServers?: string[];
    readonly tags?: {
        [key: string]: string;
    };
}
export declare class VpcDhcpOptions extends TerraformResource {
    constructor(scope: Construct, id: string, config?: VpcDhcpOptionsConfig);
    get arn(): string;
    private _domainName?;
    get domainName(): string | undefined;
    set domainName(value: string | undefined);
    private _domainNameServers?;
    get domainNameServers(): string[] | undefined;
    set domainNameServers(value: string[] | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _netbiosNameServers?;
    get netbiosNameServers(): string[] | undefined;
    set netbiosNameServers(value: string[] | undefined);
    private _netbiosNodeType?;
    get netbiosNodeType(): string | undefined;
    set netbiosNodeType(value: string | undefined);
    private _ntpServers?;
    get ntpServers(): string[] | undefined;
    set ntpServers(value: string[] | undefined);
    get ownerId(): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
