import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface VpcEndpointServiceConfig extends TerraformMetaArguments {
    readonly acceptanceRequired: boolean;
    readonly allowedPrincipals?: string[];
    readonly networkLoadBalancerArns: string[];
    readonly tags?: {
        [key: string]: string;
    };
}
export declare class VpcEndpointService extends TerraformResource {
    constructor(scope: Construct, id: string, config: VpcEndpointServiceConfig);
    private _acceptanceRequired;
    get acceptanceRequired(): boolean;
    set acceptanceRequired(value: boolean);
    private _allowedPrincipals?;
    get allowedPrincipals(): string[] | undefined;
    set allowedPrincipals(value: string[] | undefined);
    get arn(): string;
    get availabilityZones(): string[];
    get baseEndpointDnsNames(): string[];
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    get managesVpcEndpoints(): boolean;
    private _networkLoadBalancerArns;
    get networkLoadBalancerArns(): string[];
    set networkLoadBalancerArns(value: string[]);
    get privateDnsName(): string;
    get serviceName(): string;
    get serviceType(): string;
    get state(): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
