import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
import { ComplexComputedList } from "cdktf";
export interface VpcEndpointConfig extends TerraformMetaArguments {
    readonly autoAccept?: boolean;
    readonly policy?: string;
    readonly privateDnsEnabled?: boolean;
    readonly routeTableIds?: string[];
    readonly securityGroupIds?: string[];
    readonly serviceName: string;
    readonly subnetIds?: string[];
    readonly tags?: {
        [key: string]: string;
    };
    readonly vpcEndpointType?: string;
    readonly vpcId: string;
    /** timeouts block */
    readonly timeouts?: VpcEndpointTimeouts;
}
export declare class VpcEndpointDnsEntry extends ComplexComputedList {
    get dnsName(): string;
    get hostedZoneId(): string;
}
export interface VpcEndpointTimeouts {
    readonly create?: string;
    readonly delete?: string;
    readonly update?: string;
}
export declare class VpcEndpoint extends TerraformResource {
    constructor(scope: Construct, id: string, config: VpcEndpointConfig);
    get arn(): string;
    private _autoAccept?;
    get autoAccept(): boolean | undefined;
    set autoAccept(value: boolean | undefined);
    get cidrBlocks(): string[];
    dnsEntry(index: string): VpcEndpointDnsEntry;
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    get networkInterfaceIds(): string[];
    get ownerId(): string;
    private _policy?;
    get policy(): string | undefined;
    set policy(value: string | undefined);
    get prefixListId(): string;
    private _privateDnsEnabled?;
    get privateDnsEnabled(): boolean | undefined;
    set privateDnsEnabled(value: boolean | undefined);
    get requesterManaged(): boolean;
    private _routeTableIds?;
    get routeTableIds(): string[] | undefined;
    set routeTableIds(value: string[] | undefined);
    private _securityGroupIds?;
    get securityGroupIds(): string[] | undefined;
    set securityGroupIds(value: string[] | undefined);
    private _serviceName;
    get serviceName(): string;
    set serviceName(value: string);
    get state(): string;
    private _subnetIds?;
    get subnetIds(): string[] | undefined;
    set subnetIds(value: string[] | undefined);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _vpcEndpointType?;
    get vpcEndpointType(): string | undefined;
    set vpcEndpointType(value: string | undefined);
    private _vpcId;
    get vpcId(): string;
    set vpcId(value: string);
    private _timeouts?;
    get timeouts(): VpcEndpointTimeouts | undefined;
    set timeouts(value: VpcEndpointTimeouts | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
