import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface VpcPeeringConnectionAccepterAConfig extends TerraformMetaArguments {
    readonly autoAccept?: boolean;
    readonly tags?: {
        [key: string]: string;
    };
    readonly vpcPeeringConnectionId: string;
    /** accepter block */
    readonly accepter?: VpcPeeringConnectionAccepterAccepter[];
    /** requester block */
    readonly requester?: VpcPeeringConnectionAccepterRequester[];
}
export interface VpcPeeringConnectionAccepterAccepter {
    readonly allowClassicLinkToRemoteVpc?: boolean;
    readonly allowRemoteVpcDnsResolution?: boolean;
    readonly allowVpcToRemoteClassicLink?: boolean;
}
export interface VpcPeeringConnectionAccepterRequester {
    readonly allowClassicLinkToRemoteVpc?: boolean;
    readonly allowRemoteVpcDnsResolution?: boolean;
    readonly allowVpcToRemoteClassicLink?: boolean;
}
export declare class VpcPeeringConnectionAccepterA extends TerraformResource {
    constructor(scope: Construct, id: string, config: VpcPeeringConnectionAccepterAConfig);
    get acceptStatus(): string;
    private _autoAccept?;
    get autoAccept(): boolean | undefined;
    set autoAccept(value: boolean | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    get peerOwnerId(): string;
    get peerRegion(): string;
    get peerVpcId(): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    get vpcId(): string;
    private _vpcPeeringConnectionId;
    get vpcPeeringConnectionId(): string;
    set vpcPeeringConnectionId(value: string);
    private _accepter?;
    get accepter(): VpcPeeringConnectionAccepterAccepter[] | undefined;
    set accepter(value: VpcPeeringConnectionAccepterAccepter[] | undefined);
    private _requester?;
    get requester(): VpcPeeringConnectionAccepterRequester[] | undefined;
    set requester(value: VpcPeeringConnectionAccepterRequester[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
