import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface VpcPeeringConnectionOptionsConfig extends TerraformMetaArguments {
    readonly vpcPeeringConnectionId: string;
    /** accepter block */
    readonly accepter?: VpcPeeringConnectionOptionsAccepter[];
    /** requester block */
    readonly requester?: VpcPeeringConnectionOptionsRequester[];
}
export interface VpcPeeringConnectionOptionsAccepter {
    readonly allowClassicLinkToRemoteVpc?: boolean;
    readonly allowRemoteVpcDnsResolution?: boolean;
    readonly allowVpcToRemoteClassicLink?: boolean;
}
export interface VpcPeeringConnectionOptionsRequester {
    readonly allowClassicLinkToRemoteVpc?: boolean;
    readonly allowRemoteVpcDnsResolution?: boolean;
    readonly allowVpcToRemoteClassicLink?: boolean;
}
export declare class VpcPeeringConnectionOptions extends TerraformResource {
    constructor(scope: Construct, id: string, config: VpcPeeringConnectionOptionsConfig);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _vpcPeeringConnectionId;
    get vpcPeeringConnectionId(): string;
    set vpcPeeringConnectionId(value: string);
    private _accepter?;
    get accepter(): VpcPeeringConnectionOptionsAccepter[] | undefined;
    set accepter(value: VpcPeeringConnectionOptionsAccepter[] | undefined);
    private _requester?;
    get requester(): VpcPeeringConnectionOptionsRequester[] | undefined;
    set requester(value: VpcPeeringConnectionOptionsRequester[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
