"use strict";
// https://www.terraform.io/docs/providers/aws/r/vpc_peering_connection_options.html
// generated from terraform resource schema
Object.defineProperty(exports, "__esModule", { value: true });
exports.VpcPeeringConnectionOptions = void 0;
const cdktf_1 = require("cdktf");
// Resource
class VpcPeeringConnectionOptions extends cdktf_1.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'aws_vpc_peering_connection_options',
            terraformGeneratorMetadata: {
                providerName: 'aws'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._vpcPeeringConnectionId = config.vpcPeeringConnectionId;
        this._accepter = config.accepter;
        this._requester = config.requester;
    }
    get id() {
        var _a;
        return (_a = this._id) !== null && _a !== void 0 ? _a : this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    get vpcPeeringConnectionId() {
        return this._vpcPeeringConnectionId;
    }
    set vpcPeeringConnectionId(value) {
        this._vpcPeeringConnectionId = value;
    }
    get accepter() {
        return this._accepter;
    }
    set accepter(value) {
        this._accepter = value;
    }
    get requester() {
        return this._requester;
    }
    set requester(value) {
        this._requester = value;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            vpc_peering_connection_id: this._vpcPeeringConnectionId,
            accepter: this._accepter,
            requester: this._requester,
        };
    }
}
exports.VpcPeeringConnectionOptions = VpcPeeringConnectionOptions;
//# sourceMappingURL=data:application/json;base64,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