import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface VpcPeeringConnectionConfig extends TerraformMetaArguments {
    readonly autoAccept?: boolean;
    readonly peerOwnerId?: string;
    readonly peerRegion?: string;
    readonly peerVpcId: string;
    readonly tags?: {
        [key: string]: string;
    };
    readonly vpcId: string;
    /** accepter block */
    readonly accepter?: VpcPeeringConnectionAccepter[];
    /** requester block */
    readonly requester?: VpcPeeringConnectionRequester[];
    /** timeouts block */
    readonly timeouts?: VpcPeeringConnectionTimeouts;
}
export interface VpcPeeringConnectionAccepter {
    readonly allowClassicLinkToRemoteVpc?: boolean;
    readonly allowRemoteVpcDnsResolution?: boolean;
    readonly allowVpcToRemoteClassicLink?: boolean;
}
export interface VpcPeeringConnectionRequester {
    readonly allowClassicLinkToRemoteVpc?: boolean;
    readonly allowRemoteVpcDnsResolution?: boolean;
    readonly allowVpcToRemoteClassicLink?: boolean;
}
export interface VpcPeeringConnectionTimeouts {
    readonly create?: string;
    readonly delete?: string;
    readonly update?: string;
}
export declare class VpcPeeringConnection extends TerraformResource {
    constructor(scope: Construct, id: string, config: VpcPeeringConnectionConfig);
    get acceptStatus(): string;
    private _autoAccept?;
    get autoAccept(): boolean | undefined;
    set autoAccept(value: boolean | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _peerOwnerId?;
    get peerOwnerId(): string | undefined;
    set peerOwnerId(value: string | undefined);
    private _peerRegion?;
    get peerRegion(): string | undefined;
    set peerRegion(value: string | undefined);
    private _peerVpcId;
    get peerVpcId(): string;
    set peerVpcId(value: string);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _vpcId;
    get vpcId(): string;
    set vpcId(value: string);
    private _accepter?;
    get accepter(): VpcPeeringConnectionAccepter[] | undefined;
    set accepter(value: VpcPeeringConnectionAccepter[] | undefined);
    private _requester?;
    get requester(): VpcPeeringConnectionRequester[] | undefined;
    set requester(value: VpcPeeringConnectionRequester[] | undefined);
    private _timeouts?;
    get timeouts(): VpcPeeringConnectionTimeouts | undefined;
    set timeouts(value: VpcPeeringConnectionTimeouts | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
