"use strict";
// https://www.terraform.io/docs/providers/aws/r/vpc_peering_connection.html
// generated from terraform resource schema
Object.defineProperty(exports, "__esModule", { value: true });
exports.VpcPeeringConnection = void 0;
const cdktf_1 = require("cdktf");
// Resource
class VpcPeeringConnection extends cdktf_1.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'aws_vpc_peering_connection',
            terraformGeneratorMetadata: {
                providerName: 'aws'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._autoAccept = config.autoAccept;
        this._peerOwnerId = config.peerOwnerId;
        this._peerRegion = config.peerRegion;
        this._peerVpcId = config.peerVpcId;
        this._tags = config.tags;
        this._vpcId = config.vpcId;
        this._accepter = config.accepter;
        this._requester = config.requester;
        this._timeouts = config.timeouts;
    }
    // ==========
    // ATTRIBUTES
    // ==========
    // accept_status - computed: true, optional: false, required: true
    get acceptStatus() {
        return this.getStringAttribute('accept_status');
    }
    get autoAccept() {
        return this._autoAccept;
    }
    set autoAccept(value) {
        this._autoAccept = value;
    }
    get id() {
        var _a;
        return (_a = this._id) !== null && _a !== void 0 ? _a : this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    get peerOwnerId() {
        var _a;
        return (_a = this._peerOwnerId) !== null && _a !== void 0 ? _a : this.getStringAttribute('peer_owner_id');
    }
    set peerOwnerId(value) {
        this._peerOwnerId = value;
    }
    get peerRegion() {
        var _a;
        return (_a = this._peerRegion) !== null && _a !== void 0 ? _a : this.getStringAttribute('peer_region');
    }
    set peerRegion(value) {
        this._peerRegion = value;
    }
    get peerVpcId() {
        return this._peerVpcId;
    }
    set peerVpcId(value) {
        this._peerVpcId = value;
    }
    get tags() {
        return this._tags;
    }
    set tags(value) {
        this._tags = value;
    }
    get vpcId() {
        return this._vpcId;
    }
    set vpcId(value) {
        this._vpcId = value;
    }
    get accepter() {
        return this._accepter;
    }
    set accepter(value) {
        this._accepter = value;
    }
    get requester() {
        return this._requester;
    }
    set requester(value) {
        this._requester = value;
    }
    get timeouts() {
        return this._timeouts;
    }
    set timeouts(value) {
        this._timeouts = value;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            auto_accept: this._autoAccept,
            peer_owner_id: this._peerOwnerId,
            peer_region: this._peerRegion,
            peer_vpc_id: this._peerVpcId,
            tags: this._tags,
            vpc_id: this._vpcId,
            accepter: this._accepter,
            requester: this._requester,
            timeouts: this._timeouts,
        };
    }
}
exports.VpcPeeringConnection = VpcPeeringConnection;
//# sourceMappingURL=data:application/json;base64,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