import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface VpcConfig extends TerraformMetaArguments {
    readonly assignGeneratedIpv6CidrBlock?: boolean;
    readonly cidrBlock: string;
    readonly enableClassiclink?: boolean;
    readonly enableClassiclinkDnsSupport?: boolean;
    readonly enableDnsHostnames?: boolean;
    readonly enableDnsSupport?: boolean;
    readonly instanceTenancy?: string;
    readonly tags?: {
        [key: string]: string;
    };
}
export declare class Vpc extends TerraformResource {
    constructor(scope: Construct, id: string, config: VpcConfig);
    get arn(): string;
    private _assignGeneratedIpv6CidrBlock?;
    get assignGeneratedIpv6CidrBlock(): boolean | undefined;
    set assignGeneratedIpv6CidrBlock(value: boolean | undefined);
    private _cidrBlock;
    get cidrBlock(): string;
    set cidrBlock(value: string);
    get defaultNetworkAclId(): string;
    get defaultRouteTableId(): string;
    get defaultSecurityGroupId(): string;
    get dhcpOptionsId(): string;
    private _enableClassiclink?;
    get enableClassiclink(): boolean | undefined;
    set enableClassiclink(value: boolean | undefined);
    private _enableClassiclinkDnsSupport?;
    get enableClassiclinkDnsSupport(): boolean | undefined;
    set enableClassiclinkDnsSupport(value: boolean | undefined);
    private _enableDnsHostnames?;
    get enableDnsHostnames(): boolean | undefined;
    set enableDnsHostnames(value: boolean | undefined);
    private _enableDnsSupport?;
    get enableDnsSupport(): boolean | undefined;
    set enableDnsSupport(value: boolean | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _instanceTenancy?;
    get instanceTenancy(): string | undefined;
    set instanceTenancy(value: string | undefined);
    get ipv6AssociationId(): string;
    get ipv6CidrBlock(): string;
    get mainRouteTableId(): string;
    get ownerId(): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
