import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
import { ComplexComputedList } from "cdktf";
export interface VpnConnectionConfig extends TerraformMetaArguments {
    readonly customerGatewayId: string;
    readonly staticRoutesOnly?: boolean;
    readonly tags?: {
        [key: string]: string;
    };
    readonly transitGatewayId?: string;
    readonly tunnel1InsideCidr?: string;
    readonly tunnel1PresharedKey?: string;
    readonly tunnel2InsideCidr?: string;
    readonly tunnel2PresharedKey?: string;
    readonly type: string;
    readonly vpnGatewayId?: string;
}
export declare class VpnConnectionRoutes extends ComplexComputedList {
    get destinationCidrBlock(): string;
    get source(): string;
    get state(): string;
}
export declare class VpnConnectionVgwTelemetry extends ComplexComputedList {
    get acceptedRouteCount(): number;
    get lastStatusChange(): string;
    get outsideIpAddress(): string;
    get status(): string;
    get statusMessage(): string;
}
export declare class VpnConnection extends TerraformResource {
    constructor(scope: Construct, id: string, config: VpnConnectionConfig);
    get arn(): string;
    get customerGatewayConfiguration(): string;
    private _customerGatewayId;
    get customerGatewayId(): string;
    set customerGatewayId(value: string);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    routes(index: string): VpnConnectionRoutes;
    private _staticRoutesOnly?;
    get staticRoutesOnly(): boolean | undefined;
    set staticRoutesOnly(value: boolean | undefined);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    get transitGatewayAttachmentId(): string;
    private _transitGatewayId?;
    get transitGatewayId(): string | undefined;
    set transitGatewayId(value: string | undefined);
    get tunnel1Address(): string;
    get tunnel1BgpAsn(): string;
    get tunnel1BgpHoldtime(): number;
    get tunnel1CgwInsideAddress(): string;
    private _tunnel1InsideCidr?;
    get tunnel1InsideCidr(): string | undefined;
    set tunnel1InsideCidr(value: string | undefined);
    private _tunnel1PresharedKey?;
    get tunnel1PresharedKey(): string | undefined;
    set tunnel1PresharedKey(value: string | undefined);
    get tunnel1VgwInsideAddress(): string;
    get tunnel2Address(): string;
    get tunnel2BgpAsn(): string;
    get tunnel2BgpHoldtime(): number;
    get tunnel2CgwInsideAddress(): string;
    private _tunnel2InsideCidr?;
    get tunnel2InsideCidr(): string | undefined;
    set tunnel2InsideCidr(value: string | undefined);
    private _tunnel2PresharedKey?;
    get tunnel2PresharedKey(): string | undefined;
    set tunnel2PresharedKey(value: string | undefined);
    get tunnel2VgwInsideAddress(): string;
    private _type;
    get type(): string;
    set type(value: string);
    vgwTelemetry(index: string): VpnConnectionVgwTelemetry;
    private _vpnGatewayId?;
    get vpnGatewayId(): string | undefined;
    set vpnGatewayId(value: string | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
