import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface WafRateBasedRuleConfig extends TerraformMetaArguments {
    readonly metricName: string;
    readonly name: string;
    readonly rateKey: string;
    readonly rateLimit: number;
    readonly tags?: {
        [key: string]: string;
    };
    /** predicates block */
    readonly predicates?: WafRateBasedRulePredicates[];
}
export interface WafRateBasedRulePredicates {
    readonly dataId: string;
    readonly negated: boolean;
    readonly type: string;
}
export declare class WafRateBasedRule extends TerraformResource {
    constructor(scope: Construct, id: string, config: WafRateBasedRuleConfig);
    get arn(): string;
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _metricName;
    get metricName(): string;
    set metricName(value: string);
    private _name;
    get name(): string;
    set name(value: string);
    private _rateKey;
    get rateKey(): string;
    set rateKey(value: string);
    private _rateLimit;
    get rateLimit(): number;
    set rateLimit(value: number);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _predicates?;
    get predicates(): WafRateBasedRulePredicates[] | undefined;
    set predicates(value: WafRateBasedRulePredicates[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
