"use strict";
// https://www.terraform.io/docs/providers/aws/r/waf_regex_match_set.html
// generated from terraform resource schema
Object.defineProperty(exports, "__esModule", { value: true });
exports.WafRegexMatchSet = void 0;
const cdktf_1 = require("cdktf");
// Resource
class WafRegexMatchSet extends cdktf_1.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'aws_waf_regex_match_set',
            terraformGeneratorMetadata: {
                providerName: 'aws'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._name = config.name;
        this._regexMatchTuple = config.regexMatchTuple;
    }
    // ==========
    // ATTRIBUTES
    // ==========
    // arn - computed: true, optional: false, required: true
    get arn() {
        return this.getStringAttribute('arn');
    }
    get id() {
        var _a;
        return (_a = this._id) !== null && _a !== void 0 ? _a : this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    get name() {
        return this._name;
    }
    set name(value) {
        this._name = value;
    }
    get regexMatchTuple() {
        return this._regexMatchTuple;
    }
    set regexMatchTuple(value) {
        this._regexMatchTuple = value;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            name: this._name,
            regex_match_tuple: this._regexMatchTuple,
        };
    }
}
exports.WafRegexMatchSet = WafRegexMatchSet;
//# sourceMappingURL=data:application/json;base64,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