import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface WafRuleGroupConfig extends TerraformMetaArguments {
    readonly metricName: string;
    readonly name: string;
    readonly tags?: {
        [key: string]: string;
    };
    /** activated_rule block */
    readonly activatedRule?: WafRuleGroupActivatedRule[];
}
export interface WafRuleGroupActivatedRuleAction {
    readonly type: string;
}
export interface WafRuleGroupActivatedRule {
    readonly priority: number;
    readonly ruleId: string;
    readonly type?: string;
    /** action block */
    readonly action: WafRuleGroupActivatedRuleAction[];
}
export declare class WafRuleGroup extends TerraformResource {
    constructor(scope: Construct, id: string, config: WafRuleGroupConfig);
    get arn(): string;
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _metricName;
    get metricName(): string;
    set metricName(value: string);
    private _name;
    get name(): string;
    set name(value: string);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _activatedRule?;
    get activatedRule(): WafRuleGroupActivatedRule[] | undefined;
    set activatedRule(value: WafRuleGroupActivatedRule[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
