import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface WafRuleConfig extends TerraformMetaArguments {
    readonly metricName: string;
    readonly name: string;
    readonly tags?: {
        [key: string]: string;
    };
    /** predicates block */
    readonly predicates?: WafRulePredicates[];
}
export interface WafRulePredicates {
    readonly dataId: string;
    readonly negated: boolean;
    readonly type: string;
}
export declare class WafRule extends TerraformResource {
    constructor(scope: Construct, id: string, config: WafRuleConfig);
    get arn(): string;
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _metricName;
    get metricName(): string;
    set metricName(value: string);
    private _name;
    get name(): string;
    set name(value: string);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _predicates?;
    get predicates(): WafRulePredicates[] | undefined;
    set predicates(value: WafRulePredicates[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
