import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface WafWebAclConfig extends TerraformMetaArguments {
    readonly metricName: string;
    readonly name: string;
    readonly tags?: {
        [key: string]: string;
    };
    /** default_action block */
    readonly defaultAction: WafWebAclDefaultAction[];
    /** logging_configuration block */
    readonly loggingConfiguration?: WafWebAclLoggingConfiguration[];
    /** rules block */
    readonly rules?: WafWebAclRules[];
}
export interface WafWebAclDefaultAction {
    readonly type: string;
}
export interface WafWebAclLoggingConfigurationRedactedFieldsFieldToMatch {
    readonly data?: string;
    readonly type: string;
}
export interface WafWebAclLoggingConfigurationRedactedFields {
    /** field_to_match block */
    readonly fieldToMatch: WafWebAclLoggingConfigurationRedactedFieldsFieldToMatch[];
}
export interface WafWebAclLoggingConfiguration {
    readonly logDestination: string;
    /** redacted_fields block */
    readonly redactedFields?: WafWebAclLoggingConfigurationRedactedFields[];
}
export interface WafWebAclRulesAction {
    readonly type: string;
}
export interface WafWebAclRulesOverrideAction {
    readonly type: string;
}
export interface WafWebAclRules {
    readonly priority: number;
    readonly ruleId: string;
    readonly type?: string;
    /** action block */
    readonly action?: WafWebAclRulesAction[];
    /** override_action block */
    readonly overrideAction?: WafWebAclRulesOverrideAction[];
}
export declare class WafWebAcl extends TerraformResource {
    constructor(scope: Construct, id: string, config: WafWebAclConfig);
    get arn(): string;
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _metricName;
    get metricName(): string;
    set metricName(value: string);
    private _name;
    get name(): string;
    set name(value: string);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _defaultAction;
    get defaultAction(): WafWebAclDefaultAction[];
    set defaultAction(value: WafWebAclDefaultAction[]);
    private _loggingConfiguration?;
    get loggingConfiguration(): WafWebAclLoggingConfiguration[] | undefined;
    set loggingConfiguration(value: WafWebAclLoggingConfiguration[] | undefined);
    private _rules?;
    get rules(): WafWebAclRules[] | undefined;
    set rules(value: WafWebAclRules[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
