import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface WafregionalRateBasedRuleConfig extends TerraformMetaArguments {
    readonly metricName: string;
    readonly name: string;
    readonly rateKey: string;
    readonly rateLimit: number;
    readonly tags?: {
        [key: string]: string;
    };
    /** predicate block */
    readonly predicate?: WafregionalRateBasedRulePredicate[];
}
export interface WafregionalRateBasedRulePredicate {
    readonly dataId: string;
    readonly negated: boolean;
    readonly type: string;
}
export declare class WafregionalRateBasedRule extends TerraformResource {
    constructor(scope: Construct, id: string, config: WafregionalRateBasedRuleConfig);
    get arn(): string;
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _metricName;
    get metricName(): string;
    set metricName(value: string);
    private _name;
    get name(): string;
    set name(value: string);
    private _rateKey;
    get rateKey(): string;
    set rateKey(value: string);
    private _rateLimit;
    get rateLimit(): number;
    set rateLimit(value: number);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _predicate?;
    get predicate(): WafregionalRateBasedRulePredicate[] | undefined;
    set predicate(value: WafregionalRateBasedRulePredicate[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
