import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface WafregionalRuleGroupConfig extends TerraformMetaArguments {
    readonly metricName: string;
    readonly name: string;
    readonly tags?: {
        [key: string]: string;
    };
    /** activated_rule block */
    readonly activatedRule?: WafregionalRuleGroupActivatedRule[];
}
export interface WafregionalRuleGroupActivatedRuleAction {
    readonly type: string;
}
export interface WafregionalRuleGroupActivatedRule {
    readonly priority: number;
    readonly ruleId: string;
    readonly type?: string;
    /** action block */
    readonly action: WafregionalRuleGroupActivatedRuleAction[];
}
export declare class WafregionalRuleGroup extends TerraformResource {
    constructor(scope: Construct, id: string, config: WafregionalRuleGroupConfig);
    get arn(): string;
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _metricName;
    get metricName(): string;
    set metricName(value: string);
    private _name;
    get name(): string;
    set name(value: string);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _activatedRule?;
    get activatedRule(): WafregionalRuleGroupActivatedRule[] | undefined;
    set activatedRule(value: WafregionalRuleGroupActivatedRule[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
