import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface WafregionalRuleConfig extends TerraformMetaArguments {
    readonly metricName: string;
    readonly name: string;
    readonly tags?: {
        [key: string]: string;
    };
    /** predicate block */
    readonly predicate?: WafregionalRulePredicate[];
}
export interface WafregionalRulePredicate {
    readonly dataId: string;
    readonly negated: boolean;
    readonly type: string;
}
export declare class WafregionalRule extends TerraformResource {
    constructor(scope: Construct, id: string, config: WafregionalRuleConfig);
    get arn(): string;
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _metricName;
    get metricName(): string;
    set metricName(value: string);
    private _name;
    get name(): string;
    set name(value: string);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _predicate?;
    get predicate(): WafregionalRulePredicate[] | undefined;
    set predicate(value: WafregionalRulePredicate[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
