import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface WafregionalWebAclConfig extends TerraformMetaArguments {
    readonly metricName: string;
    readonly name: string;
    readonly tags?: {
        [key: string]: string;
    };
    /** default_action block */
    readonly defaultAction: WafregionalWebAclDefaultAction[];
    /** logging_configuration block */
    readonly loggingConfiguration?: WafregionalWebAclLoggingConfiguration[];
    /** rule block */
    readonly rule?: WafregionalWebAclRule[];
}
export interface WafregionalWebAclDefaultAction {
    readonly type: string;
}
export interface WafregionalWebAclLoggingConfigurationRedactedFieldsFieldToMatch {
    readonly data?: string;
    readonly type: string;
}
export interface WafregionalWebAclLoggingConfigurationRedactedFields {
    /** field_to_match block */
    readonly fieldToMatch: WafregionalWebAclLoggingConfigurationRedactedFieldsFieldToMatch[];
}
export interface WafregionalWebAclLoggingConfiguration {
    readonly logDestination: string;
    /** redacted_fields block */
    readonly redactedFields?: WafregionalWebAclLoggingConfigurationRedactedFields[];
}
export interface WafregionalWebAclRuleAction {
    readonly type: string;
}
export interface WafregionalWebAclRuleOverrideAction {
    readonly type: string;
}
export interface WafregionalWebAclRule {
    readonly priority: number;
    readonly ruleId: string;
    readonly type?: string;
    /** action block */
    readonly action?: WafregionalWebAclRuleAction[];
    /** override_action block */
    readonly overrideAction?: WafregionalWebAclRuleOverrideAction[];
}
export declare class WafregionalWebAcl extends TerraformResource {
    constructor(scope: Construct, id: string, config: WafregionalWebAclConfig);
    get arn(): string;
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _metricName;
    get metricName(): string;
    set metricName(value: string);
    private _name;
    get name(): string;
    set name(value: string);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _defaultAction;
    get defaultAction(): WafregionalWebAclDefaultAction[];
    set defaultAction(value: WafregionalWebAclDefaultAction[]);
    private _loggingConfiguration?;
    get loggingConfiguration(): WafregionalWebAclLoggingConfiguration[] | undefined;
    set loggingConfiguration(value: WafregionalWebAclLoggingConfiguration[] | undefined);
    private _rule?;
    get rule(): WafregionalWebAclRule[] | undefined;
    set rule(value: WafregionalWebAclRule[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
