import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface Wafv2IpSetConfig extends TerraformMetaArguments {
    readonly addresses?: string[];
    readonly description?: string;
    readonly ipAddressVersion: string;
    readonly name: string;
    readonly scope: string;
    readonly tags?: {
        [key: string]: string;
    };
}
export declare class Wafv2IpSet extends TerraformResource {
    constructor(scope: Construct, id: string, config: Wafv2IpSetConfig);
    private _addresses?;
    get addresses(): string[] | undefined;
    set addresses(value: string[] | undefined);
    get arn(): string;
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _ipAddressVersion;
    get ipAddressVersion(): string;
    set ipAddressVersion(value: string);
    get lockToken(): string;
    private _name;
    get name(): string;
    set name(value: string);
    private _scope;
    get scope(): string;
    set scope(value: string);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
