import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface Wafv2WebAclLoggingConfigurationConfig extends TerraformMetaArguments {
    /** AWS Kinesis Firehose Delivery Stream ARNs */
    readonly logDestinationConfigs: string[];
    /** AWS WebACL ARN */
    readonly resourceArn: string;
    /** redacted_fields block */
    readonly redactedFields?: Wafv2WebAclLoggingConfigurationRedactedFields[];
}
export interface Wafv2WebAclLoggingConfigurationRedactedFieldsAllQueryArguments {
}
export interface Wafv2WebAclLoggingConfigurationRedactedFieldsBody {
}
export interface Wafv2WebAclLoggingConfigurationRedactedFieldsMethod {
}
export interface Wafv2WebAclLoggingConfigurationRedactedFieldsQueryString {
}
export interface Wafv2WebAclLoggingConfigurationRedactedFieldsSingleHeader {
    readonly name: string;
}
export interface Wafv2WebAclLoggingConfigurationRedactedFieldsSingleQueryArgument {
    readonly name: string;
}
export interface Wafv2WebAclLoggingConfigurationRedactedFieldsUriPath {
}
export interface Wafv2WebAclLoggingConfigurationRedactedFields {
    /** all_query_arguments block */
    readonly allQueryArguments?: Wafv2WebAclLoggingConfigurationRedactedFieldsAllQueryArguments[];
    /** body block */
    readonly body?: Wafv2WebAclLoggingConfigurationRedactedFieldsBody[];
    /** method block */
    readonly method?: Wafv2WebAclLoggingConfigurationRedactedFieldsMethod[];
    /** query_string block */
    readonly queryString?: Wafv2WebAclLoggingConfigurationRedactedFieldsQueryString[];
    /** single_header block */
    readonly singleHeader?: Wafv2WebAclLoggingConfigurationRedactedFieldsSingleHeader[];
    /** single_query_argument block */
    readonly singleQueryArgument?: Wafv2WebAclLoggingConfigurationRedactedFieldsSingleQueryArgument[];
    /** uri_path block */
    readonly uriPath?: Wafv2WebAclLoggingConfigurationRedactedFieldsUriPath[];
}
export declare class Wafv2WebAclLoggingConfiguration extends TerraformResource {
    constructor(scope: Construct, id: string, config: Wafv2WebAclLoggingConfigurationConfig);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _logDestinationConfigs;
    get logDestinationConfigs(): string[];
    set logDestinationConfigs(value: string[]);
    private _resourceArn;
    get resourceArn(): string;
    set resourceArn(value: string);
    private _redactedFields?;
    get redactedFields(): Wafv2WebAclLoggingConfigurationRedactedFields[] | undefined;
    set redactedFields(value: Wafv2WebAclLoggingConfigurationRedactedFields[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
