"use strict";
// https://www.terraform.io/docs/providers/aws/r/wafv2_web_acl_logging_configuration.html
// generated from terraform resource schema
Object.defineProperty(exports, "__esModule", { value: true });
exports.Wafv2WebAclLoggingConfiguration = void 0;
const cdktf_1 = require("cdktf");
// Resource
class Wafv2WebAclLoggingConfiguration extends cdktf_1.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'aws_wafv2_web_acl_logging_configuration',
            terraformGeneratorMetadata: {
                providerName: 'aws'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._logDestinationConfigs = config.logDestinationConfigs;
        this._resourceArn = config.resourceArn;
        this._redactedFields = config.redactedFields;
    }
    get id() {
        var _a;
        return (_a = this._id) !== null && _a !== void 0 ? _a : this.getStringAttribute('id');
    }
    set id(value) {
        this._id = value;
    }
    get logDestinationConfigs() {
        return this._logDestinationConfigs;
    }
    set logDestinationConfigs(value) {
        this._logDestinationConfigs = value;
    }
    get resourceArn() {
        return this._resourceArn;
    }
    set resourceArn(value) {
        this._resourceArn = value;
    }
    get redactedFields() {
        return this._redactedFields;
    }
    set redactedFields(value) {
        this._redactedFields = value;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            log_destination_configs: this._logDestinationConfigs,
            resource_arn: this._resourceArn,
            redacted_fields: this._redactedFields,
        };
    }
}
exports.Wafv2WebAclLoggingConfiguration = Wafv2WebAclLoggingConfiguration;
//# sourceMappingURL=data:application/json;base64,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