import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface WorklinkFleetConfig extends TerraformMetaArguments {
    readonly auditStreamArn?: string;
    readonly deviceCaCertificate?: string;
    readonly displayName?: string;
    readonly name: string;
    readonly optimizeForEndUserLocation?: boolean;
    /** identity_provider block */
    readonly identityProvider?: WorklinkFleetIdentityProvider[];
    /** network block */
    readonly network?: WorklinkFleetNetwork[];
}
export interface WorklinkFleetIdentityProvider {
    readonly samlMetadata: string;
    readonly type: string;
}
export interface WorklinkFleetNetwork {
    readonly securityGroupIds: string[];
    readonly subnetIds: string[];
    readonly vpcId: string;
}
export declare class WorklinkFleet extends TerraformResource {
    constructor(scope: Construct, id: string, config: WorklinkFleetConfig);
    get arn(): string;
    private _auditStreamArn?;
    get auditStreamArn(): string | undefined;
    set auditStreamArn(value: string | undefined);
    get companyCode(): string;
    get createdTime(): string;
    private _deviceCaCertificate?;
    get deviceCaCertificate(): string | undefined;
    set deviceCaCertificate(value: string | undefined);
    private _displayName?;
    get displayName(): string | undefined;
    set displayName(value: string | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    get lastUpdatedTime(): string;
    private _name;
    get name(): string;
    set name(value: string);
    private _optimizeForEndUserLocation?;
    get optimizeForEndUserLocation(): boolean | undefined;
    set optimizeForEndUserLocation(value: boolean | undefined);
    private _identityProvider?;
    get identityProvider(): WorklinkFleetIdentityProvider[] | undefined;
    set identityProvider(value: WorklinkFleetIdentityProvider[] | undefined);
    private _network?;
    get network(): WorklinkFleetNetwork[] | undefined;
    set network(value: WorklinkFleetNetwork[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
