import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface WorkspacesDirectoryConfig extends TerraformMetaArguments {
    readonly directoryId: string;
    readonly subnetIds?: string[];
    readonly tags?: {
        [key: string]: string;
    };
    /** self_service_permissions block */
    readonly selfServicePermissions?: WorkspacesDirectorySelfServicePermissions[];
}
export interface WorkspacesDirectorySelfServicePermissions {
    readonly changeComputeType?: boolean;
    readonly increaseVolumeSize?: boolean;
    readonly rebuildWorkspace?: boolean;
    readonly restartWorkspace?: boolean;
    readonly switchRunningMode?: boolean;
}
export declare class WorkspacesDirectory extends TerraformResource {
    constructor(scope: Construct, id: string, config: WorkspacesDirectoryConfig);
    get alias(): string;
    get customerUserName(): string;
    private _directoryId;
    get directoryId(): string;
    set directoryId(value: string);
    get directoryName(): string;
    get directoryType(): string;
    get dnsIpAddresses(): string[];
    get iamRoleId(): string;
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    get ipGroupIds(): string[];
    get registrationCode(): string;
    private _subnetIds?;
    get subnetIds(): string[] | undefined;
    set subnetIds(value: string[] | undefined);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    get workspaceSecurityGroupId(): string;
    private _selfServicePermissions?;
    get selfServicePermissions(): WorkspacesDirectorySelfServicePermissions[] | undefined;
    set selfServicePermissions(value: WorkspacesDirectorySelfServicePermissions[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
