import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface WorkspacesIpGroupConfig extends TerraformMetaArguments {
    readonly description?: string;
    readonly name: string;
    readonly tags?: {
        [key: string]: string;
    };
    /** rules block */
    readonly rules?: WorkspacesIpGroupRules[];
}
export interface WorkspacesIpGroupRules {
    readonly description?: string;
    readonly source: string;
}
export declare class WorkspacesIpGroup extends TerraformResource {
    constructor(scope: Construct, id: string, config: WorkspacesIpGroupConfig);
    private _description?;
    get description(): string | undefined;
    set description(value: string | undefined);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _name;
    get name(): string;
    set name(value: string);
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _rules?;
    get rules(): WorkspacesIpGroupRules[] | undefined;
    set rules(value: WorkspacesIpGroupRules[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
