import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface WorkspacesWorkspaceConfig extends TerraformMetaArguments {
    readonly bundleId: string;
    readonly directoryId: string;
    readonly rootVolumeEncryptionEnabled?: boolean;
    readonly tags?: {
        [key: string]: string;
    };
    readonly userName: string;
    readonly userVolumeEncryptionEnabled?: boolean;
    readonly volumeEncryptionKey?: string;
    /** workspace_properties block */
    readonly workspaceProperties?: WorkspacesWorkspaceWorkspaceProperties[];
}
export interface WorkspacesWorkspaceWorkspaceProperties {
    readonly computeTypeName?: string;
    readonly rootVolumeSizeGib?: number;
    readonly runningMode?: string;
    readonly runningModeAutoStopTimeoutInMinutes?: number;
    readonly userVolumeSizeGib?: number;
}
export declare class WorkspacesWorkspace extends TerraformResource {
    constructor(scope: Construct, id: string, config: WorkspacesWorkspaceConfig);
    private _bundleId;
    get bundleId(): string;
    set bundleId(value: string);
    get computerName(): string;
    private _directoryId;
    get directoryId(): string;
    set directoryId(value: string);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    get ipAddress(): string;
    private _rootVolumeEncryptionEnabled?;
    get rootVolumeEncryptionEnabled(): boolean | undefined;
    set rootVolumeEncryptionEnabled(value: boolean | undefined);
    get state(): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    } | undefined;
    set tags(value: {
        [key: string]: string;
    } | undefined);
    private _userName;
    get userName(): string;
    set userName(value: string);
    private _userVolumeEncryptionEnabled?;
    get userVolumeEncryptionEnabled(): boolean | undefined;
    set userVolumeEncryptionEnabled(value: boolean | undefined);
    private _volumeEncryptionKey?;
    get volumeEncryptionKey(): string | undefined;
    set volumeEncryptionKey(value: string | undefined);
    private _workspaceProperties?;
    get workspaceProperties(): WorkspacesWorkspaceWorkspaceProperties[] | undefined;
    set workspaceProperties(value: WorkspacesWorkspaceWorkspaceProperties[] | undefined);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
