import { Construct } from 'constructs';
import { TerraformResource } from 'cdktf';
import { TerraformMetaArguments } from 'cdktf';
export interface XraySamplingRuleConfig extends TerraformMetaArguments {
    readonly attributes?: {
        [key: string]: string;
    };
    readonly fixedRate: number;
    readonly host: string;
    readonly httpMethod: string;
    readonly priority: number;
    readonly reservoirSize: number;
    readonly resourceArn: string;
    readonly ruleName?: string;
    readonly serviceName: string;
    readonly serviceType: string;
    readonly urlPath: string;
    readonly version: number;
}
export declare class XraySamplingRule extends TerraformResource {
    constructor(scope: Construct, id: string, config: XraySamplingRuleConfig);
    get arn(): string;
    private _attributes?;
    get attributes(): {
        [key: string]: string;
    } | undefined;
    set attributes(value: {
        [key: string]: string;
    } | undefined);
    private _fixedRate;
    get fixedRate(): number;
    set fixedRate(value: number);
    private _host;
    get host(): string;
    set host(value: string);
    private _httpMethod;
    get httpMethod(): string;
    set httpMethod(value: string);
    private _id?;
    get id(): string | undefined;
    set id(value: string | undefined);
    private _priority;
    get priority(): number;
    set priority(value: number);
    private _reservoirSize;
    get reservoirSize(): number;
    set reservoirSize(value: number);
    private _resourceArn;
    get resourceArn(): string;
    set resourceArn(value: string);
    private _ruleName?;
    get ruleName(): string | undefined;
    set ruleName(value: string | undefined);
    private _serviceName;
    get serviceName(): string;
    set serviceName(value: string);
    private _serviceType;
    get serviceType(): string;
    set serviceType(value: string);
    private _urlPath;
    get urlPath(): string;
    set urlPath(value: string);
    private _version;
    get version(): number;
    set version(value: number);
    synthesizeAttributes(): {
        [name: string]: any;
    };
}
