"""
# Terraform CDK AWS Provider

This repo builds and publishes the Terraform AWS Provider bindings for [cdktf](https://cdk.tf).

Current build targets are:

* [npm]()
* [Pypi]()

## Versioning

This project is explicitly not tracking the Terraform AWS Provider version 1:1. In fact, it always tracks `latest` of `~> 2.0` with every release. If there scenarios where you explicitly have to pin your provider version, you can do so by generating the [provider constructs manually]().

These are the upstream dependencies:

* [Terraform CDK](https://cdk.tf)
* [Terraform AWS Provider](https://cdk.tf/provider/aws-native)
* [Terraform Engine](https://cdk.tf/terraform)

If there are breaking changes (backward incompatible) in any of the above, the major version of this project will be bumped. While the Terraform Engine and the Terraform AWS Provider are relatively stable, the Terraform CDK is in an early stage. Therefore, it's likely that there will be breaking changes.

## Features / Issues / Bugs

Please report bugs and issues to the [terraform cdk](https://cdk.tf) project:

* [Create bug report](https://cdk.tf/bug)
* [Create feature request](https://cdk.tf/feature)

## Contributing

## projen

This is mostly based on [projen](https://github.com/eladb/projen), which takes care of generating the entire repository.

## cdktf-provider-project based on projen

There's a custom [project builder](https://github.com/skorfmann/cdktf-provider-project) which encapsulate the common settings for all `cdktf` providers.

## provider version

The provider version can be adjusted in [./.projenrc.js](./.projenrc.js)
"""
import abc
import builtins
import datetime
import enum
import typing

import jsii
import jsii.compat
import publication

from ._jsii import *

import cdktf
import constructs


class AccessanalyzerAnalyzer(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="@skorfmann/cdktf-provider-aws.AccessanalyzerAnalyzer",
):
    def __init__(
        self,
        scope: constructs.Construct,
        id: str,
        *,
        analyzer_name: str,
        tags: typing.Optional[typing.Mapping[str, str]] = None,
        type: typing.Optional[str] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param analyzer_name: 
        :param tags: 
        :param type: 
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = AccessanalyzerAnalyzerConfig(
            analyzer_name=analyzer_name,
            tags=tags,
            type=type,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(AccessanalyzerAnalyzer, self, [scope, id, config])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property
    @jsii.member(jsii_name="arn")
    def arn(self) -> str:
        return jsii.get(self, "arn")

    @builtins.property
    @jsii.member(jsii_name="analyzerName")
    def analyzer_name(self) -> str:
        return jsii.get(self, "analyzerName")

    @analyzer_name.setter
    def analyzer_name(self, value: str) -> None:
        jsii.set(self, "analyzerName", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="tags")
    def tags(self) -> typing.Optional[typing.Mapping[str, str]]:
        return jsii.get(self, "tags")

    @tags.setter
    def tags(self, value: typing.Optional[typing.Mapping[str, str]]) -> None:
        jsii.set(self, "tags", value)

    @builtins.property
    @jsii.member(jsii_name="type")
    def type(self) -> typing.Optional[str]:
        return jsii.get(self, "type")

    @type.setter
    def type(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "type", value)


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AccessanalyzerAnalyzerConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "analyzer_name": "analyzerName",
        "tags": "tags",
        "type": "type",
    },
)
class AccessanalyzerAnalyzerConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        analyzer_name: str,
        tags: typing.Optional[typing.Mapping[str, str]] = None,
        type: typing.Optional[str] = None,
    ) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param analyzer_name: 
        :param tags: 
        :param type: 
        """
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        self._values = {
            "analyzer_name": analyzer_name,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if tags is not None:
            self._values["tags"] = tags
        if type is not None:
            self._values["type"] = type

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("count")

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.TerraformResource]]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("depends_on")

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("lifecycle")

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("provider")

    @builtins.property
    def analyzer_name(self) -> str:
        return self._values.get("analyzer_name")

    @builtins.property
    def tags(self) -> typing.Optional[typing.Mapping[str, str]]:
        return self._values.get("tags")

    @builtins.property
    def type(self) -> typing.Optional[str]:
        return self._values.get("type")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AccessanalyzerAnalyzerConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class AcmCertificate(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="@skorfmann/cdktf-provider-aws.AcmCertificate",
):
    def __init__(
        self,
        scope: constructs.Construct,
        id: str,
        *,
        certificate_authority_arn: typing.Optional[str] = None,
        certificate_body: typing.Optional[str] = None,
        certificate_chain: typing.Optional[str] = None,
        domain_name: typing.Optional[str] = None,
        options: typing.Optional[typing.List["AcmCertificateOptions"]] = None,
        private_key: typing.Optional[str] = None,
        subject_alternative_names: typing.Optional[typing.List[str]] = None,
        tags: typing.Optional[typing.Mapping[str, str]] = None,
        validation_method: typing.Optional[str] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param certificate_authority_arn: 
        :param certificate_body: 
        :param certificate_chain: 
        :param domain_name: 
        :param options: options block.
        :param private_key: 
        :param subject_alternative_names: 
        :param tags: 
        :param validation_method: 
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = AcmCertificateConfig(
            certificate_authority_arn=certificate_authority_arn,
            certificate_body=certificate_body,
            certificate_chain=certificate_chain,
            domain_name=domain_name,
            options=options,
            private_key=private_key,
            subject_alternative_names=subject_alternative_names,
            tags=tags,
            validation_method=validation_method,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(AcmCertificate, self, [scope, id, config])

    @jsii.member(jsii_name="domainValidationOptions")
    def domain_validation_options(
        self, index: str
    ) -> "AcmCertificateDomainValidationOptions":
        """
        :param index: -
        """
        return jsii.invoke(self, "domainValidationOptions", [index])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property
    @jsii.member(jsii_name="arn")
    def arn(self) -> str:
        return jsii.get(self, "arn")

    @builtins.property
    @jsii.member(jsii_name="status")
    def status(self) -> str:
        return jsii.get(self, "status")

    @builtins.property
    @jsii.member(jsii_name="validationEmails")
    def validation_emails(self) -> typing.List[str]:
        return jsii.get(self, "validationEmails")

    @builtins.property
    @jsii.member(jsii_name="certificateAuthorityArn")
    def certificate_authority_arn(self) -> typing.Optional[str]:
        return jsii.get(self, "certificateAuthorityArn")

    @certificate_authority_arn.setter
    def certificate_authority_arn(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "certificateAuthorityArn", value)

    @builtins.property
    @jsii.member(jsii_name="certificateBody")
    def certificate_body(self) -> typing.Optional[str]:
        return jsii.get(self, "certificateBody")

    @certificate_body.setter
    def certificate_body(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "certificateBody", value)

    @builtins.property
    @jsii.member(jsii_name="certificateChain")
    def certificate_chain(self) -> typing.Optional[str]:
        return jsii.get(self, "certificateChain")

    @certificate_chain.setter
    def certificate_chain(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "certificateChain", value)

    @builtins.property
    @jsii.member(jsii_name="domainName")
    def domain_name(self) -> typing.Optional[str]:
        return jsii.get(self, "domainName")

    @domain_name.setter
    def domain_name(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "domainName", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="options")
    def options(self) -> typing.Optional[typing.List["AcmCertificateOptions"]]:
        return jsii.get(self, "options")

    @options.setter
    def options(
        self, value: typing.Optional[typing.List["AcmCertificateOptions"]]
    ) -> None:
        jsii.set(self, "options", value)

    @builtins.property
    @jsii.member(jsii_name="privateKey")
    def private_key(self) -> typing.Optional[str]:
        return jsii.get(self, "privateKey")

    @private_key.setter
    def private_key(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "privateKey", value)

    @builtins.property
    @jsii.member(jsii_name="subjectAlternativeNames")
    def subject_alternative_names(self) -> typing.Optional[typing.List[str]]:
        return jsii.get(self, "subjectAlternativeNames")

    @subject_alternative_names.setter
    def subject_alternative_names(
        self, value: typing.Optional[typing.List[str]]
    ) -> None:
        jsii.set(self, "subjectAlternativeNames", value)

    @builtins.property
    @jsii.member(jsii_name="tags")
    def tags(self) -> typing.Optional[typing.Mapping[str, str]]:
        return jsii.get(self, "tags")

    @tags.setter
    def tags(self, value: typing.Optional[typing.Mapping[str, str]]) -> None:
        jsii.set(self, "tags", value)

    @builtins.property
    @jsii.member(jsii_name="validationMethod")
    def validation_method(self) -> typing.Optional[str]:
        return jsii.get(self, "validationMethod")

    @validation_method.setter
    def validation_method(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "validationMethod", value)


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AcmCertificateConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "certificate_authority_arn": "certificateAuthorityArn",
        "certificate_body": "certificateBody",
        "certificate_chain": "certificateChain",
        "domain_name": "domainName",
        "options": "options",
        "private_key": "privateKey",
        "subject_alternative_names": "subjectAlternativeNames",
        "tags": "tags",
        "validation_method": "validationMethod",
    },
)
class AcmCertificateConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        certificate_authority_arn: typing.Optional[str] = None,
        certificate_body: typing.Optional[str] = None,
        certificate_chain: typing.Optional[str] = None,
        domain_name: typing.Optional[str] = None,
        options: typing.Optional[typing.List["AcmCertificateOptions"]] = None,
        private_key: typing.Optional[str] = None,
        subject_alternative_names: typing.Optional[typing.List[str]] = None,
        tags: typing.Optional[typing.Mapping[str, str]] = None,
        validation_method: typing.Optional[str] = None,
    ) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param certificate_authority_arn: 
        :param certificate_body: 
        :param certificate_chain: 
        :param domain_name: 
        :param options: options block.
        :param private_key: 
        :param subject_alternative_names: 
        :param tags: 
        :param validation_method: 
        """
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        self._values = {}
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if certificate_authority_arn is not None:
            self._values["certificate_authority_arn"] = certificate_authority_arn
        if certificate_body is not None:
            self._values["certificate_body"] = certificate_body
        if certificate_chain is not None:
            self._values["certificate_chain"] = certificate_chain
        if domain_name is not None:
            self._values["domain_name"] = domain_name
        if options is not None:
            self._values["options"] = options
        if private_key is not None:
            self._values["private_key"] = private_key
        if subject_alternative_names is not None:
            self._values["subject_alternative_names"] = subject_alternative_names
        if tags is not None:
            self._values["tags"] = tags
        if validation_method is not None:
            self._values["validation_method"] = validation_method

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("count")

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.TerraformResource]]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("depends_on")

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("lifecycle")

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("provider")

    @builtins.property
    def certificate_authority_arn(self) -> typing.Optional[str]:
        return self._values.get("certificate_authority_arn")

    @builtins.property
    def certificate_body(self) -> typing.Optional[str]:
        return self._values.get("certificate_body")

    @builtins.property
    def certificate_chain(self) -> typing.Optional[str]:
        return self._values.get("certificate_chain")

    @builtins.property
    def domain_name(self) -> typing.Optional[str]:
        return self._values.get("domain_name")

    @builtins.property
    def options(self) -> typing.Optional[typing.List["AcmCertificateOptions"]]:
        """options block."""
        return self._values.get("options")

    @builtins.property
    def private_key(self) -> typing.Optional[str]:
        return self._values.get("private_key")

    @builtins.property
    def subject_alternative_names(self) -> typing.Optional[typing.List[str]]:
        return self._values.get("subject_alternative_names")

    @builtins.property
    def tags(self) -> typing.Optional[typing.Mapping[str, str]]:
        return self._values.get("tags")

    @builtins.property
    def validation_method(self) -> typing.Optional[str]:
        return self._values.get("validation_method")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AcmCertificateConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class AcmCertificateDomainValidationOptions(
    cdktf.ComplexComputedList,
    metaclass=jsii.JSIIMeta,
    jsii_type="@skorfmann/cdktf-provider-aws.AcmCertificateDomainValidationOptions",
):
    def __init__(
        self,
        terraform_resource: cdktf.ITerraformResource,
        terraform_attribute: str,
        index: str,
    ) -> None:
        """
        :param terraform_resource: -
        :param terraform_attribute: -
        :param index: -

        stability
        :stability: experimental
        """
        jsii.create(
            AcmCertificateDomainValidationOptions,
            self,
            [terraform_resource, terraform_attribute, index],
        )

    @builtins.property
    @jsii.member(jsii_name="domainName")
    def domain_name(self) -> str:
        return jsii.get(self, "domainName")

    @builtins.property
    @jsii.member(jsii_name="resourceRecordName")
    def resource_record_name(self) -> str:
        return jsii.get(self, "resourceRecordName")

    @builtins.property
    @jsii.member(jsii_name="resourceRecordType")
    def resource_record_type(self) -> str:
        return jsii.get(self, "resourceRecordType")

    @builtins.property
    @jsii.member(jsii_name="resourceRecordValue")
    def resource_record_value(self) -> str:
        return jsii.get(self, "resourceRecordValue")


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AcmCertificateOptions",
    jsii_struct_bases=[],
    name_mapping={
        "certificate_transparency_logging_preference": "certificateTransparencyLoggingPreference"
    },
)
class AcmCertificateOptions:
    def __init__(
        self,
        *,
        certificate_transparency_logging_preference: typing.Optional[str] = None,
    ) -> None:
        """
        :param certificate_transparency_logging_preference: 
        """
        self._values = {}
        if certificate_transparency_logging_preference is not None:
            self._values[
                "certificate_transparency_logging_preference"
            ] = certificate_transparency_logging_preference

    @builtins.property
    def certificate_transparency_logging_preference(self) -> typing.Optional[str]:
        return self._values.get("certificate_transparency_logging_preference")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AcmCertificateOptions(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class AcmCertificateValidation(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="@skorfmann/cdktf-provider-aws.AcmCertificateValidation",
):
    def __init__(
        self,
        scope: constructs.Construct,
        id: str,
        *,
        certificate_arn: str,
        timeouts: typing.Optional["AcmCertificateValidationTimeouts"] = None,
        validation_record_fqdns: typing.Optional[typing.List[str]] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param certificate_arn: 
        :param timeouts: timeouts block.
        :param validation_record_fqdns: 
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = AcmCertificateValidationConfig(
            certificate_arn=certificate_arn,
            timeouts=timeouts,
            validation_record_fqdns=validation_record_fqdns,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(AcmCertificateValidation, self, [scope, id, config])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property
    @jsii.member(jsii_name="certificateArn")
    def certificate_arn(self) -> str:
        return jsii.get(self, "certificateArn")

    @certificate_arn.setter
    def certificate_arn(self, value: str) -> None:
        jsii.set(self, "certificateArn", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="timeouts")
    def timeouts(self) -> typing.Optional["AcmCertificateValidationTimeouts"]:
        return jsii.get(self, "timeouts")

    @timeouts.setter
    def timeouts(
        self, value: typing.Optional["AcmCertificateValidationTimeouts"]
    ) -> None:
        jsii.set(self, "timeouts", value)

    @builtins.property
    @jsii.member(jsii_name="validationRecordFqdns")
    def validation_record_fqdns(self) -> typing.Optional[typing.List[str]]:
        return jsii.get(self, "validationRecordFqdns")

    @validation_record_fqdns.setter
    def validation_record_fqdns(self, value: typing.Optional[typing.List[str]]) -> None:
        jsii.set(self, "validationRecordFqdns", value)


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AcmCertificateValidationConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "certificate_arn": "certificateArn",
        "timeouts": "timeouts",
        "validation_record_fqdns": "validationRecordFqdns",
    },
)
class AcmCertificateValidationConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        certificate_arn: str,
        timeouts: typing.Optional["AcmCertificateValidationTimeouts"] = None,
        validation_record_fqdns: typing.Optional[typing.List[str]] = None,
    ) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param certificate_arn: 
        :param timeouts: timeouts block.
        :param validation_record_fqdns: 
        """
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        if isinstance(timeouts, dict):
            timeouts = AcmCertificateValidationTimeouts(**timeouts)
        self._values = {
            "certificate_arn": certificate_arn,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if timeouts is not None:
            self._values["timeouts"] = timeouts
        if validation_record_fqdns is not None:
            self._values["validation_record_fqdns"] = validation_record_fqdns

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("count")

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.TerraformResource]]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("depends_on")

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("lifecycle")

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("provider")

    @builtins.property
    def certificate_arn(self) -> str:
        return self._values.get("certificate_arn")

    @builtins.property
    def timeouts(self) -> typing.Optional["AcmCertificateValidationTimeouts"]:
        """timeouts block."""
        return self._values.get("timeouts")

    @builtins.property
    def validation_record_fqdns(self) -> typing.Optional[typing.List[str]]:
        return self._values.get("validation_record_fqdns")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AcmCertificateValidationConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AcmCertificateValidationTimeouts",
    jsii_struct_bases=[],
    name_mapping={"create": "create"},
)
class AcmCertificateValidationTimeouts:
    def __init__(self, *, create: typing.Optional[str] = None) -> None:
        """
        :param create: 
        """
        self._values = {}
        if create is not None:
            self._values["create"] = create

    @builtins.property
    def create(self) -> typing.Optional[str]:
        return self._values.get("create")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AcmCertificateValidationTimeouts(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class AcmpcaCertificateAuthority(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="@skorfmann/cdktf-provider-aws.AcmpcaCertificateAuthority",
):
    def __init__(
        self,
        scope: constructs.Construct,
        id: str,
        *,
        certificate_authority_configuration: typing.List[
            "AcmpcaCertificateAuthorityCertificateAuthorityConfiguration"
        ],
        enabled: typing.Optional[bool] = None,
        permanent_deletion_time_in_days: typing.Optional[jsii.Number] = None,
        revocation_configuration: typing.Optional[
            typing.List["AcmpcaCertificateAuthorityRevocationConfiguration"]
        ] = None,
        tags: typing.Optional[typing.Mapping[str, str]] = None,
        timeouts: typing.Optional["AcmpcaCertificateAuthorityTimeouts"] = None,
        type: typing.Optional[str] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param certificate_authority_configuration: certificate_authority_configuration block.
        :param enabled: 
        :param permanent_deletion_time_in_days: 
        :param revocation_configuration: revocation_configuration block.
        :param tags: 
        :param timeouts: timeouts block.
        :param type: 
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = AcmpcaCertificateAuthorityConfig(
            certificate_authority_configuration=certificate_authority_configuration,
            enabled=enabled,
            permanent_deletion_time_in_days=permanent_deletion_time_in_days,
            revocation_configuration=revocation_configuration,
            tags=tags,
            timeouts=timeouts,
            type=type,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(AcmpcaCertificateAuthority, self, [scope, id, config])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property
    @jsii.member(jsii_name="arn")
    def arn(self) -> str:
        return jsii.get(self, "arn")

    @builtins.property
    @jsii.member(jsii_name="certificate")
    def certificate(self) -> str:
        return jsii.get(self, "certificate")

    @builtins.property
    @jsii.member(jsii_name="certificateChain")
    def certificate_chain(self) -> str:
        return jsii.get(self, "certificateChain")

    @builtins.property
    @jsii.member(jsii_name="certificateSigningRequest")
    def certificate_signing_request(self) -> str:
        return jsii.get(self, "certificateSigningRequest")

    @builtins.property
    @jsii.member(jsii_name="notAfter")
    def not_after(self) -> str:
        return jsii.get(self, "notAfter")

    @builtins.property
    @jsii.member(jsii_name="notBefore")
    def not_before(self) -> str:
        return jsii.get(self, "notBefore")

    @builtins.property
    @jsii.member(jsii_name="serial")
    def serial(self) -> str:
        return jsii.get(self, "serial")

    @builtins.property
    @jsii.member(jsii_name="status")
    def status(self) -> str:
        return jsii.get(self, "status")

    @builtins.property
    @jsii.member(jsii_name="certificateAuthorityConfiguration")
    def certificate_authority_configuration(
        self,
    ) -> typing.List["AcmpcaCertificateAuthorityCertificateAuthorityConfiguration"]:
        return jsii.get(self, "certificateAuthorityConfiguration")

    @certificate_authority_configuration.setter
    def certificate_authority_configuration(
        self,
        value: typing.List[
            "AcmpcaCertificateAuthorityCertificateAuthorityConfiguration"
        ],
    ) -> None:
        jsii.set(self, "certificateAuthorityConfiguration", value)

    @builtins.property
    @jsii.member(jsii_name="enabled")
    def enabled(self) -> typing.Optional[bool]:
        return jsii.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: typing.Optional[bool]) -> None:
        jsii.set(self, "enabled", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="permanentDeletionTimeInDays")
    def permanent_deletion_time_in_days(self) -> typing.Optional[jsii.Number]:
        return jsii.get(self, "permanentDeletionTimeInDays")

    @permanent_deletion_time_in_days.setter
    def permanent_deletion_time_in_days(
        self, value: typing.Optional[jsii.Number]
    ) -> None:
        jsii.set(self, "permanentDeletionTimeInDays", value)

    @builtins.property
    @jsii.member(jsii_name="revocationConfiguration")
    def revocation_configuration(
        self,
    ) -> typing.Optional[
        typing.List["AcmpcaCertificateAuthorityRevocationConfiguration"]
    ]:
        return jsii.get(self, "revocationConfiguration")

    @revocation_configuration.setter
    def revocation_configuration(
        self,
        value: typing.Optional[
            typing.List["AcmpcaCertificateAuthorityRevocationConfiguration"]
        ],
    ) -> None:
        jsii.set(self, "revocationConfiguration", value)

    @builtins.property
    @jsii.member(jsii_name="tags")
    def tags(self) -> typing.Optional[typing.Mapping[str, str]]:
        return jsii.get(self, "tags")

    @tags.setter
    def tags(self, value: typing.Optional[typing.Mapping[str, str]]) -> None:
        jsii.set(self, "tags", value)

    @builtins.property
    @jsii.member(jsii_name="timeouts")
    def timeouts(self) -> typing.Optional["AcmpcaCertificateAuthorityTimeouts"]:
        return jsii.get(self, "timeouts")

    @timeouts.setter
    def timeouts(
        self, value: typing.Optional["AcmpcaCertificateAuthorityTimeouts"]
    ) -> None:
        jsii.set(self, "timeouts", value)

    @builtins.property
    @jsii.member(jsii_name="type")
    def type(self) -> typing.Optional[str]:
        return jsii.get(self, "type")

    @type.setter
    def type(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "type", value)


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AcmpcaCertificateAuthorityCertificateAuthorityConfiguration",
    jsii_struct_bases=[],
    name_mapping={
        "key_algorithm": "keyAlgorithm",
        "signing_algorithm": "signingAlgorithm",
        "subject": "subject",
    },
)
class AcmpcaCertificateAuthorityCertificateAuthorityConfiguration:
    def __init__(
        self,
        *,
        key_algorithm: str,
        signing_algorithm: str,
        subject: typing.List[
            "AcmpcaCertificateAuthorityCertificateAuthorityConfigurationSubject"
        ],
    ) -> None:
        """
        :param key_algorithm: 
        :param signing_algorithm: 
        :param subject: subject block.
        """
        self._values = {
            "key_algorithm": key_algorithm,
            "signing_algorithm": signing_algorithm,
            "subject": subject,
        }

    @builtins.property
    def key_algorithm(self) -> str:
        return self._values.get("key_algorithm")

    @builtins.property
    def signing_algorithm(self) -> str:
        return self._values.get("signing_algorithm")

    @builtins.property
    def subject(
        self,
    ) -> typing.List[
        "AcmpcaCertificateAuthorityCertificateAuthorityConfigurationSubject"
    ]:
        """subject block."""
        return self._values.get("subject")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return (
            "AcmpcaCertificateAuthorityCertificateAuthorityConfiguration(%s)"
            % ", ".join(k + "=" + repr(v) for k, v in self._values.items())
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AcmpcaCertificateAuthorityCertificateAuthorityConfigurationSubject",
    jsii_struct_bases=[],
    name_mapping={
        "common_name": "commonName",
        "country": "country",
        "distinguished_name_qualifier": "distinguishedNameQualifier",
        "generation_qualifier": "generationQualifier",
        "given_name": "givenName",
        "initials": "initials",
        "locality": "locality",
        "organization": "organization",
        "organizational_unit": "organizationalUnit",
        "pseudonym": "pseudonym",
        "state": "state",
        "surname": "surname",
        "title": "title",
    },
)
class AcmpcaCertificateAuthorityCertificateAuthorityConfigurationSubject:
    def __init__(
        self,
        *,
        common_name: typing.Optional[str] = None,
        country: typing.Optional[str] = None,
        distinguished_name_qualifier: typing.Optional[str] = None,
        generation_qualifier: typing.Optional[str] = None,
        given_name: typing.Optional[str] = None,
        initials: typing.Optional[str] = None,
        locality: typing.Optional[str] = None,
        organization: typing.Optional[str] = None,
        organizational_unit: typing.Optional[str] = None,
        pseudonym: typing.Optional[str] = None,
        state: typing.Optional[str] = None,
        surname: typing.Optional[str] = None,
        title: typing.Optional[str] = None,
    ) -> None:
        """
        :param common_name: 
        :param country: 
        :param distinguished_name_qualifier: 
        :param generation_qualifier: 
        :param given_name: 
        :param initials: 
        :param locality: 
        :param organization: 
        :param organizational_unit: 
        :param pseudonym: 
        :param state: 
        :param surname: 
        :param title: 
        """
        self._values = {}
        if common_name is not None:
            self._values["common_name"] = common_name
        if country is not None:
            self._values["country"] = country
        if distinguished_name_qualifier is not None:
            self._values["distinguished_name_qualifier"] = distinguished_name_qualifier
        if generation_qualifier is not None:
            self._values["generation_qualifier"] = generation_qualifier
        if given_name is not None:
            self._values["given_name"] = given_name
        if initials is not None:
            self._values["initials"] = initials
        if locality is not None:
            self._values["locality"] = locality
        if organization is not None:
            self._values["organization"] = organization
        if organizational_unit is not None:
            self._values["organizational_unit"] = organizational_unit
        if pseudonym is not None:
            self._values["pseudonym"] = pseudonym
        if state is not None:
            self._values["state"] = state
        if surname is not None:
            self._values["surname"] = surname
        if title is not None:
            self._values["title"] = title

    @builtins.property
    def common_name(self) -> typing.Optional[str]:
        return self._values.get("common_name")

    @builtins.property
    def country(self) -> typing.Optional[str]:
        return self._values.get("country")

    @builtins.property
    def distinguished_name_qualifier(self) -> typing.Optional[str]:
        return self._values.get("distinguished_name_qualifier")

    @builtins.property
    def generation_qualifier(self) -> typing.Optional[str]:
        return self._values.get("generation_qualifier")

    @builtins.property
    def given_name(self) -> typing.Optional[str]:
        return self._values.get("given_name")

    @builtins.property
    def initials(self) -> typing.Optional[str]:
        return self._values.get("initials")

    @builtins.property
    def locality(self) -> typing.Optional[str]:
        return self._values.get("locality")

    @builtins.property
    def organization(self) -> typing.Optional[str]:
        return self._values.get("organization")

    @builtins.property
    def organizational_unit(self) -> typing.Optional[str]:
        return self._values.get("organizational_unit")

    @builtins.property
    def pseudonym(self) -> typing.Optional[str]:
        return self._values.get("pseudonym")

    @builtins.property
    def state(self) -> typing.Optional[str]:
        return self._values.get("state")

    @builtins.property
    def surname(self) -> typing.Optional[str]:
        return self._values.get("surname")

    @builtins.property
    def title(self) -> typing.Optional[str]:
        return self._values.get("title")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return (
            "AcmpcaCertificateAuthorityCertificateAuthorityConfigurationSubject(%s)"
            % ", ".join(k + "=" + repr(v) for k, v in self._values.items())
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AcmpcaCertificateAuthorityConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "certificate_authority_configuration": "certificateAuthorityConfiguration",
        "enabled": "enabled",
        "permanent_deletion_time_in_days": "permanentDeletionTimeInDays",
        "revocation_configuration": "revocationConfiguration",
        "tags": "tags",
        "timeouts": "timeouts",
        "type": "type",
    },
)
class AcmpcaCertificateAuthorityConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        certificate_authority_configuration: typing.List[
            "AcmpcaCertificateAuthorityCertificateAuthorityConfiguration"
        ],
        enabled: typing.Optional[bool] = None,
        permanent_deletion_time_in_days: typing.Optional[jsii.Number] = None,
        revocation_configuration: typing.Optional[
            typing.List["AcmpcaCertificateAuthorityRevocationConfiguration"]
        ] = None,
        tags: typing.Optional[typing.Mapping[str, str]] = None,
        timeouts: typing.Optional["AcmpcaCertificateAuthorityTimeouts"] = None,
        type: typing.Optional[str] = None,
    ) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param certificate_authority_configuration: certificate_authority_configuration block.
        :param enabled: 
        :param permanent_deletion_time_in_days: 
        :param revocation_configuration: revocation_configuration block.
        :param tags: 
        :param timeouts: timeouts block.
        :param type: 
        """
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        if isinstance(timeouts, dict):
            timeouts = AcmpcaCertificateAuthorityTimeouts(**timeouts)
        self._values = {
            "certificate_authority_configuration": certificate_authority_configuration,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if enabled is not None:
            self._values["enabled"] = enabled
        if permanent_deletion_time_in_days is not None:
            self._values[
                "permanent_deletion_time_in_days"
            ] = permanent_deletion_time_in_days
        if revocation_configuration is not None:
            self._values["revocation_configuration"] = revocation_configuration
        if tags is not None:
            self._values["tags"] = tags
        if timeouts is not None:
            self._values["timeouts"] = timeouts
        if type is not None:
            self._values["type"] = type

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("count")

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.TerraformResource]]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("depends_on")

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("lifecycle")

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("provider")

    @builtins.property
    def certificate_authority_configuration(
        self,
    ) -> typing.List["AcmpcaCertificateAuthorityCertificateAuthorityConfiguration"]:
        """certificate_authority_configuration block."""
        return self._values.get("certificate_authority_configuration")

    @builtins.property
    def enabled(self) -> typing.Optional[bool]:
        return self._values.get("enabled")

    @builtins.property
    def permanent_deletion_time_in_days(self) -> typing.Optional[jsii.Number]:
        return self._values.get("permanent_deletion_time_in_days")

    @builtins.property
    def revocation_configuration(
        self,
    ) -> typing.Optional[
        typing.List["AcmpcaCertificateAuthorityRevocationConfiguration"]
    ]:
        """revocation_configuration block."""
        return self._values.get("revocation_configuration")

    @builtins.property
    def tags(self) -> typing.Optional[typing.Mapping[str, str]]:
        return self._values.get("tags")

    @builtins.property
    def timeouts(self) -> typing.Optional["AcmpcaCertificateAuthorityTimeouts"]:
        """timeouts block."""
        return self._values.get("timeouts")

    @builtins.property
    def type(self) -> typing.Optional[str]:
        return self._values.get("type")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AcmpcaCertificateAuthorityConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AcmpcaCertificateAuthorityRevocationConfiguration",
    jsii_struct_bases=[],
    name_mapping={"crl_configuration": "crlConfiguration"},
)
class AcmpcaCertificateAuthorityRevocationConfiguration:
    def __init__(
        self,
        *,
        crl_configuration: typing.Optional[
            typing.List[
                "AcmpcaCertificateAuthorityRevocationConfigurationCrlConfiguration"
            ]
        ] = None,
    ) -> None:
        """
        :param crl_configuration: crl_configuration block.
        """
        self._values = {}
        if crl_configuration is not None:
            self._values["crl_configuration"] = crl_configuration

    @builtins.property
    def crl_configuration(
        self,
    ) -> typing.Optional[
        typing.List["AcmpcaCertificateAuthorityRevocationConfigurationCrlConfiguration"]
    ]:
        """crl_configuration block."""
        return self._values.get("crl_configuration")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AcmpcaCertificateAuthorityRevocationConfiguration(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AcmpcaCertificateAuthorityRevocationConfigurationCrlConfiguration",
    jsii_struct_bases=[],
    name_mapping={
        "expiration_in_days": "expirationInDays",
        "custom_cname": "customCname",
        "enabled": "enabled",
        "s3_bucket_name": "s3BucketName",
    },
)
class AcmpcaCertificateAuthorityRevocationConfigurationCrlConfiguration:
    def __init__(
        self,
        *,
        expiration_in_days: jsii.Number,
        custom_cname: typing.Optional[str] = None,
        enabled: typing.Optional[bool] = None,
        s3_bucket_name: typing.Optional[str] = None,
    ) -> None:
        """
        :param expiration_in_days: 
        :param custom_cname: 
        :param enabled: 
        :param s3_bucket_name: 
        """
        self._values = {
            "expiration_in_days": expiration_in_days,
        }
        if custom_cname is not None:
            self._values["custom_cname"] = custom_cname
        if enabled is not None:
            self._values["enabled"] = enabled
        if s3_bucket_name is not None:
            self._values["s3_bucket_name"] = s3_bucket_name

    @builtins.property
    def expiration_in_days(self) -> jsii.Number:
        return self._values.get("expiration_in_days")

    @builtins.property
    def custom_cname(self) -> typing.Optional[str]:
        return self._values.get("custom_cname")

    @builtins.property
    def enabled(self) -> typing.Optional[bool]:
        return self._values.get("enabled")

    @builtins.property
    def s3_bucket_name(self) -> typing.Optional[str]:
        return self._values.get("s3_bucket_name")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return (
            "AcmpcaCertificateAuthorityRevocationConfigurationCrlConfiguration(%s)"
            % ", ".join(k + "=" + repr(v) for k, v in self._values.items())
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AcmpcaCertificateAuthorityTimeouts",
    jsii_struct_bases=[],
    name_mapping={"create": "create"},
)
class AcmpcaCertificateAuthorityTimeouts:
    def __init__(self, *, create: typing.Optional[str] = None) -> None:
        """
        :param create: 
        """
        self._values = {}
        if create is not None:
            self._values["create"] = create

    @builtins.property
    def create(self) -> typing.Optional[str]:
        return self._values.get("create")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AcmpcaCertificateAuthorityTimeouts(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class Alb(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="@skorfmann/cdktf-provider-aws.Alb",
):
    def __init__(
        self,
        scope: constructs.Construct,
        id: str,
        *,
        access_logs: typing.Optional[typing.List["AlbAccessLogs"]] = None,
        drop_invalid_header_fields: typing.Optional[bool] = None,
        enable_cross_zone_load_balancing: typing.Optional[bool] = None,
        enable_deletion_protection: typing.Optional[bool] = None,
        enable_http2: typing.Optional[bool] = None,
        idle_timeout: typing.Optional[jsii.Number] = None,
        internal: typing.Optional[bool] = None,
        ip_address_type: typing.Optional[str] = None,
        load_balancer_type: typing.Optional[str] = None,
        name: typing.Optional[str] = None,
        name_prefix: typing.Optional[str] = None,
        security_groups: typing.Optional[typing.List[str]] = None,
        subnet_mapping: typing.Optional[typing.List["AlbSubnetMapping"]] = None,
        subnets: typing.Optional[typing.List[str]] = None,
        tags: typing.Optional[typing.Mapping[str, str]] = None,
        timeouts: typing.Optional["AlbTimeouts"] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param access_logs: access_logs block.
        :param drop_invalid_header_fields: 
        :param enable_cross_zone_load_balancing: 
        :param enable_deletion_protection: 
        :param enable_http2: 
        :param idle_timeout: 
        :param internal: 
        :param ip_address_type: 
        :param load_balancer_type: 
        :param name: 
        :param name_prefix: 
        :param security_groups: 
        :param subnet_mapping: subnet_mapping block.
        :param subnets: 
        :param tags: 
        :param timeouts: timeouts block.
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = AlbConfig(
            access_logs=access_logs,
            drop_invalid_header_fields=drop_invalid_header_fields,
            enable_cross_zone_load_balancing=enable_cross_zone_load_balancing,
            enable_deletion_protection=enable_deletion_protection,
            enable_http2=enable_http2,
            idle_timeout=idle_timeout,
            internal=internal,
            ip_address_type=ip_address_type,
            load_balancer_type=load_balancer_type,
            name=name,
            name_prefix=name_prefix,
            security_groups=security_groups,
            subnet_mapping=subnet_mapping,
            subnets=subnets,
            tags=tags,
            timeouts=timeouts,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(Alb, self, [scope, id, config])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property
    @jsii.member(jsii_name="arn")
    def arn(self) -> str:
        return jsii.get(self, "arn")

    @builtins.property
    @jsii.member(jsii_name="arnSuffix")
    def arn_suffix(self) -> str:
        return jsii.get(self, "arnSuffix")

    @builtins.property
    @jsii.member(jsii_name="dnsName")
    def dns_name(self) -> str:
        return jsii.get(self, "dnsName")

    @builtins.property
    @jsii.member(jsii_name="vpcId")
    def vpc_id(self) -> str:
        return jsii.get(self, "vpcId")

    @builtins.property
    @jsii.member(jsii_name="zoneId")
    def zone_id(self) -> str:
        return jsii.get(self, "zoneId")

    @builtins.property
    @jsii.member(jsii_name="accessLogs")
    def access_logs(self) -> typing.Optional[typing.List["AlbAccessLogs"]]:
        return jsii.get(self, "accessLogs")

    @access_logs.setter
    def access_logs(self, value: typing.Optional[typing.List["AlbAccessLogs"]]) -> None:
        jsii.set(self, "accessLogs", value)

    @builtins.property
    @jsii.member(jsii_name="dropInvalidHeaderFields")
    def drop_invalid_header_fields(self) -> typing.Optional[bool]:
        return jsii.get(self, "dropInvalidHeaderFields")

    @drop_invalid_header_fields.setter
    def drop_invalid_header_fields(self, value: typing.Optional[bool]) -> None:
        jsii.set(self, "dropInvalidHeaderFields", value)

    @builtins.property
    @jsii.member(jsii_name="enableCrossZoneLoadBalancing")
    def enable_cross_zone_load_balancing(self) -> typing.Optional[bool]:
        return jsii.get(self, "enableCrossZoneLoadBalancing")

    @enable_cross_zone_load_balancing.setter
    def enable_cross_zone_load_balancing(self, value: typing.Optional[bool]) -> None:
        jsii.set(self, "enableCrossZoneLoadBalancing", value)

    @builtins.property
    @jsii.member(jsii_name="enableDeletionProtection")
    def enable_deletion_protection(self) -> typing.Optional[bool]:
        return jsii.get(self, "enableDeletionProtection")

    @enable_deletion_protection.setter
    def enable_deletion_protection(self, value: typing.Optional[bool]) -> None:
        jsii.set(self, "enableDeletionProtection", value)

    @builtins.property
    @jsii.member(jsii_name="enableHttp2")
    def enable_http2(self) -> typing.Optional[bool]:
        return jsii.get(self, "enableHttp2")

    @enable_http2.setter
    def enable_http2(self, value: typing.Optional[bool]) -> None:
        jsii.set(self, "enableHttp2", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="idleTimeout")
    def idle_timeout(self) -> typing.Optional[jsii.Number]:
        return jsii.get(self, "idleTimeout")

    @idle_timeout.setter
    def idle_timeout(self, value: typing.Optional[jsii.Number]) -> None:
        jsii.set(self, "idleTimeout", value)

    @builtins.property
    @jsii.member(jsii_name="internal")
    def internal(self) -> typing.Optional[bool]:
        return jsii.get(self, "internal")

    @internal.setter
    def internal(self, value: typing.Optional[bool]) -> None:
        jsii.set(self, "internal", value)

    @builtins.property
    @jsii.member(jsii_name="ipAddressType")
    def ip_address_type(self) -> typing.Optional[str]:
        return jsii.get(self, "ipAddressType")

    @ip_address_type.setter
    def ip_address_type(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "ipAddressType", value)

    @builtins.property
    @jsii.member(jsii_name="loadBalancerType")
    def load_balancer_type(self) -> typing.Optional[str]:
        return jsii.get(self, "loadBalancerType")

    @load_balancer_type.setter
    def load_balancer_type(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "loadBalancerType", value)

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> typing.Optional[str]:
        return jsii.get(self, "name")

    @name.setter
    def name(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "name", value)

    @builtins.property
    @jsii.member(jsii_name="namePrefix")
    def name_prefix(self) -> typing.Optional[str]:
        return jsii.get(self, "namePrefix")

    @name_prefix.setter
    def name_prefix(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "namePrefix", value)

    @builtins.property
    @jsii.member(jsii_name="securityGroups")
    def security_groups(self) -> typing.Optional[typing.List[str]]:
        return jsii.get(self, "securityGroups")

    @security_groups.setter
    def security_groups(self, value: typing.Optional[typing.List[str]]) -> None:
        jsii.set(self, "securityGroups", value)

    @builtins.property
    @jsii.member(jsii_name="subnetMapping")
    def subnet_mapping(self) -> typing.Optional[typing.List["AlbSubnetMapping"]]:
        return jsii.get(self, "subnetMapping")

    @subnet_mapping.setter
    def subnet_mapping(
        self, value: typing.Optional[typing.List["AlbSubnetMapping"]]
    ) -> None:
        jsii.set(self, "subnetMapping", value)

    @builtins.property
    @jsii.member(jsii_name="subnets")
    def subnets(self) -> typing.Optional[typing.List[str]]:
        return jsii.get(self, "subnets")

    @subnets.setter
    def subnets(self, value: typing.Optional[typing.List[str]]) -> None:
        jsii.set(self, "subnets", value)

    @builtins.property
    @jsii.member(jsii_name="tags")
    def tags(self) -> typing.Optional[typing.Mapping[str, str]]:
        return jsii.get(self, "tags")

    @tags.setter
    def tags(self, value: typing.Optional[typing.Mapping[str, str]]) -> None:
        jsii.set(self, "tags", value)

    @builtins.property
    @jsii.member(jsii_name="timeouts")
    def timeouts(self) -> typing.Optional["AlbTimeouts"]:
        return jsii.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: typing.Optional["AlbTimeouts"]) -> None:
        jsii.set(self, "timeouts", value)


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AlbAccessLogs",
    jsii_struct_bases=[],
    name_mapping={"bucket": "bucket", "enabled": "enabled", "prefix": "prefix"},
)
class AlbAccessLogs:
    def __init__(
        self,
        *,
        bucket: str,
        enabled: typing.Optional[bool] = None,
        prefix: typing.Optional[str] = None,
    ) -> None:
        """
        :param bucket: 
        :param enabled: 
        :param prefix: 
        """
        self._values = {
            "bucket": bucket,
        }
        if enabled is not None:
            self._values["enabled"] = enabled
        if prefix is not None:
            self._values["prefix"] = prefix

    @builtins.property
    def bucket(self) -> str:
        return self._values.get("bucket")

    @builtins.property
    def enabled(self) -> typing.Optional[bool]:
        return self._values.get("enabled")

    @builtins.property
    def prefix(self) -> typing.Optional[str]:
        return self._values.get("prefix")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AlbAccessLogs(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AlbConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "access_logs": "accessLogs",
        "drop_invalid_header_fields": "dropInvalidHeaderFields",
        "enable_cross_zone_load_balancing": "enableCrossZoneLoadBalancing",
        "enable_deletion_protection": "enableDeletionProtection",
        "enable_http2": "enableHttp2",
        "idle_timeout": "idleTimeout",
        "internal": "internal",
        "ip_address_type": "ipAddressType",
        "load_balancer_type": "loadBalancerType",
        "name": "name",
        "name_prefix": "namePrefix",
        "security_groups": "securityGroups",
        "subnet_mapping": "subnetMapping",
        "subnets": "subnets",
        "tags": "tags",
        "timeouts": "timeouts",
    },
)
class AlbConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        access_logs: typing.Optional[typing.List["AlbAccessLogs"]] = None,
        drop_invalid_header_fields: typing.Optional[bool] = None,
        enable_cross_zone_load_balancing: typing.Optional[bool] = None,
        enable_deletion_protection: typing.Optional[bool] = None,
        enable_http2: typing.Optional[bool] = None,
        idle_timeout: typing.Optional[jsii.Number] = None,
        internal: typing.Optional[bool] = None,
        ip_address_type: typing.Optional[str] = None,
        load_balancer_type: typing.Optional[str] = None,
        name: typing.Optional[str] = None,
        name_prefix: typing.Optional[str] = None,
        security_groups: typing.Optional[typing.List[str]] = None,
        subnet_mapping: typing.Optional[typing.List["AlbSubnetMapping"]] = None,
        subnets: typing.Optional[typing.List[str]] = None,
        tags: typing.Optional[typing.Mapping[str, str]] = None,
        timeouts: typing.Optional["AlbTimeouts"] = None,
    ) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param access_logs: access_logs block.
        :param drop_invalid_header_fields: 
        :param enable_cross_zone_load_balancing: 
        :param enable_deletion_protection: 
        :param enable_http2: 
        :param idle_timeout: 
        :param internal: 
        :param ip_address_type: 
        :param load_balancer_type: 
        :param name: 
        :param name_prefix: 
        :param security_groups: 
        :param subnet_mapping: subnet_mapping block.
        :param subnets: 
        :param tags: 
        :param timeouts: timeouts block.
        """
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        if isinstance(timeouts, dict):
            timeouts = AlbTimeouts(**timeouts)
        self._values = {}
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if access_logs is not None:
            self._values["access_logs"] = access_logs
        if drop_invalid_header_fields is not None:
            self._values["drop_invalid_header_fields"] = drop_invalid_header_fields
        if enable_cross_zone_load_balancing is not None:
            self._values[
                "enable_cross_zone_load_balancing"
            ] = enable_cross_zone_load_balancing
        if enable_deletion_protection is not None:
            self._values["enable_deletion_protection"] = enable_deletion_protection
        if enable_http2 is not None:
            self._values["enable_http2"] = enable_http2
        if idle_timeout is not None:
            self._values["idle_timeout"] = idle_timeout
        if internal is not None:
            self._values["internal"] = internal
        if ip_address_type is not None:
            self._values["ip_address_type"] = ip_address_type
        if load_balancer_type is not None:
            self._values["load_balancer_type"] = load_balancer_type
        if name is not None:
            self._values["name"] = name
        if name_prefix is not None:
            self._values["name_prefix"] = name_prefix
        if security_groups is not None:
            self._values["security_groups"] = security_groups
        if subnet_mapping is not None:
            self._values["subnet_mapping"] = subnet_mapping
        if subnets is not None:
            self._values["subnets"] = subnets
        if tags is not None:
            self._values["tags"] = tags
        if timeouts is not None:
            self._values["timeouts"] = timeouts

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("count")

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.TerraformResource]]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("depends_on")

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("lifecycle")

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("provider")

    @builtins.property
    def access_logs(self) -> typing.Optional[typing.List["AlbAccessLogs"]]:
        """access_logs block."""
        return self._values.get("access_logs")

    @builtins.property
    def drop_invalid_header_fields(self) -> typing.Optional[bool]:
        return self._values.get("drop_invalid_header_fields")

    @builtins.property
    def enable_cross_zone_load_balancing(self) -> typing.Optional[bool]:
        return self._values.get("enable_cross_zone_load_balancing")

    @builtins.property
    def enable_deletion_protection(self) -> typing.Optional[bool]:
        return self._values.get("enable_deletion_protection")

    @builtins.property
    def enable_http2(self) -> typing.Optional[bool]:
        return self._values.get("enable_http2")

    @builtins.property
    def idle_timeout(self) -> typing.Optional[jsii.Number]:
        return self._values.get("idle_timeout")

    @builtins.property
    def internal(self) -> typing.Optional[bool]:
        return self._values.get("internal")

    @builtins.property
    def ip_address_type(self) -> typing.Optional[str]:
        return self._values.get("ip_address_type")

    @builtins.property
    def load_balancer_type(self) -> typing.Optional[str]:
        return self._values.get("load_balancer_type")

    @builtins.property
    def name(self) -> typing.Optional[str]:
        return self._values.get("name")

    @builtins.property
    def name_prefix(self) -> typing.Optional[str]:
        return self._values.get("name_prefix")

    @builtins.property
    def security_groups(self) -> typing.Optional[typing.List[str]]:
        return self._values.get("security_groups")

    @builtins.property
    def subnet_mapping(self) -> typing.Optional[typing.List["AlbSubnetMapping"]]:
        """subnet_mapping block."""
        return self._values.get("subnet_mapping")

    @builtins.property
    def subnets(self) -> typing.Optional[typing.List[str]]:
        return self._values.get("subnets")

    @builtins.property
    def tags(self) -> typing.Optional[typing.Mapping[str, str]]:
        return self._values.get("tags")

    @builtins.property
    def timeouts(self) -> typing.Optional["AlbTimeouts"]:
        """timeouts block."""
        return self._values.get("timeouts")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AlbConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class AlbListener(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="@skorfmann/cdktf-provider-aws.AlbListener",
):
    def __init__(
        self,
        scope: constructs.Construct,
        id: str,
        *,
        default_action: typing.List["AlbListenerDefaultAction"],
        load_balancer_arn: str,
        port: jsii.Number,
        certificate_arn: typing.Optional[str] = None,
        protocol: typing.Optional[str] = None,
        ssl_policy: typing.Optional[str] = None,
        timeouts: typing.Optional["AlbListenerTimeouts"] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param default_action: default_action block.
        :param load_balancer_arn: 
        :param port: 
        :param certificate_arn: 
        :param protocol: 
        :param ssl_policy: 
        :param timeouts: timeouts block.
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = AlbListenerConfig(
            default_action=default_action,
            load_balancer_arn=load_balancer_arn,
            port=port,
            certificate_arn=certificate_arn,
            protocol=protocol,
            ssl_policy=ssl_policy,
            timeouts=timeouts,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(AlbListener, self, [scope, id, config])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property
    @jsii.member(jsii_name="arn")
    def arn(self) -> str:
        return jsii.get(self, "arn")

    @builtins.property
    @jsii.member(jsii_name="defaultAction")
    def default_action(self) -> typing.List["AlbListenerDefaultAction"]:
        return jsii.get(self, "defaultAction")

    @default_action.setter
    def default_action(self, value: typing.List["AlbListenerDefaultAction"]) -> None:
        jsii.set(self, "defaultAction", value)

    @builtins.property
    @jsii.member(jsii_name="loadBalancerArn")
    def load_balancer_arn(self) -> str:
        return jsii.get(self, "loadBalancerArn")

    @load_balancer_arn.setter
    def load_balancer_arn(self, value: str) -> None:
        jsii.set(self, "loadBalancerArn", value)

    @builtins.property
    @jsii.member(jsii_name="port")
    def port(self) -> jsii.Number:
        return jsii.get(self, "port")

    @port.setter
    def port(self, value: jsii.Number) -> None:
        jsii.set(self, "port", value)

    @builtins.property
    @jsii.member(jsii_name="certificateArn")
    def certificate_arn(self) -> typing.Optional[str]:
        return jsii.get(self, "certificateArn")

    @certificate_arn.setter
    def certificate_arn(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "certificateArn", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="protocol")
    def protocol(self) -> typing.Optional[str]:
        return jsii.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "protocol", value)

    @builtins.property
    @jsii.member(jsii_name="sslPolicy")
    def ssl_policy(self) -> typing.Optional[str]:
        return jsii.get(self, "sslPolicy")

    @ssl_policy.setter
    def ssl_policy(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "sslPolicy", value)

    @builtins.property
    @jsii.member(jsii_name="timeouts")
    def timeouts(self) -> typing.Optional["AlbListenerTimeouts"]:
        return jsii.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: typing.Optional["AlbListenerTimeouts"]) -> None:
        jsii.set(self, "timeouts", value)


class AlbListenerCertificate(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="@skorfmann/cdktf-provider-aws.AlbListenerCertificate",
):
    def __init__(
        self,
        scope: constructs.Construct,
        id: str,
        *,
        certificate_arn: str,
        listener_arn: str,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param certificate_arn: 
        :param listener_arn: 
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = AlbListenerCertificateConfig(
            certificate_arn=certificate_arn,
            listener_arn=listener_arn,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(AlbListenerCertificate, self, [scope, id, config])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property
    @jsii.member(jsii_name="certificateArn")
    def certificate_arn(self) -> str:
        return jsii.get(self, "certificateArn")

    @certificate_arn.setter
    def certificate_arn(self, value: str) -> None:
        jsii.set(self, "certificateArn", value)

    @builtins.property
    @jsii.member(jsii_name="listenerArn")
    def listener_arn(self) -> str:
        return jsii.get(self, "listenerArn")

    @listener_arn.setter
    def listener_arn(self, value: str) -> None:
        jsii.set(self, "listenerArn", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AlbListenerCertificateConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "certificate_arn": "certificateArn",
        "listener_arn": "listenerArn",
    },
)
class AlbListenerCertificateConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        certificate_arn: str,
        listener_arn: str,
    ) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param certificate_arn: 
        :param listener_arn: 
        """
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        self._values = {
            "certificate_arn": certificate_arn,
            "listener_arn": listener_arn,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("count")

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.TerraformResource]]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("depends_on")

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("lifecycle")

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("provider")

    @builtins.property
    def certificate_arn(self) -> str:
        return self._values.get("certificate_arn")

    @builtins.property
    def listener_arn(self) -> str:
        return self._values.get("listener_arn")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AlbListenerCertificateConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AlbListenerConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "default_action": "defaultAction",
        "load_balancer_arn": "loadBalancerArn",
        "port": "port",
        "certificate_arn": "certificateArn",
        "protocol": "protocol",
        "ssl_policy": "sslPolicy",
        "timeouts": "timeouts",
    },
)
class AlbListenerConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        default_action: typing.List["AlbListenerDefaultAction"],
        load_balancer_arn: str,
        port: jsii.Number,
        certificate_arn: typing.Optional[str] = None,
        protocol: typing.Optional[str] = None,
        ssl_policy: typing.Optional[str] = None,
        timeouts: typing.Optional["AlbListenerTimeouts"] = None,
    ) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param default_action: default_action block.
        :param load_balancer_arn: 
        :param port: 
        :param certificate_arn: 
        :param protocol: 
        :param ssl_policy: 
        :param timeouts: timeouts block.
        """
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        if isinstance(timeouts, dict):
            timeouts = AlbListenerTimeouts(**timeouts)
        self._values = {
            "default_action": default_action,
            "load_balancer_arn": load_balancer_arn,
            "port": port,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if certificate_arn is not None:
            self._values["certificate_arn"] = certificate_arn
        if protocol is not None:
            self._values["protocol"] = protocol
        if ssl_policy is not None:
            self._values["ssl_policy"] = ssl_policy
        if timeouts is not None:
            self._values["timeouts"] = timeouts

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("count")

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.TerraformResource]]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("depends_on")

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("lifecycle")

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("provider")

    @builtins.property
    def default_action(self) -> typing.List["AlbListenerDefaultAction"]:
        """default_action block."""
        return self._values.get("default_action")

    @builtins.property
    def load_balancer_arn(self) -> str:
        return self._values.get("load_balancer_arn")

    @builtins.property
    def port(self) -> jsii.Number:
        return self._values.get("port")

    @builtins.property
    def certificate_arn(self) -> typing.Optional[str]:
        return self._values.get("certificate_arn")

    @builtins.property
    def protocol(self) -> typing.Optional[str]:
        return self._values.get("protocol")

    @builtins.property
    def ssl_policy(self) -> typing.Optional[str]:
        return self._values.get("ssl_policy")

    @builtins.property
    def timeouts(self) -> typing.Optional["AlbListenerTimeouts"]:
        """timeouts block."""
        return self._values.get("timeouts")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AlbListenerConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AlbListenerDefaultAction",
    jsii_struct_bases=[],
    name_mapping={
        "type": "type",
        "authenticate_cognito": "authenticateCognito",
        "authenticate_oidc": "authenticateOidc",
        "fixed_response": "fixedResponse",
        "forward": "forward",
        "order": "order",
        "redirect": "redirect",
        "target_group_arn": "targetGroupArn",
    },
)
class AlbListenerDefaultAction:
    def __init__(
        self,
        *,
        type: str,
        authenticate_cognito: typing.Optional[
            typing.List["AlbListenerDefaultActionAuthenticateCognito"]
        ] = None,
        authenticate_oidc: typing.Optional[
            typing.List["AlbListenerDefaultActionAuthenticateOidc"]
        ] = None,
        fixed_response: typing.Optional[
            typing.List["AlbListenerDefaultActionFixedResponse"]
        ] = None,
        forward: typing.Optional[typing.List["AlbListenerDefaultActionForward"]] = None,
        order: typing.Optional[jsii.Number] = None,
        redirect: typing.Optional[
            typing.List["AlbListenerDefaultActionRedirect"]
        ] = None,
        target_group_arn: typing.Optional[str] = None,
    ) -> None:
        """
        :param type: 
        :param authenticate_cognito: authenticate_cognito block.
        :param authenticate_oidc: authenticate_oidc block.
        :param fixed_response: fixed_response block.
        :param forward: forward block.
        :param order: 
        :param redirect: redirect block.
        :param target_group_arn: 
        """
        self._values = {
            "type": type,
        }
        if authenticate_cognito is not None:
            self._values["authenticate_cognito"] = authenticate_cognito
        if authenticate_oidc is not None:
            self._values["authenticate_oidc"] = authenticate_oidc
        if fixed_response is not None:
            self._values["fixed_response"] = fixed_response
        if forward is not None:
            self._values["forward"] = forward
        if order is not None:
            self._values["order"] = order
        if redirect is not None:
            self._values["redirect"] = redirect
        if target_group_arn is not None:
            self._values["target_group_arn"] = target_group_arn

    @builtins.property
    def type(self) -> str:
        return self._values.get("type")

    @builtins.property
    def authenticate_cognito(
        self,
    ) -> typing.Optional[typing.List["AlbListenerDefaultActionAuthenticateCognito"]]:
        """authenticate_cognito block."""
        return self._values.get("authenticate_cognito")

    @builtins.property
    def authenticate_oidc(
        self,
    ) -> typing.Optional[typing.List["AlbListenerDefaultActionAuthenticateOidc"]]:
        """authenticate_oidc block."""
        return self._values.get("authenticate_oidc")

    @builtins.property
    def fixed_response(
        self,
    ) -> typing.Optional[typing.List["AlbListenerDefaultActionFixedResponse"]]:
        """fixed_response block."""
        return self._values.get("fixed_response")

    @builtins.property
    def forward(
        self,
    ) -> typing.Optional[typing.List["AlbListenerDefaultActionForward"]]:
        """forward block."""
        return self._values.get("forward")

    @builtins.property
    def order(self) -> typing.Optional[jsii.Number]:
        return self._values.get("order")

    @builtins.property
    def redirect(
        self,
    ) -> typing.Optional[typing.List["AlbListenerDefaultActionRedirect"]]:
        """redirect block."""
        return self._values.get("redirect")

    @builtins.property
    def target_group_arn(self) -> typing.Optional[str]:
        return self._values.get("target_group_arn")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AlbListenerDefaultAction(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AlbListenerDefaultActionAuthenticateCognito",
    jsii_struct_bases=[],
    name_mapping={
        "user_pool_arn": "userPoolArn",
        "user_pool_client_id": "userPoolClientId",
        "user_pool_domain": "userPoolDomain",
        "authentication_request_extra_params": "authenticationRequestExtraParams",
        "on_unauthenticated_request": "onUnauthenticatedRequest",
        "scope": "scope",
        "session_cookie_name": "sessionCookieName",
        "session_timeout": "sessionTimeout",
    },
)
class AlbListenerDefaultActionAuthenticateCognito:
    def __init__(
        self,
        *,
        user_pool_arn: str,
        user_pool_client_id: str,
        user_pool_domain: str,
        authentication_request_extra_params: typing.Optional[
            typing.Mapping[str, str]
        ] = None,
        on_unauthenticated_request: typing.Optional[str] = None,
        scope: typing.Optional[str] = None,
        session_cookie_name: typing.Optional[str] = None,
        session_timeout: typing.Optional[jsii.Number] = None,
    ) -> None:
        """
        :param user_pool_arn: 
        :param user_pool_client_id: 
        :param user_pool_domain: 
        :param authentication_request_extra_params: 
        :param on_unauthenticated_request: 
        :param scope: 
        :param session_cookie_name: 
        :param session_timeout: 
        """
        self._values = {
            "user_pool_arn": user_pool_arn,
            "user_pool_client_id": user_pool_client_id,
            "user_pool_domain": user_pool_domain,
        }
        if authentication_request_extra_params is not None:
            self._values[
                "authentication_request_extra_params"
            ] = authentication_request_extra_params
        if on_unauthenticated_request is not None:
            self._values["on_unauthenticated_request"] = on_unauthenticated_request
        if scope is not None:
            self._values["scope"] = scope
        if session_cookie_name is not None:
            self._values["session_cookie_name"] = session_cookie_name
        if session_timeout is not None:
            self._values["session_timeout"] = session_timeout

    @builtins.property
    def user_pool_arn(self) -> str:
        return self._values.get("user_pool_arn")

    @builtins.property
    def user_pool_client_id(self) -> str:
        return self._values.get("user_pool_client_id")

    @builtins.property
    def user_pool_domain(self) -> str:
        return self._values.get("user_pool_domain")

    @builtins.property
    def authentication_request_extra_params(
        self,
    ) -> typing.Optional[typing.Mapping[str, str]]:
        return self._values.get("authentication_request_extra_params")

    @builtins.property
    def on_unauthenticated_request(self) -> typing.Optional[str]:
        return self._values.get("on_unauthenticated_request")

    @builtins.property
    def scope(self) -> typing.Optional[str]:
        return self._values.get("scope")

    @builtins.property
    def session_cookie_name(self) -> typing.Optional[str]:
        return self._values.get("session_cookie_name")

    @builtins.property
    def session_timeout(self) -> typing.Optional[jsii.Number]:
        return self._values.get("session_timeout")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AlbListenerDefaultActionAuthenticateCognito(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AlbListenerDefaultActionAuthenticateOidc",
    jsii_struct_bases=[],
    name_mapping={
        "authorization_endpoint": "authorizationEndpoint",
        "client_id": "clientId",
        "client_secret": "clientSecret",
        "issuer": "issuer",
        "token_endpoint": "tokenEndpoint",
        "user_info_endpoint": "userInfoEndpoint",
        "authentication_request_extra_params": "authenticationRequestExtraParams",
        "on_unauthenticated_request": "onUnauthenticatedRequest",
        "scope": "scope",
        "session_cookie_name": "sessionCookieName",
        "session_timeout": "sessionTimeout",
    },
)
class AlbListenerDefaultActionAuthenticateOidc:
    def __init__(
        self,
        *,
        authorization_endpoint: str,
        client_id: str,
        client_secret: str,
        issuer: str,
        token_endpoint: str,
        user_info_endpoint: str,
        authentication_request_extra_params: typing.Optional[
            typing.Mapping[str, str]
        ] = None,
        on_unauthenticated_request: typing.Optional[str] = None,
        scope: typing.Optional[str] = None,
        session_cookie_name: typing.Optional[str] = None,
        session_timeout: typing.Optional[jsii.Number] = None,
    ) -> None:
        """
        :param authorization_endpoint: 
        :param client_id: 
        :param client_secret: 
        :param issuer: 
        :param token_endpoint: 
        :param user_info_endpoint: 
        :param authentication_request_extra_params: 
        :param on_unauthenticated_request: 
        :param scope: 
        :param session_cookie_name: 
        :param session_timeout: 
        """
        self._values = {
            "authorization_endpoint": authorization_endpoint,
            "client_id": client_id,
            "client_secret": client_secret,
            "issuer": issuer,
            "token_endpoint": token_endpoint,
            "user_info_endpoint": user_info_endpoint,
        }
        if authentication_request_extra_params is not None:
            self._values[
                "authentication_request_extra_params"
            ] = authentication_request_extra_params
        if on_unauthenticated_request is not None:
            self._values["on_unauthenticated_request"] = on_unauthenticated_request
        if scope is not None:
            self._values["scope"] = scope
        if session_cookie_name is not None:
            self._values["session_cookie_name"] = session_cookie_name
        if session_timeout is not None:
            self._values["session_timeout"] = session_timeout

    @builtins.property
    def authorization_endpoint(self) -> str:
        return self._values.get("authorization_endpoint")

    @builtins.property
    def client_id(self) -> str:
        return self._values.get("client_id")

    @builtins.property
    def client_secret(self) -> str:
        return self._values.get("client_secret")

    @builtins.property
    def issuer(self) -> str:
        return self._values.get("issuer")

    @builtins.property
    def token_endpoint(self) -> str:
        return self._values.get("token_endpoint")

    @builtins.property
    def user_info_endpoint(self) -> str:
        return self._values.get("user_info_endpoint")

    @builtins.property
    def authentication_request_extra_params(
        self,
    ) -> typing.Optional[typing.Mapping[str, str]]:
        return self._values.get("authentication_request_extra_params")

    @builtins.property
    def on_unauthenticated_request(self) -> typing.Optional[str]:
        return self._values.get("on_unauthenticated_request")

    @builtins.property
    def scope(self) -> typing.Optional[str]:
        return self._values.get("scope")

    @builtins.property
    def session_cookie_name(self) -> typing.Optional[str]:
        return self._values.get("session_cookie_name")

    @builtins.property
    def session_timeout(self) -> typing.Optional[jsii.Number]:
        return self._values.get("session_timeout")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AlbListenerDefaultActionAuthenticateOidc(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AlbListenerDefaultActionFixedResponse",
    jsii_struct_bases=[],
    name_mapping={
        "content_type": "contentType",
        "message_body": "messageBody",
        "status_code": "statusCode",
    },
)
class AlbListenerDefaultActionFixedResponse:
    def __init__(
        self,
        *,
        content_type: str,
        message_body: typing.Optional[str] = None,
        status_code: typing.Optional[str] = None,
    ) -> None:
        """
        :param content_type: 
        :param message_body: 
        :param status_code: 
        """
        self._values = {
            "content_type": content_type,
        }
        if message_body is not None:
            self._values["message_body"] = message_body
        if status_code is not None:
            self._values["status_code"] = status_code

    @builtins.property
    def content_type(self) -> str:
        return self._values.get("content_type")

    @builtins.property
    def message_body(self) -> typing.Optional[str]:
        return self._values.get("message_body")

    @builtins.property
    def status_code(self) -> typing.Optional[str]:
        return self._values.get("status_code")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AlbListenerDefaultActionFixedResponse(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AlbListenerDefaultActionForward",
    jsii_struct_bases=[],
    name_mapping={"target_group": "targetGroup", "stickiness": "stickiness"},
)
class AlbListenerDefaultActionForward:
    def __init__(
        self,
        *,
        target_group: typing.List["AlbListenerDefaultActionForwardTargetGroup"],
        stickiness: typing.Optional[
            typing.List["AlbListenerDefaultActionForwardStickiness"]
        ] = None,
    ) -> None:
        """
        :param target_group: target_group block.
        :param stickiness: stickiness block.
        """
        self._values = {
            "target_group": target_group,
        }
        if stickiness is not None:
            self._values["stickiness"] = stickiness

    @builtins.property
    def target_group(self) -> typing.List["AlbListenerDefaultActionForwardTargetGroup"]:
        """target_group block."""
        return self._values.get("target_group")

    @builtins.property
    def stickiness(
        self,
    ) -> typing.Optional[typing.List["AlbListenerDefaultActionForwardStickiness"]]:
        """stickiness block."""
        return self._values.get("stickiness")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AlbListenerDefaultActionForward(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AlbListenerDefaultActionForwardStickiness",
    jsii_struct_bases=[],
    name_mapping={"duration": "duration", "enabled": "enabled"},
)
class AlbListenerDefaultActionForwardStickiness:
    def __init__(
        self, *, duration: jsii.Number, enabled: typing.Optional[bool] = None
    ) -> None:
        """
        :param duration: 
        :param enabled: 
        """
        self._values = {
            "duration": duration,
        }
        if enabled is not None:
            self._values["enabled"] = enabled

    @builtins.property
    def duration(self) -> jsii.Number:
        return self._values.get("duration")

    @builtins.property
    def enabled(self) -> typing.Optional[bool]:
        return self._values.get("enabled")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AlbListenerDefaultActionForwardStickiness(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AlbListenerDefaultActionForwardTargetGroup",
    jsii_struct_bases=[],
    name_mapping={"arn": "arn", "weight": "weight"},
)
class AlbListenerDefaultActionForwardTargetGroup:
    def __init__(
        self, *, arn: str, weight: typing.Optional[jsii.Number] = None
    ) -> None:
        """
        :param arn: 
        :param weight: 
        """
        self._values = {
            "arn": arn,
        }
        if weight is not None:
            self._values["weight"] = weight

    @builtins.property
    def arn(self) -> str:
        return self._values.get("arn")

    @builtins.property
    def weight(self) -> typing.Optional[jsii.Number]:
        return self._values.get("weight")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AlbListenerDefaultActionForwardTargetGroup(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AlbListenerDefaultActionRedirect",
    jsii_struct_bases=[],
    name_mapping={
        "status_code": "statusCode",
        "host": "host",
        "path": "path",
        "port": "port",
        "protocol": "protocol",
        "query": "query",
    },
)
class AlbListenerDefaultActionRedirect:
    def __init__(
        self,
        *,
        status_code: str,
        host: typing.Optional[str] = None,
        path: typing.Optional[str] = None,
        port: typing.Optional[str] = None,
        protocol: typing.Optional[str] = None,
        query: typing.Optional[str] = None,
    ) -> None:
        """
        :param status_code: 
        :param host: 
        :param path: 
        :param port: 
        :param protocol: 
        :param query: 
        """
        self._values = {
            "status_code": status_code,
        }
        if host is not None:
            self._values["host"] = host
        if path is not None:
            self._values["path"] = path
        if port is not None:
            self._values["port"] = port
        if protocol is not None:
            self._values["protocol"] = protocol
        if query is not None:
            self._values["query"] = query

    @builtins.property
    def status_code(self) -> str:
        return self._values.get("status_code")

    @builtins.property
    def host(self) -> typing.Optional[str]:
        return self._values.get("host")

    @builtins.property
    def path(self) -> typing.Optional[str]:
        return self._values.get("path")

    @builtins.property
    def port(self) -> typing.Optional[str]:
        return self._values.get("port")

    @builtins.property
    def protocol(self) -> typing.Optional[str]:
        return self._values.get("protocol")

    @builtins.property
    def query(self) -> typing.Optional[str]:
        return self._values.get("query")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AlbListenerDefaultActionRedirect(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class AlbListenerRule(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="@skorfmann/cdktf-provider-aws.AlbListenerRule",
):
    def __init__(
        self,
        scope: constructs.Construct,
        id: str,
        *,
        action: typing.List["AlbListenerRuleAction"],
        condition: typing.List["AlbListenerRuleCondition"],
        listener_arn: str,
        priority: typing.Optional[jsii.Number] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param action: action block.
        :param condition: condition block.
        :param listener_arn: 
        :param priority: 
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = AlbListenerRuleConfig(
            action=action,
            condition=condition,
            listener_arn=listener_arn,
            priority=priority,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(AlbListenerRule, self, [scope, id, config])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property
    @jsii.member(jsii_name="arn")
    def arn(self) -> str:
        return jsii.get(self, "arn")

    @builtins.property
    @jsii.member(jsii_name="action")
    def action(self) -> typing.List["AlbListenerRuleAction"]:
        return jsii.get(self, "action")

    @action.setter
    def action(self, value: typing.List["AlbListenerRuleAction"]) -> None:
        jsii.set(self, "action", value)

    @builtins.property
    @jsii.member(jsii_name="condition")
    def condition(self) -> typing.List["AlbListenerRuleCondition"]:
        return jsii.get(self, "condition")

    @condition.setter
    def condition(self, value: typing.List["AlbListenerRuleCondition"]) -> None:
        jsii.set(self, "condition", value)

    @builtins.property
    @jsii.member(jsii_name="listenerArn")
    def listener_arn(self) -> str:
        return jsii.get(self, "listenerArn")

    @listener_arn.setter
    def listener_arn(self, value: str) -> None:
        jsii.set(self, "listenerArn", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="priority")
    def priority(self) -> typing.Optional[jsii.Number]:
        return jsii.get(self, "priority")

    @priority.setter
    def priority(self, value: typing.Optional[jsii.Number]) -> None:
        jsii.set(self, "priority", value)


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AlbListenerRuleAction",
    jsii_struct_bases=[],
    name_mapping={
        "type": "type",
        "authenticate_cognito": "authenticateCognito",
        "authenticate_oidc": "authenticateOidc",
        "fixed_response": "fixedResponse",
        "forward": "forward",
        "order": "order",
        "redirect": "redirect",
        "target_group_arn": "targetGroupArn",
    },
)
class AlbListenerRuleAction:
    def __init__(
        self,
        *,
        type: str,
        authenticate_cognito: typing.Optional[
            typing.List["AlbListenerRuleActionAuthenticateCognito"]
        ] = None,
        authenticate_oidc: typing.Optional[
            typing.List["AlbListenerRuleActionAuthenticateOidc"]
        ] = None,
        fixed_response: typing.Optional[
            typing.List["AlbListenerRuleActionFixedResponse"]
        ] = None,
        forward: typing.Optional[typing.List["AlbListenerRuleActionForward"]] = None,
        order: typing.Optional[jsii.Number] = None,
        redirect: typing.Optional[typing.List["AlbListenerRuleActionRedirect"]] = None,
        target_group_arn: typing.Optional[str] = None,
    ) -> None:
        """
        :param type: 
        :param authenticate_cognito: authenticate_cognito block.
        :param authenticate_oidc: authenticate_oidc block.
        :param fixed_response: fixed_response block.
        :param forward: forward block.
        :param order: 
        :param redirect: redirect block.
        :param target_group_arn: 
        """
        self._values = {
            "type": type,
        }
        if authenticate_cognito is not None:
            self._values["authenticate_cognito"] = authenticate_cognito
        if authenticate_oidc is not None:
            self._values["authenticate_oidc"] = authenticate_oidc
        if fixed_response is not None:
            self._values["fixed_response"] = fixed_response
        if forward is not None:
            self._values["forward"] = forward
        if order is not None:
            self._values["order"] = order
        if redirect is not None:
            self._values["redirect"] = redirect
        if target_group_arn is not None:
            self._values["target_group_arn"] = target_group_arn

    @builtins.property
    def type(self) -> str:
        return self._values.get("type")

    @builtins.property
    def authenticate_cognito(
        self,
    ) -> typing.Optional[typing.List["AlbListenerRuleActionAuthenticateCognito"]]:
        """authenticate_cognito block."""
        return self._values.get("authenticate_cognito")

    @builtins.property
    def authenticate_oidc(
        self,
    ) -> typing.Optional[typing.List["AlbListenerRuleActionAuthenticateOidc"]]:
        """authenticate_oidc block."""
        return self._values.get("authenticate_oidc")

    @builtins.property
    def fixed_response(
        self,
    ) -> typing.Optional[typing.List["AlbListenerRuleActionFixedResponse"]]:
        """fixed_response block."""
        return self._values.get("fixed_response")

    @builtins.property
    def forward(self) -> typing.Optional[typing.List["AlbListenerRuleActionForward"]]:
        """forward block."""
        return self._values.get("forward")

    @builtins.property
    def order(self) -> typing.Optional[jsii.Number]:
        return self._values.get("order")

    @builtins.property
    def redirect(self) -> typing.Optional[typing.List["AlbListenerRuleActionRedirect"]]:
        """redirect block."""
        return self._values.get("redirect")

    @builtins.property
    def target_group_arn(self) -> typing.Optional[str]:
        return self._values.get("target_group_arn")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AlbListenerRuleAction(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AlbListenerRuleActionAuthenticateCognito",
    jsii_struct_bases=[],
    name_mapping={
        "user_pool_arn": "userPoolArn",
        "user_pool_client_id": "userPoolClientId",
        "user_pool_domain": "userPoolDomain",
        "authentication_request_extra_params": "authenticationRequestExtraParams",
        "on_unauthenticated_request": "onUnauthenticatedRequest",
        "scope": "scope",
        "session_cookie_name": "sessionCookieName",
        "session_timeout": "sessionTimeout",
    },
)
class AlbListenerRuleActionAuthenticateCognito:
    def __init__(
        self,
        *,
        user_pool_arn: str,
        user_pool_client_id: str,
        user_pool_domain: str,
        authentication_request_extra_params: typing.Optional[
            typing.Mapping[str, str]
        ] = None,
        on_unauthenticated_request: typing.Optional[str] = None,
        scope: typing.Optional[str] = None,
        session_cookie_name: typing.Optional[str] = None,
        session_timeout: typing.Optional[jsii.Number] = None,
    ) -> None:
        """
        :param user_pool_arn: 
        :param user_pool_client_id: 
        :param user_pool_domain: 
        :param authentication_request_extra_params: 
        :param on_unauthenticated_request: 
        :param scope: 
        :param session_cookie_name: 
        :param session_timeout: 
        """
        self._values = {
            "user_pool_arn": user_pool_arn,
            "user_pool_client_id": user_pool_client_id,
            "user_pool_domain": user_pool_domain,
        }
        if authentication_request_extra_params is not None:
            self._values[
                "authentication_request_extra_params"
            ] = authentication_request_extra_params
        if on_unauthenticated_request is not None:
            self._values["on_unauthenticated_request"] = on_unauthenticated_request
        if scope is not None:
            self._values["scope"] = scope
        if session_cookie_name is not None:
            self._values["session_cookie_name"] = session_cookie_name
        if session_timeout is not None:
            self._values["session_timeout"] = session_timeout

    @builtins.property
    def user_pool_arn(self) -> str:
        return self._values.get("user_pool_arn")

    @builtins.property
    def user_pool_client_id(self) -> str:
        return self._values.get("user_pool_client_id")

    @builtins.property
    def user_pool_domain(self) -> str:
        return self._values.get("user_pool_domain")

    @builtins.property
    def authentication_request_extra_params(
        self,
    ) -> typing.Optional[typing.Mapping[str, str]]:
        return self._values.get("authentication_request_extra_params")

    @builtins.property
    def on_unauthenticated_request(self) -> typing.Optional[str]:
        return self._values.get("on_unauthenticated_request")

    @builtins.property
    def scope(self) -> typing.Optional[str]:
        return self._values.get("scope")

    @builtins.property
    def session_cookie_name(self) -> typing.Optional[str]:
        return self._values.get("session_cookie_name")

    @builtins.property
    def session_timeout(self) -> typing.Optional[jsii.Number]:
        return self._values.get("session_timeout")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AlbListenerRuleActionAuthenticateCognito(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AlbListenerRuleActionAuthenticateOidc",
    jsii_struct_bases=[],
    name_mapping={
        "authorization_endpoint": "authorizationEndpoint",
        "client_id": "clientId",
        "client_secret": "clientSecret",
        "issuer": "issuer",
        "token_endpoint": "tokenEndpoint",
        "user_info_endpoint": "userInfoEndpoint",
        "authentication_request_extra_params": "authenticationRequestExtraParams",
        "on_unauthenticated_request": "onUnauthenticatedRequest",
        "scope": "scope",
        "session_cookie_name": "sessionCookieName",
        "session_timeout": "sessionTimeout",
    },
)
class AlbListenerRuleActionAuthenticateOidc:
    def __init__(
        self,
        *,
        authorization_endpoint: str,
        client_id: str,
        client_secret: str,
        issuer: str,
        token_endpoint: str,
        user_info_endpoint: str,
        authentication_request_extra_params: typing.Optional[
            typing.Mapping[str, str]
        ] = None,
        on_unauthenticated_request: typing.Optional[str] = None,
        scope: typing.Optional[str] = None,
        session_cookie_name: typing.Optional[str] = None,
        session_timeout: typing.Optional[jsii.Number] = None,
    ) -> None:
        """
        :param authorization_endpoint: 
        :param client_id: 
        :param client_secret: 
        :param issuer: 
        :param token_endpoint: 
        :param user_info_endpoint: 
        :param authentication_request_extra_params: 
        :param on_unauthenticated_request: 
        :param scope: 
        :param session_cookie_name: 
        :param session_timeout: 
        """
        self._values = {
            "authorization_endpoint": authorization_endpoint,
            "client_id": client_id,
            "client_secret": client_secret,
            "issuer": issuer,
            "token_endpoint": token_endpoint,
            "user_info_endpoint": user_info_endpoint,
        }
        if authentication_request_extra_params is not None:
            self._values[
                "authentication_request_extra_params"
            ] = authentication_request_extra_params
        if on_unauthenticated_request is not None:
            self._values["on_unauthenticated_request"] = on_unauthenticated_request
        if scope is not None:
            self._values["scope"] = scope
        if session_cookie_name is not None:
            self._values["session_cookie_name"] = session_cookie_name
        if session_timeout is not None:
            self._values["session_timeout"] = session_timeout

    @builtins.property
    def authorization_endpoint(self) -> str:
        return self._values.get("authorization_endpoint")

    @builtins.property
    def client_id(self) -> str:
        return self._values.get("client_id")

    @builtins.property
    def client_secret(self) -> str:
        return self._values.get("client_secret")

    @builtins.property
    def issuer(self) -> str:
        return self._values.get("issuer")

    @builtins.property
    def token_endpoint(self) -> str:
        return self._values.get("token_endpoint")

    @builtins.property
    def user_info_endpoint(self) -> str:
        return self._values.get("user_info_endpoint")

    @builtins.property
    def authentication_request_extra_params(
        self,
    ) -> typing.Optional[typing.Mapping[str, str]]:
        return self._values.get("authentication_request_extra_params")

    @builtins.property
    def on_unauthenticated_request(self) -> typing.Optional[str]:
        return self._values.get("on_unauthenticated_request")

    @builtins.property
    def scope(self) -> typing.Optional[str]:
        return self._values.get("scope")

    @builtins.property
    def session_cookie_name(self) -> typing.Optional[str]:
        return self._values.get("session_cookie_name")

    @builtins.property
    def session_timeout(self) -> typing.Optional[jsii.Number]:
        return self._values.get("session_timeout")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AlbListenerRuleActionAuthenticateOidc(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AlbListenerRuleActionFixedResponse",
    jsii_struct_bases=[],
    name_mapping={
        "content_type": "contentType",
        "message_body": "messageBody",
        "status_code": "statusCode",
    },
)
class AlbListenerRuleActionFixedResponse:
    def __init__(
        self,
        *,
        content_type: str,
        message_body: typing.Optional[str] = None,
        status_code: typing.Optional[str] = None,
    ) -> None:
        """
        :param content_type: 
        :param message_body: 
        :param status_code: 
        """
        self._values = {
            "content_type": content_type,
        }
        if message_body is not None:
            self._values["message_body"] = message_body
        if status_code is not None:
            self._values["status_code"] = status_code

    @builtins.property
    def content_type(self) -> str:
        return self._values.get("content_type")

    @builtins.property
    def message_body(self) -> typing.Optional[str]:
        return self._values.get("message_body")

    @builtins.property
    def status_code(self) -> typing.Optional[str]:
        return self._values.get("status_code")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AlbListenerRuleActionFixedResponse(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AlbListenerRuleActionForward",
    jsii_struct_bases=[],
    name_mapping={"target_group": "targetGroup", "stickiness": "stickiness"},
)
class AlbListenerRuleActionForward:
    def __init__(
        self,
        *,
        target_group: typing.List["AlbListenerRuleActionForwardTargetGroup"],
        stickiness: typing.Optional[
            typing.List["AlbListenerRuleActionForwardStickiness"]
        ] = None,
    ) -> None:
        """
        :param target_group: target_group block.
        :param stickiness: stickiness block.
        """
        self._values = {
            "target_group": target_group,
        }
        if stickiness is not None:
            self._values["stickiness"] = stickiness

    @builtins.property
    def target_group(self) -> typing.List["AlbListenerRuleActionForwardTargetGroup"]:
        """target_group block."""
        return self._values.get("target_group")

    @builtins.property
    def stickiness(
        self,
    ) -> typing.Optional[typing.List["AlbListenerRuleActionForwardStickiness"]]:
        """stickiness block."""
        return self._values.get("stickiness")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AlbListenerRuleActionForward(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AlbListenerRuleActionForwardStickiness",
    jsii_struct_bases=[],
    name_mapping={"duration": "duration", "enabled": "enabled"},
)
class AlbListenerRuleActionForwardStickiness:
    def __init__(
        self, *, duration: jsii.Number, enabled: typing.Optional[bool] = None
    ) -> None:
        """
        :param duration: 
        :param enabled: 
        """
        self._values = {
            "duration": duration,
        }
        if enabled is not None:
            self._values["enabled"] = enabled

    @builtins.property
    def duration(self) -> jsii.Number:
        return self._values.get("duration")

    @builtins.property
    def enabled(self) -> typing.Optional[bool]:
        return self._values.get("enabled")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AlbListenerRuleActionForwardStickiness(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AlbListenerRuleActionForwardTargetGroup",
    jsii_struct_bases=[],
    name_mapping={"arn": "arn", "weight": "weight"},
)
class AlbListenerRuleActionForwardTargetGroup:
    def __init__(
        self, *, arn: str, weight: typing.Optional[jsii.Number] = None
    ) -> None:
        """
        :param arn: 
        :param weight: 
        """
        self._values = {
            "arn": arn,
        }
        if weight is not None:
            self._values["weight"] = weight

    @builtins.property
    def arn(self) -> str:
        return self._values.get("arn")

    @builtins.property
    def weight(self) -> typing.Optional[jsii.Number]:
        return self._values.get("weight")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AlbListenerRuleActionForwardTargetGroup(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AlbListenerRuleActionRedirect",
    jsii_struct_bases=[],
    name_mapping={
        "status_code": "statusCode",
        "host": "host",
        "path": "path",
        "port": "port",
        "protocol": "protocol",
        "query": "query",
    },
)
class AlbListenerRuleActionRedirect:
    def __init__(
        self,
        *,
        status_code: str,
        host: typing.Optional[str] = None,
        path: typing.Optional[str] = None,
        port: typing.Optional[str] = None,
        protocol: typing.Optional[str] = None,
        query: typing.Optional[str] = None,
    ) -> None:
        """
        :param status_code: 
        :param host: 
        :param path: 
        :param port: 
        :param protocol: 
        :param query: 
        """
        self._values = {
            "status_code": status_code,
        }
        if host is not None:
            self._values["host"] = host
        if path is not None:
            self._values["path"] = path
        if port is not None:
            self._values["port"] = port
        if protocol is not None:
            self._values["protocol"] = protocol
        if query is not None:
            self._values["query"] = query

    @builtins.property
    def status_code(self) -> str:
        return self._values.get("status_code")

    @builtins.property
    def host(self) -> typing.Optional[str]:
        return self._values.get("host")

    @builtins.property
    def path(self) -> typing.Optional[str]:
        return self._values.get("path")

    @builtins.property
    def port(self) -> typing.Optional[str]:
        return self._values.get("port")

    @builtins.property
    def protocol(self) -> typing.Optional[str]:
        return self._values.get("protocol")

    @builtins.property
    def query(self) -> typing.Optional[str]:
        return self._values.get("query")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AlbListenerRuleActionRedirect(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AlbListenerRuleCondition",
    jsii_struct_bases=[],
    name_mapping={
        "field": "field",
        "host_header": "hostHeader",
        "http_header": "httpHeader",
        "http_request_method": "httpRequestMethod",
        "path_pattern": "pathPattern",
        "query_string": "queryString",
        "source_ip": "sourceIp",
        "values": "values",
    },
)
class AlbListenerRuleCondition:
    def __init__(
        self,
        *,
        field: typing.Optional[str] = None,
        host_header: typing.Optional[
            typing.List["AlbListenerRuleConditionHostHeader"]
        ] = None,
        http_header: typing.Optional[
            typing.List["AlbListenerRuleConditionHttpHeader"]
        ] = None,
        http_request_method: typing.Optional[
            typing.List["AlbListenerRuleConditionHttpRequestMethod"]
        ] = None,
        path_pattern: typing.Optional[
            typing.List["AlbListenerRuleConditionPathPattern"]
        ] = None,
        query_string: typing.Optional[
            typing.List["AlbListenerRuleConditionQueryString"]
        ] = None,
        source_ip: typing.Optional[
            typing.List["AlbListenerRuleConditionSourceIp"]
        ] = None,
        values: typing.Optional[typing.List[str]] = None,
    ) -> None:
        """
        :param field: 
        :param host_header: host_header block.
        :param http_header: http_header block.
        :param http_request_method: http_request_method block.
        :param path_pattern: path_pattern block.
        :param query_string: query_string block.
        :param source_ip: source_ip block.
        :param values: 
        """
        self._values = {}
        if field is not None:
            self._values["field"] = field
        if host_header is not None:
            self._values["host_header"] = host_header
        if http_header is not None:
            self._values["http_header"] = http_header
        if http_request_method is not None:
            self._values["http_request_method"] = http_request_method
        if path_pattern is not None:
            self._values["path_pattern"] = path_pattern
        if query_string is not None:
            self._values["query_string"] = query_string
        if source_ip is not None:
            self._values["source_ip"] = source_ip
        if values is not None:
            self._values["values"] = values

    @builtins.property
    def field(self) -> typing.Optional[str]:
        return self._values.get("field")

    @builtins.property
    def host_header(
        self,
    ) -> typing.Optional[typing.List["AlbListenerRuleConditionHostHeader"]]:
        """host_header block."""
        return self._values.get("host_header")

    @builtins.property
    def http_header(
        self,
    ) -> typing.Optional[typing.List["AlbListenerRuleConditionHttpHeader"]]:
        """http_header block."""
        return self._values.get("http_header")

    @builtins.property
    def http_request_method(
        self,
    ) -> typing.Optional[typing.List["AlbListenerRuleConditionHttpRequestMethod"]]:
        """http_request_method block."""
        return self._values.get("http_request_method")

    @builtins.property
    def path_pattern(
        self,
    ) -> typing.Optional[typing.List["AlbListenerRuleConditionPathPattern"]]:
        """path_pattern block."""
        return self._values.get("path_pattern")

    @builtins.property
    def query_string(
        self,
    ) -> typing.Optional[typing.List["AlbListenerRuleConditionQueryString"]]:
        """query_string block."""
        return self._values.get("query_string")

    @builtins.property
    def source_ip(
        self,
    ) -> typing.Optional[typing.List["AlbListenerRuleConditionSourceIp"]]:
        """source_ip block."""
        return self._values.get("source_ip")

    @builtins.property
    def values(self) -> typing.Optional[typing.List[str]]:
        return self._values.get("values")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AlbListenerRuleCondition(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AlbListenerRuleConditionHostHeader",
    jsii_struct_bases=[],
    name_mapping={"values": "values"},
)
class AlbListenerRuleConditionHostHeader:
    def __init__(self, *, values: typing.Optional[typing.List[str]] = None) -> None:
        """
        :param values: 
        """
        self._values = {}
        if values is not None:
            self._values["values"] = values

    @builtins.property
    def values(self) -> typing.Optional[typing.List[str]]:
        return self._values.get("values")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AlbListenerRuleConditionHostHeader(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AlbListenerRuleConditionHttpHeader",
    jsii_struct_bases=[],
    name_mapping={"http_header_name": "httpHeaderName", "values": "values"},
)
class AlbListenerRuleConditionHttpHeader:
    def __init__(self, *, http_header_name: str, values: typing.List[str]) -> None:
        """
        :param http_header_name: 
        :param values: 
        """
        self._values = {
            "http_header_name": http_header_name,
            "values": values,
        }

    @builtins.property
    def http_header_name(self) -> str:
        return self._values.get("http_header_name")

    @builtins.property
    def values(self) -> typing.List[str]:
        return self._values.get("values")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AlbListenerRuleConditionHttpHeader(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AlbListenerRuleConditionHttpRequestMethod",
    jsii_struct_bases=[],
    name_mapping={"values": "values"},
)
class AlbListenerRuleConditionHttpRequestMethod:
    def __init__(self, *, values: typing.List[str]) -> None:
        """
        :param values: 
        """
        self._values = {
            "values": values,
        }

    @builtins.property
    def values(self) -> typing.List[str]:
        return self._values.get("values")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AlbListenerRuleConditionHttpRequestMethod(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AlbListenerRuleConditionPathPattern",
    jsii_struct_bases=[],
    name_mapping={"values": "values"},
)
class AlbListenerRuleConditionPathPattern:
    def __init__(self, *, values: typing.Optional[typing.List[str]] = None) -> None:
        """
        :param values: 
        """
        self._values = {}
        if values is not None:
            self._values["values"] = values

    @builtins.property
    def values(self) -> typing.Optional[typing.List[str]]:
        return self._values.get("values")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AlbListenerRuleConditionPathPattern(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AlbListenerRuleConditionQueryString",
    jsii_struct_bases=[],
    name_mapping={"value": "value", "key": "key"},
)
class AlbListenerRuleConditionQueryString:
    def __init__(self, *, value: str, key: typing.Optional[str] = None) -> None:
        """
        :param value: 
        :param key: 
        """
        self._values = {
            "value": value,
        }
        if key is not None:
            self._values["key"] = key

    @builtins.property
    def value(self) -> str:
        return self._values.get("value")

    @builtins.property
    def key(self) -> typing.Optional[str]:
        return self._values.get("key")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AlbListenerRuleConditionQueryString(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AlbListenerRuleConditionSourceIp",
    jsii_struct_bases=[],
    name_mapping={"values": "values"},
)
class AlbListenerRuleConditionSourceIp:
    def __init__(self, *, values: typing.List[str]) -> None:
        """
        :param values: 
        """
        self._values = {
            "values": values,
        }

    @builtins.property
    def values(self) -> typing.List[str]:
        return self._values.get("values")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AlbListenerRuleConditionSourceIp(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AlbListenerRuleConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "action": "action",
        "condition": "condition",
        "listener_arn": "listenerArn",
        "priority": "priority",
    },
)
class AlbListenerRuleConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        action: typing.List["AlbListenerRuleAction"],
        condition: typing.List["AlbListenerRuleCondition"],
        listener_arn: str,
        priority: typing.Optional[jsii.Number] = None,
    ) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param action: action block.
        :param condition: condition block.
        :param listener_arn: 
        :param priority: 
        """
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        self._values = {
            "action": action,
            "condition": condition,
            "listener_arn": listener_arn,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if priority is not None:
            self._values["priority"] = priority

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("count")

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.TerraformResource]]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("depends_on")

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("lifecycle")

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("provider")

    @builtins.property
    def action(self) -> typing.List["AlbListenerRuleAction"]:
        """action block."""
        return self._values.get("action")

    @builtins.property
    def condition(self) -> typing.List["AlbListenerRuleCondition"]:
        """condition block."""
        return self._values.get("condition")

    @builtins.property
    def listener_arn(self) -> str:
        return self._values.get("listener_arn")

    @builtins.property
    def priority(self) -> typing.Optional[jsii.Number]:
        return self._values.get("priority")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AlbListenerRuleConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AlbListenerTimeouts",
    jsii_struct_bases=[],
    name_mapping={"read": "read"},
)
class AlbListenerTimeouts:
    def __init__(self, *, read: typing.Optional[str] = None) -> None:
        """
        :param read: 
        """
        self._values = {}
        if read is not None:
            self._values["read"] = read

    @builtins.property
    def read(self) -> typing.Optional[str]:
        return self._values.get("read")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AlbListenerTimeouts(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AlbSubnetMapping",
    jsii_struct_bases=[],
    name_mapping={"subnet_id": "subnetId", "allocation_id": "allocationId"},
)
class AlbSubnetMapping:
    def __init__(
        self, *, subnet_id: str, allocation_id: typing.Optional[str] = None
    ) -> None:
        """
        :param subnet_id: 
        :param allocation_id: 
        """
        self._values = {
            "subnet_id": subnet_id,
        }
        if allocation_id is not None:
            self._values["allocation_id"] = allocation_id

    @builtins.property
    def subnet_id(self) -> str:
        return self._values.get("subnet_id")

    @builtins.property
    def allocation_id(self) -> typing.Optional[str]:
        return self._values.get("allocation_id")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AlbSubnetMapping(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class AlbTargetGroup(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="@skorfmann/cdktf-provider-aws.AlbTargetGroup",
):
    def __init__(
        self,
        scope: constructs.Construct,
        id: str,
        *,
        deregistration_delay: typing.Optional[jsii.Number] = None,
        health_check: typing.Optional[typing.List["AlbTargetGroupHealthCheck"]] = None,
        lambda_multi_value_headers_enabled: typing.Optional[bool] = None,
        load_balancing_algorithm_type: typing.Optional[str] = None,
        name: typing.Optional[str] = None,
        name_prefix: typing.Optional[str] = None,
        port: typing.Optional[jsii.Number] = None,
        protocol: typing.Optional[str] = None,
        proxy_protocol_v2: typing.Optional[bool] = None,
        slow_start: typing.Optional[jsii.Number] = None,
        stickiness: typing.Optional[typing.List["AlbTargetGroupStickiness"]] = None,
        tags: typing.Optional[typing.Mapping[str, str]] = None,
        target_type: typing.Optional[str] = None,
        vpc_id: typing.Optional[str] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param deregistration_delay: 
        :param health_check: health_check block.
        :param lambda_multi_value_headers_enabled: 
        :param load_balancing_algorithm_type: 
        :param name: 
        :param name_prefix: 
        :param port: 
        :param protocol: 
        :param proxy_protocol_v2: 
        :param slow_start: 
        :param stickiness: stickiness block.
        :param tags: 
        :param target_type: 
        :param vpc_id: 
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = AlbTargetGroupConfig(
            deregistration_delay=deregistration_delay,
            health_check=health_check,
            lambda_multi_value_headers_enabled=lambda_multi_value_headers_enabled,
            load_balancing_algorithm_type=load_balancing_algorithm_type,
            name=name,
            name_prefix=name_prefix,
            port=port,
            protocol=protocol,
            proxy_protocol_v2=proxy_protocol_v2,
            slow_start=slow_start,
            stickiness=stickiness,
            tags=tags,
            target_type=target_type,
            vpc_id=vpc_id,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(AlbTargetGroup, self, [scope, id, config])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property
    @jsii.member(jsii_name="arn")
    def arn(self) -> str:
        return jsii.get(self, "arn")

    @builtins.property
    @jsii.member(jsii_name="arnSuffix")
    def arn_suffix(self) -> str:
        return jsii.get(self, "arnSuffix")

    @builtins.property
    @jsii.member(jsii_name="deregistrationDelay")
    def deregistration_delay(self) -> typing.Optional[jsii.Number]:
        return jsii.get(self, "deregistrationDelay")

    @deregistration_delay.setter
    def deregistration_delay(self, value: typing.Optional[jsii.Number]) -> None:
        jsii.set(self, "deregistrationDelay", value)

    @builtins.property
    @jsii.member(jsii_name="healthCheck")
    def health_check(self) -> typing.Optional[typing.List["AlbTargetGroupHealthCheck"]]:
        return jsii.get(self, "healthCheck")

    @health_check.setter
    def health_check(
        self, value: typing.Optional[typing.List["AlbTargetGroupHealthCheck"]]
    ) -> None:
        jsii.set(self, "healthCheck", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="lambdaMultiValueHeadersEnabled")
    def lambda_multi_value_headers_enabled(self) -> typing.Optional[bool]:
        return jsii.get(self, "lambdaMultiValueHeadersEnabled")

    @lambda_multi_value_headers_enabled.setter
    def lambda_multi_value_headers_enabled(self, value: typing.Optional[bool]) -> None:
        jsii.set(self, "lambdaMultiValueHeadersEnabled", value)

    @builtins.property
    @jsii.member(jsii_name="loadBalancingAlgorithmType")
    def load_balancing_algorithm_type(self) -> typing.Optional[str]:
        return jsii.get(self, "loadBalancingAlgorithmType")

    @load_balancing_algorithm_type.setter
    def load_balancing_algorithm_type(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "loadBalancingAlgorithmType", value)

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> typing.Optional[str]:
        return jsii.get(self, "name")

    @name.setter
    def name(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "name", value)

    @builtins.property
    @jsii.member(jsii_name="namePrefix")
    def name_prefix(self) -> typing.Optional[str]:
        return jsii.get(self, "namePrefix")

    @name_prefix.setter
    def name_prefix(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "namePrefix", value)

    @builtins.property
    @jsii.member(jsii_name="port")
    def port(self) -> typing.Optional[jsii.Number]:
        return jsii.get(self, "port")

    @port.setter
    def port(self, value: typing.Optional[jsii.Number]) -> None:
        jsii.set(self, "port", value)

    @builtins.property
    @jsii.member(jsii_name="protocol")
    def protocol(self) -> typing.Optional[str]:
        return jsii.get(self, "protocol")

    @protocol.setter
    def protocol(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "protocol", value)

    @builtins.property
    @jsii.member(jsii_name="proxyProtocolV2")
    def proxy_protocol_v2(self) -> typing.Optional[bool]:
        return jsii.get(self, "proxyProtocolV2")

    @proxy_protocol_v2.setter
    def proxy_protocol_v2(self, value: typing.Optional[bool]) -> None:
        jsii.set(self, "proxyProtocolV2", value)

    @builtins.property
    @jsii.member(jsii_name="slowStart")
    def slow_start(self) -> typing.Optional[jsii.Number]:
        return jsii.get(self, "slowStart")

    @slow_start.setter
    def slow_start(self, value: typing.Optional[jsii.Number]) -> None:
        jsii.set(self, "slowStart", value)

    @builtins.property
    @jsii.member(jsii_name="stickiness")
    def stickiness(self) -> typing.Optional[typing.List["AlbTargetGroupStickiness"]]:
        return jsii.get(self, "stickiness")

    @stickiness.setter
    def stickiness(
        self, value: typing.Optional[typing.List["AlbTargetGroupStickiness"]]
    ) -> None:
        jsii.set(self, "stickiness", value)

    @builtins.property
    @jsii.member(jsii_name="tags")
    def tags(self) -> typing.Optional[typing.Mapping[str, str]]:
        return jsii.get(self, "tags")

    @tags.setter
    def tags(self, value: typing.Optional[typing.Mapping[str, str]]) -> None:
        jsii.set(self, "tags", value)

    @builtins.property
    @jsii.member(jsii_name="targetType")
    def target_type(self) -> typing.Optional[str]:
        return jsii.get(self, "targetType")

    @target_type.setter
    def target_type(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "targetType", value)

    @builtins.property
    @jsii.member(jsii_name="vpcId")
    def vpc_id(self) -> typing.Optional[str]:
        return jsii.get(self, "vpcId")

    @vpc_id.setter
    def vpc_id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "vpcId", value)


class AlbTargetGroupAttachment(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="@skorfmann/cdktf-provider-aws.AlbTargetGroupAttachment",
):
    def __init__(
        self,
        scope: constructs.Construct,
        id: str,
        *,
        target_group_arn: str,
        target_id: str,
        availability_zone: typing.Optional[str] = None,
        port: typing.Optional[jsii.Number] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param target_group_arn: 
        :param target_id: 
        :param availability_zone: 
        :param port: 
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = AlbTargetGroupAttachmentConfig(
            target_group_arn=target_group_arn,
            target_id=target_id,
            availability_zone=availability_zone,
            port=port,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(AlbTargetGroupAttachment, self, [scope, id, config])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property
    @jsii.member(jsii_name="targetGroupArn")
    def target_group_arn(self) -> str:
        return jsii.get(self, "targetGroupArn")

    @target_group_arn.setter
    def target_group_arn(self, value: str) -> None:
        jsii.set(self, "targetGroupArn", value)

    @builtins.property
    @jsii.member(jsii_name="targetId")
    def target_id(self) -> str:
        return jsii.get(self, "targetId")

    @target_id.setter
    def target_id(self, value: str) -> None:
        jsii.set(self, "targetId", value)

    @builtins.property
    @jsii.member(jsii_name="availabilityZone")
    def availability_zone(self) -> typing.Optional[str]:
        return jsii.get(self, "availabilityZone")

    @availability_zone.setter
    def availability_zone(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "availabilityZone", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="port")
    def port(self) -> typing.Optional[jsii.Number]:
        return jsii.get(self, "port")

    @port.setter
    def port(self, value: typing.Optional[jsii.Number]) -> None:
        jsii.set(self, "port", value)


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AlbTargetGroupAttachmentConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "target_group_arn": "targetGroupArn",
        "target_id": "targetId",
        "availability_zone": "availabilityZone",
        "port": "port",
    },
)
class AlbTargetGroupAttachmentConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        target_group_arn: str,
        target_id: str,
        availability_zone: typing.Optional[str] = None,
        port: typing.Optional[jsii.Number] = None,
    ) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param target_group_arn: 
        :param target_id: 
        :param availability_zone: 
        :param port: 
        """
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        self._values = {
            "target_group_arn": target_group_arn,
            "target_id": target_id,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if availability_zone is not None:
            self._values["availability_zone"] = availability_zone
        if port is not None:
            self._values["port"] = port

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("count")

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.TerraformResource]]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("depends_on")

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("lifecycle")

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("provider")

    @builtins.property
    def target_group_arn(self) -> str:
        return self._values.get("target_group_arn")

    @builtins.property
    def target_id(self) -> str:
        return self._values.get("target_id")

    @builtins.property
    def availability_zone(self) -> typing.Optional[str]:
        return self._values.get("availability_zone")

    @builtins.property
    def port(self) -> typing.Optional[jsii.Number]:
        return self._values.get("port")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AlbTargetGroupAttachmentConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AlbTargetGroupConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "deregistration_delay": "deregistrationDelay",
        "health_check": "healthCheck",
        "lambda_multi_value_headers_enabled": "lambdaMultiValueHeadersEnabled",
        "load_balancing_algorithm_type": "loadBalancingAlgorithmType",
        "name": "name",
        "name_prefix": "namePrefix",
        "port": "port",
        "protocol": "protocol",
        "proxy_protocol_v2": "proxyProtocolV2",
        "slow_start": "slowStart",
        "stickiness": "stickiness",
        "tags": "tags",
        "target_type": "targetType",
        "vpc_id": "vpcId",
    },
)
class AlbTargetGroupConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        deregistration_delay: typing.Optional[jsii.Number] = None,
        health_check: typing.Optional[typing.List["AlbTargetGroupHealthCheck"]] = None,
        lambda_multi_value_headers_enabled: typing.Optional[bool] = None,
        load_balancing_algorithm_type: typing.Optional[str] = None,
        name: typing.Optional[str] = None,
        name_prefix: typing.Optional[str] = None,
        port: typing.Optional[jsii.Number] = None,
        protocol: typing.Optional[str] = None,
        proxy_protocol_v2: typing.Optional[bool] = None,
        slow_start: typing.Optional[jsii.Number] = None,
        stickiness: typing.Optional[typing.List["AlbTargetGroupStickiness"]] = None,
        tags: typing.Optional[typing.Mapping[str, str]] = None,
        target_type: typing.Optional[str] = None,
        vpc_id: typing.Optional[str] = None,
    ) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param deregistration_delay: 
        :param health_check: health_check block.
        :param lambda_multi_value_headers_enabled: 
        :param load_balancing_algorithm_type: 
        :param name: 
        :param name_prefix: 
        :param port: 
        :param protocol: 
        :param proxy_protocol_v2: 
        :param slow_start: 
        :param stickiness: stickiness block.
        :param tags: 
        :param target_type: 
        :param vpc_id: 
        """
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        self._values = {}
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if deregistration_delay is not None:
            self._values["deregistration_delay"] = deregistration_delay
        if health_check is not None:
            self._values["health_check"] = health_check
        if lambda_multi_value_headers_enabled is not None:
            self._values[
                "lambda_multi_value_headers_enabled"
            ] = lambda_multi_value_headers_enabled
        if load_balancing_algorithm_type is not None:
            self._values[
                "load_balancing_algorithm_type"
            ] = load_balancing_algorithm_type
        if name is not None:
            self._values["name"] = name
        if name_prefix is not None:
            self._values["name_prefix"] = name_prefix
        if port is not None:
            self._values["port"] = port
        if protocol is not None:
            self._values["protocol"] = protocol
        if proxy_protocol_v2 is not None:
            self._values["proxy_protocol_v2"] = proxy_protocol_v2
        if slow_start is not None:
            self._values["slow_start"] = slow_start
        if stickiness is not None:
            self._values["stickiness"] = stickiness
        if tags is not None:
            self._values["tags"] = tags
        if target_type is not None:
            self._values["target_type"] = target_type
        if vpc_id is not None:
            self._values["vpc_id"] = vpc_id

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("count")

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.TerraformResource]]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("depends_on")

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("lifecycle")

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("provider")

    @builtins.property
    def deregistration_delay(self) -> typing.Optional[jsii.Number]:
        return self._values.get("deregistration_delay")

    @builtins.property
    def health_check(self) -> typing.Optional[typing.List["AlbTargetGroupHealthCheck"]]:
        """health_check block."""
        return self._values.get("health_check")

    @builtins.property
    def lambda_multi_value_headers_enabled(self) -> typing.Optional[bool]:
        return self._values.get("lambda_multi_value_headers_enabled")

    @builtins.property
    def load_balancing_algorithm_type(self) -> typing.Optional[str]:
        return self._values.get("load_balancing_algorithm_type")

    @builtins.property
    def name(self) -> typing.Optional[str]:
        return self._values.get("name")

    @builtins.property
    def name_prefix(self) -> typing.Optional[str]:
        return self._values.get("name_prefix")

    @builtins.property
    def port(self) -> typing.Optional[jsii.Number]:
        return self._values.get("port")

    @builtins.property
    def protocol(self) -> typing.Optional[str]:
        return self._values.get("protocol")

    @builtins.property
    def proxy_protocol_v2(self) -> typing.Optional[bool]:
        return self._values.get("proxy_protocol_v2")

    @builtins.property
    def slow_start(self) -> typing.Optional[jsii.Number]:
        return self._values.get("slow_start")

    @builtins.property
    def stickiness(self) -> typing.Optional[typing.List["AlbTargetGroupStickiness"]]:
        """stickiness block."""
        return self._values.get("stickiness")

    @builtins.property
    def tags(self) -> typing.Optional[typing.Mapping[str, str]]:
        return self._values.get("tags")

    @builtins.property
    def target_type(self) -> typing.Optional[str]:
        return self._values.get("target_type")

    @builtins.property
    def vpc_id(self) -> typing.Optional[str]:
        return self._values.get("vpc_id")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AlbTargetGroupConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AlbTargetGroupHealthCheck",
    jsii_struct_bases=[],
    name_mapping={
        "enabled": "enabled",
        "healthy_threshold": "healthyThreshold",
        "interval": "interval",
        "matcher": "matcher",
        "path": "path",
        "port": "port",
        "protocol": "protocol",
        "timeout": "timeout",
        "unhealthy_threshold": "unhealthyThreshold",
    },
)
class AlbTargetGroupHealthCheck:
    def __init__(
        self,
        *,
        enabled: typing.Optional[bool] = None,
        healthy_threshold: typing.Optional[jsii.Number] = None,
        interval: typing.Optional[jsii.Number] = None,
        matcher: typing.Optional[str] = None,
        path: typing.Optional[str] = None,
        port: typing.Optional[str] = None,
        protocol: typing.Optional[str] = None,
        timeout: typing.Optional[jsii.Number] = None,
        unhealthy_threshold: typing.Optional[jsii.Number] = None,
    ) -> None:
        """
        :param enabled: 
        :param healthy_threshold: 
        :param interval: 
        :param matcher: 
        :param path: 
        :param port: 
        :param protocol: 
        :param timeout: 
        :param unhealthy_threshold: 
        """
        self._values = {}
        if enabled is not None:
            self._values["enabled"] = enabled
        if healthy_threshold is not None:
            self._values["healthy_threshold"] = healthy_threshold
        if interval is not None:
            self._values["interval"] = interval
        if matcher is not None:
            self._values["matcher"] = matcher
        if path is not None:
            self._values["path"] = path
        if port is not None:
            self._values["port"] = port
        if protocol is not None:
            self._values["protocol"] = protocol
        if timeout is not None:
            self._values["timeout"] = timeout
        if unhealthy_threshold is not None:
            self._values["unhealthy_threshold"] = unhealthy_threshold

    @builtins.property
    def enabled(self) -> typing.Optional[bool]:
        return self._values.get("enabled")

    @builtins.property
    def healthy_threshold(self) -> typing.Optional[jsii.Number]:
        return self._values.get("healthy_threshold")

    @builtins.property
    def interval(self) -> typing.Optional[jsii.Number]:
        return self._values.get("interval")

    @builtins.property
    def matcher(self) -> typing.Optional[str]:
        return self._values.get("matcher")

    @builtins.property
    def path(self) -> typing.Optional[str]:
        return self._values.get("path")

    @builtins.property
    def port(self) -> typing.Optional[str]:
        return self._values.get("port")

    @builtins.property
    def protocol(self) -> typing.Optional[str]:
        return self._values.get("protocol")

    @builtins.property
    def timeout(self) -> typing.Optional[jsii.Number]:
        return self._values.get("timeout")

    @builtins.property
    def unhealthy_threshold(self) -> typing.Optional[jsii.Number]:
        return self._values.get("unhealthy_threshold")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AlbTargetGroupHealthCheck(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AlbTargetGroupStickiness",
    jsii_struct_bases=[],
    name_mapping={
        "type": "type",
        "cookie_duration": "cookieDuration",
        "enabled": "enabled",
    },
)
class AlbTargetGroupStickiness:
    def __init__(
        self,
        *,
        type: str,
        cookie_duration: typing.Optional[jsii.Number] = None,
        enabled: typing.Optional[bool] = None,
    ) -> None:
        """
        :param type: 
        :param cookie_duration: 
        :param enabled: 
        """
        self._values = {
            "type": type,
        }
        if cookie_duration is not None:
            self._values["cookie_duration"] = cookie_duration
        if enabled is not None:
            self._values["enabled"] = enabled

    @builtins.property
    def type(self) -> str:
        return self._values.get("type")

    @builtins.property
    def cookie_duration(self) -> typing.Optional[jsii.Number]:
        return self._values.get("cookie_duration")

    @builtins.property
    def enabled(self) -> typing.Optional[bool]:
        return self._values.get("enabled")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AlbTargetGroupStickiness(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AlbTimeouts",
    jsii_struct_bases=[],
    name_mapping={"create": "create", "delete": "delete", "update": "update"},
)
class AlbTimeouts:
    def __init__(
        self,
        *,
        create: typing.Optional[str] = None,
        delete: typing.Optional[str] = None,
        update: typing.Optional[str] = None,
    ) -> None:
        """
        :param create: 
        :param delete: 
        :param update: 
        """
        self._values = {}
        if create is not None:
            self._values["create"] = create
        if delete is not None:
            self._values["delete"] = delete
        if update is not None:
            self._values["update"] = update

    @builtins.property
    def create(self) -> typing.Optional[str]:
        return self._values.get("create")

    @builtins.property
    def delete(self) -> typing.Optional[str]:
        return self._values.get("delete")

    @builtins.property
    def update(self) -> typing.Optional[str]:
        return self._values.get("update")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AlbTimeouts(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class Ami(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="@skorfmann/cdktf-provider-aws.Ami",
):
    def __init__(
        self,
        scope: constructs.Construct,
        id: str,
        *,
        name: str,
        architecture: typing.Optional[str] = None,
        description: typing.Optional[str] = None,
        ebs_block_device: typing.Optional[typing.List["AmiEbsBlockDevice"]] = None,
        ena_support: typing.Optional[bool] = None,
        ephemeral_block_device: typing.Optional[
            typing.List["AmiEphemeralBlockDevice"]
        ] = None,
        image_location: typing.Optional[str] = None,
        kernel_id: typing.Optional[str] = None,
        ramdisk_id: typing.Optional[str] = None,
        root_device_name: typing.Optional[str] = None,
        sriov_net_support: typing.Optional[str] = None,
        tags: typing.Optional[typing.Mapping[str, str]] = None,
        timeouts: typing.Optional["AmiTimeouts"] = None,
        virtualization_type: typing.Optional[str] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param name: 
        :param architecture: 
        :param description: 
        :param ebs_block_device: ebs_block_device block.
        :param ena_support: 
        :param ephemeral_block_device: ephemeral_block_device block.
        :param image_location: 
        :param kernel_id: 
        :param ramdisk_id: 
        :param root_device_name: 
        :param sriov_net_support: 
        :param tags: 
        :param timeouts: timeouts block.
        :param virtualization_type: 
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = AmiConfig(
            name=name,
            architecture=architecture,
            description=description,
            ebs_block_device=ebs_block_device,
            ena_support=ena_support,
            ephemeral_block_device=ephemeral_block_device,
            image_location=image_location,
            kernel_id=kernel_id,
            ramdisk_id=ramdisk_id,
            root_device_name=root_device_name,
            sriov_net_support=sriov_net_support,
            tags=tags,
            timeouts=timeouts,
            virtualization_type=virtualization_type,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(Ami, self, [scope, id, config])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property
    @jsii.member(jsii_name="arn")
    def arn(self) -> str:
        return jsii.get(self, "arn")

    @builtins.property
    @jsii.member(jsii_name="manageEbsSnapshots")
    def manage_ebs_snapshots(self) -> bool:
        return jsii.get(self, "manageEbsSnapshots")

    @builtins.property
    @jsii.member(jsii_name="rootSnapshotId")
    def root_snapshot_id(self) -> str:
        return jsii.get(self, "rootSnapshotId")

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> str:
        return jsii.get(self, "name")

    @name.setter
    def name(self, value: str) -> None:
        jsii.set(self, "name", value)

    @builtins.property
    @jsii.member(jsii_name="architecture")
    def architecture(self) -> typing.Optional[str]:
        return jsii.get(self, "architecture")

    @architecture.setter
    def architecture(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "architecture", value)

    @builtins.property
    @jsii.member(jsii_name="description")
    def description(self) -> typing.Optional[str]:
        return jsii.get(self, "description")

    @description.setter
    def description(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "description", value)

    @builtins.property
    @jsii.member(jsii_name="ebsBlockDevice")
    def ebs_block_device(self) -> typing.Optional[typing.List["AmiEbsBlockDevice"]]:
        return jsii.get(self, "ebsBlockDevice")

    @ebs_block_device.setter
    def ebs_block_device(
        self, value: typing.Optional[typing.List["AmiEbsBlockDevice"]]
    ) -> None:
        jsii.set(self, "ebsBlockDevice", value)

    @builtins.property
    @jsii.member(jsii_name="enaSupport")
    def ena_support(self) -> typing.Optional[bool]:
        return jsii.get(self, "enaSupport")

    @ena_support.setter
    def ena_support(self, value: typing.Optional[bool]) -> None:
        jsii.set(self, "enaSupport", value)

    @builtins.property
    @jsii.member(jsii_name="ephemeralBlockDevice")
    def ephemeral_block_device(
        self,
    ) -> typing.Optional[typing.List["AmiEphemeralBlockDevice"]]:
        return jsii.get(self, "ephemeralBlockDevice")

    @ephemeral_block_device.setter
    def ephemeral_block_device(
        self, value: typing.Optional[typing.List["AmiEphemeralBlockDevice"]]
    ) -> None:
        jsii.set(self, "ephemeralBlockDevice", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="imageLocation")
    def image_location(self) -> typing.Optional[str]:
        return jsii.get(self, "imageLocation")

    @image_location.setter
    def image_location(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "imageLocation", value)

    @builtins.property
    @jsii.member(jsii_name="kernelId")
    def kernel_id(self) -> typing.Optional[str]:
        return jsii.get(self, "kernelId")

    @kernel_id.setter
    def kernel_id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "kernelId", value)

    @builtins.property
    @jsii.member(jsii_name="ramdiskId")
    def ramdisk_id(self) -> typing.Optional[str]:
        return jsii.get(self, "ramdiskId")

    @ramdisk_id.setter
    def ramdisk_id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "ramdiskId", value)

    @builtins.property
    @jsii.member(jsii_name="rootDeviceName")
    def root_device_name(self) -> typing.Optional[str]:
        return jsii.get(self, "rootDeviceName")

    @root_device_name.setter
    def root_device_name(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "rootDeviceName", value)

    @builtins.property
    @jsii.member(jsii_name="sriovNetSupport")
    def sriov_net_support(self) -> typing.Optional[str]:
        return jsii.get(self, "sriovNetSupport")

    @sriov_net_support.setter
    def sriov_net_support(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "sriovNetSupport", value)

    @builtins.property
    @jsii.member(jsii_name="tags")
    def tags(self) -> typing.Optional[typing.Mapping[str, str]]:
        return jsii.get(self, "tags")

    @tags.setter
    def tags(self, value: typing.Optional[typing.Mapping[str, str]]) -> None:
        jsii.set(self, "tags", value)

    @builtins.property
    @jsii.member(jsii_name="timeouts")
    def timeouts(self) -> typing.Optional["AmiTimeouts"]:
        return jsii.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: typing.Optional["AmiTimeouts"]) -> None:
        jsii.set(self, "timeouts", value)

    @builtins.property
    @jsii.member(jsii_name="virtualizationType")
    def virtualization_type(self) -> typing.Optional[str]:
        return jsii.get(self, "virtualizationType")

    @virtualization_type.setter
    def virtualization_type(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "virtualizationType", value)


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AmiConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "name": "name",
        "architecture": "architecture",
        "description": "description",
        "ebs_block_device": "ebsBlockDevice",
        "ena_support": "enaSupport",
        "ephemeral_block_device": "ephemeralBlockDevice",
        "image_location": "imageLocation",
        "kernel_id": "kernelId",
        "ramdisk_id": "ramdiskId",
        "root_device_name": "rootDeviceName",
        "sriov_net_support": "sriovNetSupport",
        "tags": "tags",
        "timeouts": "timeouts",
        "virtualization_type": "virtualizationType",
    },
)
class AmiConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        name: str,
        architecture: typing.Optional[str] = None,
        description: typing.Optional[str] = None,
        ebs_block_device: typing.Optional[typing.List["AmiEbsBlockDevice"]] = None,
        ena_support: typing.Optional[bool] = None,
        ephemeral_block_device: typing.Optional[
            typing.List["AmiEphemeralBlockDevice"]
        ] = None,
        image_location: typing.Optional[str] = None,
        kernel_id: typing.Optional[str] = None,
        ramdisk_id: typing.Optional[str] = None,
        root_device_name: typing.Optional[str] = None,
        sriov_net_support: typing.Optional[str] = None,
        tags: typing.Optional[typing.Mapping[str, str]] = None,
        timeouts: typing.Optional["AmiTimeouts"] = None,
        virtualization_type: typing.Optional[str] = None,
    ) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param name: 
        :param architecture: 
        :param description: 
        :param ebs_block_device: ebs_block_device block.
        :param ena_support: 
        :param ephemeral_block_device: ephemeral_block_device block.
        :param image_location: 
        :param kernel_id: 
        :param ramdisk_id: 
        :param root_device_name: 
        :param sriov_net_support: 
        :param tags: 
        :param timeouts: timeouts block.
        :param virtualization_type: 
        """
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        if isinstance(timeouts, dict):
            timeouts = AmiTimeouts(**timeouts)
        self._values = {
            "name": name,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if architecture is not None:
            self._values["architecture"] = architecture
        if description is not None:
            self._values["description"] = description
        if ebs_block_device is not None:
            self._values["ebs_block_device"] = ebs_block_device
        if ena_support is not None:
            self._values["ena_support"] = ena_support
        if ephemeral_block_device is not None:
            self._values["ephemeral_block_device"] = ephemeral_block_device
        if image_location is not None:
            self._values["image_location"] = image_location
        if kernel_id is not None:
            self._values["kernel_id"] = kernel_id
        if ramdisk_id is not None:
            self._values["ramdisk_id"] = ramdisk_id
        if root_device_name is not None:
            self._values["root_device_name"] = root_device_name
        if sriov_net_support is not None:
            self._values["sriov_net_support"] = sriov_net_support
        if tags is not None:
            self._values["tags"] = tags
        if timeouts is not None:
            self._values["timeouts"] = timeouts
        if virtualization_type is not None:
            self._values["virtualization_type"] = virtualization_type

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("count")

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.TerraformResource]]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("depends_on")

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("lifecycle")

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("provider")

    @builtins.property
    def name(self) -> str:
        return self._values.get("name")

    @builtins.property
    def architecture(self) -> typing.Optional[str]:
        return self._values.get("architecture")

    @builtins.property
    def description(self) -> typing.Optional[str]:
        return self._values.get("description")

    @builtins.property
    def ebs_block_device(self) -> typing.Optional[typing.List["AmiEbsBlockDevice"]]:
        """ebs_block_device block."""
        return self._values.get("ebs_block_device")

    @builtins.property
    def ena_support(self) -> typing.Optional[bool]:
        return self._values.get("ena_support")

    @builtins.property
    def ephemeral_block_device(
        self,
    ) -> typing.Optional[typing.List["AmiEphemeralBlockDevice"]]:
        """ephemeral_block_device block."""
        return self._values.get("ephemeral_block_device")

    @builtins.property
    def image_location(self) -> typing.Optional[str]:
        return self._values.get("image_location")

    @builtins.property
    def kernel_id(self) -> typing.Optional[str]:
        return self._values.get("kernel_id")

    @builtins.property
    def ramdisk_id(self) -> typing.Optional[str]:
        return self._values.get("ramdisk_id")

    @builtins.property
    def root_device_name(self) -> typing.Optional[str]:
        return self._values.get("root_device_name")

    @builtins.property
    def sriov_net_support(self) -> typing.Optional[str]:
        return self._values.get("sriov_net_support")

    @builtins.property
    def tags(self) -> typing.Optional[typing.Mapping[str, str]]:
        return self._values.get("tags")

    @builtins.property
    def timeouts(self) -> typing.Optional["AmiTimeouts"]:
        """timeouts block."""
        return self._values.get("timeouts")

    @builtins.property
    def virtualization_type(self) -> typing.Optional[str]:
        return self._values.get("virtualization_type")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AmiConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class AmiCopy(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="@skorfmann/cdktf-provider-aws.AmiCopy",
):
    def __init__(
        self,
        scope: constructs.Construct,
        id: str,
        *,
        name: str,
        source_ami_id: str,
        source_ami_region: str,
        description: typing.Optional[str] = None,
        ebs_block_device: typing.Optional[typing.List["AmiCopyEbsBlockDevice"]] = None,
        encrypted: typing.Optional[bool] = None,
        ephemeral_block_device: typing.Optional[
            typing.List["AmiCopyEphemeralBlockDevice"]
        ] = None,
        kms_key_id: typing.Optional[str] = None,
        tags: typing.Optional[typing.Mapping[str, str]] = None,
        timeouts: typing.Optional["AmiCopyTimeouts"] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param name: 
        :param source_ami_id: 
        :param source_ami_region: 
        :param description: 
        :param ebs_block_device: ebs_block_device block.
        :param encrypted: 
        :param ephemeral_block_device: ephemeral_block_device block.
        :param kms_key_id: 
        :param tags: 
        :param timeouts: timeouts block.
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = AmiCopyConfig(
            name=name,
            source_ami_id=source_ami_id,
            source_ami_region=source_ami_region,
            description=description,
            ebs_block_device=ebs_block_device,
            encrypted=encrypted,
            ephemeral_block_device=ephemeral_block_device,
            kms_key_id=kms_key_id,
            tags=tags,
            timeouts=timeouts,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(AmiCopy, self, [scope, id, config])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property
    @jsii.member(jsii_name="architecture")
    def architecture(self) -> str:
        return jsii.get(self, "architecture")

    @builtins.property
    @jsii.member(jsii_name="arn")
    def arn(self) -> str:
        return jsii.get(self, "arn")

    @builtins.property
    @jsii.member(jsii_name="enaSupport")
    def ena_support(self) -> bool:
        return jsii.get(self, "enaSupport")

    @builtins.property
    @jsii.member(jsii_name="imageLocation")
    def image_location(self) -> str:
        return jsii.get(self, "imageLocation")

    @builtins.property
    @jsii.member(jsii_name="kernelId")
    def kernel_id(self) -> str:
        return jsii.get(self, "kernelId")

    @builtins.property
    @jsii.member(jsii_name="manageEbsSnapshots")
    def manage_ebs_snapshots(self) -> bool:
        return jsii.get(self, "manageEbsSnapshots")

    @builtins.property
    @jsii.member(jsii_name="ramdiskId")
    def ramdisk_id(self) -> str:
        return jsii.get(self, "ramdiskId")

    @builtins.property
    @jsii.member(jsii_name="rootDeviceName")
    def root_device_name(self) -> str:
        return jsii.get(self, "rootDeviceName")

    @builtins.property
    @jsii.member(jsii_name="rootSnapshotId")
    def root_snapshot_id(self) -> str:
        return jsii.get(self, "rootSnapshotId")

    @builtins.property
    @jsii.member(jsii_name="sriovNetSupport")
    def sriov_net_support(self) -> str:
        return jsii.get(self, "sriovNetSupport")

    @builtins.property
    @jsii.member(jsii_name="virtualizationType")
    def virtualization_type(self) -> str:
        return jsii.get(self, "virtualizationType")

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> str:
        return jsii.get(self, "name")

    @name.setter
    def name(self, value: str) -> None:
        jsii.set(self, "name", value)

    @builtins.property
    @jsii.member(jsii_name="sourceAmiId")
    def source_ami_id(self) -> str:
        return jsii.get(self, "sourceAmiId")

    @source_ami_id.setter
    def source_ami_id(self, value: str) -> None:
        jsii.set(self, "sourceAmiId", value)

    @builtins.property
    @jsii.member(jsii_name="sourceAmiRegion")
    def source_ami_region(self) -> str:
        return jsii.get(self, "sourceAmiRegion")

    @source_ami_region.setter
    def source_ami_region(self, value: str) -> None:
        jsii.set(self, "sourceAmiRegion", value)

    @builtins.property
    @jsii.member(jsii_name="description")
    def description(self) -> typing.Optional[str]:
        return jsii.get(self, "description")

    @description.setter
    def description(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "description", value)

    @builtins.property
    @jsii.member(jsii_name="ebsBlockDevice")
    def ebs_block_device(self) -> typing.Optional[typing.List["AmiCopyEbsBlockDevice"]]:
        return jsii.get(self, "ebsBlockDevice")

    @ebs_block_device.setter
    def ebs_block_device(
        self, value: typing.Optional[typing.List["AmiCopyEbsBlockDevice"]]
    ) -> None:
        jsii.set(self, "ebsBlockDevice", value)

    @builtins.property
    @jsii.member(jsii_name="encrypted")
    def encrypted(self) -> typing.Optional[bool]:
        return jsii.get(self, "encrypted")

    @encrypted.setter
    def encrypted(self, value: typing.Optional[bool]) -> None:
        jsii.set(self, "encrypted", value)

    @builtins.property
    @jsii.member(jsii_name="ephemeralBlockDevice")
    def ephemeral_block_device(
        self,
    ) -> typing.Optional[typing.List["AmiCopyEphemeralBlockDevice"]]:
        return jsii.get(self, "ephemeralBlockDevice")

    @ephemeral_block_device.setter
    def ephemeral_block_device(
        self, value: typing.Optional[typing.List["AmiCopyEphemeralBlockDevice"]]
    ) -> None:
        jsii.set(self, "ephemeralBlockDevice", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="kmsKeyId")
    def kms_key_id(self) -> typing.Optional[str]:
        return jsii.get(self, "kmsKeyId")

    @kms_key_id.setter
    def kms_key_id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "kmsKeyId", value)

    @builtins.property
    @jsii.member(jsii_name="tags")
    def tags(self) -> typing.Optional[typing.Mapping[str, str]]:
        return jsii.get(self, "tags")

    @tags.setter
    def tags(self, value: typing.Optional[typing.Mapping[str, str]]) -> None:
        jsii.set(self, "tags", value)

    @builtins.property
    @jsii.member(jsii_name="timeouts")
    def timeouts(self) -> typing.Optional["AmiCopyTimeouts"]:
        return jsii.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: typing.Optional["AmiCopyTimeouts"]) -> None:
        jsii.set(self, "timeouts", value)


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AmiCopyConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "name": "name",
        "source_ami_id": "sourceAmiId",
        "source_ami_region": "sourceAmiRegion",
        "description": "description",
        "ebs_block_device": "ebsBlockDevice",
        "encrypted": "encrypted",
        "ephemeral_block_device": "ephemeralBlockDevice",
        "kms_key_id": "kmsKeyId",
        "tags": "tags",
        "timeouts": "timeouts",
    },
)
class AmiCopyConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        name: str,
        source_ami_id: str,
        source_ami_region: str,
        description: typing.Optional[str] = None,
        ebs_block_device: typing.Optional[typing.List["AmiCopyEbsBlockDevice"]] = None,
        encrypted: typing.Optional[bool] = None,
        ephemeral_block_device: typing.Optional[
            typing.List["AmiCopyEphemeralBlockDevice"]
        ] = None,
        kms_key_id: typing.Optional[str] = None,
        tags: typing.Optional[typing.Mapping[str, str]] = None,
        timeouts: typing.Optional["AmiCopyTimeouts"] = None,
    ) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param name: 
        :param source_ami_id: 
        :param source_ami_region: 
        :param description: 
        :param ebs_block_device: ebs_block_device block.
        :param encrypted: 
        :param ephemeral_block_device: ephemeral_block_device block.
        :param kms_key_id: 
        :param tags: 
        :param timeouts: timeouts block.
        """
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        if isinstance(timeouts, dict):
            timeouts = AmiCopyTimeouts(**timeouts)
        self._values = {
            "name": name,
            "source_ami_id": source_ami_id,
            "source_ami_region": source_ami_region,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if description is not None:
            self._values["description"] = description
        if ebs_block_device is not None:
            self._values["ebs_block_device"] = ebs_block_device
        if encrypted is not None:
            self._values["encrypted"] = encrypted
        if ephemeral_block_device is not None:
            self._values["ephemeral_block_device"] = ephemeral_block_device
        if kms_key_id is not None:
            self._values["kms_key_id"] = kms_key_id
        if tags is not None:
            self._values["tags"] = tags
        if timeouts is not None:
            self._values["timeouts"] = timeouts

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("count")

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.TerraformResource]]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("depends_on")

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("lifecycle")

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("provider")

    @builtins.property
    def name(self) -> str:
        return self._values.get("name")

    @builtins.property
    def source_ami_id(self) -> str:
        return self._values.get("source_ami_id")

    @builtins.property
    def source_ami_region(self) -> str:
        return self._values.get("source_ami_region")

    @builtins.property
    def description(self) -> typing.Optional[str]:
        return self._values.get("description")

    @builtins.property
    def ebs_block_device(self) -> typing.Optional[typing.List["AmiCopyEbsBlockDevice"]]:
        """ebs_block_device block."""
        return self._values.get("ebs_block_device")

    @builtins.property
    def encrypted(self) -> typing.Optional[bool]:
        return self._values.get("encrypted")

    @builtins.property
    def ephemeral_block_device(
        self,
    ) -> typing.Optional[typing.List["AmiCopyEphemeralBlockDevice"]]:
        """ephemeral_block_device block."""
        return self._values.get("ephemeral_block_device")

    @builtins.property
    def kms_key_id(self) -> typing.Optional[str]:
        return self._values.get("kms_key_id")

    @builtins.property
    def tags(self) -> typing.Optional[typing.Mapping[str, str]]:
        return self._values.get("tags")

    @builtins.property
    def timeouts(self) -> typing.Optional["AmiCopyTimeouts"]:
        """timeouts block."""
        return self._values.get("timeouts")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AmiCopyConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AmiCopyEbsBlockDevice",
    jsii_struct_bases=[],
    name_mapping={},
)
class AmiCopyEbsBlockDevice:
    def __init__(self) -> None:
        self._values = {}

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AmiCopyEbsBlockDevice(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AmiCopyEphemeralBlockDevice",
    jsii_struct_bases=[],
    name_mapping={},
)
class AmiCopyEphemeralBlockDevice:
    def __init__(self) -> None:
        self._values = {}

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AmiCopyEphemeralBlockDevice(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AmiCopyTimeouts",
    jsii_struct_bases=[],
    name_mapping={"create": "create", "delete": "delete", "update": "update"},
)
class AmiCopyTimeouts:
    def __init__(
        self,
        *,
        create: typing.Optional[str] = None,
        delete: typing.Optional[str] = None,
        update: typing.Optional[str] = None,
    ) -> None:
        """
        :param create: 
        :param delete: 
        :param update: 
        """
        self._values = {}
        if create is not None:
            self._values["create"] = create
        if delete is not None:
            self._values["delete"] = delete
        if update is not None:
            self._values["update"] = update

    @builtins.property
    def create(self) -> typing.Optional[str]:
        return self._values.get("create")

    @builtins.property
    def delete(self) -> typing.Optional[str]:
        return self._values.get("delete")

    @builtins.property
    def update(self) -> typing.Optional[str]:
        return self._values.get("update")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AmiCopyTimeouts(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AmiEbsBlockDevice",
    jsii_struct_bases=[],
    name_mapping={
        "device_name": "deviceName",
        "delete_on_termination": "deleteOnTermination",
        "encrypted": "encrypted",
        "iops": "iops",
        "snapshot_id": "snapshotId",
        "volume_size": "volumeSize",
        "volume_type": "volumeType",
    },
)
class AmiEbsBlockDevice:
    def __init__(
        self,
        *,
        device_name: str,
        delete_on_termination: typing.Optional[bool] = None,
        encrypted: typing.Optional[bool] = None,
        iops: typing.Optional[jsii.Number] = None,
        snapshot_id: typing.Optional[str] = None,
        volume_size: typing.Optional[jsii.Number] = None,
        volume_type: typing.Optional[str] = None,
    ) -> None:
        """
        :param device_name: 
        :param delete_on_termination: 
        :param encrypted: 
        :param iops: 
        :param snapshot_id: 
        :param volume_size: 
        :param volume_type: 
        """
        self._values = {
            "device_name": device_name,
        }
        if delete_on_termination is not None:
            self._values["delete_on_termination"] = delete_on_termination
        if encrypted is not None:
            self._values["encrypted"] = encrypted
        if iops is not None:
            self._values["iops"] = iops
        if snapshot_id is not None:
            self._values["snapshot_id"] = snapshot_id
        if volume_size is not None:
            self._values["volume_size"] = volume_size
        if volume_type is not None:
            self._values["volume_type"] = volume_type

    @builtins.property
    def device_name(self) -> str:
        return self._values.get("device_name")

    @builtins.property
    def delete_on_termination(self) -> typing.Optional[bool]:
        return self._values.get("delete_on_termination")

    @builtins.property
    def encrypted(self) -> typing.Optional[bool]:
        return self._values.get("encrypted")

    @builtins.property
    def iops(self) -> typing.Optional[jsii.Number]:
        return self._values.get("iops")

    @builtins.property
    def snapshot_id(self) -> typing.Optional[str]:
        return self._values.get("snapshot_id")

    @builtins.property
    def volume_size(self) -> typing.Optional[jsii.Number]:
        return self._values.get("volume_size")

    @builtins.property
    def volume_type(self) -> typing.Optional[str]:
        return self._values.get("volume_type")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AmiEbsBlockDevice(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AmiEphemeralBlockDevice",
    jsii_struct_bases=[],
    name_mapping={"device_name": "deviceName", "virtual_name": "virtualName"},
)
class AmiEphemeralBlockDevice:
    def __init__(self, *, device_name: str, virtual_name: str) -> None:
        """
        :param device_name: 
        :param virtual_name: 
        """
        self._values = {
            "device_name": device_name,
            "virtual_name": virtual_name,
        }

    @builtins.property
    def device_name(self) -> str:
        return self._values.get("device_name")

    @builtins.property
    def virtual_name(self) -> str:
        return self._values.get("virtual_name")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AmiEphemeralBlockDevice(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class AmiFromInstance(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="@skorfmann/cdktf-provider-aws.AmiFromInstance",
):
    def __init__(
        self,
        scope: constructs.Construct,
        id: str,
        *,
        name: str,
        source_instance_id: str,
        description: typing.Optional[str] = None,
        ebs_block_device: typing.Optional[
            typing.List["AmiFromInstanceEbsBlockDevice"]
        ] = None,
        ephemeral_block_device: typing.Optional[
            typing.List["AmiFromInstanceEphemeralBlockDevice"]
        ] = None,
        snapshot_without_reboot: typing.Optional[bool] = None,
        tags: typing.Optional[typing.Mapping[str, str]] = None,
        timeouts: typing.Optional["AmiFromInstanceTimeouts"] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param name: 
        :param source_instance_id: 
        :param description: 
        :param ebs_block_device: ebs_block_device block.
        :param ephemeral_block_device: ephemeral_block_device block.
        :param snapshot_without_reboot: 
        :param tags: 
        :param timeouts: timeouts block.
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = AmiFromInstanceConfig(
            name=name,
            source_instance_id=source_instance_id,
            description=description,
            ebs_block_device=ebs_block_device,
            ephemeral_block_device=ephemeral_block_device,
            snapshot_without_reboot=snapshot_without_reboot,
            tags=tags,
            timeouts=timeouts,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(AmiFromInstance, self, [scope, id, config])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property
    @jsii.member(jsii_name="architecture")
    def architecture(self) -> str:
        return jsii.get(self, "architecture")

    @builtins.property
    @jsii.member(jsii_name="arn")
    def arn(self) -> str:
        return jsii.get(self, "arn")

    @builtins.property
    @jsii.member(jsii_name="enaSupport")
    def ena_support(self) -> bool:
        return jsii.get(self, "enaSupport")

    @builtins.property
    @jsii.member(jsii_name="imageLocation")
    def image_location(self) -> str:
        return jsii.get(self, "imageLocation")

    @builtins.property
    @jsii.member(jsii_name="kernelId")
    def kernel_id(self) -> str:
        return jsii.get(self, "kernelId")

    @builtins.property
    @jsii.member(jsii_name="manageEbsSnapshots")
    def manage_ebs_snapshots(self) -> bool:
        return jsii.get(self, "manageEbsSnapshots")

    @builtins.property
    @jsii.member(jsii_name="ramdiskId")
    def ramdisk_id(self) -> str:
        return jsii.get(self, "ramdiskId")

    @builtins.property
    @jsii.member(jsii_name="rootDeviceName")
    def root_device_name(self) -> str:
        return jsii.get(self, "rootDeviceName")

    @builtins.property
    @jsii.member(jsii_name="rootSnapshotId")
    def root_snapshot_id(self) -> str:
        return jsii.get(self, "rootSnapshotId")

    @builtins.property
    @jsii.member(jsii_name="sriovNetSupport")
    def sriov_net_support(self) -> str:
        return jsii.get(self, "sriovNetSupport")

    @builtins.property
    @jsii.member(jsii_name="virtualizationType")
    def virtualization_type(self) -> str:
        return jsii.get(self, "virtualizationType")

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> str:
        return jsii.get(self, "name")

    @name.setter
    def name(self, value: str) -> None:
        jsii.set(self, "name", value)

    @builtins.property
    @jsii.member(jsii_name="sourceInstanceId")
    def source_instance_id(self) -> str:
        return jsii.get(self, "sourceInstanceId")

    @source_instance_id.setter
    def source_instance_id(self, value: str) -> None:
        jsii.set(self, "sourceInstanceId", value)

    @builtins.property
    @jsii.member(jsii_name="description")
    def description(self) -> typing.Optional[str]:
        return jsii.get(self, "description")

    @description.setter
    def description(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "description", value)

    @builtins.property
    @jsii.member(jsii_name="ebsBlockDevice")
    def ebs_block_device(
        self,
    ) -> typing.Optional[typing.List["AmiFromInstanceEbsBlockDevice"]]:
        return jsii.get(self, "ebsBlockDevice")

    @ebs_block_device.setter
    def ebs_block_device(
        self, value: typing.Optional[typing.List["AmiFromInstanceEbsBlockDevice"]]
    ) -> None:
        jsii.set(self, "ebsBlockDevice", value)

    @builtins.property
    @jsii.member(jsii_name="ephemeralBlockDevice")
    def ephemeral_block_device(
        self,
    ) -> typing.Optional[typing.List["AmiFromInstanceEphemeralBlockDevice"]]:
        return jsii.get(self, "ephemeralBlockDevice")

    @ephemeral_block_device.setter
    def ephemeral_block_device(
        self, value: typing.Optional[typing.List["AmiFromInstanceEphemeralBlockDevice"]]
    ) -> None:
        jsii.set(self, "ephemeralBlockDevice", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="snapshotWithoutReboot")
    def snapshot_without_reboot(self) -> typing.Optional[bool]:
        return jsii.get(self, "snapshotWithoutReboot")

    @snapshot_without_reboot.setter
    def snapshot_without_reboot(self, value: typing.Optional[bool]) -> None:
        jsii.set(self, "snapshotWithoutReboot", value)

    @builtins.property
    @jsii.member(jsii_name="tags")
    def tags(self) -> typing.Optional[typing.Mapping[str, str]]:
        return jsii.get(self, "tags")

    @tags.setter
    def tags(self, value: typing.Optional[typing.Mapping[str, str]]) -> None:
        jsii.set(self, "tags", value)

    @builtins.property
    @jsii.member(jsii_name="timeouts")
    def timeouts(self) -> typing.Optional["AmiFromInstanceTimeouts"]:
        return jsii.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: typing.Optional["AmiFromInstanceTimeouts"]) -> None:
        jsii.set(self, "timeouts", value)


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AmiFromInstanceConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "name": "name",
        "source_instance_id": "sourceInstanceId",
        "description": "description",
        "ebs_block_device": "ebsBlockDevice",
        "ephemeral_block_device": "ephemeralBlockDevice",
        "snapshot_without_reboot": "snapshotWithoutReboot",
        "tags": "tags",
        "timeouts": "timeouts",
    },
)
class AmiFromInstanceConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        name: str,
        source_instance_id: str,
        description: typing.Optional[str] = None,
        ebs_block_device: typing.Optional[
            typing.List["AmiFromInstanceEbsBlockDevice"]
        ] = None,
        ephemeral_block_device: typing.Optional[
            typing.List["AmiFromInstanceEphemeralBlockDevice"]
        ] = None,
        snapshot_without_reboot: typing.Optional[bool] = None,
        tags: typing.Optional[typing.Mapping[str, str]] = None,
        timeouts: typing.Optional["AmiFromInstanceTimeouts"] = None,
    ) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param name: 
        :param source_instance_id: 
        :param description: 
        :param ebs_block_device: ebs_block_device block.
        :param ephemeral_block_device: ephemeral_block_device block.
        :param snapshot_without_reboot: 
        :param tags: 
        :param timeouts: timeouts block.
        """
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        if isinstance(timeouts, dict):
            timeouts = AmiFromInstanceTimeouts(**timeouts)
        self._values = {
            "name": name,
            "source_instance_id": source_instance_id,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if description is not None:
            self._values["description"] = description
        if ebs_block_device is not None:
            self._values["ebs_block_device"] = ebs_block_device
        if ephemeral_block_device is not None:
            self._values["ephemeral_block_device"] = ephemeral_block_device
        if snapshot_without_reboot is not None:
            self._values["snapshot_without_reboot"] = snapshot_without_reboot
        if tags is not None:
            self._values["tags"] = tags
        if timeouts is not None:
            self._values["timeouts"] = timeouts

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("count")

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.TerraformResource]]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("depends_on")

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("lifecycle")

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("provider")

    @builtins.property
    def name(self) -> str:
        return self._values.get("name")

    @builtins.property
    def source_instance_id(self) -> str:
        return self._values.get("source_instance_id")

    @builtins.property
    def description(self) -> typing.Optional[str]:
        return self._values.get("description")

    @builtins.property
    def ebs_block_device(
        self,
    ) -> typing.Optional[typing.List["AmiFromInstanceEbsBlockDevice"]]:
        """ebs_block_device block."""
        return self._values.get("ebs_block_device")

    @builtins.property
    def ephemeral_block_device(
        self,
    ) -> typing.Optional[typing.List["AmiFromInstanceEphemeralBlockDevice"]]:
        """ephemeral_block_device block."""
        return self._values.get("ephemeral_block_device")

    @builtins.property
    def snapshot_without_reboot(self) -> typing.Optional[bool]:
        return self._values.get("snapshot_without_reboot")

    @builtins.property
    def tags(self) -> typing.Optional[typing.Mapping[str, str]]:
        return self._values.get("tags")

    @builtins.property
    def timeouts(self) -> typing.Optional["AmiFromInstanceTimeouts"]:
        """timeouts block."""
        return self._values.get("timeouts")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AmiFromInstanceConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AmiFromInstanceEbsBlockDevice",
    jsii_struct_bases=[],
    name_mapping={},
)
class AmiFromInstanceEbsBlockDevice:
    def __init__(self) -> None:
        self._values = {}

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AmiFromInstanceEbsBlockDevice(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AmiFromInstanceEphemeralBlockDevice",
    jsii_struct_bases=[],
    name_mapping={},
)
class AmiFromInstanceEphemeralBlockDevice:
    def __init__(self) -> None:
        self._values = {}

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AmiFromInstanceEphemeralBlockDevice(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AmiFromInstanceTimeouts",
    jsii_struct_bases=[],
    name_mapping={"create": "create", "delete": "delete", "update": "update"},
)
class AmiFromInstanceTimeouts:
    def __init__(
        self,
        *,
        create: typing.Optional[str] = None,
        delete: typing.Optional[str] = None,
        update: typing.Optional[str] = None,
    ) -> None:
        """
        :param create: 
        :param delete: 
        :param update: 
        """
        self._values = {}
        if create is not None:
            self._values["create"] = create
        if delete is not None:
            self._values["delete"] = delete
        if update is not None:
            self._values["update"] = update

    @builtins.property
    def create(self) -> typing.Optional[str]:
        return self._values.get("create")

    @builtins.property
    def delete(self) -> typing.Optional[str]:
        return self._values.get("delete")

    @builtins.property
    def update(self) -> typing.Optional[str]:
        return self._values.get("update")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AmiFromInstanceTimeouts(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class AmiLaunchPermission(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="@skorfmann/cdktf-provider-aws.AmiLaunchPermission",
):
    def __init__(
        self,
        scope: constructs.Construct,
        id: str,
        *,
        account_id: str,
        image_id: str,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param account_id: 
        :param image_id: 
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = AmiLaunchPermissionConfig(
            account_id=account_id,
            image_id=image_id,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(AmiLaunchPermission, self, [scope, id, config])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property
    @jsii.member(jsii_name="accountId")
    def account_id(self) -> str:
        return jsii.get(self, "accountId")

    @account_id.setter
    def account_id(self, value: str) -> None:
        jsii.set(self, "accountId", value)

    @builtins.property
    @jsii.member(jsii_name="imageId")
    def image_id(self) -> str:
        return jsii.get(self, "imageId")

    @image_id.setter
    def image_id(self, value: str) -> None:
        jsii.set(self, "imageId", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AmiLaunchPermissionConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "account_id": "accountId",
        "image_id": "imageId",
    },
)
class AmiLaunchPermissionConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        account_id: str,
        image_id: str,
    ) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param account_id: 
        :param image_id: 
        """
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        self._values = {
            "account_id": account_id,
            "image_id": image_id,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("count")

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.TerraformResource]]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("depends_on")

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("lifecycle")

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("provider")

    @builtins.property
    def account_id(self) -> str:
        return self._values.get("account_id")

    @builtins.property
    def image_id(self) -> str:
        return self._values.get("image_id")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AmiLaunchPermissionConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AmiTimeouts",
    jsii_struct_bases=[],
    name_mapping={"create": "create", "delete": "delete", "update": "update"},
)
class AmiTimeouts:
    def __init__(
        self,
        *,
        create: typing.Optional[str] = None,
        delete: typing.Optional[str] = None,
        update: typing.Optional[str] = None,
    ) -> None:
        """
        :param create: 
        :param delete: 
        :param update: 
        """
        self._values = {}
        if create is not None:
            self._values["create"] = create
        if delete is not None:
            self._values["delete"] = delete
        if update is not None:
            self._values["update"] = update

    @builtins.property
    def create(self) -> typing.Optional[str]:
        return self._values.get("create")

    @builtins.property
    def delete(self) -> typing.Optional[str]:
        return self._values.get("delete")

    @builtins.property
    def update(self) -> typing.Optional[str]:
        return self._values.get("update")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AmiTimeouts(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class ApiGatewayAccount(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="@skorfmann/cdktf-provider-aws.ApiGatewayAccount",
):
    def __init__(
        self,
        scope: constructs.Construct,
        id: str,
        *,
        cloudwatch_role_arn: typing.Optional[str] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param cloudwatch_role_arn: 
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = ApiGatewayAccountConfig(
            cloudwatch_role_arn=cloudwatch_role_arn,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(ApiGatewayAccount, self, [scope, id, config])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @jsii.member(jsii_name="throttleSettings")
    def throttle_settings(self, index: str) -> "ApiGatewayAccountThrottleSettings":
        """
        :param index: -
        """
        return jsii.invoke(self, "throttleSettings", [index])

    @builtins.property
    @jsii.member(jsii_name="cloudwatchRoleArn")
    def cloudwatch_role_arn(self) -> typing.Optional[str]:
        return jsii.get(self, "cloudwatchRoleArn")

    @cloudwatch_role_arn.setter
    def cloudwatch_role_arn(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "cloudwatchRoleArn", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.ApiGatewayAccountConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "cloudwatch_role_arn": "cloudwatchRoleArn",
    },
)
class ApiGatewayAccountConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        cloudwatch_role_arn: typing.Optional[str] = None,
    ) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param cloudwatch_role_arn: 
        """
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        self._values = {}
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if cloudwatch_role_arn is not None:
            self._values["cloudwatch_role_arn"] = cloudwatch_role_arn

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("count")

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.TerraformResource]]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("depends_on")

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("lifecycle")

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("provider")

    @builtins.property
    def cloudwatch_role_arn(self) -> typing.Optional[str]:
        return self._values.get("cloudwatch_role_arn")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiGatewayAccountConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class ApiGatewayAccountThrottleSettings(
    cdktf.ComplexComputedList,
    metaclass=jsii.JSIIMeta,
    jsii_type="@skorfmann/cdktf-provider-aws.ApiGatewayAccountThrottleSettings",
):
    def __init__(
        self,
        terraform_resource: cdktf.ITerraformResource,
        terraform_attribute: str,
        index: str,
    ) -> None:
        """
        :param terraform_resource: -
        :param terraform_attribute: -
        :param index: -

        stability
        :stability: experimental
        """
        jsii.create(
            ApiGatewayAccountThrottleSettings,
            self,
            [terraform_resource, terraform_attribute, index],
        )

    @builtins.property
    @jsii.member(jsii_name="burstLimit")
    def burst_limit(self) -> jsii.Number:
        return jsii.get(self, "burstLimit")

    @builtins.property
    @jsii.member(jsii_name="rateLimit")
    def rate_limit(self) -> jsii.Number:
        return jsii.get(self, "rateLimit")


class ApiGatewayApiKey(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="@skorfmann/cdktf-provider-aws.ApiGatewayApiKey",
):
    def __init__(
        self,
        scope: constructs.Construct,
        id: str,
        *,
        name: str,
        description: typing.Optional[str] = None,
        enabled: typing.Optional[bool] = None,
        stage_key: typing.Optional[typing.List["ApiGatewayApiKeyStageKey"]] = None,
        tags: typing.Optional[typing.Mapping[str, str]] = None,
        value: typing.Optional[str] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param name: 
        :param description: 
        :param enabled: 
        :param stage_key: stage_key block.
        :param tags: 
        :param value: 
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = ApiGatewayApiKeyConfig(
            name=name,
            description=description,
            enabled=enabled,
            stage_key=stage_key,
            tags=tags,
            value=value,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(ApiGatewayApiKey, self, [scope, id, config])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property
    @jsii.member(jsii_name="arn")
    def arn(self) -> str:
        return jsii.get(self, "arn")

    @builtins.property
    @jsii.member(jsii_name="createdDate")
    def created_date(self) -> str:
        return jsii.get(self, "createdDate")

    @builtins.property
    @jsii.member(jsii_name="lastUpdatedDate")
    def last_updated_date(self) -> str:
        return jsii.get(self, "lastUpdatedDate")

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> str:
        return jsii.get(self, "name")

    @name.setter
    def name(self, value: str) -> None:
        jsii.set(self, "name", value)

    @builtins.property
    @jsii.member(jsii_name="description")
    def description(self) -> typing.Optional[str]:
        return jsii.get(self, "description")

    @description.setter
    def description(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "description", value)

    @builtins.property
    @jsii.member(jsii_name="enabled")
    def enabled(self) -> typing.Optional[bool]:
        return jsii.get(self, "enabled")

    @enabled.setter
    def enabled(self, value: typing.Optional[bool]) -> None:
        jsii.set(self, "enabled", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="stageKey")
    def stage_key(self) -> typing.Optional[typing.List["ApiGatewayApiKeyStageKey"]]:
        return jsii.get(self, "stageKey")

    @stage_key.setter
    def stage_key(
        self, value: typing.Optional[typing.List["ApiGatewayApiKeyStageKey"]]
    ) -> None:
        jsii.set(self, "stageKey", value)

    @builtins.property
    @jsii.member(jsii_name="tags")
    def tags(self) -> typing.Optional[typing.Mapping[str, str]]:
        return jsii.get(self, "tags")

    @tags.setter
    def tags(self, value: typing.Optional[typing.Mapping[str, str]]) -> None:
        jsii.set(self, "tags", value)

    @builtins.property
    @jsii.member(jsii_name="value")
    def value(self) -> typing.Optional[str]:
        return jsii.get(self, "value")

    @value.setter
    def value(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "value", value)


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.ApiGatewayApiKeyConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "name": "name",
        "description": "description",
        "enabled": "enabled",
        "stage_key": "stageKey",
        "tags": "tags",
        "value": "value",
    },
)
class ApiGatewayApiKeyConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        name: str,
        description: typing.Optional[str] = None,
        enabled: typing.Optional[bool] = None,
        stage_key: typing.Optional[typing.List["ApiGatewayApiKeyStageKey"]] = None,
        tags: typing.Optional[typing.Mapping[str, str]] = None,
        value: typing.Optional[str] = None,
    ) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param name: 
        :param description: 
        :param enabled: 
        :param stage_key: stage_key block.
        :param tags: 
        :param value: 
        """
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        self._values = {
            "name": name,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if description is not None:
            self._values["description"] = description
        if enabled is not None:
            self._values["enabled"] = enabled
        if stage_key is not None:
            self._values["stage_key"] = stage_key
        if tags is not None:
            self._values["tags"] = tags
        if value is not None:
            self._values["value"] = value

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("count")

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.TerraformResource]]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("depends_on")

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("lifecycle")

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("provider")

    @builtins.property
    def name(self) -> str:
        return self._values.get("name")

    @builtins.property
    def description(self) -> typing.Optional[str]:
        return self._values.get("description")

    @builtins.property
    def enabled(self) -> typing.Optional[bool]:
        return self._values.get("enabled")

    @builtins.property
    def stage_key(self) -> typing.Optional[typing.List["ApiGatewayApiKeyStageKey"]]:
        """stage_key block."""
        return self._values.get("stage_key")

    @builtins.property
    def tags(self) -> typing.Optional[typing.Mapping[str, str]]:
        return self._values.get("tags")

    @builtins.property
    def value(self) -> typing.Optional[str]:
        return self._values.get("value")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiGatewayApiKeyConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.ApiGatewayApiKeyStageKey",
    jsii_struct_bases=[],
    name_mapping={"rest_api_id": "restApiId", "stage_name": "stageName"},
)
class ApiGatewayApiKeyStageKey:
    def __init__(self, *, rest_api_id: str, stage_name: str) -> None:
        """
        :param rest_api_id: 
        :param stage_name: 
        """
        self._values = {
            "rest_api_id": rest_api_id,
            "stage_name": stage_name,
        }

    @builtins.property
    def rest_api_id(self) -> str:
        return self._values.get("rest_api_id")

    @builtins.property
    def stage_name(self) -> str:
        return self._values.get("stage_name")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiGatewayApiKeyStageKey(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class ApiGatewayAuthorizer(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="@skorfmann/cdktf-provider-aws.ApiGatewayAuthorizer",
):
    def __init__(
        self,
        scope: constructs.Construct,
        id: str,
        *,
        name: str,
        rest_api_id: str,
        authorizer_credentials: typing.Optional[str] = None,
        authorizer_result_ttl_in_seconds: typing.Optional[jsii.Number] = None,
        authorizer_uri: typing.Optional[str] = None,
        identity_source: typing.Optional[str] = None,
        identity_validation_expression: typing.Optional[str] = None,
        provider_arns: typing.Optional[typing.List[str]] = None,
        type: typing.Optional[str] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param name: 
        :param rest_api_id: 
        :param authorizer_credentials: 
        :param authorizer_result_ttl_in_seconds: 
        :param authorizer_uri: 
        :param identity_source: 
        :param identity_validation_expression: 
        :param provider_arns: 
        :param type: 
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = ApiGatewayAuthorizerConfig(
            name=name,
            rest_api_id=rest_api_id,
            authorizer_credentials=authorizer_credentials,
            authorizer_result_ttl_in_seconds=authorizer_result_ttl_in_seconds,
            authorizer_uri=authorizer_uri,
            identity_source=identity_source,
            identity_validation_expression=identity_validation_expression,
            provider_arns=provider_arns,
            type=type,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(ApiGatewayAuthorizer, self, [scope, id, config])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> str:
        return jsii.get(self, "name")

    @name.setter
    def name(self, value: str) -> None:
        jsii.set(self, "name", value)

    @builtins.property
    @jsii.member(jsii_name="restApiId")
    def rest_api_id(self) -> str:
        return jsii.get(self, "restApiId")

    @rest_api_id.setter
    def rest_api_id(self, value: str) -> None:
        jsii.set(self, "restApiId", value)

    @builtins.property
    @jsii.member(jsii_name="authorizerCredentials")
    def authorizer_credentials(self) -> typing.Optional[str]:
        return jsii.get(self, "authorizerCredentials")

    @authorizer_credentials.setter
    def authorizer_credentials(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "authorizerCredentials", value)

    @builtins.property
    @jsii.member(jsii_name="authorizerResultTtlInSeconds")
    def authorizer_result_ttl_in_seconds(self) -> typing.Optional[jsii.Number]:
        return jsii.get(self, "authorizerResultTtlInSeconds")

    @authorizer_result_ttl_in_seconds.setter
    def authorizer_result_ttl_in_seconds(
        self, value: typing.Optional[jsii.Number]
    ) -> None:
        jsii.set(self, "authorizerResultTtlInSeconds", value)

    @builtins.property
    @jsii.member(jsii_name="authorizerUri")
    def authorizer_uri(self) -> typing.Optional[str]:
        return jsii.get(self, "authorizerUri")

    @authorizer_uri.setter
    def authorizer_uri(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "authorizerUri", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="identitySource")
    def identity_source(self) -> typing.Optional[str]:
        return jsii.get(self, "identitySource")

    @identity_source.setter
    def identity_source(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "identitySource", value)

    @builtins.property
    @jsii.member(jsii_name="identityValidationExpression")
    def identity_validation_expression(self) -> typing.Optional[str]:
        return jsii.get(self, "identityValidationExpression")

    @identity_validation_expression.setter
    def identity_validation_expression(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "identityValidationExpression", value)

    @builtins.property
    @jsii.member(jsii_name="providerArns")
    def provider_arns(self) -> typing.Optional[typing.List[str]]:
        return jsii.get(self, "providerArns")

    @provider_arns.setter
    def provider_arns(self, value: typing.Optional[typing.List[str]]) -> None:
        jsii.set(self, "providerArns", value)

    @builtins.property
    @jsii.member(jsii_name="type")
    def type(self) -> typing.Optional[str]:
        return jsii.get(self, "type")

    @type.setter
    def type(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "type", value)


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.ApiGatewayAuthorizerConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "name": "name",
        "rest_api_id": "restApiId",
        "authorizer_credentials": "authorizerCredentials",
        "authorizer_result_ttl_in_seconds": "authorizerResultTtlInSeconds",
        "authorizer_uri": "authorizerUri",
        "identity_source": "identitySource",
        "identity_validation_expression": "identityValidationExpression",
        "provider_arns": "providerArns",
        "type": "type",
    },
)
class ApiGatewayAuthorizerConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        name: str,
        rest_api_id: str,
        authorizer_credentials: typing.Optional[str] = None,
        authorizer_result_ttl_in_seconds: typing.Optional[jsii.Number] = None,
        authorizer_uri: typing.Optional[str] = None,
        identity_source: typing.Optional[str] = None,
        identity_validation_expression: typing.Optional[str] = None,
        provider_arns: typing.Optional[typing.List[str]] = None,
        type: typing.Optional[str] = None,
    ) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param name: 
        :param rest_api_id: 
        :param authorizer_credentials: 
        :param authorizer_result_ttl_in_seconds: 
        :param authorizer_uri: 
        :param identity_source: 
        :param identity_validation_expression: 
        :param provider_arns: 
        :param type: 
        """
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        self._values = {
            "name": name,
            "rest_api_id": rest_api_id,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if authorizer_credentials is not None:
            self._values["authorizer_credentials"] = authorizer_credentials
        if authorizer_result_ttl_in_seconds is not None:
            self._values[
                "authorizer_result_ttl_in_seconds"
            ] = authorizer_result_ttl_in_seconds
        if authorizer_uri is not None:
            self._values["authorizer_uri"] = authorizer_uri
        if identity_source is not None:
            self._values["identity_source"] = identity_source
        if identity_validation_expression is not None:
            self._values[
                "identity_validation_expression"
            ] = identity_validation_expression
        if provider_arns is not None:
            self._values["provider_arns"] = provider_arns
        if type is not None:
            self._values["type"] = type

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("count")

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.TerraformResource]]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("depends_on")

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("lifecycle")

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("provider")

    @builtins.property
    def name(self) -> str:
        return self._values.get("name")

    @builtins.property
    def rest_api_id(self) -> str:
        return self._values.get("rest_api_id")

    @builtins.property
    def authorizer_credentials(self) -> typing.Optional[str]:
        return self._values.get("authorizer_credentials")

    @builtins.property
    def authorizer_result_ttl_in_seconds(self) -> typing.Optional[jsii.Number]:
        return self._values.get("authorizer_result_ttl_in_seconds")

    @builtins.property
    def authorizer_uri(self) -> typing.Optional[str]:
        return self._values.get("authorizer_uri")

    @builtins.property
    def identity_source(self) -> typing.Optional[str]:
        return self._values.get("identity_source")

    @builtins.property
    def identity_validation_expression(self) -> typing.Optional[str]:
        return self._values.get("identity_validation_expression")

    @builtins.property
    def provider_arns(self) -> typing.Optional[typing.List[str]]:
        return self._values.get("provider_arns")

    @builtins.property
    def type(self) -> typing.Optional[str]:
        return self._values.get("type")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiGatewayAuthorizerConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class ApiGatewayBasePathMapping(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="@skorfmann/cdktf-provider-aws.ApiGatewayBasePathMapping",
):
    def __init__(
        self,
        scope: constructs.Construct,
        id: str,
        *,
        api_id: str,
        domain_name: str,
        base_path: typing.Optional[str] = None,
        stage_name: typing.Optional[str] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param api_id: 
        :param domain_name: 
        :param base_path: 
        :param stage_name: 
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = ApiGatewayBasePathMappingConfig(
            api_id=api_id,
            domain_name=domain_name,
            base_path=base_path,
            stage_name=stage_name,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(ApiGatewayBasePathMapping, self, [scope, id, config])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property
    @jsii.member(jsii_name="apiId")
    def api_id(self) -> str:
        return jsii.get(self, "apiId")

    @api_id.setter
    def api_id(self, value: str) -> None:
        jsii.set(self, "apiId", value)

    @builtins.property
    @jsii.member(jsii_name="domainName")
    def domain_name(self) -> str:
        return jsii.get(self, "domainName")

    @domain_name.setter
    def domain_name(self, value: str) -> None:
        jsii.set(self, "domainName", value)

    @builtins.property
    @jsii.member(jsii_name="basePath")
    def base_path(self) -> typing.Optional[str]:
        return jsii.get(self, "basePath")

    @base_path.setter
    def base_path(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "basePath", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="stageName")
    def stage_name(self) -> typing.Optional[str]:
        return jsii.get(self, "stageName")

    @stage_name.setter
    def stage_name(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "stageName", value)


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.ApiGatewayBasePathMappingConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "api_id": "apiId",
        "domain_name": "domainName",
        "base_path": "basePath",
        "stage_name": "stageName",
    },
)
class ApiGatewayBasePathMappingConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        api_id: str,
        domain_name: str,
        base_path: typing.Optional[str] = None,
        stage_name: typing.Optional[str] = None,
    ) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param api_id: 
        :param domain_name: 
        :param base_path: 
        :param stage_name: 
        """
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        self._values = {
            "api_id": api_id,
            "domain_name": domain_name,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if base_path is not None:
            self._values["base_path"] = base_path
        if stage_name is not None:
            self._values["stage_name"] = stage_name

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("count")

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.TerraformResource]]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("depends_on")

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("lifecycle")

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("provider")

    @builtins.property
    def api_id(self) -> str:
        return self._values.get("api_id")

    @builtins.property
    def domain_name(self) -> str:
        return self._values.get("domain_name")

    @builtins.property
    def base_path(self) -> typing.Optional[str]:
        return self._values.get("base_path")

    @builtins.property
    def stage_name(self) -> typing.Optional[str]:
        return self._values.get("stage_name")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiGatewayBasePathMappingConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class ApiGatewayClientCertificate(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="@skorfmann/cdktf-provider-aws.ApiGatewayClientCertificate",
):
    def __init__(
        self,
        scope: constructs.Construct,
        id: str,
        *,
        description: typing.Optional[str] = None,
        tags: typing.Optional[typing.Mapping[str, str]] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param description: 
        :param tags: 
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = ApiGatewayClientCertificateConfig(
            description=description,
            tags=tags,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(ApiGatewayClientCertificate, self, [scope, id, config])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property
    @jsii.member(jsii_name="arn")
    def arn(self) -> str:
        return jsii.get(self, "arn")

    @builtins.property
    @jsii.member(jsii_name="createdDate")
    def created_date(self) -> str:
        return jsii.get(self, "createdDate")

    @builtins.property
    @jsii.member(jsii_name="expirationDate")
    def expiration_date(self) -> str:
        return jsii.get(self, "expirationDate")

    @builtins.property
    @jsii.member(jsii_name="pemEncodedCertificate")
    def pem_encoded_certificate(self) -> str:
        return jsii.get(self, "pemEncodedCertificate")

    @builtins.property
    @jsii.member(jsii_name="description")
    def description(self) -> typing.Optional[str]:
        return jsii.get(self, "description")

    @description.setter
    def description(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "description", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="tags")
    def tags(self) -> typing.Optional[typing.Mapping[str, str]]:
        return jsii.get(self, "tags")

    @tags.setter
    def tags(self, value: typing.Optional[typing.Mapping[str, str]]) -> None:
        jsii.set(self, "tags", value)


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.ApiGatewayClientCertificateConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "description": "description",
        "tags": "tags",
    },
)
class ApiGatewayClientCertificateConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        description: typing.Optional[str] = None,
        tags: typing.Optional[typing.Mapping[str, str]] = None,
    ) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param description: 
        :param tags: 
        """
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        self._values = {}
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if description is not None:
            self._values["description"] = description
        if tags is not None:
            self._values["tags"] = tags

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("count")

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.TerraformResource]]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("depends_on")

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("lifecycle")

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("provider")

    @builtins.property
    def description(self) -> typing.Optional[str]:
        return self._values.get("description")

    @builtins.property
    def tags(self) -> typing.Optional[typing.Mapping[str, str]]:
        return self._values.get("tags")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiGatewayClientCertificateConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class ApiGatewayDeployment(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="@skorfmann/cdktf-provider-aws.ApiGatewayDeployment",
):
    def __init__(
        self,
        scope: constructs.Construct,
        id: str,
        *,
        rest_api_id: str,
        description: typing.Optional[str] = None,
        stage_description: typing.Optional[str] = None,
        stage_name: typing.Optional[str] = None,
        triggers: typing.Optional[typing.Mapping[str, str]] = None,
        variables: typing.Optional[typing.Mapping[str, str]] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param rest_api_id: 
        :param description: 
        :param stage_description: 
        :param stage_name: 
        :param triggers: 
        :param variables: 
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = ApiGatewayDeploymentConfig(
            rest_api_id=rest_api_id,
            description=description,
            stage_description=stage_description,
            stage_name=stage_name,
            triggers=triggers,
            variables=variables,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(ApiGatewayDeployment, self, [scope, id, config])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property
    @jsii.member(jsii_name="createdDate")
    def created_date(self) -> str:
        return jsii.get(self, "createdDate")

    @builtins.property
    @jsii.member(jsii_name="executionArn")
    def execution_arn(self) -> str:
        return jsii.get(self, "executionArn")

    @builtins.property
    @jsii.member(jsii_name="invokeUrl")
    def invoke_url(self) -> str:
        return jsii.get(self, "invokeUrl")

    @builtins.property
    @jsii.member(jsii_name="restApiId")
    def rest_api_id(self) -> str:
        return jsii.get(self, "restApiId")

    @rest_api_id.setter
    def rest_api_id(self, value: str) -> None:
        jsii.set(self, "restApiId", value)

    @builtins.property
    @jsii.member(jsii_name="description")
    def description(self) -> typing.Optional[str]:
        return jsii.get(self, "description")

    @description.setter
    def description(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "description", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="stageDescription")
    def stage_description(self) -> typing.Optional[str]:
        return jsii.get(self, "stageDescription")

    @stage_description.setter
    def stage_description(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "stageDescription", value)

    @builtins.property
    @jsii.member(jsii_name="stageName")
    def stage_name(self) -> typing.Optional[str]:
        return jsii.get(self, "stageName")

    @stage_name.setter
    def stage_name(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "stageName", value)

    @builtins.property
    @jsii.member(jsii_name="triggers")
    def triggers(self) -> typing.Optional[typing.Mapping[str, str]]:
        return jsii.get(self, "triggers")

    @triggers.setter
    def triggers(self, value: typing.Optional[typing.Mapping[str, str]]) -> None:
        jsii.set(self, "triggers", value)

    @builtins.property
    @jsii.member(jsii_name="variables")
    def variables(self) -> typing.Optional[typing.Mapping[str, str]]:
        return jsii.get(self, "variables")

    @variables.setter
    def variables(self, value: typing.Optional[typing.Mapping[str, str]]) -> None:
        jsii.set(self, "variables", value)


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.ApiGatewayDeploymentConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "rest_api_id": "restApiId",
        "description": "description",
        "stage_description": "stageDescription",
        "stage_name": "stageName",
        "triggers": "triggers",
        "variables": "variables",
    },
)
class ApiGatewayDeploymentConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        rest_api_id: str,
        description: typing.Optional[str] = None,
        stage_description: typing.Optional[str] = None,
        stage_name: typing.Optional[str] = None,
        triggers: typing.Optional[typing.Mapping[str, str]] = None,
        variables: typing.Optional[typing.Mapping[str, str]] = None,
    ) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param rest_api_id: 
        :param description: 
        :param stage_description: 
        :param stage_name: 
        :param triggers: 
        :param variables: 
        """
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        self._values = {
            "rest_api_id": rest_api_id,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if description is not None:
            self._values["description"] = description
        if stage_description is not None:
            self._values["stage_description"] = stage_description
        if stage_name is not None:
            self._values["stage_name"] = stage_name
        if triggers is not None:
            self._values["triggers"] = triggers
        if variables is not None:
            self._values["variables"] = variables

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("count")

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.TerraformResource]]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("depends_on")

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("lifecycle")

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("provider")

    @builtins.property
    def rest_api_id(self) -> str:
        return self._values.get("rest_api_id")

    @builtins.property
    def description(self) -> typing.Optional[str]:
        return self._values.get("description")

    @builtins.property
    def stage_description(self) -> typing.Optional[str]:
        return self._values.get("stage_description")

    @builtins.property
    def stage_name(self) -> typing.Optional[str]:
        return self._values.get("stage_name")

    @builtins.property
    def triggers(self) -> typing.Optional[typing.Mapping[str, str]]:
        return self._values.get("triggers")

    @builtins.property
    def variables(self) -> typing.Optional[typing.Mapping[str, str]]:
        return self._values.get("variables")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiGatewayDeploymentConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class ApiGatewayDocumentationPart(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="@skorfmann/cdktf-provider-aws.ApiGatewayDocumentationPart",
):
    def __init__(
        self,
        scope: constructs.Construct,
        id: str,
        *,
        location: typing.List["ApiGatewayDocumentationPartLocation"],
        properties: str,
        rest_api_id: str,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param location: location block.
        :param properties: 
        :param rest_api_id: 
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = ApiGatewayDocumentationPartConfig(
            location=location,
            properties=properties,
            rest_api_id=rest_api_id,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(ApiGatewayDocumentationPart, self, [scope, id, config])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property
    @jsii.member(jsii_name="location")
    def location(self) -> typing.List["ApiGatewayDocumentationPartLocation"]:
        return jsii.get(self, "location")

    @location.setter
    def location(
        self, value: typing.List["ApiGatewayDocumentationPartLocation"]
    ) -> None:
        jsii.set(self, "location", value)

    @builtins.property
    @jsii.member(jsii_name="properties")
    def properties(self) -> str:
        return jsii.get(self, "properties")

    @properties.setter
    def properties(self, value: str) -> None:
        jsii.set(self, "properties", value)

    @builtins.property
    @jsii.member(jsii_name="restApiId")
    def rest_api_id(self) -> str:
        return jsii.get(self, "restApiId")

    @rest_api_id.setter
    def rest_api_id(self, value: str) -> None:
        jsii.set(self, "restApiId", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.ApiGatewayDocumentationPartConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "location": "location",
        "properties": "properties",
        "rest_api_id": "restApiId",
    },
)
class ApiGatewayDocumentationPartConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        location: typing.List["ApiGatewayDocumentationPartLocation"],
        properties: str,
        rest_api_id: str,
    ) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param location: location block.
        :param properties: 
        :param rest_api_id: 
        """
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        self._values = {
            "location": location,
            "properties": properties,
            "rest_api_id": rest_api_id,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("count")

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.TerraformResource]]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("depends_on")

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("lifecycle")

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("provider")

    @builtins.property
    def location(self) -> typing.List["ApiGatewayDocumentationPartLocation"]:
        """location block."""
        return self._values.get("location")

    @builtins.property
    def properties(self) -> str:
        return self._values.get("properties")

    @builtins.property
    def rest_api_id(self) -> str:
        return self._values.get("rest_api_id")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiGatewayDocumentationPartConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.ApiGatewayDocumentationPartLocation",
    jsii_struct_bases=[],
    name_mapping={
        "type": "type",
        "method": "method",
        "name": "name",
        "path": "path",
        "status_code": "statusCode",
    },
)
class ApiGatewayDocumentationPartLocation:
    def __init__(
        self,
        *,
        type: str,
        method: typing.Optional[str] = None,
        name: typing.Optional[str] = None,
        path: typing.Optional[str] = None,
        status_code: typing.Optional[str] = None,
    ) -> None:
        """
        :param type: 
        :param method: 
        :param name: 
        :param path: 
        :param status_code: 
        """
        self._values = {
            "type": type,
        }
        if method is not None:
            self._values["method"] = method
        if name is not None:
            self._values["name"] = name
        if path is not None:
            self._values["path"] = path
        if status_code is not None:
            self._values["status_code"] = status_code

    @builtins.property
    def type(self) -> str:
        return self._values.get("type")

    @builtins.property
    def method(self) -> typing.Optional[str]:
        return self._values.get("method")

    @builtins.property
    def name(self) -> typing.Optional[str]:
        return self._values.get("name")

    @builtins.property
    def path(self) -> typing.Optional[str]:
        return self._values.get("path")

    @builtins.property
    def status_code(self) -> typing.Optional[str]:
        return self._values.get("status_code")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiGatewayDocumentationPartLocation(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class ApiGatewayDocumentationVersion(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="@skorfmann/cdktf-provider-aws.ApiGatewayDocumentationVersion",
):
    def __init__(
        self,
        scope: constructs.Construct,
        id: str,
        *,
        rest_api_id: str,
        version: str,
        description: typing.Optional[str] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param rest_api_id: 
        :param version: 
        :param description: 
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = ApiGatewayDocumentationVersionConfig(
            rest_api_id=rest_api_id,
            version=version,
            description=description,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(ApiGatewayDocumentationVersion, self, [scope, id, config])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property
    @jsii.member(jsii_name="restApiId")
    def rest_api_id(self) -> str:
        return jsii.get(self, "restApiId")

    @rest_api_id.setter
    def rest_api_id(self, value: str) -> None:
        jsii.set(self, "restApiId", value)

    @builtins.property
    @jsii.member(jsii_name="version")
    def version(self) -> str:
        return jsii.get(self, "version")

    @version.setter
    def version(self, value: str) -> None:
        jsii.set(self, "version", value)

    @builtins.property
    @jsii.member(jsii_name="description")
    def description(self) -> typing.Optional[str]:
        return jsii.get(self, "description")

    @description.setter
    def description(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "description", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.ApiGatewayDocumentationVersionConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "rest_api_id": "restApiId",
        "version": "version",
        "description": "description",
    },
)
class ApiGatewayDocumentationVersionConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        rest_api_id: str,
        version: str,
        description: typing.Optional[str] = None,
    ) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param rest_api_id: 
        :param version: 
        :param description: 
        """
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        self._values = {
            "rest_api_id": rest_api_id,
            "version": version,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if description is not None:
            self._values["description"] = description

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("count")

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.TerraformResource]]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("depends_on")

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("lifecycle")

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("provider")

    @builtins.property
    def rest_api_id(self) -> str:
        return self._values.get("rest_api_id")

    @builtins.property
    def version(self) -> str:
        return self._values.get("version")

    @builtins.property
    def description(self) -> typing.Optional[str]:
        return self._values.get("description")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiGatewayDocumentationVersionConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class ApiGatewayDomainName(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="@skorfmann/cdktf-provider-aws.ApiGatewayDomainName",
):
    def __init__(
        self,
        scope: constructs.Construct,
        id: str,
        *,
        domain_name: str,
        certificate_arn: typing.Optional[str] = None,
        certificate_body: typing.Optional[str] = None,
        certificate_chain: typing.Optional[str] = None,
        certificate_name: typing.Optional[str] = None,
        certificate_private_key: typing.Optional[str] = None,
        endpoint_configuration: typing.Optional[
            typing.List["ApiGatewayDomainNameEndpointConfiguration"]
        ] = None,
        regional_certificate_arn: typing.Optional[str] = None,
        regional_certificate_name: typing.Optional[str] = None,
        security_policy: typing.Optional[str] = None,
        tags: typing.Optional[typing.Mapping[str, str]] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param domain_name: 
        :param certificate_arn: 
        :param certificate_body: 
        :param certificate_chain: 
        :param certificate_name: 
        :param certificate_private_key: 
        :param endpoint_configuration: endpoint_configuration block.
        :param regional_certificate_arn: 
        :param regional_certificate_name: 
        :param security_policy: 
        :param tags: 
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = ApiGatewayDomainNameConfig(
            domain_name=domain_name,
            certificate_arn=certificate_arn,
            certificate_body=certificate_body,
            certificate_chain=certificate_chain,
            certificate_name=certificate_name,
            certificate_private_key=certificate_private_key,
            endpoint_configuration=endpoint_configuration,
            regional_certificate_arn=regional_certificate_arn,
            regional_certificate_name=regional_certificate_name,
            security_policy=security_policy,
            tags=tags,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(ApiGatewayDomainName, self, [scope, id, config])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property
    @jsii.member(jsii_name="arn")
    def arn(self) -> str:
        return jsii.get(self, "arn")

    @builtins.property
    @jsii.member(jsii_name="certificateUploadDate")
    def certificate_upload_date(self) -> str:
        return jsii.get(self, "certificateUploadDate")

    @builtins.property
    @jsii.member(jsii_name="cloudfrontDomainName")
    def cloudfront_domain_name(self) -> str:
        return jsii.get(self, "cloudfrontDomainName")

    @builtins.property
    @jsii.member(jsii_name="cloudfrontZoneId")
    def cloudfront_zone_id(self) -> str:
        return jsii.get(self, "cloudfrontZoneId")

    @builtins.property
    @jsii.member(jsii_name="regionalDomainName")
    def regional_domain_name(self) -> str:
        return jsii.get(self, "regionalDomainName")

    @builtins.property
    @jsii.member(jsii_name="regionalZoneId")
    def regional_zone_id(self) -> str:
        return jsii.get(self, "regionalZoneId")

    @builtins.property
    @jsii.member(jsii_name="domainName")
    def domain_name(self) -> str:
        return jsii.get(self, "domainName")

    @domain_name.setter
    def domain_name(self, value: str) -> None:
        jsii.set(self, "domainName", value)

    @builtins.property
    @jsii.member(jsii_name="certificateArn")
    def certificate_arn(self) -> typing.Optional[str]:
        return jsii.get(self, "certificateArn")

    @certificate_arn.setter
    def certificate_arn(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "certificateArn", value)

    @builtins.property
    @jsii.member(jsii_name="certificateBody")
    def certificate_body(self) -> typing.Optional[str]:
        return jsii.get(self, "certificateBody")

    @certificate_body.setter
    def certificate_body(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "certificateBody", value)

    @builtins.property
    @jsii.member(jsii_name="certificateChain")
    def certificate_chain(self) -> typing.Optional[str]:
        return jsii.get(self, "certificateChain")

    @certificate_chain.setter
    def certificate_chain(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "certificateChain", value)

    @builtins.property
    @jsii.member(jsii_name="certificateName")
    def certificate_name(self) -> typing.Optional[str]:
        return jsii.get(self, "certificateName")

    @certificate_name.setter
    def certificate_name(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "certificateName", value)

    @builtins.property
    @jsii.member(jsii_name="certificatePrivateKey")
    def certificate_private_key(self) -> typing.Optional[str]:
        return jsii.get(self, "certificatePrivateKey")

    @certificate_private_key.setter
    def certificate_private_key(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "certificatePrivateKey", value)

    @builtins.property
    @jsii.member(jsii_name="endpointConfiguration")
    def endpoint_configuration(
        self,
    ) -> typing.Optional[typing.List["ApiGatewayDomainNameEndpointConfiguration"]]:
        return jsii.get(self, "endpointConfiguration")

    @endpoint_configuration.setter
    def endpoint_configuration(
        self,
        value: typing.Optional[
            typing.List["ApiGatewayDomainNameEndpointConfiguration"]
        ],
    ) -> None:
        jsii.set(self, "endpointConfiguration", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="regionalCertificateArn")
    def regional_certificate_arn(self) -> typing.Optional[str]:
        return jsii.get(self, "regionalCertificateArn")

    @regional_certificate_arn.setter
    def regional_certificate_arn(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "regionalCertificateArn", value)

    @builtins.property
    @jsii.member(jsii_name="regionalCertificateName")
    def regional_certificate_name(self) -> typing.Optional[str]:
        return jsii.get(self, "regionalCertificateName")

    @regional_certificate_name.setter
    def regional_certificate_name(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "regionalCertificateName", value)

    @builtins.property
    @jsii.member(jsii_name="securityPolicy")
    def security_policy(self) -> typing.Optional[str]:
        return jsii.get(self, "securityPolicy")

    @security_policy.setter
    def security_policy(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "securityPolicy", value)

    @builtins.property
    @jsii.member(jsii_name="tags")
    def tags(self) -> typing.Optional[typing.Mapping[str, str]]:
        return jsii.get(self, "tags")

    @tags.setter
    def tags(self, value: typing.Optional[typing.Mapping[str, str]]) -> None:
        jsii.set(self, "tags", value)


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.ApiGatewayDomainNameConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "domain_name": "domainName",
        "certificate_arn": "certificateArn",
        "certificate_body": "certificateBody",
        "certificate_chain": "certificateChain",
        "certificate_name": "certificateName",
        "certificate_private_key": "certificatePrivateKey",
        "endpoint_configuration": "endpointConfiguration",
        "regional_certificate_arn": "regionalCertificateArn",
        "regional_certificate_name": "regionalCertificateName",
        "security_policy": "securityPolicy",
        "tags": "tags",
    },
)
class ApiGatewayDomainNameConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        domain_name: str,
        certificate_arn: typing.Optional[str] = None,
        certificate_body: typing.Optional[str] = None,
        certificate_chain: typing.Optional[str] = None,
        certificate_name: typing.Optional[str] = None,
        certificate_private_key: typing.Optional[str] = None,
        endpoint_configuration: typing.Optional[
            typing.List["ApiGatewayDomainNameEndpointConfiguration"]
        ] = None,
        regional_certificate_arn: typing.Optional[str] = None,
        regional_certificate_name: typing.Optional[str] = None,
        security_policy: typing.Optional[str] = None,
        tags: typing.Optional[typing.Mapping[str, str]] = None,
    ) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param domain_name: 
        :param certificate_arn: 
        :param certificate_body: 
        :param certificate_chain: 
        :param certificate_name: 
        :param certificate_private_key: 
        :param endpoint_configuration: endpoint_configuration block.
        :param regional_certificate_arn: 
        :param regional_certificate_name: 
        :param security_policy: 
        :param tags: 
        """
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        self._values = {
            "domain_name": domain_name,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if certificate_arn is not None:
            self._values["certificate_arn"] = certificate_arn
        if certificate_body is not None:
            self._values["certificate_body"] = certificate_body
        if certificate_chain is not None:
            self._values["certificate_chain"] = certificate_chain
        if certificate_name is not None:
            self._values["certificate_name"] = certificate_name
        if certificate_private_key is not None:
            self._values["certificate_private_key"] = certificate_private_key
        if endpoint_configuration is not None:
            self._values["endpoint_configuration"] = endpoint_configuration
        if regional_certificate_arn is not None:
            self._values["regional_certificate_arn"] = regional_certificate_arn
        if regional_certificate_name is not None:
            self._values["regional_certificate_name"] = regional_certificate_name
        if security_policy is not None:
            self._values["security_policy"] = security_policy
        if tags is not None:
            self._values["tags"] = tags

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("count")

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.TerraformResource]]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("depends_on")

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("lifecycle")

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("provider")

    @builtins.property
    def domain_name(self) -> str:
        return self._values.get("domain_name")

    @builtins.property
    def certificate_arn(self) -> typing.Optional[str]:
        return self._values.get("certificate_arn")

    @builtins.property
    def certificate_body(self) -> typing.Optional[str]:
        return self._values.get("certificate_body")

    @builtins.property
    def certificate_chain(self) -> typing.Optional[str]:
        return self._values.get("certificate_chain")

    @builtins.property
    def certificate_name(self) -> typing.Optional[str]:
        return self._values.get("certificate_name")

    @builtins.property
    def certificate_private_key(self) -> typing.Optional[str]:
        return self._values.get("certificate_private_key")

    @builtins.property
    def endpoint_configuration(
        self,
    ) -> typing.Optional[typing.List["ApiGatewayDomainNameEndpointConfiguration"]]:
        """endpoint_configuration block."""
        return self._values.get("endpoint_configuration")

    @builtins.property
    def regional_certificate_arn(self) -> typing.Optional[str]:
        return self._values.get("regional_certificate_arn")

    @builtins.property
    def regional_certificate_name(self) -> typing.Optional[str]:
        return self._values.get("regional_certificate_name")

    @builtins.property
    def security_policy(self) -> typing.Optional[str]:
        return self._values.get("security_policy")

    @builtins.property
    def tags(self) -> typing.Optional[typing.Mapping[str, str]]:
        return self._values.get("tags")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiGatewayDomainNameConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.ApiGatewayDomainNameEndpointConfiguration",
    jsii_struct_bases=[],
    name_mapping={"types": "types"},
)
class ApiGatewayDomainNameEndpointConfiguration:
    def __init__(self, *, types: typing.List[str]) -> None:
        """
        :param types: 
        """
        self._values = {
            "types": types,
        }

    @builtins.property
    def types(self) -> typing.List[str]:
        return self._values.get("types")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiGatewayDomainNameEndpointConfiguration(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class ApiGatewayGatewayResponse(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="@skorfmann/cdktf-provider-aws.ApiGatewayGatewayResponse",
):
    def __init__(
        self,
        scope: constructs.Construct,
        id: str,
        *,
        response_type: str,
        rest_api_id: str,
        response_parameters: typing.Optional[typing.Mapping[str, str]] = None,
        response_templates: typing.Optional[typing.Mapping[str, str]] = None,
        status_code: typing.Optional[str] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param response_type: 
        :param rest_api_id: 
        :param response_parameters: 
        :param response_templates: 
        :param status_code: 
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = ApiGatewayGatewayResponseConfig(
            response_type=response_type,
            rest_api_id=rest_api_id,
            response_parameters=response_parameters,
            response_templates=response_templates,
            status_code=status_code,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(ApiGatewayGatewayResponse, self, [scope, id, config])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property
    @jsii.member(jsii_name="responseType")
    def response_type(self) -> str:
        return jsii.get(self, "responseType")

    @response_type.setter
    def response_type(self, value: str) -> None:
        jsii.set(self, "responseType", value)

    @builtins.property
    @jsii.member(jsii_name="restApiId")
    def rest_api_id(self) -> str:
        return jsii.get(self, "restApiId")

    @rest_api_id.setter
    def rest_api_id(self, value: str) -> None:
        jsii.set(self, "restApiId", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="responseParameters")
    def response_parameters(self) -> typing.Optional[typing.Mapping[str, str]]:
        return jsii.get(self, "responseParameters")

    @response_parameters.setter
    def response_parameters(
        self, value: typing.Optional[typing.Mapping[str, str]]
    ) -> None:
        jsii.set(self, "responseParameters", value)

    @builtins.property
    @jsii.member(jsii_name="responseTemplates")
    def response_templates(self) -> typing.Optional[typing.Mapping[str, str]]:
        return jsii.get(self, "responseTemplates")

    @response_templates.setter
    def response_templates(
        self, value: typing.Optional[typing.Mapping[str, str]]
    ) -> None:
        jsii.set(self, "responseTemplates", value)

    @builtins.property
    @jsii.member(jsii_name="statusCode")
    def status_code(self) -> typing.Optional[str]:
        return jsii.get(self, "statusCode")

    @status_code.setter
    def status_code(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "statusCode", value)


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.ApiGatewayGatewayResponseConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "response_type": "responseType",
        "rest_api_id": "restApiId",
        "response_parameters": "responseParameters",
        "response_templates": "responseTemplates",
        "status_code": "statusCode",
    },
)
class ApiGatewayGatewayResponseConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        response_type: str,
        rest_api_id: str,
        response_parameters: typing.Optional[typing.Mapping[str, str]] = None,
        response_templates: typing.Optional[typing.Mapping[str, str]] = None,
        status_code: typing.Optional[str] = None,
    ) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param response_type: 
        :param rest_api_id: 
        :param response_parameters: 
        :param response_templates: 
        :param status_code: 
        """
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        self._values = {
            "response_type": response_type,
            "rest_api_id": rest_api_id,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if response_parameters is not None:
            self._values["response_parameters"] = response_parameters
        if response_templates is not None:
            self._values["response_templates"] = response_templates
        if status_code is not None:
            self._values["status_code"] = status_code

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("count")

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.TerraformResource]]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("depends_on")

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("lifecycle")

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("provider")

    @builtins.property
    def response_type(self) -> str:
        return self._values.get("response_type")

    @builtins.property
    def rest_api_id(self) -> str:
        return self._values.get("rest_api_id")

    @builtins.property
    def response_parameters(self) -> typing.Optional[typing.Mapping[str, str]]:
        return self._values.get("response_parameters")

    @builtins.property
    def response_templates(self) -> typing.Optional[typing.Mapping[str, str]]:
        return self._values.get("response_templates")

    @builtins.property
    def status_code(self) -> typing.Optional[str]:
        return self._values.get("status_code")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiGatewayGatewayResponseConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class ApiGatewayIntegration(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="@skorfmann/cdktf-provider-aws.ApiGatewayIntegration",
):
    def __init__(
        self,
        scope: constructs.Construct,
        id: str,
        *,
        http_method: str,
        resource_id: str,
        rest_api_id: str,
        type: str,
        cache_key_parameters: typing.Optional[typing.List[str]] = None,
        cache_namespace: typing.Optional[str] = None,
        connection_id: typing.Optional[str] = None,
        connection_type: typing.Optional[str] = None,
        content_handling: typing.Optional[str] = None,
        credentials: typing.Optional[str] = None,
        integration_http_method: typing.Optional[str] = None,
        passthrough_behavior: typing.Optional[str] = None,
        request_parameters: typing.Optional[typing.Mapping[str, str]] = None,
        request_parameters_in_json: typing.Optional[str] = None,
        request_templates: typing.Optional[typing.Mapping[str, str]] = None,
        timeout_milliseconds: typing.Optional[jsii.Number] = None,
        uri: typing.Optional[str] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param http_method: 
        :param resource_id: 
        :param rest_api_id: 
        :param type: 
        :param cache_key_parameters: 
        :param cache_namespace: 
        :param connection_id: 
        :param connection_type: 
        :param content_handling: 
        :param credentials: 
        :param integration_http_method: 
        :param passthrough_behavior: 
        :param request_parameters: 
        :param request_parameters_in_json: 
        :param request_templates: 
        :param timeout_milliseconds: 
        :param uri: 
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = ApiGatewayIntegrationConfig(
            http_method=http_method,
            resource_id=resource_id,
            rest_api_id=rest_api_id,
            type=type,
            cache_key_parameters=cache_key_parameters,
            cache_namespace=cache_namespace,
            connection_id=connection_id,
            connection_type=connection_type,
            content_handling=content_handling,
            credentials=credentials,
            integration_http_method=integration_http_method,
            passthrough_behavior=passthrough_behavior,
            request_parameters=request_parameters,
            request_parameters_in_json=request_parameters_in_json,
            request_templates=request_templates,
            timeout_milliseconds=timeout_milliseconds,
            uri=uri,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(ApiGatewayIntegration, self, [scope, id, config])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property
    @jsii.member(jsii_name="httpMethod")
    def http_method(self) -> str:
        return jsii.get(self, "httpMethod")

    @http_method.setter
    def http_method(self, value: str) -> None:
        jsii.set(self, "httpMethod", value)

    @builtins.property
    @jsii.member(jsii_name="resourceId")
    def resource_id(self) -> str:
        return jsii.get(self, "resourceId")

    @resource_id.setter
    def resource_id(self, value: str) -> None:
        jsii.set(self, "resourceId", value)

    @builtins.property
    @jsii.member(jsii_name="restApiId")
    def rest_api_id(self) -> str:
        return jsii.get(self, "restApiId")

    @rest_api_id.setter
    def rest_api_id(self, value: str) -> None:
        jsii.set(self, "restApiId", value)

    @builtins.property
    @jsii.member(jsii_name="type")
    def type(self) -> str:
        return jsii.get(self, "type")

    @type.setter
    def type(self, value: str) -> None:
        jsii.set(self, "type", value)

    @builtins.property
    @jsii.member(jsii_name="cacheKeyParameters")
    def cache_key_parameters(self) -> typing.Optional[typing.List[str]]:
        return jsii.get(self, "cacheKeyParameters")

    @cache_key_parameters.setter
    def cache_key_parameters(self, value: typing.Optional[typing.List[str]]) -> None:
        jsii.set(self, "cacheKeyParameters", value)

    @builtins.property
    @jsii.member(jsii_name="cacheNamespace")
    def cache_namespace(self) -> typing.Optional[str]:
        return jsii.get(self, "cacheNamespace")

    @cache_namespace.setter
    def cache_namespace(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "cacheNamespace", value)

    @builtins.property
    @jsii.member(jsii_name="connectionId")
    def connection_id(self) -> typing.Optional[str]:
        return jsii.get(self, "connectionId")

    @connection_id.setter
    def connection_id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "connectionId", value)

    @builtins.property
    @jsii.member(jsii_name="connectionType")
    def connection_type(self) -> typing.Optional[str]:
        return jsii.get(self, "connectionType")

    @connection_type.setter
    def connection_type(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "connectionType", value)

    @builtins.property
    @jsii.member(jsii_name="contentHandling")
    def content_handling(self) -> typing.Optional[str]:
        return jsii.get(self, "contentHandling")

    @content_handling.setter
    def content_handling(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "contentHandling", value)

    @builtins.property
    @jsii.member(jsii_name="credentials")
    def credentials(self) -> typing.Optional[str]:
        return jsii.get(self, "credentials")

    @credentials.setter
    def credentials(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "credentials", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="integrationHttpMethod")
    def integration_http_method(self) -> typing.Optional[str]:
        return jsii.get(self, "integrationHttpMethod")

    @integration_http_method.setter
    def integration_http_method(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "integrationHttpMethod", value)

    @builtins.property
    @jsii.member(jsii_name="passthroughBehavior")
    def passthrough_behavior(self) -> typing.Optional[str]:
        return jsii.get(self, "passthroughBehavior")

    @passthrough_behavior.setter
    def passthrough_behavior(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "passthroughBehavior", value)

    @builtins.property
    @jsii.member(jsii_name="requestParameters")
    def request_parameters(self) -> typing.Optional[typing.Mapping[str, str]]:
        return jsii.get(self, "requestParameters")

    @request_parameters.setter
    def request_parameters(
        self, value: typing.Optional[typing.Mapping[str, str]]
    ) -> None:
        jsii.set(self, "requestParameters", value)

    @builtins.property
    @jsii.member(jsii_name="requestParametersInJson")
    def request_parameters_in_json(self) -> typing.Optional[str]:
        return jsii.get(self, "requestParametersInJson")

    @request_parameters_in_json.setter
    def request_parameters_in_json(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "requestParametersInJson", value)

    @builtins.property
    @jsii.member(jsii_name="requestTemplates")
    def request_templates(self) -> typing.Optional[typing.Mapping[str, str]]:
        return jsii.get(self, "requestTemplates")

    @request_templates.setter
    def request_templates(
        self, value: typing.Optional[typing.Mapping[str, str]]
    ) -> None:
        jsii.set(self, "requestTemplates", value)

    @builtins.property
    @jsii.member(jsii_name="timeoutMilliseconds")
    def timeout_milliseconds(self) -> typing.Optional[jsii.Number]:
        return jsii.get(self, "timeoutMilliseconds")

    @timeout_milliseconds.setter
    def timeout_milliseconds(self, value: typing.Optional[jsii.Number]) -> None:
        jsii.set(self, "timeoutMilliseconds", value)

    @builtins.property
    @jsii.member(jsii_name="uri")
    def uri(self) -> typing.Optional[str]:
        return jsii.get(self, "uri")

    @uri.setter
    def uri(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "uri", value)


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.ApiGatewayIntegrationConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "http_method": "httpMethod",
        "resource_id": "resourceId",
        "rest_api_id": "restApiId",
        "type": "type",
        "cache_key_parameters": "cacheKeyParameters",
        "cache_namespace": "cacheNamespace",
        "connection_id": "connectionId",
        "connection_type": "connectionType",
        "content_handling": "contentHandling",
        "credentials": "credentials",
        "integration_http_method": "integrationHttpMethod",
        "passthrough_behavior": "passthroughBehavior",
        "request_parameters": "requestParameters",
        "request_parameters_in_json": "requestParametersInJson",
        "request_templates": "requestTemplates",
        "timeout_milliseconds": "timeoutMilliseconds",
        "uri": "uri",
    },
)
class ApiGatewayIntegrationConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        http_method: str,
        resource_id: str,
        rest_api_id: str,
        type: str,
        cache_key_parameters: typing.Optional[typing.List[str]] = None,
        cache_namespace: typing.Optional[str] = None,
        connection_id: typing.Optional[str] = None,
        connection_type: typing.Optional[str] = None,
        content_handling: typing.Optional[str] = None,
        credentials: typing.Optional[str] = None,
        integration_http_method: typing.Optional[str] = None,
        passthrough_behavior: typing.Optional[str] = None,
        request_parameters: typing.Optional[typing.Mapping[str, str]] = None,
        request_parameters_in_json: typing.Optional[str] = None,
        request_templates: typing.Optional[typing.Mapping[str, str]] = None,
        timeout_milliseconds: typing.Optional[jsii.Number] = None,
        uri: typing.Optional[str] = None,
    ) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param http_method: 
        :param resource_id: 
        :param rest_api_id: 
        :param type: 
        :param cache_key_parameters: 
        :param cache_namespace: 
        :param connection_id: 
        :param connection_type: 
        :param content_handling: 
        :param credentials: 
        :param integration_http_method: 
        :param passthrough_behavior: 
        :param request_parameters: 
        :param request_parameters_in_json: 
        :param request_templates: 
        :param timeout_milliseconds: 
        :param uri: 
        """
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        self._values = {
            "http_method": http_method,
            "resource_id": resource_id,
            "rest_api_id": rest_api_id,
            "type": type,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if cache_key_parameters is not None:
            self._values["cache_key_parameters"] = cache_key_parameters
        if cache_namespace is not None:
            self._values["cache_namespace"] = cache_namespace
        if connection_id is not None:
            self._values["connection_id"] = connection_id
        if connection_type is not None:
            self._values["connection_type"] = connection_type
        if content_handling is not None:
            self._values["content_handling"] = content_handling
        if credentials is not None:
            self._values["credentials"] = credentials
        if integration_http_method is not None:
            self._values["integration_http_method"] = integration_http_method
        if passthrough_behavior is not None:
            self._values["passthrough_behavior"] = passthrough_behavior
        if request_parameters is not None:
            self._values["request_parameters"] = request_parameters
        if request_parameters_in_json is not None:
            self._values["request_parameters_in_json"] = request_parameters_in_json
        if request_templates is not None:
            self._values["request_templates"] = request_templates
        if timeout_milliseconds is not None:
            self._values["timeout_milliseconds"] = timeout_milliseconds
        if uri is not None:
            self._values["uri"] = uri

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("count")

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.TerraformResource]]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("depends_on")

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("lifecycle")

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("provider")

    @builtins.property
    def http_method(self) -> str:
        return self._values.get("http_method")

    @builtins.property
    def resource_id(self) -> str:
        return self._values.get("resource_id")

    @builtins.property
    def rest_api_id(self) -> str:
        return self._values.get("rest_api_id")

    @builtins.property
    def type(self) -> str:
        return self._values.get("type")

    @builtins.property
    def cache_key_parameters(self) -> typing.Optional[typing.List[str]]:
        return self._values.get("cache_key_parameters")

    @builtins.property
    def cache_namespace(self) -> typing.Optional[str]:
        return self._values.get("cache_namespace")

    @builtins.property
    def connection_id(self) -> typing.Optional[str]:
        return self._values.get("connection_id")

    @builtins.property
    def connection_type(self) -> typing.Optional[str]:
        return self._values.get("connection_type")

    @builtins.property
    def content_handling(self) -> typing.Optional[str]:
        return self._values.get("content_handling")

    @builtins.property
    def credentials(self) -> typing.Optional[str]:
        return self._values.get("credentials")

    @builtins.property
    def integration_http_method(self) -> typing.Optional[str]:
        return self._values.get("integration_http_method")

    @builtins.property
    def passthrough_behavior(self) -> typing.Optional[str]:
        return self._values.get("passthrough_behavior")

    @builtins.property
    def request_parameters(self) -> typing.Optional[typing.Mapping[str, str]]:
        return self._values.get("request_parameters")

    @builtins.property
    def request_parameters_in_json(self) -> typing.Optional[str]:
        return self._values.get("request_parameters_in_json")

    @builtins.property
    def request_templates(self) -> typing.Optional[typing.Mapping[str, str]]:
        return self._values.get("request_templates")

    @builtins.property
    def timeout_milliseconds(self) -> typing.Optional[jsii.Number]:
        return self._values.get("timeout_milliseconds")

    @builtins.property
    def uri(self) -> typing.Optional[str]:
        return self._values.get("uri")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiGatewayIntegrationConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class ApiGatewayIntegrationResponse(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="@skorfmann/cdktf-provider-aws.ApiGatewayIntegrationResponse",
):
    def __init__(
        self,
        scope: constructs.Construct,
        id: str,
        *,
        http_method: str,
        resource_id: str,
        rest_api_id: str,
        status_code: str,
        content_handling: typing.Optional[str] = None,
        response_parameters: typing.Optional[typing.Mapping[str, str]] = None,
        response_parameters_in_json: typing.Optional[str] = None,
        response_templates: typing.Optional[typing.Mapping[str, str]] = None,
        selection_pattern: typing.Optional[str] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param http_method: 
        :param resource_id: 
        :param rest_api_id: 
        :param status_code: 
        :param content_handling: 
        :param response_parameters: 
        :param response_parameters_in_json: 
        :param response_templates: 
        :param selection_pattern: 
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = ApiGatewayIntegrationResponseConfig(
            http_method=http_method,
            resource_id=resource_id,
            rest_api_id=rest_api_id,
            status_code=status_code,
            content_handling=content_handling,
            response_parameters=response_parameters,
            response_parameters_in_json=response_parameters_in_json,
            response_templates=response_templates,
            selection_pattern=selection_pattern,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(ApiGatewayIntegrationResponse, self, [scope, id, config])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property
    @jsii.member(jsii_name="httpMethod")
    def http_method(self) -> str:
        return jsii.get(self, "httpMethod")

    @http_method.setter
    def http_method(self, value: str) -> None:
        jsii.set(self, "httpMethod", value)

    @builtins.property
    @jsii.member(jsii_name="resourceId")
    def resource_id(self) -> str:
        return jsii.get(self, "resourceId")

    @resource_id.setter
    def resource_id(self, value: str) -> None:
        jsii.set(self, "resourceId", value)

    @builtins.property
    @jsii.member(jsii_name="restApiId")
    def rest_api_id(self) -> str:
        return jsii.get(self, "restApiId")

    @rest_api_id.setter
    def rest_api_id(self, value: str) -> None:
        jsii.set(self, "restApiId", value)

    @builtins.property
    @jsii.member(jsii_name="statusCode")
    def status_code(self) -> str:
        return jsii.get(self, "statusCode")

    @status_code.setter
    def status_code(self, value: str) -> None:
        jsii.set(self, "statusCode", value)

    @builtins.property
    @jsii.member(jsii_name="contentHandling")
    def content_handling(self) -> typing.Optional[str]:
        return jsii.get(self, "contentHandling")

    @content_handling.setter
    def content_handling(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "contentHandling", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="responseParameters")
    def response_parameters(self) -> typing.Optional[typing.Mapping[str, str]]:
        return jsii.get(self, "responseParameters")

    @response_parameters.setter
    def response_parameters(
        self, value: typing.Optional[typing.Mapping[str, str]]
    ) -> None:
        jsii.set(self, "responseParameters", value)

    @builtins.property
    @jsii.member(jsii_name="responseParametersInJson")
    def response_parameters_in_json(self) -> typing.Optional[str]:
        return jsii.get(self, "responseParametersInJson")

    @response_parameters_in_json.setter
    def response_parameters_in_json(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "responseParametersInJson", value)

    @builtins.property
    @jsii.member(jsii_name="responseTemplates")
    def response_templates(self) -> typing.Optional[typing.Mapping[str, str]]:
        return jsii.get(self, "responseTemplates")

    @response_templates.setter
    def response_templates(
        self, value: typing.Optional[typing.Mapping[str, str]]
    ) -> None:
        jsii.set(self, "responseTemplates", value)

    @builtins.property
    @jsii.member(jsii_name="selectionPattern")
    def selection_pattern(self) -> typing.Optional[str]:
        return jsii.get(self, "selectionPattern")

    @selection_pattern.setter
    def selection_pattern(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "selectionPattern", value)


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.ApiGatewayIntegrationResponseConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "http_method": "httpMethod",
        "resource_id": "resourceId",
        "rest_api_id": "restApiId",
        "status_code": "statusCode",
        "content_handling": "contentHandling",
        "response_parameters": "responseParameters",
        "response_parameters_in_json": "responseParametersInJson",
        "response_templates": "responseTemplates",
        "selection_pattern": "selectionPattern",
    },
)
class ApiGatewayIntegrationResponseConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        http_method: str,
        resource_id: str,
        rest_api_id: str,
        status_code: str,
        content_handling: typing.Optional[str] = None,
        response_parameters: typing.Optional[typing.Mapping[str, str]] = None,
        response_parameters_in_json: typing.Optional[str] = None,
        response_templates: typing.Optional[typing.Mapping[str, str]] = None,
        selection_pattern: typing.Optional[str] = None,
    ) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param http_method: 
        :param resource_id: 
        :param rest_api_id: 
        :param status_code: 
        :param content_handling: 
        :param response_parameters: 
        :param response_parameters_in_json: 
        :param response_templates: 
        :param selection_pattern: 
        """
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        self._values = {
            "http_method": http_method,
            "resource_id": resource_id,
            "rest_api_id": rest_api_id,
            "status_code": status_code,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if content_handling is not None:
            self._values["content_handling"] = content_handling
        if response_parameters is not None:
            self._values["response_parameters"] = response_parameters
        if response_parameters_in_json is not None:
            self._values["response_parameters_in_json"] = response_parameters_in_json
        if response_templates is not None:
            self._values["response_templates"] = response_templates
        if selection_pattern is not None:
            self._values["selection_pattern"] = selection_pattern

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("count")

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.TerraformResource]]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("depends_on")

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("lifecycle")

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("provider")

    @builtins.property
    def http_method(self) -> str:
        return self._values.get("http_method")

    @builtins.property
    def resource_id(self) -> str:
        return self._values.get("resource_id")

    @builtins.property
    def rest_api_id(self) -> str:
        return self._values.get("rest_api_id")

    @builtins.property
    def status_code(self) -> str:
        return self._values.get("status_code")

    @builtins.property
    def content_handling(self) -> typing.Optional[str]:
        return self._values.get("content_handling")

    @builtins.property
    def response_parameters(self) -> typing.Optional[typing.Mapping[str, str]]:
        return self._values.get("response_parameters")

    @builtins.property
    def response_parameters_in_json(self) -> typing.Optional[str]:
        return self._values.get("response_parameters_in_json")

    @builtins.property
    def response_templates(self) -> typing.Optional[typing.Mapping[str, str]]:
        return self._values.get("response_templates")

    @builtins.property
    def selection_pattern(self) -> typing.Optional[str]:
        return self._values.get("selection_pattern")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiGatewayIntegrationResponseConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class ApiGatewayMethod(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="@skorfmann/cdktf-provider-aws.ApiGatewayMethod",
):
    def __init__(
        self,
        scope: constructs.Construct,
        id: str,
        *,
        authorization: str,
        http_method: str,
        resource_id: str,
        rest_api_id: str,
        api_key_required: typing.Optional[bool] = None,
        authorization_scopes: typing.Optional[typing.List[str]] = None,
        authorizer_id: typing.Optional[str] = None,
        request_models: typing.Optional[typing.Mapping[str, str]] = None,
        request_parameters: typing.Optional[typing.Mapping[str, bool]] = None,
        request_parameters_in_json: typing.Optional[str] = None,
        request_validator_id: typing.Optional[str] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param authorization: 
        :param http_method: 
        :param resource_id: 
        :param rest_api_id: 
        :param api_key_required: 
        :param authorization_scopes: 
        :param authorizer_id: 
        :param request_models: 
        :param request_parameters: 
        :param request_parameters_in_json: 
        :param request_validator_id: 
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = ApiGatewayMethodConfig(
            authorization=authorization,
            http_method=http_method,
            resource_id=resource_id,
            rest_api_id=rest_api_id,
            api_key_required=api_key_required,
            authorization_scopes=authorization_scopes,
            authorizer_id=authorizer_id,
            request_models=request_models,
            request_parameters=request_parameters,
            request_parameters_in_json=request_parameters_in_json,
            request_validator_id=request_validator_id,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(ApiGatewayMethod, self, [scope, id, config])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property
    @jsii.member(jsii_name="authorization")
    def authorization(self) -> str:
        return jsii.get(self, "authorization")

    @authorization.setter
    def authorization(self, value: str) -> None:
        jsii.set(self, "authorization", value)

    @builtins.property
    @jsii.member(jsii_name="httpMethod")
    def http_method(self) -> str:
        return jsii.get(self, "httpMethod")

    @http_method.setter
    def http_method(self, value: str) -> None:
        jsii.set(self, "httpMethod", value)

    @builtins.property
    @jsii.member(jsii_name="resourceId")
    def resource_id(self) -> str:
        return jsii.get(self, "resourceId")

    @resource_id.setter
    def resource_id(self, value: str) -> None:
        jsii.set(self, "resourceId", value)

    @builtins.property
    @jsii.member(jsii_name="restApiId")
    def rest_api_id(self) -> str:
        return jsii.get(self, "restApiId")

    @rest_api_id.setter
    def rest_api_id(self, value: str) -> None:
        jsii.set(self, "restApiId", value)

    @builtins.property
    @jsii.member(jsii_name="apiKeyRequired")
    def api_key_required(self) -> typing.Optional[bool]:
        return jsii.get(self, "apiKeyRequired")

    @api_key_required.setter
    def api_key_required(self, value: typing.Optional[bool]) -> None:
        jsii.set(self, "apiKeyRequired", value)

    @builtins.property
    @jsii.member(jsii_name="authorizationScopes")
    def authorization_scopes(self) -> typing.Optional[typing.List[str]]:
        return jsii.get(self, "authorizationScopes")

    @authorization_scopes.setter
    def authorization_scopes(self, value: typing.Optional[typing.List[str]]) -> None:
        jsii.set(self, "authorizationScopes", value)

    @builtins.property
    @jsii.member(jsii_name="authorizerId")
    def authorizer_id(self) -> typing.Optional[str]:
        return jsii.get(self, "authorizerId")

    @authorizer_id.setter
    def authorizer_id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "authorizerId", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="requestModels")
    def request_models(self) -> typing.Optional[typing.Mapping[str, str]]:
        return jsii.get(self, "requestModels")

    @request_models.setter
    def request_models(self, value: typing.Optional[typing.Mapping[str, str]]) -> None:
        jsii.set(self, "requestModels", value)

    @builtins.property
    @jsii.member(jsii_name="requestParameters")
    def request_parameters(self) -> typing.Optional[typing.Mapping[str, bool]]:
        return jsii.get(self, "requestParameters")

    @request_parameters.setter
    def request_parameters(
        self, value: typing.Optional[typing.Mapping[str, bool]]
    ) -> None:
        jsii.set(self, "requestParameters", value)

    @builtins.property
    @jsii.member(jsii_name="requestParametersInJson")
    def request_parameters_in_json(self) -> typing.Optional[str]:
        return jsii.get(self, "requestParametersInJson")

    @request_parameters_in_json.setter
    def request_parameters_in_json(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "requestParametersInJson", value)

    @builtins.property
    @jsii.member(jsii_name="requestValidatorId")
    def request_validator_id(self) -> typing.Optional[str]:
        return jsii.get(self, "requestValidatorId")

    @request_validator_id.setter
    def request_validator_id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "requestValidatorId", value)


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.ApiGatewayMethodConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "authorization": "authorization",
        "http_method": "httpMethod",
        "resource_id": "resourceId",
        "rest_api_id": "restApiId",
        "api_key_required": "apiKeyRequired",
        "authorization_scopes": "authorizationScopes",
        "authorizer_id": "authorizerId",
        "request_models": "requestModels",
        "request_parameters": "requestParameters",
        "request_parameters_in_json": "requestParametersInJson",
        "request_validator_id": "requestValidatorId",
    },
)
class ApiGatewayMethodConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        authorization: str,
        http_method: str,
        resource_id: str,
        rest_api_id: str,
        api_key_required: typing.Optional[bool] = None,
        authorization_scopes: typing.Optional[typing.List[str]] = None,
        authorizer_id: typing.Optional[str] = None,
        request_models: typing.Optional[typing.Mapping[str, str]] = None,
        request_parameters: typing.Optional[typing.Mapping[str, bool]] = None,
        request_parameters_in_json: typing.Optional[str] = None,
        request_validator_id: typing.Optional[str] = None,
    ) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param authorization: 
        :param http_method: 
        :param resource_id: 
        :param rest_api_id: 
        :param api_key_required: 
        :param authorization_scopes: 
        :param authorizer_id: 
        :param request_models: 
        :param request_parameters: 
        :param request_parameters_in_json: 
        :param request_validator_id: 
        """
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        self._values = {
            "authorization": authorization,
            "http_method": http_method,
            "resource_id": resource_id,
            "rest_api_id": rest_api_id,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if api_key_required is not None:
            self._values["api_key_required"] = api_key_required
        if authorization_scopes is not None:
            self._values["authorization_scopes"] = authorization_scopes
        if authorizer_id is not None:
            self._values["authorizer_id"] = authorizer_id
        if request_models is not None:
            self._values["request_models"] = request_models
        if request_parameters is not None:
            self._values["request_parameters"] = request_parameters
        if request_parameters_in_json is not None:
            self._values["request_parameters_in_json"] = request_parameters_in_json
        if request_validator_id is not None:
            self._values["request_validator_id"] = request_validator_id

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("count")

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.TerraformResource]]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("depends_on")

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("lifecycle")

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("provider")

    @builtins.property
    def authorization(self) -> str:
        return self._values.get("authorization")

    @builtins.property
    def http_method(self) -> str:
        return self._values.get("http_method")

    @builtins.property
    def resource_id(self) -> str:
        return self._values.get("resource_id")

    @builtins.property
    def rest_api_id(self) -> str:
        return self._values.get("rest_api_id")

    @builtins.property
    def api_key_required(self) -> typing.Optional[bool]:
        return self._values.get("api_key_required")

    @builtins.property
    def authorization_scopes(self) -> typing.Optional[typing.List[str]]:
        return self._values.get("authorization_scopes")

    @builtins.property
    def authorizer_id(self) -> typing.Optional[str]:
        return self._values.get("authorizer_id")

    @builtins.property
    def request_models(self) -> typing.Optional[typing.Mapping[str, str]]:
        return self._values.get("request_models")

    @builtins.property
    def request_parameters(self) -> typing.Optional[typing.Mapping[str, bool]]:
        return self._values.get("request_parameters")

    @builtins.property
    def request_parameters_in_json(self) -> typing.Optional[str]:
        return self._values.get("request_parameters_in_json")

    @builtins.property
    def request_validator_id(self) -> typing.Optional[str]:
        return self._values.get("request_validator_id")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiGatewayMethodConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class ApiGatewayMethodResponse(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="@skorfmann/cdktf-provider-aws.ApiGatewayMethodResponse",
):
    def __init__(
        self,
        scope: constructs.Construct,
        id: str,
        *,
        http_method: str,
        resource_id: str,
        rest_api_id: str,
        status_code: str,
        response_models: typing.Optional[typing.Mapping[str, str]] = None,
        response_parameters: typing.Optional[typing.Mapping[str, bool]] = None,
        response_parameters_in_json: typing.Optional[str] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param http_method: 
        :param resource_id: 
        :param rest_api_id: 
        :param status_code: 
        :param response_models: 
        :param response_parameters: 
        :param response_parameters_in_json: 
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = ApiGatewayMethodResponseConfig(
            http_method=http_method,
            resource_id=resource_id,
            rest_api_id=rest_api_id,
            status_code=status_code,
            response_models=response_models,
            response_parameters=response_parameters,
            response_parameters_in_json=response_parameters_in_json,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(ApiGatewayMethodResponse, self, [scope, id, config])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property
    @jsii.member(jsii_name="httpMethod")
    def http_method(self) -> str:
        return jsii.get(self, "httpMethod")

    @http_method.setter
    def http_method(self, value: str) -> None:
        jsii.set(self, "httpMethod", value)

    @builtins.property
    @jsii.member(jsii_name="resourceId")
    def resource_id(self) -> str:
        return jsii.get(self, "resourceId")

    @resource_id.setter
    def resource_id(self, value: str) -> None:
        jsii.set(self, "resourceId", value)

    @builtins.property
    @jsii.member(jsii_name="restApiId")
    def rest_api_id(self) -> str:
        return jsii.get(self, "restApiId")

    @rest_api_id.setter
    def rest_api_id(self, value: str) -> None:
        jsii.set(self, "restApiId", value)

    @builtins.property
    @jsii.member(jsii_name="statusCode")
    def status_code(self) -> str:
        return jsii.get(self, "statusCode")

    @status_code.setter
    def status_code(self, value: str) -> None:
        jsii.set(self, "statusCode", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="responseModels")
    def response_models(self) -> typing.Optional[typing.Mapping[str, str]]:
        return jsii.get(self, "responseModels")

    @response_models.setter
    def response_models(self, value: typing.Optional[typing.Mapping[str, str]]) -> None:
        jsii.set(self, "responseModels", value)

    @builtins.property
    @jsii.member(jsii_name="responseParameters")
    def response_parameters(self) -> typing.Optional[typing.Mapping[str, bool]]:
        return jsii.get(self, "responseParameters")

    @response_parameters.setter
    def response_parameters(
        self, value: typing.Optional[typing.Mapping[str, bool]]
    ) -> None:
        jsii.set(self, "responseParameters", value)

    @builtins.property
    @jsii.member(jsii_name="responseParametersInJson")
    def response_parameters_in_json(self) -> typing.Optional[str]:
        return jsii.get(self, "responseParametersInJson")

    @response_parameters_in_json.setter
    def response_parameters_in_json(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "responseParametersInJson", value)


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.ApiGatewayMethodResponseConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "http_method": "httpMethod",
        "resource_id": "resourceId",
        "rest_api_id": "restApiId",
        "status_code": "statusCode",
        "response_models": "responseModels",
        "response_parameters": "responseParameters",
        "response_parameters_in_json": "responseParametersInJson",
    },
)
class ApiGatewayMethodResponseConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        http_method: str,
        resource_id: str,
        rest_api_id: str,
        status_code: str,
        response_models: typing.Optional[typing.Mapping[str, str]] = None,
        response_parameters: typing.Optional[typing.Mapping[str, bool]] = None,
        response_parameters_in_json: typing.Optional[str] = None,
    ) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param http_method: 
        :param resource_id: 
        :param rest_api_id: 
        :param status_code: 
        :param response_models: 
        :param response_parameters: 
        :param response_parameters_in_json: 
        """
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        self._values = {
            "http_method": http_method,
            "resource_id": resource_id,
            "rest_api_id": rest_api_id,
            "status_code": status_code,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if response_models is not None:
            self._values["response_models"] = response_models
        if response_parameters is not None:
            self._values["response_parameters"] = response_parameters
        if response_parameters_in_json is not None:
            self._values["response_parameters_in_json"] = response_parameters_in_json

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("count")

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.TerraformResource]]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("depends_on")

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("lifecycle")

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("provider")

    @builtins.property
    def http_method(self) -> str:
        return self._values.get("http_method")

    @builtins.property
    def resource_id(self) -> str:
        return self._values.get("resource_id")

    @builtins.property
    def rest_api_id(self) -> str:
        return self._values.get("rest_api_id")

    @builtins.property
    def status_code(self) -> str:
        return self._values.get("status_code")

    @builtins.property
    def response_models(self) -> typing.Optional[typing.Mapping[str, str]]:
        return self._values.get("response_models")

    @builtins.property
    def response_parameters(self) -> typing.Optional[typing.Mapping[str, bool]]:
        return self._values.get("response_parameters")

    @builtins.property
    def response_parameters_in_json(self) -> typing.Optional[str]:
        return self._values.get("response_parameters_in_json")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiGatewayMethodResponseConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class ApiGatewayMethodSettings(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="@skorfmann/cdktf-provider-aws.ApiGatewayMethodSettings",
):
    def __init__(
        self,
        scope: constructs.Construct,
        id: str,
        *,
        method_path: str,
        rest_api_id: str,
        settings: typing.List["ApiGatewayMethodSettingsSettings"],
        stage_name: str,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param method_path: 
        :param rest_api_id: 
        :param settings: settings block.
        :param stage_name: 
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = ApiGatewayMethodSettingsConfig(
            method_path=method_path,
            rest_api_id=rest_api_id,
            settings=settings,
            stage_name=stage_name,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(ApiGatewayMethodSettings, self, [scope, id, config])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property
    @jsii.member(jsii_name="methodPath")
    def method_path(self) -> str:
        return jsii.get(self, "methodPath")

    @method_path.setter
    def method_path(self, value: str) -> None:
        jsii.set(self, "methodPath", value)

    @builtins.property
    @jsii.member(jsii_name="restApiId")
    def rest_api_id(self) -> str:
        return jsii.get(self, "restApiId")

    @rest_api_id.setter
    def rest_api_id(self, value: str) -> None:
        jsii.set(self, "restApiId", value)

    @builtins.property
    @jsii.member(jsii_name="settings")
    def settings(self) -> typing.List["ApiGatewayMethodSettingsSettings"]:
        return jsii.get(self, "settings")

    @settings.setter
    def settings(self, value: typing.List["ApiGatewayMethodSettingsSettings"]) -> None:
        jsii.set(self, "settings", value)

    @builtins.property
    @jsii.member(jsii_name="stageName")
    def stage_name(self) -> str:
        return jsii.get(self, "stageName")

    @stage_name.setter
    def stage_name(self, value: str) -> None:
        jsii.set(self, "stageName", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.ApiGatewayMethodSettingsConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "method_path": "methodPath",
        "rest_api_id": "restApiId",
        "settings": "settings",
        "stage_name": "stageName",
    },
)
class ApiGatewayMethodSettingsConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        method_path: str,
        rest_api_id: str,
        settings: typing.List["ApiGatewayMethodSettingsSettings"],
        stage_name: str,
    ) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param method_path: 
        :param rest_api_id: 
        :param settings: settings block.
        :param stage_name: 
        """
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        self._values = {
            "method_path": method_path,
            "rest_api_id": rest_api_id,
            "settings": settings,
            "stage_name": stage_name,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("count")

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.TerraformResource]]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("depends_on")

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("lifecycle")

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("provider")

    @builtins.property
    def method_path(self) -> str:
        return self._values.get("method_path")

    @builtins.property
    def rest_api_id(self) -> str:
        return self._values.get("rest_api_id")

    @builtins.property
    def settings(self) -> typing.List["ApiGatewayMethodSettingsSettings"]:
        """settings block."""
        return self._values.get("settings")

    @builtins.property
    def stage_name(self) -> str:
        return self._values.get("stage_name")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiGatewayMethodSettingsConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.ApiGatewayMethodSettingsSettings",
    jsii_struct_bases=[],
    name_mapping={
        "cache_data_encrypted": "cacheDataEncrypted",
        "cache_ttl_in_seconds": "cacheTtlInSeconds",
        "caching_enabled": "cachingEnabled",
        "data_trace_enabled": "dataTraceEnabled",
        "logging_level": "loggingLevel",
        "metrics_enabled": "metricsEnabled",
        "require_authorization_for_cache_control": "requireAuthorizationForCacheControl",
        "throttling_burst_limit": "throttlingBurstLimit",
        "throttling_rate_limit": "throttlingRateLimit",
        "unauthorized_cache_control_header_strategy": "unauthorizedCacheControlHeaderStrategy",
    },
)
class ApiGatewayMethodSettingsSettings:
    def __init__(
        self,
        *,
        cache_data_encrypted: typing.Optional[bool] = None,
        cache_ttl_in_seconds: typing.Optional[jsii.Number] = None,
        caching_enabled: typing.Optional[bool] = None,
        data_trace_enabled: typing.Optional[bool] = None,
        logging_level: typing.Optional[str] = None,
        metrics_enabled: typing.Optional[bool] = None,
        require_authorization_for_cache_control: typing.Optional[bool] = None,
        throttling_burst_limit: typing.Optional[jsii.Number] = None,
        throttling_rate_limit: typing.Optional[jsii.Number] = None,
        unauthorized_cache_control_header_strategy: typing.Optional[str] = None,
    ) -> None:
        """
        :param cache_data_encrypted: 
        :param cache_ttl_in_seconds: 
        :param caching_enabled: 
        :param data_trace_enabled: 
        :param logging_level: 
        :param metrics_enabled: 
        :param require_authorization_for_cache_control: 
        :param throttling_burst_limit: 
        :param throttling_rate_limit: 
        :param unauthorized_cache_control_header_strategy: 
        """
        self._values = {}
        if cache_data_encrypted is not None:
            self._values["cache_data_encrypted"] = cache_data_encrypted
        if cache_ttl_in_seconds is not None:
            self._values["cache_ttl_in_seconds"] = cache_ttl_in_seconds
        if caching_enabled is not None:
            self._values["caching_enabled"] = caching_enabled
        if data_trace_enabled is not None:
            self._values["data_trace_enabled"] = data_trace_enabled
        if logging_level is not None:
            self._values["logging_level"] = logging_level
        if metrics_enabled is not None:
            self._values["metrics_enabled"] = metrics_enabled
        if require_authorization_for_cache_control is not None:
            self._values[
                "require_authorization_for_cache_control"
            ] = require_authorization_for_cache_control
        if throttling_burst_limit is not None:
            self._values["throttling_burst_limit"] = throttling_burst_limit
        if throttling_rate_limit is not None:
            self._values["throttling_rate_limit"] = throttling_rate_limit
        if unauthorized_cache_control_header_strategy is not None:
            self._values[
                "unauthorized_cache_control_header_strategy"
            ] = unauthorized_cache_control_header_strategy

    @builtins.property
    def cache_data_encrypted(self) -> typing.Optional[bool]:
        return self._values.get("cache_data_encrypted")

    @builtins.property
    def cache_ttl_in_seconds(self) -> typing.Optional[jsii.Number]:
        return self._values.get("cache_ttl_in_seconds")

    @builtins.property
    def caching_enabled(self) -> typing.Optional[bool]:
        return self._values.get("caching_enabled")

    @builtins.property
    def data_trace_enabled(self) -> typing.Optional[bool]:
        return self._values.get("data_trace_enabled")

    @builtins.property
    def logging_level(self) -> typing.Optional[str]:
        return self._values.get("logging_level")

    @builtins.property
    def metrics_enabled(self) -> typing.Optional[bool]:
        return self._values.get("metrics_enabled")

    @builtins.property
    def require_authorization_for_cache_control(self) -> typing.Optional[bool]:
        return self._values.get("require_authorization_for_cache_control")

    @builtins.property
    def throttling_burst_limit(self) -> typing.Optional[jsii.Number]:
        return self._values.get("throttling_burst_limit")

    @builtins.property
    def throttling_rate_limit(self) -> typing.Optional[jsii.Number]:
        return self._values.get("throttling_rate_limit")

    @builtins.property
    def unauthorized_cache_control_header_strategy(self) -> typing.Optional[str]:
        return self._values.get("unauthorized_cache_control_header_strategy")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiGatewayMethodSettingsSettings(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class ApiGatewayModel(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="@skorfmann/cdktf-provider-aws.ApiGatewayModel",
):
    def __init__(
        self,
        scope: constructs.Construct,
        id: str,
        *,
        content_type: str,
        name: str,
        rest_api_id: str,
        description: typing.Optional[str] = None,
        schema: typing.Optional[str] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param content_type: 
        :param name: 
        :param rest_api_id: 
        :param description: 
        :param schema: 
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = ApiGatewayModelConfig(
            content_type=content_type,
            name=name,
            rest_api_id=rest_api_id,
            description=description,
            schema=schema,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(ApiGatewayModel, self, [scope, id, config])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property
    @jsii.member(jsii_name="contentType")
    def content_type(self) -> str:
        return jsii.get(self, "contentType")

    @content_type.setter
    def content_type(self, value: str) -> None:
        jsii.set(self, "contentType", value)

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> str:
        return jsii.get(self, "name")

    @name.setter
    def name(self, value: str) -> None:
        jsii.set(self, "name", value)

    @builtins.property
    @jsii.member(jsii_name="restApiId")
    def rest_api_id(self) -> str:
        return jsii.get(self, "restApiId")

    @rest_api_id.setter
    def rest_api_id(self, value: str) -> None:
        jsii.set(self, "restApiId", value)

    @builtins.property
    @jsii.member(jsii_name="description")
    def description(self) -> typing.Optional[str]:
        return jsii.get(self, "description")

    @description.setter
    def description(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "description", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="schema")
    def schema(self) -> typing.Optional[str]:
        return jsii.get(self, "schema")

    @schema.setter
    def schema(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "schema", value)


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.ApiGatewayModelConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "content_type": "contentType",
        "name": "name",
        "rest_api_id": "restApiId",
        "description": "description",
        "schema": "schema",
    },
)
class ApiGatewayModelConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        content_type: str,
        name: str,
        rest_api_id: str,
        description: typing.Optional[str] = None,
        schema: typing.Optional[str] = None,
    ) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param content_type: 
        :param name: 
        :param rest_api_id: 
        :param description: 
        :param schema: 
        """
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        self._values = {
            "content_type": content_type,
            "name": name,
            "rest_api_id": rest_api_id,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if description is not None:
            self._values["description"] = description
        if schema is not None:
            self._values["schema"] = schema

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("count")

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.TerraformResource]]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("depends_on")

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("lifecycle")

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("provider")

    @builtins.property
    def content_type(self) -> str:
        return self._values.get("content_type")

    @builtins.property
    def name(self) -> str:
        return self._values.get("name")

    @builtins.property
    def rest_api_id(self) -> str:
        return self._values.get("rest_api_id")

    @builtins.property
    def description(self) -> typing.Optional[str]:
        return self._values.get("description")

    @builtins.property
    def schema(self) -> typing.Optional[str]:
        return self._values.get("schema")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiGatewayModelConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class ApiGatewayRequestValidator(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="@skorfmann/cdktf-provider-aws.ApiGatewayRequestValidator",
):
    def __init__(
        self,
        scope: constructs.Construct,
        id: str,
        *,
        name: str,
        rest_api_id: str,
        validate_request_body: typing.Optional[bool] = None,
        validate_request_parameters: typing.Optional[bool] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param name: 
        :param rest_api_id: 
        :param validate_request_body: 
        :param validate_request_parameters: 
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = ApiGatewayRequestValidatorConfig(
            name=name,
            rest_api_id=rest_api_id,
            validate_request_body=validate_request_body,
            validate_request_parameters=validate_request_parameters,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(ApiGatewayRequestValidator, self, [scope, id, config])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> str:
        return jsii.get(self, "name")

    @name.setter
    def name(self, value: str) -> None:
        jsii.set(self, "name", value)

    @builtins.property
    @jsii.member(jsii_name="restApiId")
    def rest_api_id(self) -> str:
        return jsii.get(self, "restApiId")

    @rest_api_id.setter
    def rest_api_id(self, value: str) -> None:
        jsii.set(self, "restApiId", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="validateRequestBody")
    def validate_request_body(self) -> typing.Optional[bool]:
        return jsii.get(self, "validateRequestBody")

    @validate_request_body.setter
    def validate_request_body(self, value: typing.Optional[bool]) -> None:
        jsii.set(self, "validateRequestBody", value)

    @builtins.property
    @jsii.member(jsii_name="validateRequestParameters")
    def validate_request_parameters(self) -> typing.Optional[bool]:
        return jsii.get(self, "validateRequestParameters")

    @validate_request_parameters.setter
    def validate_request_parameters(self, value: typing.Optional[bool]) -> None:
        jsii.set(self, "validateRequestParameters", value)


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.ApiGatewayRequestValidatorConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "name": "name",
        "rest_api_id": "restApiId",
        "validate_request_body": "validateRequestBody",
        "validate_request_parameters": "validateRequestParameters",
    },
)
class ApiGatewayRequestValidatorConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        name: str,
        rest_api_id: str,
        validate_request_body: typing.Optional[bool] = None,
        validate_request_parameters: typing.Optional[bool] = None,
    ) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param name: 
        :param rest_api_id: 
        :param validate_request_body: 
        :param validate_request_parameters: 
        """
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        self._values = {
            "name": name,
            "rest_api_id": rest_api_id,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if validate_request_body is not None:
            self._values["validate_request_body"] = validate_request_body
        if validate_request_parameters is not None:
            self._values["validate_request_parameters"] = validate_request_parameters

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("count")

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.TerraformResource]]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("depends_on")

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("lifecycle")

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("provider")

    @builtins.property
    def name(self) -> str:
        return self._values.get("name")

    @builtins.property
    def rest_api_id(self) -> str:
        return self._values.get("rest_api_id")

    @builtins.property
    def validate_request_body(self) -> typing.Optional[bool]:
        return self._values.get("validate_request_body")

    @builtins.property
    def validate_request_parameters(self) -> typing.Optional[bool]:
        return self._values.get("validate_request_parameters")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiGatewayRequestValidatorConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class ApiGatewayResource(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="@skorfmann/cdktf-provider-aws.ApiGatewayResource",
):
    def __init__(
        self,
        scope: constructs.Construct,
        id: str,
        *,
        parent_id: str,
        path_part: str,
        rest_api_id: str,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param parent_id: 
        :param path_part: 
        :param rest_api_id: 
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = ApiGatewayResourceConfig(
            parent_id=parent_id,
            path_part=path_part,
            rest_api_id=rest_api_id,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(ApiGatewayResource, self, [scope, id, config])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property
    @jsii.member(jsii_name="path")
    def path(self) -> str:
        return jsii.get(self, "path")

    @builtins.property
    @jsii.member(jsii_name="parentId")
    def parent_id(self) -> str:
        return jsii.get(self, "parentId")

    @parent_id.setter
    def parent_id(self, value: str) -> None:
        jsii.set(self, "parentId", value)

    @builtins.property
    @jsii.member(jsii_name="pathPart")
    def path_part(self) -> str:
        return jsii.get(self, "pathPart")

    @path_part.setter
    def path_part(self, value: str) -> None:
        jsii.set(self, "pathPart", value)

    @builtins.property
    @jsii.member(jsii_name="restApiId")
    def rest_api_id(self) -> str:
        return jsii.get(self, "restApiId")

    @rest_api_id.setter
    def rest_api_id(self, value: str) -> None:
        jsii.set(self, "restApiId", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.ApiGatewayResourceConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "parent_id": "parentId",
        "path_part": "pathPart",
        "rest_api_id": "restApiId",
    },
)
class ApiGatewayResourceConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        parent_id: str,
        path_part: str,
        rest_api_id: str,
    ) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param parent_id: 
        :param path_part: 
        :param rest_api_id: 
        """
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        self._values = {
            "parent_id": parent_id,
            "path_part": path_part,
            "rest_api_id": rest_api_id,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("count")

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.TerraformResource]]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("depends_on")

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("lifecycle")

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("provider")

    @builtins.property
    def parent_id(self) -> str:
        return self._values.get("parent_id")

    @builtins.property
    def path_part(self) -> str:
        return self._values.get("path_part")

    @builtins.property
    def rest_api_id(self) -> str:
        return self._values.get("rest_api_id")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiGatewayResourceConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class ApiGatewayRestApi(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="@skorfmann/cdktf-provider-aws.ApiGatewayRestApi",
):
    def __init__(
        self,
        scope: constructs.Construct,
        id: str,
        *,
        name: str,
        api_key_source: typing.Optional[str] = None,
        binary_media_types: typing.Optional[typing.List[str]] = None,
        body: typing.Optional[str] = None,
        description: typing.Optional[str] = None,
        endpoint_configuration: typing.Optional[
            typing.List["ApiGatewayRestApiEndpointConfiguration"]
        ] = None,
        minimum_compression_size: typing.Optional[jsii.Number] = None,
        policy: typing.Optional[str] = None,
        tags: typing.Optional[typing.Mapping[str, str]] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param name: 
        :param api_key_source: 
        :param binary_media_types: 
        :param body: 
        :param description: 
        :param endpoint_configuration: endpoint_configuration block.
        :param minimum_compression_size: 
        :param policy: 
        :param tags: 
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = ApiGatewayRestApiConfig(
            name=name,
            api_key_source=api_key_source,
            binary_media_types=binary_media_types,
            body=body,
            description=description,
            endpoint_configuration=endpoint_configuration,
            minimum_compression_size=minimum_compression_size,
            policy=policy,
            tags=tags,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(ApiGatewayRestApi, self, [scope, id, config])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property
    @jsii.member(jsii_name="arn")
    def arn(self) -> str:
        return jsii.get(self, "arn")

    @builtins.property
    @jsii.member(jsii_name="createdDate")
    def created_date(self) -> str:
        return jsii.get(self, "createdDate")

    @builtins.property
    @jsii.member(jsii_name="executionArn")
    def execution_arn(self) -> str:
        return jsii.get(self, "executionArn")

    @builtins.property
    @jsii.member(jsii_name="rootResourceId")
    def root_resource_id(self) -> str:
        return jsii.get(self, "rootResourceId")

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> str:
        return jsii.get(self, "name")

    @name.setter
    def name(self, value: str) -> None:
        jsii.set(self, "name", value)

    @builtins.property
    @jsii.member(jsii_name="apiKeySource")
    def api_key_source(self) -> typing.Optional[str]:
        return jsii.get(self, "apiKeySource")

    @api_key_source.setter
    def api_key_source(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "apiKeySource", value)

    @builtins.property
    @jsii.member(jsii_name="binaryMediaTypes")
    def binary_media_types(self) -> typing.Optional[typing.List[str]]:
        return jsii.get(self, "binaryMediaTypes")

    @binary_media_types.setter
    def binary_media_types(self, value: typing.Optional[typing.List[str]]) -> None:
        jsii.set(self, "binaryMediaTypes", value)

    @builtins.property
    @jsii.member(jsii_name="body")
    def body(self) -> typing.Optional[str]:
        return jsii.get(self, "body")

    @body.setter
    def body(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "body", value)

    @builtins.property
    @jsii.member(jsii_name="description")
    def description(self) -> typing.Optional[str]:
        return jsii.get(self, "description")

    @description.setter
    def description(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "description", value)

    @builtins.property
    @jsii.member(jsii_name="endpointConfiguration")
    def endpoint_configuration(
        self,
    ) -> typing.Optional[typing.List["ApiGatewayRestApiEndpointConfiguration"]]:
        return jsii.get(self, "endpointConfiguration")

    @endpoint_configuration.setter
    def endpoint_configuration(
        self,
        value: typing.Optional[typing.List["ApiGatewayRestApiEndpointConfiguration"]],
    ) -> None:
        jsii.set(self, "endpointConfiguration", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="minimumCompressionSize")
    def minimum_compression_size(self) -> typing.Optional[jsii.Number]:
        return jsii.get(self, "minimumCompressionSize")

    @minimum_compression_size.setter
    def minimum_compression_size(self, value: typing.Optional[jsii.Number]) -> None:
        jsii.set(self, "minimumCompressionSize", value)

    @builtins.property
    @jsii.member(jsii_name="policy")
    def policy(self) -> typing.Optional[str]:
        return jsii.get(self, "policy")

    @policy.setter
    def policy(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "policy", value)

    @builtins.property
    @jsii.member(jsii_name="tags")
    def tags(self) -> typing.Optional[typing.Mapping[str, str]]:
        return jsii.get(self, "tags")

    @tags.setter
    def tags(self, value: typing.Optional[typing.Mapping[str, str]]) -> None:
        jsii.set(self, "tags", value)


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.ApiGatewayRestApiConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "name": "name",
        "api_key_source": "apiKeySource",
        "binary_media_types": "binaryMediaTypes",
        "body": "body",
        "description": "description",
        "endpoint_configuration": "endpointConfiguration",
        "minimum_compression_size": "minimumCompressionSize",
        "policy": "policy",
        "tags": "tags",
    },
)
class ApiGatewayRestApiConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        name: str,
        api_key_source: typing.Optional[str] = None,
        binary_media_types: typing.Optional[typing.List[str]] = None,
        body: typing.Optional[str] = None,
        description: typing.Optional[str] = None,
        endpoint_configuration: typing.Optional[
            typing.List["ApiGatewayRestApiEndpointConfiguration"]
        ] = None,
        minimum_compression_size: typing.Optional[jsii.Number] = None,
        policy: typing.Optional[str] = None,
        tags: typing.Optional[typing.Mapping[str, str]] = None,
    ) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param name: 
        :param api_key_source: 
        :param binary_media_types: 
        :param body: 
        :param description: 
        :param endpoint_configuration: endpoint_configuration block.
        :param minimum_compression_size: 
        :param policy: 
        :param tags: 
        """
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        self._values = {
            "name": name,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if api_key_source is not None:
            self._values["api_key_source"] = api_key_source
        if binary_media_types is not None:
            self._values["binary_media_types"] = binary_media_types
        if body is not None:
            self._values["body"] = body
        if description is not None:
            self._values["description"] = description
        if endpoint_configuration is not None:
            self._values["endpoint_configuration"] = endpoint_configuration
        if minimum_compression_size is not None:
            self._values["minimum_compression_size"] = minimum_compression_size
        if policy is not None:
            self._values["policy"] = policy
        if tags is not None:
            self._values["tags"] = tags

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("count")

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.TerraformResource]]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("depends_on")

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("lifecycle")

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("provider")

    @builtins.property
    def name(self) -> str:
        return self._values.get("name")

    @builtins.property
    def api_key_source(self) -> typing.Optional[str]:
        return self._values.get("api_key_source")

    @builtins.property
    def binary_media_types(self) -> typing.Optional[typing.List[str]]:
        return self._values.get("binary_media_types")

    @builtins.property
    def body(self) -> typing.Optional[str]:
        return self._values.get("body")

    @builtins.property
    def description(self) -> typing.Optional[str]:
        return self._values.get("description")

    @builtins.property
    def endpoint_configuration(
        self,
    ) -> typing.Optional[typing.List["ApiGatewayRestApiEndpointConfiguration"]]:
        """endpoint_configuration block."""
        return self._values.get("endpoint_configuration")

    @builtins.property
    def minimum_compression_size(self) -> typing.Optional[jsii.Number]:
        return self._values.get("minimum_compression_size")

    @builtins.property
    def policy(self) -> typing.Optional[str]:
        return self._values.get("policy")

    @builtins.property
    def tags(self) -> typing.Optional[typing.Mapping[str, str]]:
        return self._values.get("tags")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiGatewayRestApiConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.ApiGatewayRestApiEndpointConfiguration",
    jsii_struct_bases=[],
    name_mapping={"types": "types", "vpc_endpoint_ids": "vpcEndpointIds"},
)
class ApiGatewayRestApiEndpointConfiguration:
    def __init__(
        self,
        *,
        types: typing.List[str],
        vpc_endpoint_ids: typing.Optional[typing.List[str]] = None,
    ) -> None:
        """
        :param types: 
        :param vpc_endpoint_ids: 
        """
        self._values = {
            "types": types,
        }
        if vpc_endpoint_ids is not None:
            self._values["vpc_endpoint_ids"] = vpc_endpoint_ids

    @builtins.property
    def types(self) -> typing.List[str]:
        return self._values.get("types")

    @builtins.property
    def vpc_endpoint_ids(self) -> typing.Optional[typing.List[str]]:
        return self._values.get("vpc_endpoint_ids")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiGatewayRestApiEndpointConfiguration(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class ApiGatewayStage(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="@skorfmann/cdktf-provider-aws.ApiGatewayStage",
):
    def __init__(
        self,
        scope: constructs.Construct,
        id: str,
        *,
        deployment_id: str,
        rest_api_id: str,
        stage_name: str,
        access_log_settings: typing.Optional[
            typing.List["ApiGatewayStageAccessLogSettings"]
        ] = None,
        cache_cluster_enabled: typing.Optional[bool] = None,
        cache_cluster_size: typing.Optional[str] = None,
        client_certificate_id: typing.Optional[str] = None,
        description: typing.Optional[str] = None,
        documentation_version: typing.Optional[str] = None,
        tags: typing.Optional[typing.Mapping[str, str]] = None,
        variables: typing.Optional[typing.Mapping[str, str]] = None,
        xray_tracing_enabled: typing.Optional[bool] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param deployment_id: 
        :param rest_api_id: 
        :param stage_name: 
        :param access_log_settings: access_log_settings block.
        :param cache_cluster_enabled: 
        :param cache_cluster_size: 
        :param client_certificate_id: 
        :param description: 
        :param documentation_version: 
        :param tags: 
        :param variables: 
        :param xray_tracing_enabled: 
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = ApiGatewayStageConfig(
            deployment_id=deployment_id,
            rest_api_id=rest_api_id,
            stage_name=stage_name,
            access_log_settings=access_log_settings,
            cache_cluster_enabled=cache_cluster_enabled,
            cache_cluster_size=cache_cluster_size,
            client_certificate_id=client_certificate_id,
            description=description,
            documentation_version=documentation_version,
            tags=tags,
            variables=variables,
            xray_tracing_enabled=xray_tracing_enabled,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(ApiGatewayStage, self, [scope, id, config])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property
    @jsii.member(jsii_name="arn")
    def arn(self) -> str:
        return jsii.get(self, "arn")

    @builtins.property
    @jsii.member(jsii_name="executionArn")
    def execution_arn(self) -> str:
        return jsii.get(self, "executionArn")

    @builtins.property
    @jsii.member(jsii_name="invokeUrl")
    def invoke_url(self) -> str:
        return jsii.get(self, "invokeUrl")

    @builtins.property
    @jsii.member(jsii_name="deploymentId")
    def deployment_id(self) -> str:
        return jsii.get(self, "deploymentId")

    @deployment_id.setter
    def deployment_id(self, value: str) -> None:
        jsii.set(self, "deploymentId", value)

    @builtins.property
    @jsii.member(jsii_name="restApiId")
    def rest_api_id(self) -> str:
        return jsii.get(self, "restApiId")

    @rest_api_id.setter
    def rest_api_id(self, value: str) -> None:
        jsii.set(self, "restApiId", value)

    @builtins.property
    @jsii.member(jsii_name="stageName")
    def stage_name(self) -> str:
        return jsii.get(self, "stageName")

    @stage_name.setter
    def stage_name(self, value: str) -> None:
        jsii.set(self, "stageName", value)

    @builtins.property
    @jsii.member(jsii_name="accessLogSettings")
    def access_log_settings(
        self,
    ) -> typing.Optional[typing.List["ApiGatewayStageAccessLogSettings"]]:
        return jsii.get(self, "accessLogSettings")

    @access_log_settings.setter
    def access_log_settings(
        self, value: typing.Optional[typing.List["ApiGatewayStageAccessLogSettings"]]
    ) -> None:
        jsii.set(self, "accessLogSettings", value)

    @builtins.property
    @jsii.member(jsii_name="cacheClusterEnabled")
    def cache_cluster_enabled(self) -> typing.Optional[bool]:
        return jsii.get(self, "cacheClusterEnabled")

    @cache_cluster_enabled.setter
    def cache_cluster_enabled(self, value: typing.Optional[bool]) -> None:
        jsii.set(self, "cacheClusterEnabled", value)

    @builtins.property
    @jsii.member(jsii_name="cacheClusterSize")
    def cache_cluster_size(self) -> typing.Optional[str]:
        return jsii.get(self, "cacheClusterSize")

    @cache_cluster_size.setter
    def cache_cluster_size(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "cacheClusterSize", value)

    @builtins.property
    @jsii.member(jsii_name="clientCertificateId")
    def client_certificate_id(self) -> typing.Optional[str]:
        return jsii.get(self, "clientCertificateId")

    @client_certificate_id.setter
    def client_certificate_id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "clientCertificateId", value)

    @builtins.property
    @jsii.member(jsii_name="description")
    def description(self) -> typing.Optional[str]:
        return jsii.get(self, "description")

    @description.setter
    def description(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "description", value)

    @builtins.property
    @jsii.member(jsii_name="documentationVersion")
    def documentation_version(self) -> typing.Optional[str]:
        return jsii.get(self, "documentationVersion")

    @documentation_version.setter
    def documentation_version(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "documentationVersion", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="tags")
    def tags(self) -> typing.Optional[typing.Mapping[str, str]]:
        return jsii.get(self, "tags")

    @tags.setter
    def tags(self, value: typing.Optional[typing.Mapping[str, str]]) -> None:
        jsii.set(self, "tags", value)

    @builtins.property
    @jsii.member(jsii_name="variables")
    def variables(self) -> typing.Optional[typing.Mapping[str, str]]:
        return jsii.get(self, "variables")

    @variables.setter
    def variables(self, value: typing.Optional[typing.Mapping[str, str]]) -> None:
        jsii.set(self, "variables", value)

    @builtins.property
    @jsii.member(jsii_name="xrayTracingEnabled")
    def xray_tracing_enabled(self) -> typing.Optional[bool]:
        return jsii.get(self, "xrayTracingEnabled")

    @xray_tracing_enabled.setter
    def xray_tracing_enabled(self, value: typing.Optional[bool]) -> None:
        jsii.set(self, "xrayTracingEnabled", value)


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.ApiGatewayStageAccessLogSettings",
    jsii_struct_bases=[],
    name_mapping={"destination_arn": "destinationArn", "format": "format"},
)
class ApiGatewayStageAccessLogSettings:
    def __init__(self, *, destination_arn: str, format: str) -> None:
        """
        :param destination_arn: 
        :param format: 
        """
        self._values = {
            "destination_arn": destination_arn,
            "format": format,
        }

    @builtins.property
    def destination_arn(self) -> str:
        return self._values.get("destination_arn")

    @builtins.property
    def format(self) -> str:
        return self._values.get("format")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiGatewayStageAccessLogSettings(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.ApiGatewayStageConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "deployment_id": "deploymentId",
        "rest_api_id": "restApiId",
        "stage_name": "stageName",
        "access_log_settings": "accessLogSettings",
        "cache_cluster_enabled": "cacheClusterEnabled",
        "cache_cluster_size": "cacheClusterSize",
        "client_certificate_id": "clientCertificateId",
        "description": "description",
        "documentation_version": "documentationVersion",
        "tags": "tags",
        "variables": "variables",
        "xray_tracing_enabled": "xrayTracingEnabled",
    },
)
class ApiGatewayStageConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        deployment_id: str,
        rest_api_id: str,
        stage_name: str,
        access_log_settings: typing.Optional[
            typing.List["ApiGatewayStageAccessLogSettings"]
        ] = None,
        cache_cluster_enabled: typing.Optional[bool] = None,
        cache_cluster_size: typing.Optional[str] = None,
        client_certificate_id: typing.Optional[str] = None,
        description: typing.Optional[str] = None,
        documentation_version: typing.Optional[str] = None,
        tags: typing.Optional[typing.Mapping[str, str]] = None,
        variables: typing.Optional[typing.Mapping[str, str]] = None,
        xray_tracing_enabled: typing.Optional[bool] = None,
    ) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param deployment_id: 
        :param rest_api_id: 
        :param stage_name: 
        :param access_log_settings: access_log_settings block.
        :param cache_cluster_enabled: 
        :param cache_cluster_size: 
        :param client_certificate_id: 
        :param description: 
        :param documentation_version: 
        :param tags: 
        :param variables: 
        :param xray_tracing_enabled: 
        """
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        self._values = {
            "deployment_id": deployment_id,
            "rest_api_id": rest_api_id,
            "stage_name": stage_name,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if access_log_settings is not None:
            self._values["access_log_settings"] = access_log_settings
        if cache_cluster_enabled is not None:
            self._values["cache_cluster_enabled"] = cache_cluster_enabled
        if cache_cluster_size is not None:
            self._values["cache_cluster_size"] = cache_cluster_size
        if client_certificate_id is not None:
            self._values["client_certificate_id"] = client_certificate_id
        if description is not None:
            self._values["description"] = description
        if documentation_version is not None:
            self._values["documentation_version"] = documentation_version
        if tags is not None:
            self._values["tags"] = tags
        if variables is not None:
            self._values["variables"] = variables
        if xray_tracing_enabled is not None:
            self._values["xray_tracing_enabled"] = xray_tracing_enabled

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("count")

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.TerraformResource]]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("depends_on")

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("lifecycle")

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("provider")

    @builtins.property
    def deployment_id(self) -> str:
        return self._values.get("deployment_id")

    @builtins.property
    def rest_api_id(self) -> str:
        return self._values.get("rest_api_id")

    @builtins.property
    def stage_name(self) -> str:
        return self._values.get("stage_name")

    @builtins.property
    def access_log_settings(
        self,
    ) -> typing.Optional[typing.List["ApiGatewayStageAccessLogSettings"]]:
        """access_log_settings block."""
        return self._values.get("access_log_settings")

    @builtins.property
    def cache_cluster_enabled(self) -> typing.Optional[bool]:
        return self._values.get("cache_cluster_enabled")

    @builtins.property
    def cache_cluster_size(self) -> typing.Optional[str]:
        return self._values.get("cache_cluster_size")

    @builtins.property
    def client_certificate_id(self) -> typing.Optional[str]:
        return self._values.get("client_certificate_id")

    @builtins.property
    def description(self) -> typing.Optional[str]:
        return self._values.get("description")

    @builtins.property
    def documentation_version(self) -> typing.Optional[str]:
        return self._values.get("documentation_version")

    @builtins.property
    def tags(self) -> typing.Optional[typing.Mapping[str, str]]:
        return self._values.get("tags")

    @builtins.property
    def variables(self) -> typing.Optional[typing.Mapping[str, str]]:
        return self._values.get("variables")

    @builtins.property
    def xray_tracing_enabled(self) -> typing.Optional[bool]:
        return self._values.get("xray_tracing_enabled")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiGatewayStageConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class ApiGatewayUsagePlan(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="@skorfmann/cdktf-provider-aws.ApiGatewayUsagePlan",
):
    def __init__(
        self,
        scope: constructs.Construct,
        id: str,
        *,
        name: str,
        api_stages: typing.Optional[typing.List["ApiGatewayUsagePlanApiStages"]] = None,
        description: typing.Optional[str] = None,
        product_code: typing.Optional[str] = None,
        quota_settings: typing.Optional[
            typing.List["ApiGatewayUsagePlanQuotaSettings"]
        ] = None,
        tags: typing.Optional[typing.Mapping[str, str]] = None,
        throttle_settings: typing.Optional[
            typing.List["ApiGatewayUsagePlanThrottleSettings"]
        ] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param name: 
        :param api_stages: api_stages block.
        :param description: 
        :param product_code: 
        :param quota_settings: quota_settings block.
        :param tags: 
        :param throttle_settings: throttle_settings block.
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = ApiGatewayUsagePlanConfig(
            name=name,
            api_stages=api_stages,
            description=description,
            product_code=product_code,
            quota_settings=quota_settings,
            tags=tags,
            throttle_settings=throttle_settings,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(ApiGatewayUsagePlan, self, [scope, id, config])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property
    @jsii.member(jsii_name="arn")
    def arn(self) -> str:
        return jsii.get(self, "arn")

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> str:
        return jsii.get(self, "name")

    @name.setter
    def name(self, value: str) -> None:
        jsii.set(self, "name", value)

    @builtins.property
    @jsii.member(jsii_name="apiStages")
    def api_stages(
        self,
    ) -> typing.Optional[typing.List["ApiGatewayUsagePlanApiStages"]]:
        return jsii.get(self, "apiStages")

    @api_stages.setter
    def api_stages(
        self, value: typing.Optional[typing.List["ApiGatewayUsagePlanApiStages"]]
    ) -> None:
        jsii.set(self, "apiStages", value)

    @builtins.property
    @jsii.member(jsii_name="description")
    def description(self) -> typing.Optional[str]:
        return jsii.get(self, "description")

    @description.setter
    def description(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "description", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="productCode")
    def product_code(self) -> typing.Optional[str]:
        return jsii.get(self, "productCode")

    @product_code.setter
    def product_code(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "productCode", value)

    @builtins.property
    @jsii.member(jsii_name="quotaSettings")
    def quota_settings(
        self,
    ) -> typing.Optional[typing.List["ApiGatewayUsagePlanQuotaSettings"]]:
        return jsii.get(self, "quotaSettings")

    @quota_settings.setter
    def quota_settings(
        self, value: typing.Optional[typing.List["ApiGatewayUsagePlanQuotaSettings"]]
    ) -> None:
        jsii.set(self, "quotaSettings", value)

    @builtins.property
    @jsii.member(jsii_name="tags")
    def tags(self) -> typing.Optional[typing.Mapping[str, str]]:
        return jsii.get(self, "tags")

    @tags.setter
    def tags(self, value: typing.Optional[typing.Mapping[str, str]]) -> None:
        jsii.set(self, "tags", value)

    @builtins.property
    @jsii.member(jsii_name="throttleSettings")
    def throttle_settings(
        self,
    ) -> typing.Optional[typing.List["ApiGatewayUsagePlanThrottleSettings"]]:
        return jsii.get(self, "throttleSettings")

    @throttle_settings.setter
    def throttle_settings(
        self, value: typing.Optional[typing.List["ApiGatewayUsagePlanThrottleSettings"]]
    ) -> None:
        jsii.set(self, "throttleSettings", value)


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.ApiGatewayUsagePlanApiStages",
    jsii_struct_bases=[],
    name_mapping={"api_id": "apiId", "stage": "stage"},
)
class ApiGatewayUsagePlanApiStages:
    def __init__(self, *, api_id: str, stage: str) -> None:
        """
        :param api_id: 
        :param stage: 
        """
        self._values = {
            "api_id": api_id,
            "stage": stage,
        }

    @builtins.property
    def api_id(self) -> str:
        return self._values.get("api_id")

    @builtins.property
    def stage(self) -> str:
        return self._values.get("stage")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiGatewayUsagePlanApiStages(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.ApiGatewayUsagePlanConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "name": "name",
        "api_stages": "apiStages",
        "description": "description",
        "product_code": "productCode",
        "quota_settings": "quotaSettings",
        "tags": "tags",
        "throttle_settings": "throttleSettings",
    },
)
class ApiGatewayUsagePlanConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        name: str,
        api_stages: typing.Optional[typing.List["ApiGatewayUsagePlanApiStages"]] = None,
        description: typing.Optional[str] = None,
        product_code: typing.Optional[str] = None,
        quota_settings: typing.Optional[
            typing.List["ApiGatewayUsagePlanQuotaSettings"]
        ] = None,
        tags: typing.Optional[typing.Mapping[str, str]] = None,
        throttle_settings: typing.Optional[
            typing.List["ApiGatewayUsagePlanThrottleSettings"]
        ] = None,
    ) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param name: 
        :param api_stages: api_stages block.
        :param description: 
        :param product_code: 
        :param quota_settings: quota_settings block.
        :param tags: 
        :param throttle_settings: throttle_settings block.
        """
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        self._values = {
            "name": name,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if api_stages is not None:
            self._values["api_stages"] = api_stages
        if description is not None:
            self._values["description"] = description
        if product_code is not None:
            self._values["product_code"] = product_code
        if quota_settings is not None:
            self._values["quota_settings"] = quota_settings
        if tags is not None:
            self._values["tags"] = tags
        if throttle_settings is not None:
            self._values["throttle_settings"] = throttle_settings

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("count")

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.TerraformResource]]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("depends_on")

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("lifecycle")

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("provider")

    @builtins.property
    def name(self) -> str:
        return self._values.get("name")

    @builtins.property
    def api_stages(
        self,
    ) -> typing.Optional[typing.List["ApiGatewayUsagePlanApiStages"]]:
        """api_stages block."""
        return self._values.get("api_stages")

    @builtins.property
    def description(self) -> typing.Optional[str]:
        return self._values.get("description")

    @builtins.property
    def product_code(self) -> typing.Optional[str]:
        return self._values.get("product_code")

    @builtins.property
    def quota_settings(
        self,
    ) -> typing.Optional[typing.List["ApiGatewayUsagePlanQuotaSettings"]]:
        """quota_settings block."""
        return self._values.get("quota_settings")

    @builtins.property
    def tags(self) -> typing.Optional[typing.Mapping[str, str]]:
        return self._values.get("tags")

    @builtins.property
    def throttle_settings(
        self,
    ) -> typing.Optional[typing.List["ApiGatewayUsagePlanThrottleSettings"]]:
        """throttle_settings block."""
        return self._values.get("throttle_settings")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiGatewayUsagePlanConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class ApiGatewayUsagePlanKey(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="@skorfmann/cdktf-provider-aws.ApiGatewayUsagePlanKey",
):
    def __init__(
        self,
        scope: constructs.Construct,
        id: str,
        *,
        key_id: str,
        key_type: str,
        usage_plan_id: str,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param key_id: 
        :param key_type: 
        :param usage_plan_id: 
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = ApiGatewayUsagePlanKeyConfig(
            key_id=key_id,
            key_type=key_type,
            usage_plan_id=usage_plan_id,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(ApiGatewayUsagePlanKey, self, [scope, id, config])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> str:
        return jsii.get(self, "name")

    @builtins.property
    @jsii.member(jsii_name="value")
    def value(self) -> str:
        return jsii.get(self, "value")

    @builtins.property
    @jsii.member(jsii_name="keyId")
    def key_id(self) -> str:
        return jsii.get(self, "keyId")

    @key_id.setter
    def key_id(self, value: str) -> None:
        jsii.set(self, "keyId", value)

    @builtins.property
    @jsii.member(jsii_name="keyType")
    def key_type(self) -> str:
        return jsii.get(self, "keyType")

    @key_type.setter
    def key_type(self, value: str) -> None:
        jsii.set(self, "keyType", value)

    @builtins.property
    @jsii.member(jsii_name="usagePlanId")
    def usage_plan_id(self) -> str:
        return jsii.get(self, "usagePlanId")

    @usage_plan_id.setter
    def usage_plan_id(self, value: str) -> None:
        jsii.set(self, "usagePlanId", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.ApiGatewayUsagePlanKeyConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "key_id": "keyId",
        "key_type": "keyType",
        "usage_plan_id": "usagePlanId",
    },
)
class ApiGatewayUsagePlanKeyConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        key_id: str,
        key_type: str,
        usage_plan_id: str,
    ) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param key_id: 
        :param key_type: 
        :param usage_plan_id: 
        """
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        self._values = {
            "key_id": key_id,
            "key_type": key_type,
            "usage_plan_id": usage_plan_id,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("count")

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.TerraformResource]]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("depends_on")

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("lifecycle")

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("provider")

    @builtins.property
    def key_id(self) -> str:
        return self._values.get("key_id")

    @builtins.property
    def key_type(self) -> str:
        return self._values.get("key_type")

    @builtins.property
    def usage_plan_id(self) -> str:
        return self._values.get("usage_plan_id")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiGatewayUsagePlanKeyConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.ApiGatewayUsagePlanQuotaSettings",
    jsii_struct_bases=[],
    name_mapping={"limit": "limit", "period": "period", "offset": "offset"},
)
class ApiGatewayUsagePlanQuotaSettings:
    def __init__(
        self,
        *,
        limit: jsii.Number,
        period: str,
        offset: typing.Optional[jsii.Number] = None,
    ) -> None:
        """
        :param limit: 
        :param period: 
        :param offset: 
        """
        self._values = {
            "limit": limit,
            "period": period,
        }
        if offset is not None:
            self._values["offset"] = offset

    @builtins.property
    def limit(self) -> jsii.Number:
        return self._values.get("limit")

    @builtins.property
    def period(self) -> str:
        return self._values.get("period")

    @builtins.property
    def offset(self) -> typing.Optional[jsii.Number]:
        return self._values.get("offset")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiGatewayUsagePlanQuotaSettings(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.ApiGatewayUsagePlanThrottleSettings",
    jsii_struct_bases=[],
    name_mapping={"burst_limit": "burstLimit", "rate_limit": "rateLimit"},
)
class ApiGatewayUsagePlanThrottleSettings:
    def __init__(
        self,
        *,
        burst_limit: typing.Optional[jsii.Number] = None,
        rate_limit: typing.Optional[jsii.Number] = None,
    ) -> None:
        """
        :param burst_limit: 
        :param rate_limit: 
        """
        self._values = {}
        if burst_limit is not None:
            self._values["burst_limit"] = burst_limit
        if rate_limit is not None:
            self._values["rate_limit"] = rate_limit

    @builtins.property
    def burst_limit(self) -> typing.Optional[jsii.Number]:
        return self._values.get("burst_limit")

    @builtins.property
    def rate_limit(self) -> typing.Optional[jsii.Number]:
        return self._values.get("rate_limit")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiGatewayUsagePlanThrottleSettings(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class ApiGatewayVpcLink(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="@skorfmann/cdktf-provider-aws.ApiGatewayVpcLink",
):
    def __init__(
        self,
        scope: constructs.Construct,
        id: str,
        *,
        name: str,
        target_arns: typing.List[str],
        description: typing.Optional[str] = None,
        tags: typing.Optional[typing.Mapping[str, str]] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param name: 
        :param target_arns: 
        :param description: 
        :param tags: 
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = ApiGatewayVpcLinkConfig(
            name=name,
            target_arns=target_arns,
            description=description,
            tags=tags,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(ApiGatewayVpcLink, self, [scope, id, config])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property
    @jsii.member(jsii_name="arn")
    def arn(self) -> str:
        return jsii.get(self, "arn")

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> str:
        return jsii.get(self, "name")

    @name.setter
    def name(self, value: str) -> None:
        jsii.set(self, "name", value)

    @builtins.property
    @jsii.member(jsii_name="targetArns")
    def target_arns(self) -> typing.List[str]:
        return jsii.get(self, "targetArns")

    @target_arns.setter
    def target_arns(self, value: typing.List[str]) -> None:
        jsii.set(self, "targetArns", value)

    @builtins.property
    @jsii.member(jsii_name="description")
    def description(self) -> typing.Optional[str]:
        return jsii.get(self, "description")

    @description.setter
    def description(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "description", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="tags")
    def tags(self) -> typing.Optional[typing.Mapping[str, str]]:
        return jsii.get(self, "tags")

    @tags.setter
    def tags(self, value: typing.Optional[typing.Mapping[str, str]]) -> None:
        jsii.set(self, "tags", value)


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.ApiGatewayVpcLinkConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "name": "name",
        "target_arns": "targetArns",
        "description": "description",
        "tags": "tags",
    },
)
class ApiGatewayVpcLinkConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        name: str,
        target_arns: typing.List[str],
        description: typing.Optional[str] = None,
        tags: typing.Optional[typing.Mapping[str, str]] = None,
    ) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param name: 
        :param target_arns: 
        :param description: 
        :param tags: 
        """
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        self._values = {
            "name": name,
            "target_arns": target_arns,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if description is not None:
            self._values["description"] = description
        if tags is not None:
            self._values["tags"] = tags

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("count")

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.TerraformResource]]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("depends_on")

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("lifecycle")

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("provider")

    @builtins.property
    def name(self) -> str:
        return self._values.get("name")

    @builtins.property
    def target_arns(self) -> typing.List[str]:
        return self._values.get("target_arns")

    @builtins.property
    def description(self) -> typing.Optional[str]:
        return self._values.get("description")

    @builtins.property
    def tags(self) -> typing.Optional[typing.Mapping[str, str]]:
        return self._values.get("tags")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "ApiGatewayVpcLinkConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class Apigatewayv2Api(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="@skorfmann/cdktf-provider-aws.Apigatewayv2Api",
):
    def __init__(
        self,
        scope: constructs.Construct,
        id: str,
        *,
        name: str,
        protocol_type: str,
        api_key_selection_expression: typing.Optional[str] = None,
        cors_configuration: typing.Optional[
            typing.List["Apigatewayv2ApiCorsConfiguration"]
        ] = None,
        credentials_arn: typing.Optional[str] = None,
        description: typing.Optional[str] = None,
        route_key: typing.Optional[str] = None,
        route_selection_expression: typing.Optional[str] = None,
        tags: typing.Optional[typing.Mapping[str, str]] = None,
        target: typing.Optional[str] = None,
        version: typing.Optional[str] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param name: 
        :param protocol_type: 
        :param api_key_selection_expression: 
        :param cors_configuration: cors_configuration block.
        :param credentials_arn: 
        :param description: 
        :param route_key: 
        :param route_selection_expression: 
        :param tags: 
        :param target: 
        :param version: 
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = Apigatewayv2ApiConfig(
            name=name,
            protocol_type=protocol_type,
            api_key_selection_expression=api_key_selection_expression,
            cors_configuration=cors_configuration,
            credentials_arn=credentials_arn,
            description=description,
            route_key=route_key,
            route_selection_expression=route_selection_expression,
            tags=tags,
            target=target,
            version=version,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(Apigatewayv2Api, self, [scope, id, config])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property
    @jsii.member(jsii_name="apiEndpoint")
    def api_endpoint(self) -> str:
        return jsii.get(self, "apiEndpoint")

    @builtins.property
    @jsii.member(jsii_name="arn")
    def arn(self) -> str:
        return jsii.get(self, "arn")

    @builtins.property
    @jsii.member(jsii_name="executionArn")
    def execution_arn(self) -> str:
        return jsii.get(self, "executionArn")

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> str:
        return jsii.get(self, "name")

    @name.setter
    def name(self, value: str) -> None:
        jsii.set(self, "name", value)

    @builtins.property
    @jsii.member(jsii_name="protocolType")
    def protocol_type(self) -> str:
        return jsii.get(self, "protocolType")

    @protocol_type.setter
    def protocol_type(self, value: str) -> None:
        jsii.set(self, "protocolType", value)

    @builtins.property
    @jsii.member(jsii_name="apiKeySelectionExpression")
    def api_key_selection_expression(self) -> typing.Optional[str]:
        return jsii.get(self, "apiKeySelectionExpression")

    @api_key_selection_expression.setter
    def api_key_selection_expression(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "apiKeySelectionExpression", value)

    @builtins.property
    @jsii.member(jsii_name="corsConfiguration")
    def cors_configuration(
        self,
    ) -> typing.Optional[typing.List["Apigatewayv2ApiCorsConfiguration"]]:
        return jsii.get(self, "corsConfiguration")

    @cors_configuration.setter
    def cors_configuration(
        self, value: typing.Optional[typing.List["Apigatewayv2ApiCorsConfiguration"]]
    ) -> None:
        jsii.set(self, "corsConfiguration", value)

    @builtins.property
    @jsii.member(jsii_name="credentialsArn")
    def credentials_arn(self) -> typing.Optional[str]:
        return jsii.get(self, "credentialsArn")

    @credentials_arn.setter
    def credentials_arn(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "credentialsArn", value)

    @builtins.property
    @jsii.member(jsii_name="description")
    def description(self) -> typing.Optional[str]:
        return jsii.get(self, "description")

    @description.setter
    def description(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "description", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="routeKey")
    def route_key(self) -> typing.Optional[str]:
        return jsii.get(self, "routeKey")

    @route_key.setter
    def route_key(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "routeKey", value)

    @builtins.property
    @jsii.member(jsii_name="routeSelectionExpression")
    def route_selection_expression(self) -> typing.Optional[str]:
        return jsii.get(self, "routeSelectionExpression")

    @route_selection_expression.setter
    def route_selection_expression(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "routeSelectionExpression", value)

    @builtins.property
    @jsii.member(jsii_name="tags")
    def tags(self) -> typing.Optional[typing.Mapping[str, str]]:
        return jsii.get(self, "tags")

    @tags.setter
    def tags(self, value: typing.Optional[typing.Mapping[str, str]]) -> None:
        jsii.set(self, "tags", value)

    @builtins.property
    @jsii.member(jsii_name="target")
    def target(self) -> typing.Optional[str]:
        return jsii.get(self, "target")

    @target.setter
    def target(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "target", value)

    @builtins.property
    @jsii.member(jsii_name="version")
    def version(self) -> typing.Optional[str]:
        return jsii.get(self, "version")

    @version.setter
    def version(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "version", value)


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.Apigatewayv2ApiConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "name": "name",
        "protocol_type": "protocolType",
        "api_key_selection_expression": "apiKeySelectionExpression",
        "cors_configuration": "corsConfiguration",
        "credentials_arn": "credentialsArn",
        "description": "description",
        "route_key": "routeKey",
        "route_selection_expression": "routeSelectionExpression",
        "tags": "tags",
        "target": "target",
        "version": "version",
    },
)
class Apigatewayv2ApiConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        name: str,
        protocol_type: str,
        api_key_selection_expression: typing.Optional[str] = None,
        cors_configuration: typing.Optional[
            typing.List["Apigatewayv2ApiCorsConfiguration"]
        ] = None,
        credentials_arn: typing.Optional[str] = None,
        description: typing.Optional[str] = None,
        route_key: typing.Optional[str] = None,
        route_selection_expression: typing.Optional[str] = None,
        tags: typing.Optional[typing.Mapping[str, str]] = None,
        target: typing.Optional[str] = None,
        version: typing.Optional[str] = None,
    ) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param name: 
        :param protocol_type: 
        :param api_key_selection_expression: 
        :param cors_configuration: cors_configuration block.
        :param credentials_arn: 
        :param description: 
        :param route_key: 
        :param route_selection_expression: 
        :param tags: 
        :param target: 
        :param version: 
        """
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        self._values = {
            "name": name,
            "protocol_type": protocol_type,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if api_key_selection_expression is not None:
            self._values["api_key_selection_expression"] = api_key_selection_expression
        if cors_configuration is not None:
            self._values["cors_configuration"] = cors_configuration
        if credentials_arn is not None:
            self._values["credentials_arn"] = credentials_arn
        if description is not None:
            self._values["description"] = description
        if route_key is not None:
            self._values["route_key"] = route_key
        if route_selection_expression is not None:
            self._values["route_selection_expression"] = route_selection_expression
        if tags is not None:
            self._values["tags"] = tags
        if target is not None:
            self._values["target"] = target
        if version is not None:
            self._values["version"] = version

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("count")

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.TerraformResource]]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("depends_on")

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("lifecycle")

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("provider")

    @builtins.property
    def name(self) -> str:
        return self._values.get("name")

    @builtins.property
    def protocol_type(self) -> str:
        return self._values.get("protocol_type")

    @builtins.property
    def api_key_selection_expression(self) -> typing.Optional[str]:
        return self._values.get("api_key_selection_expression")

    @builtins.property
    def cors_configuration(
        self,
    ) -> typing.Optional[typing.List["Apigatewayv2ApiCorsConfiguration"]]:
        """cors_configuration block."""
        return self._values.get("cors_configuration")

    @builtins.property
    def credentials_arn(self) -> typing.Optional[str]:
        return self._values.get("credentials_arn")

    @builtins.property
    def description(self) -> typing.Optional[str]:
        return self._values.get("description")

    @builtins.property
    def route_key(self) -> typing.Optional[str]:
        return self._values.get("route_key")

    @builtins.property
    def route_selection_expression(self) -> typing.Optional[str]:
        return self._values.get("route_selection_expression")

    @builtins.property
    def tags(self) -> typing.Optional[typing.Mapping[str, str]]:
        return self._values.get("tags")

    @builtins.property
    def target(self) -> typing.Optional[str]:
        return self._values.get("target")

    @builtins.property
    def version(self) -> typing.Optional[str]:
        return self._values.get("version")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "Apigatewayv2ApiConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.Apigatewayv2ApiCorsConfiguration",
    jsii_struct_bases=[],
    name_mapping={
        "allow_credentials": "allowCredentials",
        "allow_headers": "allowHeaders",
        "allow_methods": "allowMethods",
        "allow_origins": "allowOrigins",
        "expose_headers": "exposeHeaders",
        "max_age": "maxAge",
    },
)
class Apigatewayv2ApiCorsConfiguration:
    def __init__(
        self,
        *,
        allow_credentials: typing.Optional[bool] = None,
        allow_headers: typing.Optional[typing.List[str]] = None,
        allow_methods: typing.Optional[typing.List[str]] = None,
        allow_origins: typing.Optional[typing.List[str]] = None,
        expose_headers: typing.Optional[typing.List[str]] = None,
        max_age: typing.Optional[jsii.Number] = None,
    ) -> None:
        """
        :param allow_credentials: 
        :param allow_headers: 
        :param allow_methods: 
        :param allow_origins: 
        :param expose_headers: 
        :param max_age: 
        """
        self._values = {}
        if allow_credentials is not None:
            self._values["allow_credentials"] = allow_credentials
        if allow_headers is not None:
            self._values["allow_headers"] = allow_headers
        if allow_methods is not None:
            self._values["allow_methods"] = allow_methods
        if allow_origins is not None:
            self._values["allow_origins"] = allow_origins
        if expose_headers is not None:
            self._values["expose_headers"] = expose_headers
        if max_age is not None:
            self._values["max_age"] = max_age

    @builtins.property
    def allow_credentials(self) -> typing.Optional[bool]:
        return self._values.get("allow_credentials")

    @builtins.property
    def allow_headers(self) -> typing.Optional[typing.List[str]]:
        return self._values.get("allow_headers")

    @builtins.property
    def allow_methods(self) -> typing.Optional[typing.List[str]]:
        return self._values.get("allow_methods")

    @builtins.property
    def allow_origins(self) -> typing.Optional[typing.List[str]]:
        return self._values.get("allow_origins")

    @builtins.property
    def expose_headers(self) -> typing.Optional[typing.List[str]]:
        return self._values.get("expose_headers")

    @builtins.property
    def max_age(self) -> typing.Optional[jsii.Number]:
        return self._values.get("max_age")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "Apigatewayv2ApiCorsConfiguration(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class Apigatewayv2ApiMapping(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="@skorfmann/cdktf-provider-aws.Apigatewayv2ApiMapping",
):
    def __init__(
        self,
        scope: constructs.Construct,
        id: str,
        *,
        api_id: str,
        domain_name: str,
        stage: str,
        api_mapping_key: typing.Optional[str] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param api_id: 
        :param domain_name: 
        :param stage: 
        :param api_mapping_key: 
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = Apigatewayv2ApiMappingConfig(
            api_id=api_id,
            domain_name=domain_name,
            stage=stage,
            api_mapping_key=api_mapping_key,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(Apigatewayv2ApiMapping, self, [scope, id, config])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property
    @jsii.member(jsii_name="apiId")
    def api_id(self) -> str:
        return jsii.get(self, "apiId")

    @api_id.setter
    def api_id(self, value: str) -> None:
        jsii.set(self, "apiId", value)

    @builtins.property
    @jsii.member(jsii_name="domainName")
    def domain_name(self) -> str:
        return jsii.get(self, "domainName")

    @domain_name.setter
    def domain_name(self, value: str) -> None:
        jsii.set(self, "domainName", value)

    @builtins.property
    @jsii.member(jsii_name="stage")
    def stage(self) -> str:
        return jsii.get(self, "stage")

    @stage.setter
    def stage(self, value: str) -> None:
        jsii.set(self, "stage", value)

    @builtins.property
    @jsii.member(jsii_name="apiMappingKey")
    def api_mapping_key(self) -> typing.Optional[str]:
        return jsii.get(self, "apiMappingKey")

    @api_mapping_key.setter
    def api_mapping_key(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "apiMappingKey", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.Apigatewayv2ApiMappingConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "api_id": "apiId",
        "domain_name": "domainName",
        "stage": "stage",
        "api_mapping_key": "apiMappingKey",
    },
)
class Apigatewayv2ApiMappingConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        api_id: str,
        domain_name: str,
        stage: str,
        api_mapping_key: typing.Optional[str] = None,
    ) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param api_id: 
        :param domain_name: 
        :param stage: 
        :param api_mapping_key: 
        """
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        self._values = {
            "api_id": api_id,
            "domain_name": domain_name,
            "stage": stage,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if api_mapping_key is not None:
            self._values["api_mapping_key"] = api_mapping_key

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("count")

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.TerraformResource]]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("depends_on")

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("lifecycle")

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("provider")

    @builtins.property
    def api_id(self) -> str:
        return self._values.get("api_id")

    @builtins.property
    def domain_name(self) -> str:
        return self._values.get("domain_name")

    @builtins.property
    def stage(self) -> str:
        return self._values.get("stage")

    @builtins.property
    def api_mapping_key(self) -> typing.Optional[str]:
        return self._values.get("api_mapping_key")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "Apigatewayv2ApiMappingConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class Apigatewayv2Authorizer(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="@skorfmann/cdktf-provider-aws.Apigatewayv2Authorizer",
):
    def __init__(
        self,
        scope: constructs.Construct,
        id: str,
        *,
        api_id: str,
        authorizer_type: str,
        identity_sources: typing.List[str],
        name: str,
        authorizer_credentials_arn: typing.Optional[str] = None,
        authorizer_uri: typing.Optional[str] = None,
        jwt_configuration: typing.Optional[
            typing.List["Apigatewayv2AuthorizerJwtConfiguration"]
        ] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param api_id: 
        :param authorizer_type: 
        :param identity_sources: 
        :param name: 
        :param authorizer_credentials_arn: 
        :param authorizer_uri: 
        :param jwt_configuration: jwt_configuration block.
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = Apigatewayv2AuthorizerConfig(
            api_id=api_id,
            authorizer_type=authorizer_type,
            identity_sources=identity_sources,
            name=name,
            authorizer_credentials_arn=authorizer_credentials_arn,
            authorizer_uri=authorizer_uri,
            jwt_configuration=jwt_configuration,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(Apigatewayv2Authorizer, self, [scope, id, config])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property
    @jsii.member(jsii_name="apiId")
    def api_id(self) -> str:
        return jsii.get(self, "apiId")

    @api_id.setter
    def api_id(self, value: str) -> None:
        jsii.set(self, "apiId", value)

    @builtins.property
    @jsii.member(jsii_name="authorizerType")
    def authorizer_type(self) -> str:
        return jsii.get(self, "authorizerType")

    @authorizer_type.setter
    def authorizer_type(self, value: str) -> None:
        jsii.set(self, "authorizerType", value)

    @builtins.property
    @jsii.member(jsii_name="identitySources")
    def identity_sources(self) -> typing.List[str]:
        return jsii.get(self, "identitySources")

    @identity_sources.setter
    def identity_sources(self, value: typing.List[str]) -> None:
        jsii.set(self, "identitySources", value)

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> str:
        return jsii.get(self, "name")

    @name.setter
    def name(self, value: str) -> None:
        jsii.set(self, "name", value)

    @builtins.property
    @jsii.member(jsii_name="authorizerCredentialsArn")
    def authorizer_credentials_arn(self) -> typing.Optional[str]:
        return jsii.get(self, "authorizerCredentialsArn")

    @authorizer_credentials_arn.setter
    def authorizer_credentials_arn(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "authorizerCredentialsArn", value)

    @builtins.property
    @jsii.member(jsii_name="authorizerUri")
    def authorizer_uri(self) -> typing.Optional[str]:
        return jsii.get(self, "authorizerUri")

    @authorizer_uri.setter
    def authorizer_uri(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "authorizerUri", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="jwtConfiguration")
    def jwt_configuration(
        self,
    ) -> typing.Optional[typing.List["Apigatewayv2AuthorizerJwtConfiguration"]]:
        return jsii.get(self, "jwtConfiguration")

    @jwt_configuration.setter
    def jwt_configuration(
        self,
        value: typing.Optional[typing.List["Apigatewayv2AuthorizerJwtConfiguration"]],
    ) -> None:
        jsii.set(self, "jwtConfiguration", value)


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.Apigatewayv2AuthorizerConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "api_id": "apiId",
        "authorizer_type": "authorizerType",
        "identity_sources": "identitySources",
        "name": "name",
        "authorizer_credentials_arn": "authorizerCredentialsArn",
        "authorizer_uri": "authorizerUri",
        "jwt_configuration": "jwtConfiguration",
    },
)
class Apigatewayv2AuthorizerConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        api_id: str,
        authorizer_type: str,
        identity_sources: typing.List[str],
        name: str,
        authorizer_credentials_arn: typing.Optional[str] = None,
        authorizer_uri: typing.Optional[str] = None,
        jwt_configuration: typing.Optional[
            typing.List["Apigatewayv2AuthorizerJwtConfiguration"]
        ] = None,
    ) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param api_id: 
        :param authorizer_type: 
        :param identity_sources: 
        :param name: 
        :param authorizer_credentials_arn: 
        :param authorizer_uri: 
        :param jwt_configuration: jwt_configuration block.
        """
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        self._values = {
            "api_id": api_id,
            "authorizer_type": authorizer_type,
            "identity_sources": identity_sources,
            "name": name,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if authorizer_credentials_arn is not None:
            self._values["authorizer_credentials_arn"] = authorizer_credentials_arn
        if authorizer_uri is not None:
            self._values["authorizer_uri"] = authorizer_uri
        if jwt_configuration is not None:
            self._values["jwt_configuration"] = jwt_configuration

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("count")

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.TerraformResource]]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("depends_on")

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("lifecycle")

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("provider")

    @builtins.property
    def api_id(self) -> str:
        return self._values.get("api_id")

    @builtins.property
    def authorizer_type(self) -> str:
        return self._values.get("authorizer_type")

    @builtins.property
    def identity_sources(self) -> typing.List[str]:
        return self._values.get("identity_sources")

    @builtins.property
    def name(self) -> str:
        return self._values.get("name")

    @builtins.property
    def authorizer_credentials_arn(self) -> typing.Optional[str]:
        return self._values.get("authorizer_credentials_arn")

    @builtins.property
    def authorizer_uri(self) -> typing.Optional[str]:
        return self._values.get("authorizer_uri")

    @builtins.property
    def jwt_configuration(
        self,
    ) -> typing.Optional[typing.List["Apigatewayv2AuthorizerJwtConfiguration"]]:
        """jwt_configuration block."""
        return self._values.get("jwt_configuration")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "Apigatewayv2AuthorizerConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.Apigatewayv2AuthorizerJwtConfiguration",
    jsii_struct_bases=[],
    name_mapping={"audience": "audience", "issuer": "issuer"},
)
class Apigatewayv2AuthorizerJwtConfiguration:
    def __init__(
        self,
        *,
        audience: typing.Optional[typing.List[str]] = None,
        issuer: typing.Optional[str] = None,
    ) -> None:
        """
        :param audience: 
        :param issuer: 
        """
        self._values = {}
        if audience is not None:
            self._values["audience"] = audience
        if issuer is not None:
            self._values["issuer"] = issuer

    @builtins.property
    def audience(self) -> typing.Optional[typing.List[str]]:
        return self._values.get("audience")

    @builtins.property
    def issuer(self) -> typing.Optional[str]:
        return self._values.get("issuer")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "Apigatewayv2AuthorizerJwtConfiguration(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class Apigatewayv2Deployment(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="@skorfmann/cdktf-provider-aws.Apigatewayv2Deployment",
):
    def __init__(
        self,
        scope: constructs.Construct,
        id: str,
        *,
        api_id: str,
        description: typing.Optional[str] = None,
        triggers: typing.Optional[typing.Mapping[str, str]] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param api_id: 
        :param description: 
        :param triggers: 
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = Apigatewayv2DeploymentConfig(
            api_id=api_id,
            description=description,
            triggers=triggers,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(Apigatewayv2Deployment, self, [scope, id, config])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property
    @jsii.member(jsii_name="autoDeployed")
    def auto_deployed(self) -> bool:
        return jsii.get(self, "autoDeployed")

    @builtins.property
    @jsii.member(jsii_name="apiId")
    def api_id(self) -> str:
        return jsii.get(self, "apiId")

    @api_id.setter
    def api_id(self, value: str) -> None:
        jsii.set(self, "apiId", value)

    @builtins.property
    @jsii.member(jsii_name="description")
    def description(self) -> typing.Optional[str]:
        return jsii.get(self, "description")

    @description.setter
    def description(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "description", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="triggers")
    def triggers(self) -> typing.Optional[typing.Mapping[str, str]]:
        return jsii.get(self, "triggers")

    @triggers.setter
    def triggers(self, value: typing.Optional[typing.Mapping[str, str]]) -> None:
        jsii.set(self, "triggers", value)


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.Apigatewayv2DeploymentConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "api_id": "apiId",
        "description": "description",
        "triggers": "triggers",
    },
)
class Apigatewayv2DeploymentConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        api_id: str,
        description: typing.Optional[str] = None,
        triggers: typing.Optional[typing.Mapping[str, str]] = None,
    ) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param api_id: 
        :param description: 
        :param triggers: 
        """
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        self._values = {
            "api_id": api_id,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if description is not None:
            self._values["description"] = description
        if triggers is not None:
            self._values["triggers"] = triggers

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("count")

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.TerraformResource]]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("depends_on")

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("lifecycle")

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("provider")

    @builtins.property
    def api_id(self) -> str:
        return self._values.get("api_id")

    @builtins.property
    def description(self) -> typing.Optional[str]:
        return self._values.get("description")

    @builtins.property
    def triggers(self) -> typing.Optional[typing.Mapping[str, str]]:
        return self._values.get("triggers")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "Apigatewayv2DeploymentConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class Apigatewayv2DomainName(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="@skorfmann/cdktf-provider-aws.Apigatewayv2DomainName",
):
    def __init__(
        self,
        scope: constructs.Construct,
        id: str,
        *,
        domain_name: str,
        domain_name_configuration: typing.List[
            "Apigatewayv2DomainNameDomainNameConfiguration"
        ],
        tags: typing.Optional[typing.Mapping[str, str]] = None,
        timeouts: typing.Optional["Apigatewayv2DomainNameTimeouts"] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param domain_name: 
        :param domain_name_configuration: domain_name_configuration block.
        :param tags: 
        :param timeouts: timeouts block.
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = Apigatewayv2DomainNameConfig(
            domain_name=domain_name,
            domain_name_configuration=domain_name_configuration,
            tags=tags,
            timeouts=timeouts,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(Apigatewayv2DomainName, self, [scope, id, config])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property
    @jsii.member(jsii_name="apiMappingSelectionExpression")
    def api_mapping_selection_expression(self) -> str:
        return jsii.get(self, "apiMappingSelectionExpression")

    @builtins.property
    @jsii.member(jsii_name="arn")
    def arn(self) -> str:
        return jsii.get(self, "arn")

    @builtins.property
    @jsii.member(jsii_name="domainName")
    def domain_name(self) -> str:
        return jsii.get(self, "domainName")

    @domain_name.setter
    def domain_name(self, value: str) -> None:
        jsii.set(self, "domainName", value)

    @builtins.property
    @jsii.member(jsii_name="domainNameConfiguration")
    def domain_name_configuration(
        self,
    ) -> typing.List["Apigatewayv2DomainNameDomainNameConfiguration"]:
        return jsii.get(self, "domainNameConfiguration")

    @domain_name_configuration.setter
    def domain_name_configuration(
        self, value: typing.List["Apigatewayv2DomainNameDomainNameConfiguration"]
    ) -> None:
        jsii.set(self, "domainNameConfiguration", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="tags")
    def tags(self) -> typing.Optional[typing.Mapping[str, str]]:
        return jsii.get(self, "tags")

    @tags.setter
    def tags(self, value: typing.Optional[typing.Mapping[str, str]]) -> None:
        jsii.set(self, "tags", value)

    @builtins.property
    @jsii.member(jsii_name="timeouts")
    def timeouts(self) -> typing.Optional["Apigatewayv2DomainNameTimeouts"]:
        return jsii.get(self, "timeouts")

    @timeouts.setter
    def timeouts(
        self, value: typing.Optional["Apigatewayv2DomainNameTimeouts"]
    ) -> None:
        jsii.set(self, "timeouts", value)


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.Apigatewayv2DomainNameConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "domain_name": "domainName",
        "domain_name_configuration": "domainNameConfiguration",
        "tags": "tags",
        "timeouts": "timeouts",
    },
)
class Apigatewayv2DomainNameConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        domain_name: str,
        domain_name_configuration: typing.List[
            "Apigatewayv2DomainNameDomainNameConfiguration"
        ],
        tags: typing.Optional[typing.Mapping[str, str]] = None,
        timeouts: typing.Optional["Apigatewayv2DomainNameTimeouts"] = None,
    ) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param domain_name: 
        :param domain_name_configuration: domain_name_configuration block.
        :param tags: 
        :param timeouts: timeouts block.
        """
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        if isinstance(timeouts, dict):
            timeouts = Apigatewayv2DomainNameTimeouts(**timeouts)
        self._values = {
            "domain_name": domain_name,
            "domain_name_configuration": domain_name_configuration,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if tags is not None:
            self._values["tags"] = tags
        if timeouts is not None:
            self._values["timeouts"] = timeouts

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("count")

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.TerraformResource]]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("depends_on")

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("lifecycle")

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("provider")

    @builtins.property
    def domain_name(self) -> str:
        return self._values.get("domain_name")

    @builtins.property
    def domain_name_configuration(
        self,
    ) -> typing.List["Apigatewayv2DomainNameDomainNameConfiguration"]:
        """domain_name_configuration block."""
        return self._values.get("domain_name_configuration")

    @builtins.property
    def tags(self) -> typing.Optional[typing.Mapping[str, str]]:
        return self._values.get("tags")

    @builtins.property
    def timeouts(self) -> typing.Optional["Apigatewayv2DomainNameTimeouts"]:
        """timeouts block."""
        return self._values.get("timeouts")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "Apigatewayv2DomainNameConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.Apigatewayv2DomainNameDomainNameConfiguration",
    jsii_struct_bases=[],
    name_mapping={
        "certificate_arn": "certificateArn",
        "endpoint_type": "endpointType",
        "security_policy": "securityPolicy",
    },
)
class Apigatewayv2DomainNameDomainNameConfiguration:
    def __init__(
        self, *, certificate_arn: str, endpoint_type: str, security_policy: str
    ) -> None:
        """
        :param certificate_arn: 
        :param endpoint_type: 
        :param security_policy: 
        """
        self._values = {
            "certificate_arn": certificate_arn,
            "endpoint_type": endpoint_type,
            "security_policy": security_policy,
        }

    @builtins.property
    def certificate_arn(self) -> str:
        return self._values.get("certificate_arn")

    @builtins.property
    def endpoint_type(self) -> str:
        return self._values.get("endpoint_type")

    @builtins.property
    def security_policy(self) -> str:
        return self._values.get("security_policy")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "Apigatewayv2DomainNameDomainNameConfiguration(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.Apigatewayv2DomainNameTimeouts",
    jsii_struct_bases=[],
    name_mapping={"update": "update"},
)
class Apigatewayv2DomainNameTimeouts:
    def __init__(self, *, update: typing.Optional[str] = None) -> None:
        """
        :param update: 
        """
        self._values = {}
        if update is not None:
            self._values["update"] = update

    @builtins.property
    def update(self) -> typing.Optional[str]:
        return self._values.get("update")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "Apigatewayv2DomainNameTimeouts(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class Apigatewayv2Integration(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="@skorfmann/cdktf-provider-aws.Apigatewayv2Integration",
):
    def __init__(
        self,
        scope: constructs.Construct,
        id: str,
        *,
        api_id: str,
        integration_type: str,
        connection_id: typing.Optional[str] = None,
        connection_type: typing.Optional[str] = None,
        content_handling_strategy: typing.Optional[str] = None,
        credentials_arn: typing.Optional[str] = None,
        description: typing.Optional[str] = None,
        integration_method: typing.Optional[str] = None,
        integration_uri: typing.Optional[str] = None,
        passthrough_behavior: typing.Optional[str] = None,
        payload_format_version: typing.Optional[str] = None,
        request_templates: typing.Optional[typing.Mapping[str, str]] = None,
        template_selection_expression: typing.Optional[str] = None,
        timeout_milliseconds: typing.Optional[jsii.Number] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param api_id: 
        :param integration_type: 
        :param connection_id: 
        :param connection_type: 
        :param content_handling_strategy: 
        :param credentials_arn: 
        :param description: 
        :param integration_method: 
        :param integration_uri: 
        :param passthrough_behavior: 
        :param payload_format_version: 
        :param request_templates: 
        :param template_selection_expression: 
        :param timeout_milliseconds: 
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = Apigatewayv2IntegrationConfig(
            api_id=api_id,
            integration_type=integration_type,
            connection_id=connection_id,
            connection_type=connection_type,
            content_handling_strategy=content_handling_strategy,
            credentials_arn=credentials_arn,
            description=description,
            integration_method=integration_method,
            integration_uri=integration_uri,
            passthrough_behavior=passthrough_behavior,
            payload_format_version=payload_format_version,
            request_templates=request_templates,
            template_selection_expression=template_selection_expression,
            timeout_milliseconds=timeout_milliseconds,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(Apigatewayv2Integration, self, [scope, id, config])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property
    @jsii.member(jsii_name="integrationResponseSelectionExpression")
    def integration_response_selection_expression(self) -> str:
        return jsii.get(self, "integrationResponseSelectionExpression")

    @builtins.property
    @jsii.member(jsii_name="apiId")
    def api_id(self) -> str:
        return jsii.get(self, "apiId")

    @api_id.setter
    def api_id(self, value: str) -> None:
        jsii.set(self, "apiId", value)

    @builtins.property
    @jsii.member(jsii_name="integrationType")
    def integration_type(self) -> str:
        return jsii.get(self, "integrationType")

    @integration_type.setter
    def integration_type(self, value: str) -> None:
        jsii.set(self, "integrationType", value)

    @builtins.property
    @jsii.member(jsii_name="connectionId")
    def connection_id(self) -> typing.Optional[str]:
        return jsii.get(self, "connectionId")

    @connection_id.setter
    def connection_id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "connectionId", value)

    @builtins.property
    @jsii.member(jsii_name="connectionType")
    def connection_type(self) -> typing.Optional[str]:
        return jsii.get(self, "connectionType")

    @connection_type.setter
    def connection_type(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "connectionType", value)

    @builtins.property
    @jsii.member(jsii_name="contentHandlingStrategy")
    def content_handling_strategy(self) -> typing.Optional[str]:
        return jsii.get(self, "contentHandlingStrategy")

    @content_handling_strategy.setter
    def content_handling_strategy(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "contentHandlingStrategy", value)

    @builtins.property
    @jsii.member(jsii_name="credentialsArn")
    def credentials_arn(self) -> typing.Optional[str]:
        return jsii.get(self, "credentialsArn")

    @credentials_arn.setter
    def credentials_arn(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "credentialsArn", value)

    @builtins.property
    @jsii.member(jsii_name="description")
    def description(self) -> typing.Optional[str]:
        return jsii.get(self, "description")

    @description.setter
    def description(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "description", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="integrationMethod")
    def integration_method(self) -> typing.Optional[str]:
        return jsii.get(self, "integrationMethod")

    @integration_method.setter
    def integration_method(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "integrationMethod", value)

    @builtins.property
    @jsii.member(jsii_name="integrationUri")
    def integration_uri(self) -> typing.Optional[str]:
        return jsii.get(self, "integrationUri")

    @integration_uri.setter
    def integration_uri(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "integrationUri", value)

    @builtins.property
    @jsii.member(jsii_name="passthroughBehavior")
    def passthrough_behavior(self) -> typing.Optional[str]:
        return jsii.get(self, "passthroughBehavior")

    @passthrough_behavior.setter
    def passthrough_behavior(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "passthroughBehavior", value)

    @builtins.property
    @jsii.member(jsii_name="payloadFormatVersion")
    def payload_format_version(self) -> typing.Optional[str]:
        return jsii.get(self, "payloadFormatVersion")

    @payload_format_version.setter
    def payload_format_version(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "payloadFormatVersion", value)

    @builtins.property
    @jsii.member(jsii_name="requestTemplates")
    def request_templates(self) -> typing.Optional[typing.Mapping[str, str]]:
        return jsii.get(self, "requestTemplates")

    @request_templates.setter
    def request_templates(
        self, value: typing.Optional[typing.Mapping[str, str]]
    ) -> None:
        jsii.set(self, "requestTemplates", value)

    @builtins.property
    @jsii.member(jsii_name="templateSelectionExpression")
    def template_selection_expression(self) -> typing.Optional[str]:
        return jsii.get(self, "templateSelectionExpression")

    @template_selection_expression.setter
    def template_selection_expression(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "templateSelectionExpression", value)

    @builtins.property
    @jsii.member(jsii_name="timeoutMilliseconds")
    def timeout_milliseconds(self) -> typing.Optional[jsii.Number]:
        return jsii.get(self, "timeoutMilliseconds")

    @timeout_milliseconds.setter
    def timeout_milliseconds(self, value: typing.Optional[jsii.Number]) -> None:
        jsii.set(self, "timeoutMilliseconds", value)


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.Apigatewayv2IntegrationConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "api_id": "apiId",
        "integration_type": "integrationType",
        "connection_id": "connectionId",
        "connection_type": "connectionType",
        "content_handling_strategy": "contentHandlingStrategy",
        "credentials_arn": "credentialsArn",
        "description": "description",
        "integration_method": "integrationMethod",
        "integration_uri": "integrationUri",
        "passthrough_behavior": "passthroughBehavior",
        "payload_format_version": "payloadFormatVersion",
        "request_templates": "requestTemplates",
        "template_selection_expression": "templateSelectionExpression",
        "timeout_milliseconds": "timeoutMilliseconds",
    },
)
class Apigatewayv2IntegrationConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        api_id: str,
        integration_type: str,
        connection_id: typing.Optional[str] = None,
        connection_type: typing.Optional[str] = None,
        content_handling_strategy: typing.Optional[str] = None,
        credentials_arn: typing.Optional[str] = None,
        description: typing.Optional[str] = None,
        integration_method: typing.Optional[str] = None,
        integration_uri: typing.Optional[str] = None,
        passthrough_behavior: typing.Optional[str] = None,
        payload_format_version: typing.Optional[str] = None,
        request_templates: typing.Optional[typing.Mapping[str, str]] = None,
        template_selection_expression: typing.Optional[str] = None,
        timeout_milliseconds: typing.Optional[jsii.Number] = None,
    ) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param api_id: 
        :param integration_type: 
        :param connection_id: 
        :param connection_type: 
        :param content_handling_strategy: 
        :param credentials_arn: 
        :param description: 
        :param integration_method: 
        :param integration_uri: 
        :param passthrough_behavior: 
        :param payload_format_version: 
        :param request_templates: 
        :param template_selection_expression: 
        :param timeout_milliseconds: 
        """
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        self._values = {
            "api_id": api_id,
            "integration_type": integration_type,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if connection_id is not None:
            self._values["connection_id"] = connection_id
        if connection_type is not None:
            self._values["connection_type"] = connection_type
        if content_handling_strategy is not None:
            self._values["content_handling_strategy"] = content_handling_strategy
        if credentials_arn is not None:
            self._values["credentials_arn"] = credentials_arn
        if description is not None:
            self._values["description"] = description
        if integration_method is not None:
            self._values["integration_method"] = integration_method
        if integration_uri is not None:
            self._values["integration_uri"] = integration_uri
        if passthrough_behavior is not None:
            self._values["passthrough_behavior"] = passthrough_behavior
        if payload_format_version is not None:
            self._values["payload_format_version"] = payload_format_version
        if request_templates is not None:
            self._values["request_templates"] = request_templates
        if template_selection_expression is not None:
            self._values[
                "template_selection_expression"
            ] = template_selection_expression
        if timeout_milliseconds is not None:
            self._values["timeout_milliseconds"] = timeout_milliseconds

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("count")

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.TerraformResource]]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("depends_on")

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("lifecycle")

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("provider")

    @builtins.property
    def api_id(self) -> str:
        return self._values.get("api_id")

    @builtins.property
    def integration_type(self) -> str:
        return self._values.get("integration_type")

    @builtins.property
    def connection_id(self) -> typing.Optional[str]:
        return self._values.get("connection_id")

    @builtins.property
    def connection_type(self) -> typing.Optional[str]:
        return self._values.get("connection_type")

    @builtins.property
    def content_handling_strategy(self) -> typing.Optional[str]:
        return self._values.get("content_handling_strategy")

    @builtins.property
    def credentials_arn(self) -> typing.Optional[str]:
        return self._values.get("credentials_arn")

    @builtins.property
    def description(self) -> typing.Optional[str]:
        return self._values.get("description")

    @builtins.property
    def integration_method(self) -> typing.Optional[str]:
        return self._values.get("integration_method")

    @builtins.property
    def integration_uri(self) -> typing.Optional[str]:
        return self._values.get("integration_uri")

    @builtins.property
    def passthrough_behavior(self) -> typing.Optional[str]:
        return self._values.get("passthrough_behavior")

    @builtins.property
    def payload_format_version(self) -> typing.Optional[str]:
        return self._values.get("payload_format_version")

    @builtins.property
    def request_templates(self) -> typing.Optional[typing.Mapping[str, str]]:
        return self._values.get("request_templates")

    @builtins.property
    def template_selection_expression(self) -> typing.Optional[str]:
        return self._values.get("template_selection_expression")

    @builtins.property
    def timeout_milliseconds(self) -> typing.Optional[jsii.Number]:
        return self._values.get("timeout_milliseconds")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "Apigatewayv2IntegrationConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class Apigatewayv2IntegrationResponse(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="@skorfmann/cdktf-provider-aws.Apigatewayv2IntegrationResponse",
):
    def __init__(
        self,
        scope: constructs.Construct,
        id: str,
        *,
        api_id: str,
        integration_id: str,
        integration_response_key: str,
        content_handling_strategy: typing.Optional[str] = None,
        response_templates: typing.Optional[typing.Mapping[str, str]] = None,
        template_selection_expression: typing.Optional[str] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param api_id: 
        :param integration_id: 
        :param integration_response_key: 
        :param content_handling_strategy: 
        :param response_templates: 
        :param template_selection_expression: 
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = Apigatewayv2IntegrationResponseConfig(
            api_id=api_id,
            integration_id=integration_id,
            integration_response_key=integration_response_key,
            content_handling_strategy=content_handling_strategy,
            response_templates=response_templates,
            template_selection_expression=template_selection_expression,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(Apigatewayv2IntegrationResponse, self, [scope, id, config])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property
    @jsii.member(jsii_name="apiId")
    def api_id(self) -> str:
        return jsii.get(self, "apiId")

    @api_id.setter
    def api_id(self, value: str) -> None:
        jsii.set(self, "apiId", value)

    @builtins.property
    @jsii.member(jsii_name="integrationId")
    def integration_id(self) -> str:
        return jsii.get(self, "integrationId")

    @integration_id.setter
    def integration_id(self, value: str) -> None:
        jsii.set(self, "integrationId", value)

    @builtins.property
    @jsii.member(jsii_name="integrationResponseKey")
    def integration_response_key(self) -> str:
        return jsii.get(self, "integrationResponseKey")

    @integration_response_key.setter
    def integration_response_key(self, value: str) -> None:
        jsii.set(self, "integrationResponseKey", value)

    @builtins.property
    @jsii.member(jsii_name="contentHandlingStrategy")
    def content_handling_strategy(self) -> typing.Optional[str]:
        return jsii.get(self, "contentHandlingStrategy")

    @content_handling_strategy.setter
    def content_handling_strategy(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "contentHandlingStrategy", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="responseTemplates")
    def response_templates(self) -> typing.Optional[typing.Mapping[str, str]]:
        return jsii.get(self, "responseTemplates")

    @response_templates.setter
    def response_templates(
        self, value: typing.Optional[typing.Mapping[str, str]]
    ) -> None:
        jsii.set(self, "responseTemplates", value)

    @builtins.property
    @jsii.member(jsii_name="templateSelectionExpression")
    def template_selection_expression(self) -> typing.Optional[str]:
        return jsii.get(self, "templateSelectionExpression")

    @template_selection_expression.setter
    def template_selection_expression(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "templateSelectionExpression", value)


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.Apigatewayv2IntegrationResponseConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "api_id": "apiId",
        "integration_id": "integrationId",
        "integration_response_key": "integrationResponseKey",
        "content_handling_strategy": "contentHandlingStrategy",
        "response_templates": "responseTemplates",
        "template_selection_expression": "templateSelectionExpression",
    },
)
class Apigatewayv2IntegrationResponseConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        api_id: str,
        integration_id: str,
        integration_response_key: str,
        content_handling_strategy: typing.Optional[str] = None,
        response_templates: typing.Optional[typing.Mapping[str, str]] = None,
        template_selection_expression: typing.Optional[str] = None,
    ) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param api_id: 
        :param integration_id: 
        :param integration_response_key: 
        :param content_handling_strategy: 
        :param response_templates: 
        :param template_selection_expression: 
        """
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        self._values = {
            "api_id": api_id,
            "integration_id": integration_id,
            "integration_response_key": integration_response_key,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if content_handling_strategy is not None:
            self._values["content_handling_strategy"] = content_handling_strategy
        if response_templates is not None:
            self._values["response_templates"] = response_templates
        if template_selection_expression is not None:
            self._values[
                "template_selection_expression"
            ] = template_selection_expression

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("count")

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.TerraformResource]]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("depends_on")

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("lifecycle")

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("provider")

    @builtins.property
    def api_id(self) -> str:
        return self._values.get("api_id")

    @builtins.property
    def integration_id(self) -> str:
        return self._values.get("integration_id")

    @builtins.property
    def integration_response_key(self) -> str:
        return self._values.get("integration_response_key")

    @builtins.property
    def content_handling_strategy(self) -> typing.Optional[str]:
        return self._values.get("content_handling_strategy")

    @builtins.property
    def response_templates(self) -> typing.Optional[typing.Mapping[str, str]]:
        return self._values.get("response_templates")

    @builtins.property
    def template_selection_expression(self) -> typing.Optional[str]:
        return self._values.get("template_selection_expression")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "Apigatewayv2IntegrationResponseConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class Apigatewayv2Model(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="@skorfmann/cdktf-provider-aws.Apigatewayv2Model",
):
    def __init__(
        self,
        scope: constructs.Construct,
        id: str,
        *,
        api_id: str,
        content_type: str,
        name: str,
        schema: str,
        description: typing.Optional[str] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param api_id: 
        :param content_type: 
        :param name: 
        :param schema: 
        :param description: 
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = Apigatewayv2ModelConfig(
            api_id=api_id,
            content_type=content_type,
            name=name,
            schema=schema,
            description=description,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(Apigatewayv2Model, self, [scope, id, config])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property
    @jsii.member(jsii_name="apiId")
    def api_id(self) -> str:
        return jsii.get(self, "apiId")

    @api_id.setter
    def api_id(self, value: str) -> None:
        jsii.set(self, "apiId", value)

    @builtins.property
    @jsii.member(jsii_name="contentType")
    def content_type(self) -> str:
        return jsii.get(self, "contentType")

    @content_type.setter
    def content_type(self, value: str) -> None:
        jsii.set(self, "contentType", value)

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> str:
        return jsii.get(self, "name")

    @name.setter
    def name(self, value: str) -> None:
        jsii.set(self, "name", value)

    @builtins.property
    @jsii.member(jsii_name="schema")
    def schema(self) -> str:
        return jsii.get(self, "schema")

    @schema.setter
    def schema(self, value: str) -> None:
        jsii.set(self, "schema", value)

    @builtins.property
    @jsii.member(jsii_name="description")
    def description(self) -> typing.Optional[str]:
        return jsii.get(self, "description")

    @description.setter
    def description(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "description", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.Apigatewayv2ModelConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "api_id": "apiId",
        "content_type": "contentType",
        "name": "name",
        "schema": "schema",
        "description": "description",
    },
)
class Apigatewayv2ModelConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        api_id: str,
        content_type: str,
        name: str,
        schema: str,
        description: typing.Optional[str] = None,
    ) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param api_id: 
        :param content_type: 
        :param name: 
        :param schema: 
        :param description: 
        """
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        self._values = {
            "api_id": api_id,
            "content_type": content_type,
            "name": name,
            "schema": schema,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if description is not None:
            self._values["description"] = description

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("count")

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.TerraformResource]]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("depends_on")

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("lifecycle")

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("provider")

    @builtins.property
    def api_id(self) -> str:
        return self._values.get("api_id")

    @builtins.property
    def content_type(self) -> str:
        return self._values.get("content_type")

    @builtins.property
    def name(self) -> str:
        return self._values.get("name")

    @builtins.property
    def schema(self) -> str:
        return self._values.get("schema")

    @builtins.property
    def description(self) -> typing.Optional[str]:
        return self._values.get("description")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "Apigatewayv2ModelConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class Apigatewayv2Route(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="@skorfmann/cdktf-provider-aws.Apigatewayv2Route",
):
    def __init__(
        self,
        scope: constructs.Construct,
        id: str,
        *,
        api_id: str,
        route_key: str,
        api_key_required: typing.Optional[bool] = None,
        authorization_scopes: typing.Optional[typing.List[str]] = None,
        authorization_type: typing.Optional[str] = None,
        authorizer_id: typing.Optional[str] = None,
        model_selection_expression: typing.Optional[str] = None,
        operation_name: typing.Optional[str] = None,
        request_models: typing.Optional[typing.Mapping[str, str]] = None,
        route_response_selection_expression: typing.Optional[str] = None,
        target: typing.Optional[str] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param api_id: 
        :param route_key: 
        :param api_key_required: 
        :param authorization_scopes: 
        :param authorization_type: 
        :param authorizer_id: 
        :param model_selection_expression: 
        :param operation_name: 
        :param request_models: 
        :param route_response_selection_expression: 
        :param target: 
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = Apigatewayv2RouteConfig(
            api_id=api_id,
            route_key=route_key,
            api_key_required=api_key_required,
            authorization_scopes=authorization_scopes,
            authorization_type=authorization_type,
            authorizer_id=authorizer_id,
            model_selection_expression=model_selection_expression,
            operation_name=operation_name,
            request_models=request_models,
            route_response_selection_expression=route_response_selection_expression,
            target=target,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(Apigatewayv2Route, self, [scope, id, config])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property
    @jsii.member(jsii_name="apiId")
    def api_id(self) -> str:
        return jsii.get(self, "apiId")

    @api_id.setter
    def api_id(self, value: str) -> None:
        jsii.set(self, "apiId", value)

    @builtins.property
    @jsii.member(jsii_name="routeKey")
    def route_key(self) -> str:
        return jsii.get(self, "routeKey")

    @route_key.setter
    def route_key(self, value: str) -> None:
        jsii.set(self, "routeKey", value)

    @builtins.property
    @jsii.member(jsii_name="apiKeyRequired")
    def api_key_required(self) -> typing.Optional[bool]:
        return jsii.get(self, "apiKeyRequired")

    @api_key_required.setter
    def api_key_required(self, value: typing.Optional[bool]) -> None:
        jsii.set(self, "apiKeyRequired", value)

    @builtins.property
    @jsii.member(jsii_name="authorizationScopes")
    def authorization_scopes(self) -> typing.Optional[typing.List[str]]:
        return jsii.get(self, "authorizationScopes")

    @authorization_scopes.setter
    def authorization_scopes(self, value: typing.Optional[typing.List[str]]) -> None:
        jsii.set(self, "authorizationScopes", value)

    @builtins.property
    @jsii.member(jsii_name="authorizationType")
    def authorization_type(self) -> typing.Optional[str]:
        return jsii.get(self, "authorizationType")

    @authorization_type.setter
    def authorization_type(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "authorizationType", value)

    @builtins.property
    @jsii.member(jsii_name="authorizerId")
    def authorizer_id(self) -> typing.Optional[str]:
        return jsii.get(self, "authorizerId")

    @authorizer_id.setter
    def authorizer_id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "authorizerId", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="modelSelectionExpression")
    def model_selection_expression(self) -> typing.Optional[str]:
        return jsii.get(self, "modelSelectionExpression")

    @model_selection_expression.setter
    def model_selection_expression(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "modelSelectionExpression", value)

    @builtins.property
    @jsii.member(jsii_name="operationName")
    def operation_name(self) -> typing.Optional[str]:
        return jsii.get(self, "operationName")

    @operation_name.setter
    def operation_name(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "operationName", value)

    @builtins.property
    @jsii.member(jsii_name="requestModels")
    def request_models(self) -> typing.Optional[typing.Mapping[str, str]]:
        return jsii.get(self, "requestModels")

    @request_models.setter
    def request_models(self, value: typing.Optional[typing.Mapping[str, str]]) -> None:
        jsii.set(self, "requestModels", value)

    @builtins.property
    @jsii.member(jsii_name="routeResponseSelectionExpression")
    def route_response_selection_expression(self) -> typing.Optional[str]:
        return jsii.get(self, "routeResponseSelectionExpression")

    @route_response_selection_expression.setter
    def route_response_selection_expression(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "routeResponseSelectionExpression", value)

    @builtins.property
    @jsii.member(jsii_name="target")
    def target(self) -> typing.Optional[str]:
        return jsii.get(self, "target")

    @target.setter
    def target(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "target", value)


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.Apigatewayv2RouteConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "api_id": "apiId",
        "route_key": "routeKey",
        "api_key_required": "apiKeyRequired",
        "authorization_scopes": "authorizationScopes",
        "authorization_type": "authorizationType",
        "authorizer_id": "authorizerId",
        "model_selection_expression": "modelSelectionExpression",
        "operation_name": "operationName",
        "request_models": "requestModels",
        "route_response_selection_expression": "routeResponseSelectionExpression",
        "target": "target",
    },
)
class Apigatewayv2RouteConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        api_id: str,
        route_key: str,
        api_key_required: typing.Optional[bool] = None,
        authorization_scopes: typing.Optional[typing.List[str]] = None,
        authorization_type: typing.Optional[str] = None,
        authorizer_id: typing.Optional[str] = None,
        model_selection_expression: typing.Optional[str] = None,
        operation_name: typing.Optional[str] = None,
        request_models: typing.Optional[typing.Mapping[str, str]] = None,
        route_response_selection_expression: typing.Optional[str] = None,
        target: typing.Optional[str] = None,
    ) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param api_id: 
        :param route_key: 
        :param api_key_required: 
        :param authorization_scopes: 
        :param authorization_type: 
        :param authorizer_id: 
        :param model_selection_expression: 
        :param operation_name: 
        :param request_models: 
        :param route_response_selection_expression: 
        :param target: 
        """
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        self._values = {
            "api_id": api_id,
            "route_key": route_key,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if api_key_required is not None:
            self._values["api_key_required"] = api_key_required
        if authorization_scopes is not None:
            self._values["authorization_scopes"] = authorization_scopes
        if authorization_type is not None:
            self._values["authorization_type"] = authorization_type
        if authorizer_id is not None:
            self._values["authorizer_id"] = authorizer_id
        if model_selection_expression is not None:
            self._values["model_selection_expression"] = model_selection_expression
        if operation_name is not None:
            self._values["operation_name"] = operation_name
        if request_models is not None:
            self._values["request_models"] = request_models
        if route_response_selection_expression is not None:
            self._values[
                "route_response_selection_expression"
            ] = route_response_selection_expression
        if target is not None:
            self._values["target"] = target

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("count")

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.TerraformResource]]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("depends_on")

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("lifecycle")

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("provider")

    @builtins.property
    def api_id(self) -> str:
        return self._values.get("api_id")

    @builtins.property
    def route_key(self) -> str:
        return self._values.get("route_key")

    @builtins.property
    def api_key_required(self) -> typing.Optional[bool]:
        return self._values.get("api_key_required")

    @builtins.property
    def authorization_scopes(self) -> typing.Optional[typing.List[str]]:
        return self._values.get("authorization_scopes")

    @builtins.property
    def authorization_type(self) -> typing.Optional[str]:
        return self._values.get("authorization_type")

    @builtins.property
    def authorizer_id(self) -> typing.Optional[str]:
        return self._values.get("authorizer_id")

    @builtins.property
    def model_selection_expression(self) -> typing.Optional[str]:
        return self._values.get("model_selection_expression")

    @builtins.property
    def operation_name(self) -> typing.Optional[str]:
        return self._values.get("operation_name")

    @builtins.property
    def request_models(self) -> typing.Optional[typing.Mapping[str, str]]:
        return self._values.get("request_models")

    @builtins.property
    def route_response_selection_expression(self) -> typing.Optional[str]:
        return self._values.get("route_response_selection_expression")

    @builtins.property
    def target(self) -> typing.Optional[str]:
        return self._values.get("target")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "Apigatewayv2RouteConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class Apigatewayv2RouteResponse(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="@skorfmann/cdktf-provider-aws.Apigatewayv2RouteResponse",
):
    def __init__(
        self,
        scope: constructs.Construct,
        id: str,
        *,
        api_id: str,
        route_id: str,
        route_response_key: str,
        model_selection_expression: typing.Optional[str] = None,
        response_models: typing.Optional[typing.Mapping[str, str]] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param api_id: 
        :param route_id: 
        :param route_response_key: 
        :param model_selection_expression: 
        :param response_models: 
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = Apigatewayv2RouteResponseConfig(
            api_id=api_id,
            route_id=route_id,
            route_response_key=route_response_key,
            model_selection_expression=model_selection_expression,
            response_models=response_models,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(Apigatewayv2RouteResponse, self, [scope, id, config])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property
    @jsii.member(jsii_name="apiId")
    def api_id(self) -> str:
        return jsii.get(self, "apiId")

    @api_id.setter
    def api_id(self, value: str) -> None:
        jsii.set(self, "apiId", value)

    @builtins.property
    @jsii.member(jsii_name="routeId")
    def route_id(self) -> str:
        return jsii.get(self, "routeId")

    @route_id.setter
    def route_id(self, value: str) -> None:
        jsii.set(self, "routeId", value)

    @builtins.property
    @jsii.member(jsii_name="routeResponseKey")
    def route_response_key(self) -> str:
        return jsii.get(self, "routeResponseKey")

    @route_response_key.setter
    def route_response_key(self, value: str) -> None:
        jsii.set(self, "routeResponseKey", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="modelSelectionExpression")
    def model_selection_expression(self) -> typing.Optional[str]:
        return jsii.get(self, "modelSelectionExpression")

    @model_selection_expression.setter
    def model_selection_expression(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "modelSelectionExpression", value)

    @builtins.property
    @jsii.member(jsii_name="responseModels")
    def response_models(self) -> typing.Optional[typing.Mapping[str, str]]:
        return jsii.get(self, "responseModels")

    @response_models.setter
    def response_models(self, value: typing.Optional[typing.Mapping[str, str]]) -> None:
        jsii.set(self, "responseModels", value)


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.Apigatewayv2RouteResponseConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "api_id": "apiId",
        "route_id": "routeId",
        "route_response_key": "routeResponseKey",
        "model_selection_expression": "modelSelectionExpression",
        "response_models": "responseModels",
    },
)
class Apigatewayv2RouteResponseConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        api_id: str,
        route_id: str,
        route_response_key: str,
        model_selection_expression: typing.Optional[str] = None,
        response_models: typing.Optional[typing.Mapping[str, str]] = None,
    ) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param api_id: 
        :param route_id: 
        :param route_response_key: 
        :param model_selection_expression: 
        :param response_models: 
        """
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        self._values = {
            "api_id": api_id,
            "route_id": route_id,
            "route_response_key": route_response_key,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if model_selection_expression is not None:
            self._values["model_selection_expression"] = model_selection_expression
        if response_models is not None:
            self._values["response_models"] = response_models

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("count")

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.TerraformResource]]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("depends_on")

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("lifecycle")

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("provider")

    @builtins.property
    def api_id(self) -> str:
        return self._values.get("api_id")

    @builtins.property
    def route_id(self) -> str:
        return self._values.get("route_id")

    @builtins.property
    def route_response_key(self) -> str:
        return self._values.get("route_response_key")

    @builtins.property
    def model_selection_expression(self) -> typing.Optional[str]:
        return self._values.get("model_selection_expression")

    @builtins.property
    def response_models(self) -> typing.Optional[typing.Mapping[str, str]]:
        return self._values.get("response_models")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "Apigatewayv2RouteResponseConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class Apigatewayv2Stage(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="@skorfmann/cdktf-provider-aws.Apigatewayv2Stage",
):
    def __init__(
        self,
        scope: constructs.Construct,
        id: str,
        *,
        api_id: str,
        name: str,
        access_log_settings: typing.Optional[
            typing.List["Apigatewayv2StageAccessLogSettings"]
        ] = None,
        auto_deploy: typing.Optional[bool] = None,
        client_certificate_id: typing.Optional[str] = None,
        default_route_settings: typing.Optional[
            typing.List["Apigatewayv2StageDefaultRouteSettings"]
        ] = None,
        deployment_id: typing.Optional[str] = None,
        description: typing.Optional[str] = None,
        route_settings: typing.Optional[
            typing.List["Apigatewayv2StageRouteSettings"]
        ] = None,
        stage_variables: typing.Optional[typing.Mapping[str, str]] = None,
        tags: typing.Optional[typing.Mapping[str, str]] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param api_id: 
        :param name: 
        :param access_log_settings: access_log_settings block.
        :param auto_deploy: 
        :param client_certificate_id: 
        :param default_route_settings: default_route_settings block.
        :param deployment_id: 
        :param description: 
        :param route_settings: route_settings block.
        :param stage_variables: 
        :param tags: 
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = Apigatewayv2StageConfig(
            api_id=api_id,
            name=name,
            access_log_settings=access_log_settings,
            auto_deploy=auto_deploy,
            client_certificate_id=client_certificate_id,
            default_route_settings=default_route_settings,
            deployment_id=deployment_id,
            description=description,
            route_settings=route_settings,
            stage_variables=stage_variables,
            tags=tags,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(Apigatewayv2Stage, self, [scope, id, config])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property
    @jsii.member(jsii_name="arn")
    def arn(self) -> str:
        return jsii.get(self, "arn")

    @builtins.property
    @jsii.member(jsii_name="executionArn")
    def execution_arn(self) -> str:
        return jsii.get(self, "executionArn")

    @builtins.property
    @jsii.member(jsii_name="invokeUrl")
    def invoke_url(self) -> str:
        return jsii.get(self, "invokeUrl")

    @builtins.property
    @jsii.member(jsii_name="apiId")
    def api_id(self) -> str:
        return jsii.get(self, "apiId")

    @api_id.setter
    def api_id(self, value: str) -> None:
        jsii.set(self, "apiId", value)

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> str:
        return jsii.get(self, "name")

    @name.setter
    def name(self, value: str) -> None:
        jsii.set(self, "name", value)

    @builtins.property
    @jsii.member(jsii_name="accessLogSettings")
    def access_log_settings(
        self,
    ) -> typing.Optional[typing.List["Apigatewayv2StageAccessLogSettings"]]:
        return jsii.get(self, "accessLogSettings")

    @access_log_settings.setter
    def access_log_settings(
        self, value: typing.Optional[typing.List["Apigatewayv2StageAccessLogSettings"]]
    ) -> None:
        jsii.set(self, "accessLogSettings", value)

    @builtins.property
    @jsii.member(jsii_name="autoDeploy")
    def auto_deploy(self) -> typing.Optional[bool]:
        return jsii.get(self, "autoDeploy")

    @auto_deploy.setter
    def auto_deploy(self, value: typing.Optional[bool]) -> None:
        jsii.set(self, "autoDeploy", value)

    @builtins.property
    @jsii.member(jsii_name="clientCertificateId")
    def client_certificate_id(self) -> typing.Optional[str]:
        return jsii.get(self, "clientCertificateId")

    @client_certificate_id.setter
    def client_certificate_id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "clientCertificateId", value)

    @builtins.property
    @jsii.member(jsii_name="defaultRouteSettings")
    def default_route_settings(
        self,
    ) -> typing.Optional[typing.List["Apigatewayv2StageDefaultRouteSettings"]]:
        return jsii.get(self, "defaultRouteSettings")

    @default_route_settings.setter
    def default_route_settings(
        self,
        value: typing.Optional[typing.List["Apigatewayv2StageDefaultRouteSettings"]],
    ) -> None:
        jsii.set(self, "defaultRouteSettings", value)

    @builtins.property
    @jsii.member(jsii_name="deploymentId")
    def deployment_id(self) -> typing.Optional[str]:
        return jsii.get(self, "deploymentId")

    @deployment_id.setter
    def deployment_id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "deploymentId", value)

    @builtins.property
    @jsii.member(jsii_name="description")
    def description(self) -> typing.Optional[str]:
        return jsii.get(self, "description")

    @description.setter
    def description(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "description", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="routeSettings")
    def route_settings(
        self,
    ) -> typing.Optional[typing.List["Apigatewayv2StageRouteSettings"]]:
        return jsii.get(self, "routeSettings")

    @route_settings.setter
    def route_settings(
        self, value: typing.Optional[typing.List["Apigatewayv2StageRouteSettings"]]
    ) -> None:
        jsii.set(self, "routeSettings", value)

    @builtins.property
    @jsii.member(jsii_name="stageVariables")
    def stage_variables(self) -> typing.Optional[typing.Mapping[str, str]]:
        return jsii.get(self, "stageVariables")

    @stage_variables.setter
    def stage_variables(self, value: typing.Optional[typing.Mapping[str, str]]) -> None:
        jsii.set(self, "stageVariables", value)

    @builtins.property
    @jsii.member(jsii_name="tags")
    def tags(self) -> typing.Optional[typing.Mapping[str, str]]:
        return jsii.get(self, "tags")

    @tags.setter
    def tags(self, value: typing.Optional[typing.Mapping[str, str]]) -> None:
        jsii.set(self, "tags", value)


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.Apigatewayv2StageAccessLogSettings",
    jsii_struct_bases=[],
    name_mapping={"destination_arn": "destinationArn", "format": "format"},
)
class Apigatewayv2StageAccessLogSettings:
    def __init__(self, *, destination_arn: str, format: str) -> None:
        """
        :param destination_arn: 
        :param format: 
        """
        self._values = {
            "destination_arn": destination_arn,
            "format": format,
        }

    @builtins.property
    def destination_arn(self) -> str:
        return self._values.get("destination_arn")

    @builtins.property
    def format(self) -> str:
        return self._values.get("format")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "Apigatewayv2StageAccessLogSettings(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.Apigatewayv2StageConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "api_id": "apiId",
        "name": "name",
        "access_log_settings": "accessLogSettings",
        "auto_deploy": "autoDeploy",
        "client_certificate_id": "clientCertificateId",
        "default_route_settings": "defaultRouteSettings",
        "deployment_id": "deploymentId",
        "description": "description",
        "route_settings": "routeSettings",
        "stage_variables": "stageVariables",
        "tags": "tags",
    },
)
class Apigatewayv2StageConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        api_id: str,
        name: str,
        access_log_settings: typing.Optional[
            typing.List["Apigatewayv2StageAccessLogSettings"]
        ] = None,
        auto_deploy: typing.Optional[bool] = None,
        client_certificate_id: typing.Optional[str] = None,
        default_route_settings: typing.Optional[
            typing.List["Apigatewayv2StageDefaultRouteSettings"]
        ] = None,
        deployment_id: typing.Optional[str] = None,
        description: typing.Optional[str] = None,
        route_settings: typing.Optional[
            typing.List["Apigatewayv2StageRouteSettings"]
        ] = None,
        stage_variables: typing.Optional[typing.Mapping[str, str]] = None,
        tags: typing.Optional[typing.Mapping[str, str]] = None,
    ) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param api_id: 
        :param name: 
        :param access_log_settings: access_log_settings block.
        :param auto_deploy: 
        :param client_certificate_id: 
        :param default_route_settings: default_route_settings block.
        :param deployment_id: 
        :param description: 
        :param route_settings: route_settings block.
        :param stage_variables: 
        :param tags: 
        """
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        self._values = {
            "api_id": api_id,
            "name": name,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if access_log_settings is not None:
            self._values["access_log_settings"] = access_log_settings
        if auto_deploy is not None:
            self._values["auto_deploy"] = auto_deploy
        if client_certificate_id is not None:
            self._values["client_certificate_id"] = client_certificate_id
        if default_route_settings is not None:
            self._values["default_route_settings"] = default_route_settings
        if deployment_id is not None:
            self._values["deployment_id"] = deployment_id
        if description is not None:
            self._values["description"] = description
        if route_settings is not None:
            self._values["route_settings"] = route_settings
        if stage_variables is not None:
            self._values["stage_variables"] = stage_variables
        if tags is not None:
            self._values["tags"] = tags

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("count")

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.TerraformResource]]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("depends_on")

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("lifecycle")

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("provider")

    @builtins.property
    def api_id(self) -> str:
        return self._values.get("api_id")

    @builtins.property
    def name(self) -> str:
        return self._values.get("name")

    @builtins.property
    def access_log_settings(
        self,
    ) -> typing.Optional[typing.List["Apigatewayv2StageAccessLogSettings"]]:
        """access_log_settings block."""
        return self._values.get("access_log_settings")

    @builtins.property
    def auto_deploy(self) -> typing.Optional[bool]:
        return self._values.get("auto_deploy")

    @builtins.property
    def client_certificate_id(self) -> typing.Optional[str]:
        return self._values.get("client_certificate_id")

    @builtins.property
    def default_route_settings(
        self,
    ) -> typing.Optional[typing.List["Apigatewayv2StageDefaultRouteSettings"]]:
        """default_route_settings block."""
        return self._values.get("default_route_settings")

    @builtins.property
    def deployment_id(self) -> typing.Optional[str]:
        return self._values.get("deployment_id")

    @builtins.property
    def description(self) -> typing.Optional[str]:
        return self._values.get("description")

    @builtins.property
    def route_settings(
        self,
    ) -> typing.Optional[typing.List["Apigatewayv2StageRouteSettings"]]:
        """route_settings block."""
        return self._values.get("route_settings")

    @builtins.property
    def stage_variables(self) -> typing.Optional[typing.Mapping[str, str]]:
        return self._values.get("stage_variables")

    @builtins.property
    def tags(self) -> typing.Optional[typing.Mapping[str, str]]:
        return self._values.get("tags")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "Apigatewayv2StageConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.Apigatewayv2StageDefaultRouteSettings",
    jsii_struct_bases=[],
    name_mapping={
        "data_trace_enabled": "dataTraceEnabled",
        "detailed_metrics_enabled": "detailedMetricsEnabled",
        "logging_level": "loggingLevel",
        "throttling_burst_limit": "throttlingBurstLimit",
        "throttling_rate_limit": "throttlingRateLimit",
    },
)
class Apigatewayv2StageDefaultRouteSettings:
    def __init__(
        self,
        *,
        data_trace_enabled: typing.Optional[bool] = None,
        detailed_metrics_enabled: typing.Optional[bool] = None,
        logging_level: typing.Optional[str] = None,
        throttling_burst_limit: typing.Optional[jsii.Number] = None,
        throttling_rate_limit: typing.Optional[jsii.Number] = None,
    ) -> None:
        """
        :param data_trace_enabled: 
        :param detailed_metrics_enabled: 
        :param logging_level: 
        :param throttling_burst_limit: 
        :param throttling_rate_limit: 
        """
        self._values = {}
        if data_trace_enabled is not None:
            self._values["data_trace_enabled"] = data_trace_enabled
        if detailed_metrics_enabled is not None:
            self._values["detailed_metrics_enabled"] = detailed_metrics_enabled
        if logging_level is not None:
            self._values["logging_level"] = logging_level
        if throttling_burst_limit is not None:
            self._values["throttling_burst_limit"] = throttling_burst_limit
        if throttling_rate_limit is not None:
            self._values["throttling_rate_limit"] = throttling_rate_limit

    @builtins.property
    def data_trace_enabled(self) -> typing.Optional[bool]:
        return self._values.get("data_trace_enabled")

    @builtins.property
    def detailed_metrics_enabled(self) -> typing.Optional[bool]:
        return self._values.get("detailed_metrics_enabled")

    @builtins.property
    def logging_level(self) -> typing.Optional[str]:
        return self._values.get("logging_level")

    @builtins.property
    def throttling_burst_limit(self) -> typing.Optional[jsii.Number]:
        return self._values.get("throttling_burst_limit")

    @builtins.property
    def throttling_rate_limit(self) -> typing.Optional[jsii.Number]:
        return self._values.get("throttling_rate_limit")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "Apigatewayv2StageDefaultRouteSettings(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.Apigatewayv2StageRouteSettings",
    jsii_struct_bases=[],
    name_mapping={
        "route_key": "routeKey",
        "data_trace_enabled": "dataTraceEnabled",
        "detailed_metrics_enabled": "detailedMetricsEnabled",
        "logging_level": "loggingLevel",
        "throttling_burst_limit": "throttlingBurstLimit",
        "throttling_rate_limit": "throttlingRateLimit",
    },
)
class Apigatewayv2StageRouteSettings:
    def __init__(
        self,
        *,
        route_key: str,
        data_trace_enabled: typing.Optional[bool] = None,
        detailed_metrics_enabled: typing.Optional[bool] = None,
        logging_level: typing.Optional[str] = None,
        throttling_burst_limit: typing.Optional[jsii.Number] = None,
        throttling_rate_limit: typing.Optional[jsii.Number] = None,
    ) -> None:
        """
        :param route_key: 
        :param data_trace_enabled: 
        :param detailed_metrics_enabled: 
        :param logging_level: 
        :param throttling_burst_limit: 
        :param throttling_rate_limit: 
        """
        self._values = {
            "route_key": route_key,
        }
        if data_trace_enabled is not None:
            self._values["data_trace_enabled"] = data_trace_enabled
        if detailed_metrics_enabled is not None:
            self._values["detailed_metrics_enabled"] = detailed_metrics_enabled
        if logging_level is not None:
            self._values["logging_level"] = logging_level
        if throttling_burst_limit is not None:
            self._values["throttling_burst_limit"] = throttling_burst_limit
        if throttling_rate_limit is not None:
            self._values["throttling_rate_limit"] = throttling_rate_limit

    @builtins.property
    def route_key(self) -> str:
        return self._values.get("route_key")

    @builtins.property
    def data_trace_enabled(self) -> typing.Optional[bool]:
        return self._values.get("data_trace_enabled")

    @builtins.property
    def detailed_metrics_enabled(self) -> typing.Optional[bool]:
        return self._values.get("detailed_metrics_enabled")

    @builtins.property
    def logging_level(self) -> typing.Optional[str]:
        return self._values.get("logging_level")

    @builtins.property
    def throttling_burst_limit(self) -> typing.Optional[jsii.Number]:
        return self._values.get("throttling_burst_limit")

    @builtins.property
    def throttling_rate_limit(self) -> typing.Optional[jsii.Number]:
        return self._values.get("throttling_rate_limit")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "Apigatewayv2StageRouteSettings(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class Apigatewayv2VpcLink(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="@skorfmann/cdktf-provider-aws.Apigatewayv2VpcLink",
):
    def __init__(
        self,
        scope: constructs.Construct,
        id: str,
        *,
        name: str,
        security_group_ids: typing.List[str],
        subnet_ids: typing.List[str],
        tags: typing.Optional[typing.Mapping[str, str]] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param name: 
        :param security_group_ids: 
        :param subnet_ids: 
        :param tags: 
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = Apigatewayv2VpcLinkConfig(
            name=name,
            security_group_ids=security_group_ids,
            subnet_ids=subnet_ids,
            tags=tags,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(Apigatewayv2VpcLink, self, [scope, id, config])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property
    @jsii.member(jsii_name="arn")
    def arn(self) -> str:
        return jsii.get(self, "arn")

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> str:
        return jsii.get(self, "name")

    @name.setter
    def name(self, value: str) -> None:
        jsii.set(self, "name", value)

    @builtins.property
    @jsii.member(jsii_name="securityGroupIds")
    def security_group_ids(self) -> typing.List[str]:
        return jsii.get(self, "securityGroupIds")

    @security_group_ids.setter
    def security_group_ids(self, value: typing.List[str]) -> None:
        jsii.set(self, "securityGroupIds", value)

    @builtins.property
    @jsii.member(jsii_name="subnetIds")
    def subnet_ids(self) -> typing.List[str]:
        return jsii.get(self, "subnetIds")

    @subnet_ids.setter
    def subnet_ids(self, value: typing.List[str]) -> None:
        jsii.set(self, "subnetIds", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="tags")
    def tags(self) -> typing.Optional[typing.Mapping[str, str]]:
        return jsii.get(self, "tags")

    @tags.setter
    def tags(self, value: typing.Optional[typing.Mapping[str, str]]) -> None:
        jsii.set(self, "tags", value)


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.Apigatewayv2VpcLinkConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "name": "name",
        "security_group_ids": "securityGroupIds",
        "subnet_ids": "subnetIds",
        "tags": "tags",
    },
)
class Apigatewayv2VpcLinkConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        name: str,
        security_group_ids: typing.List[str],
        subnet_ids: typing.List[str],
        tags: typing.Optional[typing.Mapping[str, str]] = None,
    ) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param name: 
        :param security_group_ids: 
        :param subnet_ids: 
        :param tags: 
        """
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        self._values = {
            "name": name,
            "security_group_ids": security_group_ids,
            "subnet_ids": subnet_ids,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if tags is not None:
            self._values["tags"] = tags

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("count")

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.TerraformResource]]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("depends_on")

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("lifecycle")

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("provider")

    @builtins.property
    def name(self) -> str:
        return self._values.get("name")

    @builtins.property
    def security_group_ids(self) -> typing.List[str]:
        return self._values.get("security_group_ids")

    @builtins.property
    def subnet_ids(self) -> typing.List[str]:
        return self._values.get("subnet_ids")

    @builtins.property
    def tags(self) -> typing.Optional[typing.Mapping[str, str]]:
        return self._values.get("tags")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "Apigatewayv2VpcLinkConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class AppCookieStickinessPolicy(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="@skorfmann/cdktf-provider-aws.AppCookieStickinessPolicy",
):
    def __init__(
        self,
        scope: constructs.Construct,
        id: str,
        *,
        cookie_name: str,
        lb_port: jsii.Number,
        load_balancer: str,
        name: str,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param cookie_name: 
        :param lb_port: 
        :param load_balancer: 
        :param name: 
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = AppCookieStickinessPolicyConfig(
            cookie_name=cookie_name,
            lb_port=lb_port,
            load_balancer=load_balancer,
            name=name,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(AppCookieStickinessPolicy, self, [scope, id, config])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property
    @jsii.member(jsii_name="cookieName")
    def cookie_name(self) -> str:
        return jsii.get(self, "cookieName")

    @cookie_name.setter
    def cookie_name(self, value: str) -> None:
        jsii.set(self, "cookieName", value)

    @builtins.property
    @jsii.member(jsii_name="lbPort")
    def lb_port(self) -> jsii.Number:
        return jsii.get(self, "lbPort")

    @lb_port.setter
    def lb_port(self, value: jsii.Number) -> None:
        jsii.set(self, "lbPort", value)

    @builtins.property
    @jsii.member(jsii_name="loadBalancer")
    def load_balancer(self) -> str:
        return jsii.get(self, "loadBalancer")

    @load_balancer.setter
    def load_balancer(self, value: str) -> None:
        jsii.set(self, "loadBalancer", value)

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> str:
        return jsii.get(self, "name")

    @name.setter
    def name(self, value: str) -> None:
        jsii.set(self, "name", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AppCookieStickinessPolicyConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "cookie_name": "cookieName",
        "lb_port": "lbPort",
        "load_balancer": "loadBalancer",
        "name": "name",
    },
)
class AppCookieStickinessPolicyConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        cookie_name: str,
        lb_port: jsii.Number,
        load_balancer: str,
        name: str,
    ) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param cookie_name: 
        :param lb_port: 
        :param load_balancer: 
        :param name: 
        """
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        self._values = {
            "cookie_name": cookie_name,
            "lb_port": lb_port,
            "load_balancer": load_balancer,
            "name": name,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("count")

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.TerraformResource]]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("depends_on")

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("lifecycle")

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("provider")

    @builtins.property
    def cookie_name(self) -> str:
        return self._values.get("cookie_name")

    @builtins.property
    def lb_port(self) -> jsii.Number:
        return self._values.get("lb_port")

    @builtins.property
    def load_balancer(self) -> str:
        return self._values.get("load_balancer")

    @builtins.property
    def name(self) -> str:
        return self._values.get("name")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppCookieStickinessPolicyConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class AppautoscalingPolicy(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="@skorfmann/cdktf-provider-aws.AppautoscalingPolicy",
):
    def __init__(
        self,
        scope: constructs.Construct,
        id: str,
        *,
        name: str,
        resource_id: str,
        scalable_dimension: str,
        service_namespace: str,
        adjustment_type: typing.Optional[str] = None,
        cooldown: typing.Optional[jsii.Number] = None,
        metric_aggregation_type: typing.Optional[str] = None,
        min_adjustment_magnitude: typing.Optional[jsii.Number] = None,
        policy_type: typing.Optional[str] = None,
        step_adjustment: typing.Optional[
            typing.List["AppautoscalingPolicyStepAdjustment"]
        ] = None,
        step_scaling_policy_configuration: typing.Optional[
            typing.List["AppautoscalingPolicyStepScalingPolicyConfiguration"]
        ] = None,
        target_tracking_scaling_policy_configuration: typing.Optional[
            typing.List["AppautoscalingPolicyTargetTrackingScalingPolicyConfiguration"]
        ] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param name: 
        :param resource_id: 
        :param scalable_dimension: 
        :param service_namespace: 
        :param adjustment_type: 
        :param cooldown: 
        :param metric_aggregation_type: 
        :param min_adjustment_magnitude: 
        :param policy_type: 
        :param step_adjustment: step_adjustment block.
        :param step_scaling_policy_configuration: step_scaling_policy_configuration block.
        :param target_tracking_scaling_policy_configuration: target_tracking_scaling_policy_configuration block.
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = AppautoscalingPolicyConfig(
            name=name,
            resource_id=resource_id,
            scalable_dimension=scalable_dimension,
            service_namespace=service_namespace,
            adjustment_type=adjustment_type,
            cooldown=cooldown,
            metric_aggregation_type=metric_aggregation_type,
            min_adjustment_magnitude=min_adjustment_magnitude,
            policy_type=policy_type,
            step_adjustment=step_adjustment,
            step_scaling_policy_configuration=step_scaling_policy_configuration,
            target_tracking_scaling_policy_configuration=target_tracking_scaling_policy_configuration,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(AppautoscalingPolicy, self, [scope, id, config])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property
    @jsii.member(jsii_name="arn")
    def arn(self) -> str:
        return jsii.get(self, "arn")

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> str:
        return jsii.get(self, "name")

    @name.setter
    def name(self, value: str) -> None:
        jsii.set(self, "name", value)

    @builtins.property
    @jsii.member(jsii_name="resourceId")
    def resource_id(self) -> str:
        return jsii.get(self, "resourceId")

    @resource_id.setter
    def resource_id(self, value: str) -> None:
        jsii.set(self, "resourceId", value)

    @builtins.property
    @jsii.member(jsii_name="scalableDimension")
    def scalable_dimension(self) -> str:
        return jsii.get(self, "scalableDimension")

    @scalable_dimension.setter
    def scalable_dimension(self, value: str) -> None:
        jsii.set(self, "scalableDimension", value)

    @builtins.property
    @jsii.member(jsii_name="serviceNamespace")
    def service_namespace(self) -> str:
        return jsii.get(self, "serviceNamespace")

    @service_namespace.setter
    def service_namespace(self, value: str) -> None:
        jsii.set(self, "serviceNamespace", value)

    @builtins.property
    @jsii.member(jsii_name="adjustmentType")
    def adjustment_type(self) -> typing.Optional[str]:
        return jsii.get(self, "adjustmentType")

    @adjustment_type.setter
    def adjustment_type(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "adjustmentType", value)

    @builtins.property
    @jsii.member(jsii_name="cooldown")
    def cooldown(self) -> typing.Optional[jsii.Number]:
        return jsii.get(self, "cooldown")

    @cooldown.setter
    def cooldown(self, value: typing.Optional[jsii.Number]) -> None:
        jsii.set(self, "cooldown", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="metricAggregationType")
    def metric_aggregation_type(self) -> typing.Optional[str]:
        return jsii.get(self, "metricAggregationType")

    @metric_aggregation_type.setter
    def metric_aggregation_type(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "metricAggregationType", value)

    @builtins.property
    @jsii.member(jsii_name="minAdjustmentMagnitude")
    def min_adjustment_magnitude(self) -> typing.Optional[jsii.Number]:
        return jsii.get(self, "minAdjustmentMagnitude")

    @min_adjustment_magnitude.setter
    def min_adjustment_magnitude(self, value: typing.Optional[jsii.Number]) -> None:
        jsii.set(self, "minAdjustmentMagnitude", value)

    @builtins.property
    @jsii.member(jsii_name="policyType")
    def policy_type(self) -> typing.Optional[str]:
        return jsii.get(self, "policyType")

    @policy_type.setter
    def policy_type(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "policyType", value)

    @builtins.property
    @jsii.member(jsii_name="stepAdjustment")
    def step_adjustment(
        self,
    ) -> typing.Optional[typing.List["AppautoscalingPolicyStepAdjustment"]]:
        return jsii.get(self, "stepAdjustment")

    @step_adjustment.setter
    def step_adjustment(
        self, value: typing.Optional[typing.List["AppautoscalingPolicyStepAdjustment"]]
    ) -> None:
        jsii.set(self, "stepAdjustment", value)

    @builtins.property
    @jsii.member(jsii_name="stepScalingPolicyConfiguration")
    def step_scaling_policy_configuration(
        self,
    ) -> typing.Optional[
        typing.List["AppautoscalingPolicyStepScalingPolicyConfiguration"]
    ]:
        return jsii.get(self, "stepScalingPolicyConfiguration")

    @step_scaling_policy_configuration.setter
    def step_scaling_policy_configuration(
        self,
        value: typing.Optional[
            typing.List["AppautoscalingPolicyStepScalingPolicyConfiguration"]
        ],
    ) -> None:
        jsii.set(self, "stepScalingPolicyConfiguration", value)

    @builtins.property
    @jsii.member(jsii_name="targetTrackingScalingPolicyConfiguration")
    def target_tracking_scaling_policy_configuration(
        self,
    ) -> typing.Optional[
        typing.List["AppautoscalingPolicyTargetTrackingScalingPolicyConfiguration"]
    ]:
        return jsii.get(self, "targetTrackingScalingPolicyConfiguration")

    @target_tracking_scaling_policy_configuration.setter
    def target_tracking_scaling_policy_configuration(
        self,
        value: typing.Optional[
            typing.List["AppautoscalingPolicyTargetTrackingScalingPolicyConfiguration"]
        ],
    ) -> None:
        jsii.set(self, "targetTrackingScalingPolicyConfiguration", value)


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AppautoscalingPolicyConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "name": "name",
        "resource_id": "resourceId",
        "scalable_dimension": "scalableDimension",
        "service_namespace": "serviceNamespace",
        "adjustment_type": "adjustmentType",
        "cooldown": "cooldown",
        "metric_aggregation_type": "metricAggregationType",
        "min_adjustment_magnitude": "minAdjustmentMagnitude",
        "policy_type": "policyType",
        "step_adjustment": "stepAdjustment",
        "step_scaling_policy_configuration": "stepScalingPolicyConfiguration",
        "target_tracking_scaling_policy_configuration": "targetTrackingScalingPolicyConfiguration",
    },
)
class AppautoscalingPolicyConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        name: str,
        resource_id: str,
        scalable_dimension: str,
        service_namespace: str,
        adjustment_type: typing.Optional[str] = None,
        cooldown: typing.Optional[jsii.Number] = None,
        metric_aggregation_type: typing.Optional[str] = None,
        min_adjustment_magnitude: typing.Optional[jsii.Number] = None,
        policy_type: typing.Optional[str] = None,
        step_adjustment: typing.Optional[
            typing.List["AppautoscalingPolicyStepAdjustment"]
        ] = None,
        step_scaling_policy_configuration: typing.Optional[
            typing.List["AppautoscalingPolicyStepScalingPolicyConfiguration"]
        ] = None,
        target_tracking_scaling_policy_configuration: typing.Optional[
            typing.List["AppautoscalingPolicyTargetTrackingScalingPolicyConfiguration"]
        ] = None,
    ) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param name: 
        :param resource_id: 
        :param scalable_dimension: 
        :param service_namespace: 
        :param adjustment_type: 
        :param cooldown: 
        :param metric_aggregation_type: 
        :param min_adjustment_magnitude: 
        :param policy_type: 
        :param step_adjustment: step_adjustment block.
        :param step_scaling_policy_configuration: step_scaling_policy_configuration block.
        :param target_tracking_scaling_policy_configuration: target_tracking_scaling_policy_configuration block.
        """
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        self._values = {
            "name": name,
            "resource_id": resource_id,
            "scalable_dimension": scalable_dimension,
            "service_namespace": service_namespace,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if adjustment_type is not None:
            self._values["adjustment_type"] = adjustment_type
        if cooldown is not None:
            self._values["cooldown"] = cooldown
        if metric_aggregation_type is not None:
            self._values["metric_aggregation_type"] = metric_aggregation_type
        if min_adjustment_magnitude is not None:
            self._values["min_adjustment_magnitude"] = min_adjustment_magnitude
        if policy_type is not None:
            self._values["policy_type"] = policy_type
        if step_adjustment is not None:
            self._values["step_adjustment"] = step_adjustment
        if step_scaling_policy_configuration is not None:
            self._values[
                "step_scaling_policy_configuration"
            ] = step_scaling_policy_configuration
        if target_tracking_scaling_policy_configuration is not None:
            self._values[
                "target_tracking_scaling_policy_configuration"
            ] = target_tracking_scaling_policy_configuration

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("count")

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.TerraformResource]]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("depends_on")

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("lifecycle")

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("provider")

    @builtins.property
    def name(self) -> str:
        return self._values.get("name")

    @builtins.property
    def resource_id(self) -> str:
        return self._values.get("resource_id")

    @builtins.property
    def scalable_dimension(self) -> str:
        return self._values.get("scalable_dimension")

    @builtins.property
    def service_namespace(self) -> str:
        return self._values.get("service_namespace")

    @builtins.property
    def adjustment_type(self) -> typing.Optional[str]:
        return self._values.get("adjustment_type")

    @builtins.property
    def cooldown(self) -> typing.Optional[jsii.Number]:
        return self._values.get("cooldown")

    @builtins.property
    def metric_aggregation_type(self) -> typing.Optional[str]:
        return self._values.get("metric_aggregation_type")

    @builtins.property
    def min_adjustment_magnitude(self) -> typing.Optional[jsii.Number]:
        return self._values.get("min_adjustment_magnitude")

    @builtins.property
    def policy_type(self) -> typing.Optional[str]:
        return self._values.get("policy_type")

    @builtins.property
    def step_adjustment(
        self,
    ) -> typing.Optional[typing.List["AppautoscalingPolicyStepAdjustment"]]:
        """step_adjustment block."""
        return self._values.get("step_adjustment")

    @builtins.property
    def step_scaling_policy_configuration(
        self,
    ) -> typing.Optional[
        typing.List["AppautoscalingPolicyStepScalingPolicyConfiguration"]
    ]:
        """step_scaling_policy_configuration block."""
        return self._values.get("step_scaling_policy_configuration")

    @builtins.property
    def target_tracking_scaling_policy_configuration(
        self,
    ) -> typing.Optional[
        typing.List["AppautoscalingPolicyTargetTrackingScalingPolicyConfiguration"]
    ]:
        """target_tracking_scaling_policy_configuration block."""
        return self._values.get("target_tracking_scaling_policy_configuration")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppautoscalingPolicyConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AppautoscalingPolicyStepAdjustment",
    jsii_struct_bases=[],
    name_mapping={
        "scaling_adjustment": "scalingAdjustment",
        "metric_interval_lower_bound": "metricIntervalLowerBound",
        "metric_interval_upper_bound": "metricIntervalUpperBound",
    },
)
class AppautoscalingPolicyStepAdjustment:
    def __init__(
        self,
        *,
        scaling_adjustment: jsii.Number,
        metric_interval_lower_bound: typing.Optional[str] = None,
        metric_interval_upper_bound: typing.Optional[str] = None,
    ) -> None:
        """
        :param scaling_adjustment: 
        :param metric_interval_lower_bound: 
        :param metric_interval_upper_bound: 
        """
        self._values = {
            "scaling_adjustment": scaling_adjustment,
        }
        if metric_interval_lower_bound is not None:
            self._values["metric_interval_lower_bound"] = metric_interval_lower_bound
        if metric_interval_upper_bound is not None:
            self._values["metric_interval_upper_bound"] = metric_interval_upper_bound

    @builtins.property
    def scaling_adjustment(self) -> jsii.Number:
        return self._values.get("scaling_adjustment")

    @builtins.property
    def metric_interval_lower_bound(self) -> typing.Optional[str]:
        return self._values.get("metric_interval_lower_bound")

    @builtins.property
    def metric_interval_upper_bound(self) -> typing.Optional[str]:
        return self._values.get("metric_interval_upper_bound")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppautoscalingPolicyStepAdjustment(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AppautoscalingPolicyStepScalingPolicyConfiguration",
    jsii_struct_bases=[],
    name_mapping={
        "adjustment_type": "adjustmentType",
        "cooldown": "cooldown",
        "metric_aggregation_type": "metricAggregationType",
        "min_adjustment_magnitude": "minAdjustmentMagnitude",
        "step_adjustment": "stepAdjustment",
    },
)
class AppautoscalingPolicyStepScalingPolicyConfiguration:
    def __init__(
        self,
        *,
        adjustment_type: typing.Optional[str] = None,
        cooldown: typing.Optional[jsii.Number] = None,
        metric_aggregation_type: typing.Optional[str] = None,
        min_adjustment_magnitude: typing.Optional[jsii.Number] = None,
        step_adjustment: typing.Optional[
            typing.List[
                "AppautoscalingPolicyStepScalingPolicyConfigurationStepAdjustment"
            ]
        ] = None,
    ) -> None:
        """
        :param adjustment_type: 
        :param cooldown: 
        :param metric_aggregation_type: 
        :param min_adjustment_magnitude: 
        :param step_adjustment: step_adjustment block.
        """
        self._values = {}
        if adjustment_type is not None:
            self._values["adjustment_type"] = adjustment_type
        if cooldown is not None:
            self._values["cooldown"] = cooldown
        if metric_aggregation_type is not None:
            self._values["metric_aggregation_type"] = metric_aggregation_type
        if min_adjustment_magnitude is not None:
            self._values["min_adjustment_magnitude"] = min_adjustment_magnitude
        if step_adjustment is not None:
            self._values["step_adjustment"] = step_adjustment

    @builtins.property
    def adjustment_type(self) -> typing.Optional[str]:
        return self._values.get("adjustment_type")

    @builtins.property
    def cooldown(self) -> typing.Optional[jsii.Number]:
        return self._values.get("cooldown")

    @builtins.property
    def metric_aggregation_type(self) -> typing.Optional[str]:
        return self._values.get("metric_aggregation_type")

    @builtins.property
    def min_adjustment_magnitude(self) -> typing.Optional[jsii.Number]:
        return self._values.get("min_adjustment_magnitude")

    @builtins.property
    def step_adjustment(
        self,
    ) -> typing.Optional[
        typing.List["AppautoscalingPolicyStepScalingPolicyConfigurationStepAdjustment"]
    ]:
        """step_adjustment block."""
        return self._values.get("step_adjustment")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppautoscalingPolicyStepScalingPolicyConfiguration(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AppautoscalingPolicyStepScalingPolicyConfigurationStepAdjustment",
    jsii_struct_bases=[],
    name_mapping={
        "scaling_adjustment": "scalingAdjustment",
        "metric_interval_lower_bound": "metricIntervalLowerBound",
        "metric_interval_upper_bound": "metricIntervalUpperBound",
    },
)
class AppautoscalingPolicyStepScalingPolicyConfigurationStepAdjustment:
    def __init__(
        self,
        *,
        scaling_adjustment: jsii.Number,
        metric_interval_lower_bound: typing.Optional[str] = None,
        metric_interval_upper_bound: typing.Optional[str] = None,
    ) -> None:
        """
        :param scaling_adjustment: 
        :param metric_interval_lower_bound: 
        :param metric_interval_upper_bound: 
        """
        self._values = {
            "scaling_adjustment": scaling_adjustment,
        }
        if metric_interval_lower_bound is not None:
            self._values["metric_interval_lower_bound"] = metric_interval_lower_bound
        if metric_interval_upper_bound is not None:
            self._values["metric_interval_upper_bound"] = metric_interval_upper_bound

    @builtins.property
    def scaling_adjustment(self) -> jsii.Number:
        return self._values.get("scaling_adjustment")

    @builtins.property
    def metric_interval_lower_bound(self) -> typing.Optional[str]:
        return self._values.get("metric_interval_lower_bound")

    @builtins.property
    def metric_interval_upper_bound(self) -> typing.Optional[str]:
        return self._values.get("metric_interval_upper_bound")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return (
            "AppautoscalingPolicyStepScalingPolicyConfigurationStepAdjustment(%s)"
            % ", ".join(k + "=" + repr(v) for k, v in self._values.items())
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AppautoscalingPolicyTargetTrackingScalingPolicyConfiguration",
    jsii_struct_bases=[],
    name_mapping={
        "target_value": "targetValue",
        "customized_metric_specification": "customizedMetricSpecification",
        "disable_scale_in": "disableScaleIn",
        "predefined_metric_specification": "predefinedMetricSpecification",
        "scale_in_cooldown": "scaleInCooldown",
        "scale_out_cooldown": "scaleOutCooldown",
    },
)
class AppautoscalingPolicyTargetTrackingScalingPolicyConfiguration:
    def __init__(
        self,
        *,
        target_value: jsii.Number,
        customized_metric_specification: typing.Optional[
            typing.List[
                "AppautoscalingPolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecification"
            ]
        ] = None,
        disable_scale_in: typing.Optional[bool] = None,
        predefined_metric_specification: typing.Optional[
            typing.List[
                "AppautoscalingPolicyTargetTrackingScalingPolicyConfigurationPredefinedMetricSpecification"
            ]
        ] = None,
        scale_in_cooldown: typing.Optional[jsii.Number] = None,
        scale_out_cooldown: typing.Optional[jsii.Number] = None,
    ) -> None:
        """
        :param target_value: 
        :param customized_metric_specification: customized_metric_specification block.
        :param disable_scale_in: 
        :param predefined_metric_specification: predefined_metric_specification block.
        :param scale_in_cooldown: 
        :param scale_out_cooldown: 
        """
        self._values = {
            "target_value": target_value,
        }
        if customized_metric_specification is not None:
            self._values[
                "customized_metric_specification"
            ] = customized_metric_specification
        if disable_scale_in is not None:
            self._values["disable_scale_in"] = disable_scale_in
        if predefined_metric_specification is not None:
            self._values[
                "predefined_metric_specification"
            ] = predefined_metric_specification
        if scale_in_cooldown is not None:
            self._values["scale_in_cooldown"] = scale_in_cooldown
        if scale_out_cooldown is not None:
            self._values["scale_out_cooldown"] = scale_out_cooldown

    @builtins.property
    def target_value(self) -> jsii.Number:
        return self._values.get("target_value")

    @builtins.property
    def customized_metric_specification(
        self,
    ) -> typing.Optional[
        typing.List[
            "AppautoscalingPolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecification"
        ]
    ]:
        """customized_metric_specification block."""
        return self._values.get("customized_metric_specification")

    @builtins.property
    def disable_scale_in(self) -> typing.Optional[bool]:
        return self._values.get("disable_scale_in")

    @builtins.property
    def predefined_metric_specification(
        self,
    ) -> typing.Optional[
        typing.List[
            "AppautoscalingPolicyTargetTrackingScalingPolicyConfigurationPredefinedMetricSpecification"
        ]
    ]:
        """predefined_metric_specification block."""
        return self._values.get("predefined_metric_specification")

    @builtins.property
    def scale_in_cooldown(self) -> typing.Optional[jsii.Number]:
        return self._values.get("scale_in_cooldown")

    @builtins.property
    def scale_out_cooldown(self) -> typing.Optional[jsii.Number]:
        return self._values.get("scale_out_cooldown")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return (
            "AppautoscalingPolicyTargetTrackingScalingPolicyConfiguration(%s)"
            % ", ".join(k + "=" + repr(v) for k, v in self._values.items())
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AppautoscalingPolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecification",
    jsii_struct_bases=[],
    name_mapping={
        "metric_name": "metricName",
        "namespace": "namespace",
        "statistic": "statistic",
        "dimensions": "dimensions",
        "unit": "unit",
    },
)
class AppautoscalingPolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecification:
    def __init__(
        self,
        *,
        metric_name: str,
        namespace: str,
        statistic: str,
        dimensions: typing.Optional[
            typing.List[
                "AppautoscalingPolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationDimensions"
            ]
        ] = None,
        unit: typing.Optional[str] = None,
    ) -> None:
        """
        :param metric_name: 
        :param namespace: 
        :param statistic: 
        :param dimensions: dimensions block.
        :param unit: 
        """
        self._values = {
            "metric_name": metric_name,
            "namespace": namespace,
            "statistic": statistic,
        }
        if dimensions is not None:
            self._values["dimensions"] = dimensions
        if unit is not None:
            self._values["unit"] = unit

    @builtins.property
    def metric_name(self) -> str:
        return self._values.get("metric_name")

    @builtins.property
    def namespace(self) -> str:
        return self._values.get("namespace")

    @builtins.property
    def statistic(self) -> str:
        return self._values.get("statistic")

    @builtins.property
    def dimensions(
        self,
    ) -> typing.Optional[
        typing.List[
            "AppautoscalingPolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationDimensions"
        ]
    ]:
        """dimensions block."""
        return self._values.get("dimensions")

    @builtins.property
    def unit(self) -> typing.Optional[str]:
        return self._values.get("unit")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return (
            "AppautoscalingPolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecification(%s)"
            % ", ".join(k + "=" + repr(v) for k, v in self._values.items())
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AppautoscalingPolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationDimensions",
    jsii_struct_bases=[],
    name_mapping={"name": "name", "value": "value"},
)
class AppautoscalingPolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationDimensions:
    def __init__(self, *, name: str, value: str) -> None:
        """
        :param name: 
        :param value: 
        """
        self._values = {
            "name": name,
            "value": value,
        }

    @builtins.property
    def name(self) -> str:
        return self._values.get("name")

    @builtins.property
    def value(self) -> str:
        return self._values.get("value")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return (
            "AppautoscalingPolicyTargetTrackingScalingPolicyConfigurationCustomizedMetricSpecificationDimensions(%s)"
            % ", ".join(k + "=" + repr(v) for k, v in self._values.items())
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AppautoscalingPolicyTargetTrackingScalingPolicyConfigurationPredefinedMetricSpecification",
    jsii_struct_bases=[],
    name_mapping={
        "predefined_metric_type": "predefinedMetricType",
        "resource_label": "resourceLabel",
    },
)
class AppautoscalingPolicyTargetTrackingScalingPolicyConfigurationPredefinedMetricSpecification:
    def __init__(
        self,
        *,
        predefined_metric_type: str,
        resource_label: typing.Optional[str] = None,
    ) -> None:
        """
        :param predefined_metric_type: 
        :param resource_label: 
        """
        self._values = {
            "predefined_metric_type": predefined_metric_type,
        }
        if resource_label is not None:
            self._values["resource_label"] = resource_label

    @builtins.property
    def predefined_metric_type(self) -> str:
        return self._values.get("predefined_metric_type")

    @builtins.property
    def resource_label(self) -> typing.Optional[str]:
        return self._values.get("resource_label")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return (
            "AppautoscalingPolicyTargetTrackingScalingPolicyConfigurationPredefinedMetricSpecification(%s)"
            % ", ".join(k + "=" + repr(v) for k, v in self._values.items())
        )


class AppautoscalingScheduledAction(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="@skorfmann/cdktf-provider-aws.AppautoscalingScheduledAction",
):
    def __init__(
        self,
        scope: constructs.Construct,
        id: str,
        *,
        name: str,
        resource_id: str,
        service_namespace: str,
        end_time: typing.Optional[str] = None,
        scalable_dimension: typing.Optional[str] = None,
        scalable_target_action: typing.Optional[
            typing.List["AppautoscalingScheduledActionScalableTargetAction"]
        ] = None,
        schedule: typing.Optional[str] = None,
        start_time: typing.Optional[str] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param name: 
        :param resource_id: 
        :param service_namespace: 
        :param end_time: 
        :param scalable_dimension: 
        :param scalable_target_action: scalable_target_action block.
        :param schedule: 
        :param start_time: 
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = AppautoscalingScheduledActionConfig(
            name=name,
            resource_id=resource_id,
            service_namespace=service_namespace,
            end_time=end_time,
            scalable_dimension=scalable_dimension,
            scalable_target_action=scalable_target_action,
            schedule=schedule,
            start_time=start_time,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(AppautoscalingScheduledAction, self, [scope, id, config])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property
    @jsii.member(jsii_name="arn")
    def arn(self) -> str:
        return jsii.get(self, "arn")

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> str:
        return jsii.get(self, "name")

    @name.setter
    def name(self, value: str) -> None:
        jsii.set(self, "name", value)

    @builtins.property
    @jsii.member(jsii_name="resourceId")
    def resource_id(self) -> str:
        return jsii.get(self, "resourceId")

    @resource_id.setter
    def resource_id(self, value: str) -> None:
        jsii.set(self, "resourceId", value)

    @builtins.property
    @jsii.member(jsii_name="serviceNamespace")
    def service_namespace(self) -> str:
        return jsii.get(self, "serviceNamespace")

    @service_namespace.setter
    def service_namespace(self, value: str) -> None:
        jsii.set(self, "serviceNamespace", value)

    @builtins.property
    @jsii.member(jsii_name="endTime")
    def end_time(self) -> typing.Optional[str]:
        return jsii.get(self, "endTime")

    @end_time.setter
    def end_time(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "endTime", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="scalableDimension")
    def scalable_dimension(self) -> typing.Optional[str]:
        return jsii.get(self, "scalableDimension")

    @scalable_dimension.setter
    def scalable_dimension(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "scalableDimension", value)

    @builtins.property
    @jsii.member(jsii_name="scalableTargetAction")
    def scalable_target_action(
        self,
    ) -> typing.Optional[
        typing.List["AppautoscalingScheduledActionScalableTargetAction"]
    ]:
        return jsii.get(self, "scalableTargetAction")

    @scalable_target_action.setter
    def scalable_target_action(
        self,
        value: typing.Optional[
            typing.List["AppautoscalingScheduledActionScalableTargetAction"]
        ],
    ) -> None:
        jsii.set(self, "scalableTargetAction", value)

    @builtins.property
    @jsii.member(jsii_name="schedule")
    def schedule(self) -> typing.Optional[str]:
        return jsii.get(self, "schedule")

    @schedule.setter
    def schedule(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "schedule", value)

    @builtins.property
    @jsii.member(jsii_name="startTime")
    def start_time(self) -> typing.Optional[str]:
        return jsii.get(self, "startTime")

    @start_time.setter
    def start_time(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "startTime", value)


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AppautoscalingScheduledActionConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "name": "name",
        "resource_id": "resourceId",
        "service_namespace": "serviceNamespace",
        "end_time": "endTime",
        "scalable_dimension": "scalableDimension",
        "scalable_target_action": "scalableTargetAction",
        "schedule": "schedule",
        "start_time": "startTime",
    },
)
class AppautoscalingScheduledActionConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        name: str,
        resource_id: str,
        service_namespace: str,
        end_time: typing.Optional[str] = None,
        scalable_dimension: typing.Optional[str] = None,
        scalable_target_action: typing.Optional[
            typing.List["AppautoscalingScheduledActionScalableTargetAction"]
        ] = None,
        schedule: typing.Optional[str] = None,
        start_time: typing.Optional[str] = None,
    ) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param name: 
        :param resource_id: 
        :param service_namespace: 
        :param end_time: 
        :param scalable_dimension: 
        :param scalable_target_action: scalable_target_action block.
        :param schedule: 
        :param start_time: 
        """
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        self._values = {
            "name": name,
            "resource_id": resource_id,
            "service_namespace": service_namespace,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if end_time is not None:
            self._values["end_time"] = end_time
        if scalable_dimension is not None:
            self._values["scalable_dimension"] = scalable_dimension
        if scalable_target_action is not None:
            self._values["scalable_target_action"] = scalable_target_action
        if schedule is not None:
            self._values["schedule"] = schedule
        if start_time is not None:
            self._values["start_time"] = start_time

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("count")

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.TerraformResource]]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("depends_on")

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("lifecycle")

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("provider")

    @builtins.property
    def name(self) -> str:
        return self._values.get("name")

    @builtins.property
    def resource_id(self) -> str:
        return self._values.get("resource_id")

    @builtins.property
    def service_namespace(self) -> str:
        return self._values.get("service_namespace")

    @builtins.property
    def end_time(self) -> typing.Optional[str]:
        return self._values.get("end_time")

    @builtins.property
    def scalable_dimension(self) -> typing.Optional[str]:
        return self._values.get("scalable_dimension")

    @builtins.property
    def scalable_target_action(
        self,
    ) -> typing.Optional[
        typing.List["AppautoscalingScheduledActionScalableTargetAction"]
    ]:
        """scalable_target_action block."""
        return self._values.get("scalable_target_action")

    @builtins.property
    def schedule(self) -> typing.Optional[str]:
        return self._values.get("schedule")

    @builtins.property
    def start_time(self) -> typing.Optional[str]:
        return self._values.get("start_time")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppautoscalingScheduledActionConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AppautoscalingScheduledActionScalableTargetAction",
    jsii_struct_bases=[],
    name_mapping={"max_capacity": "maxCapacity", "min_capacity": "minCapacity"},
)
class AppautoscalingScheduledActionScalableTargetAction:
    def __init__(
        self,
        *,
        max_capacity: typing.Optional[jsii.Number] = None,
        min_capacity: typing.Optional[jsii.Number] = None,
    ) -> None:
        """
        :param max_capacity: 
        :param min_capacity: 
        """
        self._values = {}
        if max_capacity is not None:
            self._values["max_capacity"] = max_capacity
        if min_capacity is not None:
            self._values["min_capacity"] = min_capacity

    @builtins.property
    def max_capacity(self) -> typing.Optional[jsii.Number]:
        return self._values.get("max_capacity")

    @builtins.property
    def min_capacity(self) -> typing.Optional[jsii.Number]:
        return self._values.get("min_capacity")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppautoscalingScheduledActionScalableTargetAction(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class AppautoscalingTarget(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="@skorfmann/cdktf-provider-aws.AppautoscalingTarget",
):
    def __init__(
        self,
        scope: constructs.Construct,
        id: str,
        *,
        max_capacity: jsii.Number,
        min_capacity: jsii.Number,
        resource_id: str,
        scalable_dimension: str,
        service_namespace: str,
        role_arn: typing.Optional[str] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param max_capacity: 
        :param min_capacity: 
        :param resource_id: 
        :param scalable_dimension: 
        :param service_namespace: 
        :param role_arn: 
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = AppautoscalingTargetConfig(
            max_capacity=max_capacity,
            min_capacity=min_capacity,
            resource_id=resource_id,
            scalable_dimension=scalable_dimension,
            service_namespace=service_namespace,
            role_arn=role_arn,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(AppautoscalingTarget, self, [scope, id, config])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property
    @jsii.member(jsii_name="maxCapacity")
    def max_capacity(self) -> jsii.Number:
        return jsii.get(self, "maxCapacity")

    @max_capacity.setter
    def max_capacity(self, value: jsii.Number) -> None:
        jsii.set(self, "maxCapacity", value)

    @builtins.property
    @jsii.member(jsii_name="minCapacity")
    def min_capacity(self) -> jsii.Number:
        return jsii.get(self, "minCapacity")

    @min_capacity.setter
    def min_capacity(self, value: jsii.Number) -> None:
        jsii.set(self, "minCapacity", value)

    @builtins.property
    @jsii.member(jsii_name="resourceId")
    def resource_id(self) -> str:
        return jsii.get(self, "resourceId")

    @resource_id.setter
    def resource_id(self, value: str) -> None:
        jsii.set(self, "resourceId", value)

    @builtins.property
    @jsii.member(jsii_name="scalableDimension")
    def scalable_dimension(self) -> str:
        return jsii.get(self, "scalableDimension")

    @scalable_dimension.setter
    def scalable_dimension(self, value: str) -> None:
        jsii.set(self, "scalableDimension", value)

    @builtins.property
    @jsii.member(jsii_name="serviceNamespace")
    def service_namespace(self) -> str:
        return jsii.get(self, "serviceNamespace")

    @service_namespace.setter
    def service_namespace(self, value: str) -> None:
        jsii.set(self, "serviceNamespace", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="roleArn")
    def role_arn(self) -> typing.Optional[str]:
        return jsii.get(self, "roleArn")

    @role_arn.setter
    def role_arn(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "roleArn", value)


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AppautoscalingTargetConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "max_capacity": "maxCapacity",
        "min_capacity": "minCapacity",
        "resource_id": "resourceId",
        "scalable_dimension": "scalableDimension",
        "service_namespace": "serviceNamespace",
        "role_arn": "roleArn",
    },
)
class AppautoscalingTargetConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        max_capacity: jsii.Number,
        min_capacity: jsii.Number,
        resource_id: str,
        scalable_dimension: str,
        service_namespace: str,
        role_arn: typing.Optional[str] = None,
    ) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param max_capacity: 
        :param min_capacity: 
        :param resource_id: 
        :param scalable_dimension: 
        :param service_namespace: 
        :param role_arn: 
        """
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        self._values = {
            "max_capacity": max_capacity,
            "min_capacity": min_capacity,
            "resource_id": resource_id,
            "scalable_dimension": scalable_dimension,
            "service_namespace": service_namespace,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if role_arn is not None:
            self._values["role_arn"] = role_arn

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("count")

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.TerraformResource]]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("depends_on")

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("lifecycle")

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("provider")

    @builtins.property
    def max_capacity(self) -> jsii.Number:
        return self._values.get("max_capacity")

    @builtins.property
    def min_capacity(self) -> jsii.Number:
        return self._values.get("min_capacity")

    @builtins.property
    def resource_id(self) -> str:
        return self._values.get("resource_id")

    @builtins.property
    def scalable_dimension(self) -> str:
        return self._values.get("scalable_dimension")

    @builtins.property
    def service_namespace(self) -> str:
        return self._values.get("service_namespace")

    @builtins.property
    def role_arn(self) -> typing.Optional[str]:
        return self._values.get("role_arn")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppautoscalingTargetConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class AppmeshMesh(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="@skorfmann/cdktf-provider-aws.AppmeshMesh",
):
    def __init__(
        self,
        scope: constructs.Construct,
        id: str,
        *,
        name: str,
        spec: typing.Optional[typing.List["AppmeshMeshSpec"]] = None,
        tags: typing.Optional[typing.Mapping[str, str]] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param name: 
        :param spec: spec block.
        :param tags: 
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = AppmeshMeshConfig(
            name=name,
            spec=spec,
            tags=tags,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(AppmeshMesh, self, [scope, id, config])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property
    @jsii.member(jsii_name="arn")
    def arn(self) -> str:
        return jsii.get(self, "arn")

    @builtins.property
    @jsii.member(jsii_name="createdDate")
    def created_date(self) -> str:
        return jsii.get(self, "createdDate")

    @builtins.property
    @jsii.member(jsii_name="lastUpdatedDate")
    def last_updated_date(self) -> str:
        return jsii.get(self, "lastUpdatedDate")

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> str:
        return jsii.get(self, "name")

    @name.setter
    def name(self, value: str) -> None:
        jsii.set(self, "name", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="spec")
    def spec(self) -> typing.Optional[typing.List["AppmeshMeshSpec"]]:
        return jsii.get(self, "spec")

    @spec.setter
    def spec(self, value: typing.Optional[typing.List["AppmeshMeshSpec"]]) -> None:
        jsii.set(self, "spec", value)

    @builtins.property
    @jsii.member(jsii_name="tags")
    def tags(self) -> typing.Optional[typing.Mapping[str, str]]:
        return jsii.get(self, "tags")

    @tags.setter
    def tags(self, value: typing.Optional[typing.Mapping[str, str]]) -> None:
        jsii.set(self, "tags", value)


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AppmeshMeshConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "name": "name",
        "spec": "spec",
        "tags": "tags",
    },
)
class AppmeshMeshConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        name: str,
        spec: typing.Optional[typing.List["AppmeshMeshSpec"]] = None,
        tags: typing.Optional[typing.Mapping[str, str]] = None,
    ) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param name: 
        :param spec: spec block.
        :param tags: 
        """
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        self._values = {
            "name": name,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if spec is not None:
            self._values["spec"] = spec
        if tags is not None:
            self._values["tags"] = tags

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("count")

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.TerraformResource]]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("depends_on")

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("lifecycle")

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("provider")

    @builtins.property
    def name(self) -> str:
        return self._values.get("name")

    @builtins.property
    def spec(self) -> typing.Optional[typing.List["AppmeshMeshSpec"]]:
        """spec block."""
        return self._values.get("spec")

    @builtins.property
    def tags(self) -> typing.Optional[typing.Mapping[str, str]]:
        return self._values.get("tags")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppmeshMeshConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AppmeshMeshSpec",
    jsii_struct_bases=[],
    name_mapping={"egress_filter": "egressFilter"},
)
class AppmeshMeshSpec:
    def __init__(
        self,
        *,
        egress_filter: typing.Optional[
            typing.List["AppmeshMeshSpecEgressFilter"]
        ] = None,
    ) -> None:
        """
        :param egress_filter: egress_filter block.
        """
        self._values = {}
        if egress_filter is not None:
            self._values["egress_filter"] = egress_filter

    @builtins.property
    def egress_filter(
        self,
    ) -> typing.Optional[typing.List["AppmeshMeshSpecEgressFilter"]]:
        """egress_filter block."""
        return self._values.get("egress_filter")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppmeshMeshSpec(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AppmeshMeshSpecEgressFilter",
    jsii_struct_bases=[],
    name_mapping={"type": "type"},
)
class AppmeshMeshSpecEgressFilter:
    def __init__(self, *, type: typing.Optional[str] = None) -> None:
        """
        :param type: 
        """
        self._values = {}
        if type is not None:
            self._values["type"] = type

    @builtins.property
    def type(self) -> typing.Optional[str]:
        return self._values.get("type")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppmeshMeshSpecEgressFilter(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class AppmeshRoute(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="@skorfmann/cdktf-provider-aws.AppmeshRoute",
):
    def __init__(
        self,
        scope: constructs.Construct,
        id: str,
        *,
        mesh_name: str,
        name: str,
        spec: typing.List["AppmeshRouteSpec"],
        virtual_router_name: str,
        tags: typing.Optional[typing.Mapping[str, str]] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param mesh_name: 
        :param name: 
        :param spec: spec block.
        :param virtual_router_name: 
        :param tags: 
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = AppmeshRouteConfig(
            mesh_name=mesh_name,
            name=name,
            spec=spec,
            virtual_router_name=virtual_router_name,
            tags=tags,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(AppmeshRoute, self, [scope, id, config])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property
    @jsii.member(jsii_name="arn")
    def arn(self) -> str:
        return jsii.get(self, "arn")

    @builtins.property
    @jsii.member(jsii_name="createdDate")
    def created_date(self) -> str:
        return jsii.get(self, "createdDate")

    @builtins.property
    @jsii.member(jsii_name="lastUpdatedDate")
    def last_updated_date(self) -> str:
        return jsii.get(self, "lastUpdatedDate")

    @builtins.property
    @jsii.member(jsii_name="meshName")
    def mesh_name(self) -> str:
        return jsii.get(self, "meshName")

    @mesh_name.setter
    def mesh_name(self, value: str) -> None:
        jsii.set(self, "meshName", value)

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> str:
        return jsii.get(self, "name")

    @name.setter
    def name(self, value: str) -> None:
        jsii.set(self, "name", value)

    @builtins.property
    @jsii.member(jsii_name="spec")
    def spec(self) -> typing.List["AppmeshRouteSpec"]:
        return jsii.get(self, "spec")

    @spec.setter
    def spec(self, value: typing.List["AppmeshRouteSpec"]) -> None:
        jsii.set(self, "spec", value)

    @builtins.property
    @jsii.member(jsii_name="virtualRouterName")
    def virtual_router_name(self) -> str:
        return jsii.get(self, "virtualRouterName")

    @virtual_router_name.setter
    def virtual_router_name(self, value: str) -> None:
        jsii.set(self, "virtualRouterName", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="tags")
    def tags(self) -> typing.Optional[typing.Mapping[str, str]]:
        return jsii.get(self, "tags")

    @tags.setter
    def tags(self, value: typing.Optional[typing.Mapping[str, str]]) -> None:
        jsii.set(self, "tags", value)


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AppmeshRouteConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "mesh_name": "meshName",
        "name": "name",
        "spec": "spec",
        "virtual_router_name": "virtualRouterName",
        "tags": "tags",
    },
)
class AppmeshRouteConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        mesh_name: str,
        name: str,
        spec: typing.List["AppmeshRouteSpec"],
        virtual_router_name: str,
        tags: typing.Optional[typing.Mapping[str, str]] = None,
    ) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param mesh_name: 
        :param name: 
        :param spec: spec block.
        :param virtual_router_name: 
        :param tags: 
        """
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        self._values = {
            "mesh_name": mesh_name,
            "name": name,
            "spec": spec,
            "virtual_router_name": virtual_router_name,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if tags is not None:
            self._values["tags"] = tags

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("count")

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.TerraformResource]]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("depends_on")

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("lifecycle")

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("provider")

    @builtins.property
    def mesh_name(self) -> str:
        return self._values.get("mesh_name")

    @builtins.property
    def name(self) -> str:
        return self._values.get("name")

    @builtins.property
    def spec(self) -> typing.List["AppmeshRouteSpec"]:
        """spec block."""
        return self._values.get("spec")

    @builtins.property
    def virtual_router_name(self) -> str:
        return self._values.get("virtual_router_name")

    @builtins.property
    def tags(self) -> typing.Optional[typing.Mapping[str, str]]:
        return self._values.get("tags")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppmeshRouteConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AppmeshRouteSpec",
    jsii_struct_bases=[],
    name_mapping={
        "http_route": "httpRoute",
        "priority": "priority",
        "tcp_route": "tcpRoute",
    },
)
class AppmeshRouteSpec:
    def __init__(
        self,
        *,
        http_route: typing.Optional[typing.List["AppmeshRouteSpecHttpRoute"]] = None,
        priority: typing.Optional[jsii.Number] = None,
        tcp_route: typing.Optional[typing.List["AppmeshRouteSpecTcpRoute"]] = None,
    ) -> None:
        """
        :param http_route: http_route block.
        :param priority: 
        :param tcp_route: tcp_route block.
        """
        self._values = {}
        if http_route is not None:
            self._values["http_route"] = http_route
        if priority is not None:
            self._values["priority"] = priority
        if tcp_route is not None:
            self._values["tcp_route"] = tcp_route

    @builtins.property
    def http_route(self) -> typing.Optional[typing.List["AppmeshRouteSpecHttpRoute"]]:
        """http_route block."""
        return self._values.get("http_route")

    @builtins.property
    def priority(self) -> typing.Optional[jsii.Number]:
        return self._values.get("priority")

    @builtins.property
    def tcp_route(self) -> typing.Optional[typing.List["AppmeshRouteSpecTcpRoute"]]:
        """tcp_route block."""
        return self._values.get("tcp_route")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppmeshRouteSpec(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AppmeshRouteSpecHttpRoute",
    jsii_struct_bases=[],
    name_mapping={"action": "action", "match": "match"},
)
class AppmeshRouteSpecHttpRoute:
    def __init__(
        self,
        *,
        action: typing.List["AppmeshRouteSpecHttpRouteAction"],
        match: typing.List["AppmeshRouteSpecHttpRouteMatch"],
    ) -> None:
        """
        :param action: action block.
        :param match: match block.
        """
        self._values = {
            "action": action,
            "match": match,
        }

    @builtins.property
    def action(self) -> typing.List["AppmeshRouteSpecHttpRouteAction"]:
        """action block."""
        return self._values.get("action")

    @builtins.property
    def match(self) -> typing.List["AppmeshRouteSpecHttpRouteMatch"]:
        """match block."""
        return self._values.get("match")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppmeshRouteSpecHttpRoute(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AppmeshRouteSpecHttpRouteAction",
    jsii_struct_bases=[],
    name_mapping={"weighted_target": "weightedTarget"},
)
class AppmeshRouteSpecHttpRouteAction:
    def __init__(
        self,
        *,
        weighted_target: typing.List["AppmeshRouteSpecHttpRouteActionWeightedTarget"],
    ) -> None:
        """
        :param weighted_target: weighted_target block.
        """
        self._values = {
            "weighted_target": weighted_target,
        }

    @builtins.property
    def weighted_target(
        self,
    ) -> typing.List["AppmeshRouteSpecHttpRouteActionWeightedTarget"]:
        """weighted_target block."""
        return self._values.get("weighted_target")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppmeshRouteSpecHttpRouteAction(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AppmeshRouteSpecHttpRouteActionWeightedTarget",
    jsii_struct_bases=[],
    name_mapping={"virtual_node": "virtualNode", "weight": "weight"},
)
class AppmeshRouteSpecHttpRouteActionWeightedTarget:
    def __init__(self, *, virtual_node: str, weight: jsii.Number) -> None:
        """
        :param virtual_node: 
        :param weight: 
        """
        self._values = {
            "virtual_node": virtual_node,
            "weight": weight,
        }

    @builtins.property
    def virtual_node(self) -> str:
        return self._values.get("virtual_node")

    @builtins.property
    def weight(self) -> jsii.Number:
        return self._values.get("weight")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppmeshRouteSpecHttpRouteActionWeightedTarget(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AppmeshRouteSpecHttpRouteMatch",
    jsii_struct_bases=[],
    name_mapping={
        "prefix": "prefix",
        "header": "header",
        "method": "method",
        "scheme": "scheme",
    },
)
class AppmeshRouteSpecHttpRouteMatch:
    def __init__(
        self,
        *,
        prefix: str,
        header: typing.Optional[
            typing.List["AppmeshRouteSpecHttpRouteMatchHeader"]
        ] = None,
        method: typing.Optional[str] = None,
        scheme: typing.Optional[str] = None,
    ) -> None:
        """
        :param prefix: 
        :param header: header block.
        :param method: 
        :param scheme: 
        """
        self._values = {
            "prefix": prefix,
        }
        if header is not None:
            self._values["header"] = header
        if method is not None:
            self._values["method"] = method
        if scheme is not None:
            self._values["scheme"] = scheme

    @builtins.property
    def prefix(self) -> str:
        return self._values.get("prefix")

    @builtins.property
    def header(
        self,
    ) -> typing.Optional[typing.List["AppmeshRouteSpecHttpRouteMatchHeader"]]:
        """header block."""
        return self._values.get("header")

    @builtins.property
    def method(self) -> typing.Optional[str]:
        return self._values.get("method")

    @builtins.property
    def scheme(self) -> typing.Optional[str]:
        return self._values.get("scheme")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppmeshRouteSpecHttpRouteMatch(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AppmeshRouteSpecHttpRouteMatchHeader",
    jsii_struct_bases=[],
    name_mapping={"name": "name", "invert": "invert", "match": "match"},
)
class AppmeshRouteSpecHttpRouteMatchHeader:
    def __init__(
        self,
        *,
        name: str,
        invert: typing.Optional[bool] = None,
        match: typing.Optional[
            typing.List["AppmeshRouteSpecHttpRouteMatchHeaderMatch"]
        ] = None,
    ) -> None:
        """
        :param name: 
        :param invert: 
        :param match: match block.
        """
        self._values = {
            "name": name,
        }
        if invert is not None:
            self._values["invert"] = invert
        if match is not None:
            self._values["match"] = match

    @builtins.property
    def name(self) -> str:
        return self._values.get("name")

    @builtins.property
    def invert(self) -> typing.Optional[bool]:
        return self._values.get("invert")

    @builtins.property
    def match(
        self,
    ) -> typing.Optional[typing.List["AppmeshRouteSpecHttpRouteMatchHeaderMatch"]]:
        """match block."""
        return self._values.get("match")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppmeshRouteSpecHttpRouteMatchHeader(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AppmeshRouteSpecHttpRouteMatchHeaderMatch",
    jsii_struct_bases=[],
    name_mapping={
        "exact": "exact",
        "prefix": "prefix",
        "range": "range",
        "regex": "regex",
        "suffix": "suffix",
    },
)
class AppmeshRouteSpecHttpRouteMatchHeaderMatch:
    def __init__(
        self,
        *,
        exact: typing.Optional[str] = None,
        prefix: typing.Optional[str] = None,
        range: typing.Optional[
            typing.List["AppmeshRouteSpecHttpRouteMatchHeaderMatchRange"]
        ] = None,
        regex: typing.Optional[str] = None,
        suffix: typing.Optional[str] = None,
    ) -> None:
        """
        :param exact: 
        :param prefix: 
        :param range: range block.
        :param regex: 
        :param suffix: 
        """
        self._values = {}
        if exact is not None:
            self._values["exact"] = exact
        if prefix is not None:
            self._values["prefix"] = prefix
        if range is not None:
            self._values["range"] = range
        if regex is not None:
            self._values["regex"] = regex
        if suffix is not None:
            self._values["suffix"] = suffix

    @builtins.property
    def exact(self) -> typing.Optional[str]:
        return self._values.get("exact")

    @builtins.property
    def prefix(self) -> typing.Optional[str]:
        return self._values.get("prefix")

    @builtins.property
    def range(
        self,
    ) -> typing.Optional[typing.List["AppmeshRouteSpecHttpRouteMatchHeaderMatchRange"]]:
        """range block."""
        return self._values.get("range")

    @builtins.property
    def regex(self) -> typing.Optional[str]:
        return self._values.get("regex")

    @builtins.property
    def suffix(self) -> typing.Optional[str]:
        return self._values.get("suffix")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppmeshRouteSpecHttpRouteMatchHeaderMatch(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AppmeshRouteSpecHttpRouteMatchHeaderMatchRange",
    jsii_struct_bases=[],
    name_mapping={"end": "end", "start": "start"},
)
class AppmeshRouteSpecHttpRouteMatchHeaderMatchRange:
    def __init__(self, *, end: jsii.Number, start: jsii.Number) -> None:
        """
        :param end: 
        :param start: 
        """
        self._values = {
            "end": end,
            "start": start,
        }

    @builtins.property
    def end(self) -> jsii.Number:
        return self._values.get("end")

    @builtins.property
    def start(self) -> jsii.Number:
        return self._values.get("start")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppmeshRouteSpecHttpRouteMatchHeaderMatchRange(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AppmeshRouteSpecTcpRoute",
    jsii_struct_bases=[],
    name_mapping={"action": "action"},
)
class AppmeshRouteSpecTcpRoute:
    def __init__(
        self, *, action: typing.List["AppmeshRouteSpecTcpRouteAction"]
    ) -> None:
        """
        :param action: action block.
        """
        self._values = {
            "action": action,
        }

    @builtins.property
    def action(self) -> typing.List["AppmeshRouteSpecTcpRouteAction"]:
        """action block."""
        return self._values.get("action")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppmeshRouteSpecTcpRoute(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AppmeshRouteSpecTcpRouteAction",
    jsii_struct_bases=[],
    name_mapping={"weighted_target": "weightedTarget"},
)
class AppmeshRouteSpecTcpRouteAction:
    def __init__(
        self,
        *,
        weighted_target: typing.List["AppmeshRouteSpecTcpRouteActionWeightedTarget"],
    ) -> None:
        """
        :param weighted_target: weighted_target block.
        """
        self._values = {
            "weighted_target": weighted_target,
        }

    @builtins.property
    def weighted_target(
        self,
    ) -> typing.List["AppmeshRouteSpecTcpRouteActionWeightedTarget"]:
        """weighted_target block."""
        return self._values.get("weighted_target")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppmeshRouteSpecTcpRouteAction(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AppmeshRouteSpecTcpRouteActionWeightedTarget",
    jsii_struct_bases=[],
    name_mapping={"virtual_node": "virtualNode", "weight": "weight"},
)
class AppmeshRouteSpecTcpRouteActionWeightedTarget:
    def __init__(self, *, virtual_node: str, weight: jsii.Number) -> None:
        """
        :param virtual_node: 
        :param weight: 
        """
        self._values = {
            "virtual_node": virtual_node,
            "weight": weight,
        }

    @builtins.property
    def virtual_node(self) -> str:
        return self._values.get("virtual_node")

    @builtins.property
    def weight(self) -> jsii.Number:
        return self._values.get("weight")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppmeshRouteSpecTcpRouteActionWeightedTarget(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class AppmeshVirtualNode(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="@skorfmann/cdktf-provider-aws.AppmeshVirtualNode",
):
    def __init__(
        self,
        scope: constructs.Construct,
        id: str,
        *,
        mesh_name: str,
        name: str,
        spec: typing.List["AppmeshVirtualNodeSpec"],
        tags: typing.Optional[typing.Mapping[str, str]] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param mesh_name: 
        :param name: 
        :param spec: spec block.
        :param tags: 
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = AppmeshVirtualNodeConfig(
            mesh_name=mesh_name,
            name=name,
            spec=spec,
            tags=tags,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(AppmeshVirtualNode, self, [scope, id, config])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property
    @jsii.member(jsii_name="arn")
    def arn(self) -> str:
        return jsii.get(self, "arn")

    @builtins.property
    @jsii.member(jsii_name="createdDate")
    def created_date(self) -> str:
        return jsii.get(self, "createdDate")

    @builtins.property
    @jsii.member(jsii_name="lastUpdatedDate")
    def last_updated_date(self) -> str:
        return jsii.get(self, "lastUpdatedDate")

    @builtins.property
    @jsii.member(jsii_name="meshName")
    def mesh_name(self) -> str:
        return jsii.get(self, "meshName")

    @mesh_name.setter
    def mesh_name(self, value: str) -> None:
        jsii.set(self, "meshName", value)

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> str:
        return jsii.get(self, "name")

    @name.setter
    def name(self, value: str) -> None:
        jsii.set(self, "name", value)

    @builtins.property
    @jsii.member(jsii_name="spec")
    def spec(self) -> typing.List["AppmeshVirtualNodeSpec"]:
        return jsii.get(self, "spec")

    @spec.setter
    def spec(self, value: typing.List["AppmeshVirtualNodeSpec"]) -> None:
        jsii.set(self, "spec", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="tags")
    def tags(self) -> typing.Optional[typing.Mapping[str, str]]:
        return jsii.get(self, "tags")

    @tags.setter
    def tags(self, value: typing.Optional[typing.Mapping[str, str]]) -> None:
        jsii.set(self, "tags", value)


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AppmeshVirtualNodeConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "mesh_name": "meshName",
        "name": "name",
        "spec": "spec",
        "tags": "tags",
    },
)
class AppmeshVirtualNodeConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        mesh_name: str,
        name: str,
        spec: typing.List["AppmeshVirtualNodeSpec"],
        tags: typing.Optional[typing.Mapping[str, str]] = None,
    ) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param mesh_name: 
        :param name: 
        :param spec: spec block.
        :param tags: 
        """
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        self._values = {
            "mesh_name": mesh_name,
            "name": name,
            "spec": spec,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if tags is not None:
            self._values["tags"] = tags

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("count")

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.TerraformResource]]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("depends_on")

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("lifecycle")

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("provider")

    @builtins.property
    def mesh_name(self) -> str:
        return self._values.get("mesh_name")

    @builtins.property
    def name(self) -> str:
        return self._values.get("name")

    @builtins.property
    def spec(self) -> typing.List["AppmeshVirtualNodeSpec"]:
        """spec block."""
        return self._values.get("spec")

    @builtins.property
    def tags(self) -> typing.Optional[typing.Mapping[str, str]]:
        return self._values.get("tags")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppmeshVirtualNodeConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AppmeshVirtualNodeSpec",
    jsii_struct_bases=[],
    name_mapping={
        "backend": "backend",
        "backends": "backends",
        "listener": "listener",
        "logging": "logging",
        "service_discovery": "serviceDiscovery",
    },
)
class AppmeshVirtualNodeSpec:
    def __init__(
        self,
        *,
        backend: typing.Optional[typing.List["AppmeshVirtualNodeSpecBackend"]] = None,
        backends: typing.Optional[typing.List[str]] = None,
        listener: typing.Optional[typing.List["AppmeshVirtualNodeSpecListener"]] = None,
        logging: typing.Optional[typing.List["AppmeshVirtualNodeSpecLogging"]] = None,
        service_discovery: typing.Optional[
            typing.List["AppmeshVirtualNodeSpecServiceDiscovery"]
        ] = None,
    ) -> None:
        """
        :param backend: backend block.
        :param backends: 
        :param listener: listener block.
        :param logging: logging block.
        :param service_discovery: service_discovery block.
        """
        self._values = {}
        if backend is not None:
            self._values["backend"] = backend
        if backends is not None:
            self._values["backends"] = backends
        if listener is not None:
            self._values["listener"] = listener
        if logging is not None:
            self._values["logging"] = logging
        if service_discovery is not None:
            self._values["service_discovery"] = service_discovery

    @builtins.property
    def backend(self) -> typing.Optional[typing.List["AppmeshVirtualNodeSpecBackend"]]:
        """backend block."""
        return self._values.get("backend")

    @builtins.property
    def backends(self) -> typing.Optional[typing.List[str]]:
        return self._values.get("backends")

    @builtins.property
    def listener(
        self,
    ) -> typing.Optional[typing.List["AppmeshVirtualNodeSpecListener"]]:
        """listener block."""
        return self._values.get("listener")

    @builtins.property
    def logging(self) -> typing.Optional[typing.List["AppmeshVirtualNodeSpecLogging"]]:
        """logging block."""
        return self._values.get("logging")

    @builtins.property
    def service_discovery(
        self,
    ) -> typing.Optional[typing.List["AppmeshVirtualNodeSpecServiceDiscovery"]]:
        """service_discovery block."""
        return self._values.get("service_discovery")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppmeshVirtualNodeSpec(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AppmeshVirtualNodeSpecBackend",
    jsii_struct_bases=[],
    name_mapping={"virtual_service": "virtualService"},
)
class AppmeshVirtualNodeSpecBackend:
    def __init__(
        self,
        *,
        virtual_service: typing.Optional[
            typing.List["AppmeshVirtualNodeSpecBackendVirtualService"]
        ] = None,
    ) -> None:
        """
        :param virtual_service: virtual_service block.
        """
        self._values = {}
        if virtual_service is not None:
            self._values["virtual_service"] = virtual_service

    @builtins.property
    def virtual_service(
        self,
    ) -> typing.Optional[typing.List["AppmeshVirtualNodeSpecBackendVirtualService"]]:
        """virtual_service block."""
        return self._values.get("virtual_service")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppmeshVirtualNodeSpecBackend(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AppmeshVirtualNodeSpecBackendVirtualService",
    jsii_struct_bases=[],
    name_mapping={"virtual_service_name": "virtualServiceName"},
)
class AppmeshVirtualNodeSpecBackendVirtualService:
    def __init__(self, *, virtual_service_name: str) -> None:
        """
        :param virtual_service_name: 
        """
        self._values = {
            "virtual_service_name": virtual_service_name,
        }

    @builtins.property
    def virtual_service_name(self) -> str:
        return self._values.get("virtual_service_name")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppmeshVirtualNodeSpecBackendVirtualService(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AppmeshVirtualNodeSpecListener",
    jsii_struct_bases=[],
    name_mapping={"port_mapping": "portMapping", "health_check": "healthCheck"},
)
class AppmeshVirtualNodeSpecListener:
    def __init__(
        self,
        *,
        port_mapping: typing.List["AppmeshVirtualNodeSpecListenerPortMapping"],
        health_check: typing.Optional[
            typing.List["AppmeshVirtualNodeSpecListenerHealthCheck"]
        ] = None,
    ) -> None:
        """
        :param port_mapping: port_mapping block.
        :param health_check: health_check block.
        """
        self._values = {
            "port_mapping": port_mapping,
        }
        if health_check is not None:
            self._values["health_check"] = health_check

    @builtins.property
    def port_mapping(self) -> typing.List["AppmeshVirtualNodeSpecListenerPortMapping"]:
        """port_mapping block."""
        return self._values.get("port_mapping")

    @builtins.property
    def health_check(
        self,
    ) -> typing.Optional[typing.List["AppmeshVirtualNodeSpecListenerHealthCheck"]]:
        """health_check block."""
        return self._values.get("health_check")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppmeshVirtualNodeSpecListener(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AppmeshVirtualNodeSpecListenerHealthCheck",
    jsii_struct_bases=[],
    name_mapping={
        "healthy_threshold": "healthyThreshold",
        "interval_millis": "intervalMillis",
        "protocol": "protocol",
        "timeout_millis": "timeoutMillis",
        "unhealthy_threshold": "unhealthyThreshold",
        "path": "path",
        "port": "port",
    },
)
class AppmeshVirtualNodeSpecListenerHealthCheck:
    def __init__(
        self,
        *,
        healthy_threshold: jsii.Number,
        interval_millis: jsii.Number,
        protocol: str,
        timeout_millis: jsii.Number,
        unhealthy_threshold: jsii.Number,
        path: typing.Optional[str] = None,
        port: typing.Optional[jsii.Number] = None,
    ) -> None:
        """
        :param healthy_threshold: 
        :param interval_millis: 
        :param protocol: 
        :param timeout_millis: 
        :param unhealthy_threshold: 
        :param path: 
        :param port: 
        """
        self._values = {
            "healthy_threshold": healthy_threshold,
            "interval_millis": interval_millis,
            "protocol": protocol,
            "timeout_millis": timeout_millis,
            "unhealthy_threshold": unhealthy_threshold,
        }
        if path is not None:
            self._values["path"] = path
        if port is not None:
            self._values["port"] = port

    @builtins.property
    def healthy_threshold(self) -> jsii.Number:
        return self._values.get("healthy_threshold")

    @builtins.property
    def interval_millis(self) -> jsii.Number:
        return self._values.get("interval_millis")

    @builtins.property
    def protocol(self) -> str:
        return self._values.get("protocol")

    @builtins.property
    def timeout_millis(self) -> jsii.Number:
        return self._values.get("timeout_millis")

    @builtins.property
    def unhealthy_threshold(self) -> jsii.Number:
        return self._values.get("unhealthy_threshold")

    @builtins.property
    def path(self) -> typing.Optional[str]:
        return self._values.get("path")

    @builtins.property
    def port(self) -> typing.Optional[jsii.Number]:
        return self._values.get("port")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppmeshVirtualNodeSpecListenerHealthCheck(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AppmeshVirtualNodeSpecListenerPortMapping",
    jsii_struct_bases=[],
    name_mapping={"port": "port", "protocol": "protocol"},
)
class AppmeshVirtualNodeSpecListenerPortMapping:
    def __init__(self, *, port: jsii.Number, protocol: str) -> None:
        """
        :param port: 
        :param protocol: 
        """
        self._values = {
            "port": port,
            "protocol": protocol,
        }

    @builtins.property
    def port(self) -> jsii.Number:
        return self._values.get("port")

    @builtins.property
    def protocol(self) -> str:
        return self._values.get("protocol")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppmeshVirtualNodeSpecListenerPortMapping(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AppmeshVirtualNodeSpecLogging",
    jsii_struct_bases=[],
    name_mapping={"access_log": "accessLog"},
)
class AppmeshVirtualNodeSpecLogging:
    def __init__(
        self,
        *,
        access_log: typing.Optional[
            typing.List["AppmeshVirtualNodeSpecLoggingAccessLog"]
        ] = None,
    ) -> None:
        """
        :param access_log: access_log block.
        """
        self._values = {}
        if access_log is not None:
            self._values["access_log"] = access_log

    @builtins.property
    def access_log(
        self,
    ) -> typing.Optional[typing.List["AppmeshVirtualNodeSpecLoggingAccessLog"]]:
        """access_log block."""
        return self._values.get("access_log")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppmeshVirtualNodeSpecLogging(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AppmeshVirtualNodeSpecLoggingAccessLog",
    jsii_struct_bases=[],
    name_mapping={"file": "file"},
)
class AppmeshVirtualNodeSpecLoggingAccessLog:
    def __init__(
        self,
        *,
        file: typing.Optional[
            typing.List["AppmeshVirtualNodeSpecLoggingAccessLogFile"]
        ] = None,
    ) -> None:
        """
        :param file: file block.
        """
        self._values = {}
        if file is not None:
            self._values["file"] = file

    @builtins.property
    def file(
        self,
    ) -> typing.Optional[typing.List["AppmeshVirtualNodeSpecLoggingAccessLogFile"]]:
        """file block."""
        return self._values.get("file")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppmeshVirtualNodeSpecLoggingAccessLog(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AppmeshVirtualNodeSpecLoggingAccessLogFile",
    jsii_struct_bases=[],
    name_mapping={"path": "path"},
)
class AppmeshVirtualNodeSpecLoggingAccessLogFile:
    def __init__(self, *, path: str) -> None:
        """
        :param path: 
        """
        self._values = {
            "path": path,
        }

    @builtins.property
    def path(self) -> str:
        return self._values.get("path")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppmeshVirtualNodeSpecLoggingAccessLogFile(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AppmeshVirtualNodeSpecServiceDiscovery",
    jsii_struct_bases=[],
    name_mapping={"aws_cloud_map": "awsCloudMap", "dns": "dns"},
)
class AppmeshVirtualNodeSpecServiceDiscovery:
    def __init__(
        self,
        *,
        aws_cloud_map: typing.Optional[
            typing.List["AppmeshVirtualNodeSpecServiceDiscoveryAwsCloudMap"]
        ] = None,
        dns: typing.Optional[
            typing.List["AppmeshVirtualNodeSpecServiceDiscoveryDns"]
        ] = None,
    ) -> None:
        """
        :param aws_cloud_map: aws_cloud_map block.
        :param dns: dns block.
        """
        self._values = {}
        if aws_cloud_map is not None:
            self._values["aws_cloud_map"] = aws_cloud_map
        if dns is not None:
            self._values["dns"] = dns

    @builtins.property
    def aws_cloud_map(
        self,
    ) -> typing.Optional[
        typing.List["AppmeshVirtualNodeSpecServiceDiscoveryAwsCloudMap"]
    ]:
        """aws_cloud_map block."""
        return self._values.get("aws_cloud_map")

    @builtins.property
    def dns(
        self,
    ) -> typing.Optional[typing.List["AppmeshVirtualNodeSpecServiceDiscoveryDns"]]:
        """dns block."""
        return self._values.get("dns")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppmeshVirtualNodeSpecServiceDiscovery(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AppmeshVirtualNodeSpecServiceDiscoveryAwsCloudMap",
    jsii_struct_bases=[],
    name_mapping={
        "namespace_name": "namespaceName",
        "service_name": "serviceName",
        "attributes": "attributes",
    },
)
class AppmeshVirtualNodeSpecServiceDiscoveryAwsCloudMap:
    def __init__(
        self,
        *,
        namespace_name: str,
        service_name: str,
        attributes: typing.Optional[typing.Mapping[str, str]] = None,
    ) -> None:
        """
        :param namespace_name: 
        :param service_name: 
        :param attributes: 
        """
        self._values = {
            "namespace_name": namespace_name,
            "service_name": service_name,
        }
        if attributes is not None:
            self._values["attributes"] = attributes

    @builtins.property
    def namespace_name(self) -> str:
        return self._values.get("namespace_name")

    @builtins.property
    def service_name(self) -> str:
        return self._values.get("service_name")

    @builtins.property
    def attributes(self) -> typing.Optional[typing.Mapping[str, str]]:
        return self._values.get("attributes")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppmeshVirtualNodeSpecServiceDiscoveryAwsCloudMap(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AppmeshVirtualNodeSpecServiceDiscoveryDns",
    jsii_struct_bases=[],
    name_mapping={"hostname": "hostname", "service_name": "serviceName"},
)
class AppmeshVirtualNodeSpecServiceDiscoveryDns:
    def __init__(
        self, *, hostname: str, service_name: typing.Optional[str] = None
    ) -> None:
        """
        :param hostname: 
        :param service_name: 
        """
        self._values = {
            "hostname": hostname,
        }
        if service_name is not None:
            self._values["service_name"] = service_name

    @builtins.property
    def hostname(self) -> str:
        return self._values.get("hostname")

    @builtins.property
    def service_name(self) -> typing.Optional[str]:
        return self._values.get("service_name")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppmeshVirtualNodeSpecServiceDiscoveryDns(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class AppmeshVirtualRouter(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="@skorfmann/cdktf-provider-aws.AppmeshVirtualRouter",
):
    def __init__(
        self,
        scope: constructs.Construct,
        id: str,
        *,
        mesh_name: str,
        name: str,
        spec: typing.List["AppmeshVirtualRouterSpec"],
        tags: typing.Optional[typing.Mapping[str, str]] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param mesh_name: 
        :param name: 
        :param spec: spec block.
        :param tags: 
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = AppmeshVirtualRouterConfig(
            mesh_name=mesh_name,
            name=name,
            spec=spec,
            tags=tags,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(AppmeshVirtualRouter, self, [scope, id, config])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property
    @jsii.member(jsii_name="arn")
    def arn(self) -> str:
        return jsii.get(self, "arn")

    @builtins.property
    @jsii.member(jsii_name="createdDate")
    def created_date(self) -> str:
        return jsii.get(self, "createdDate")

    @builtins.property
    @jsii.member(jsii_name="lastUpdatedDate")
    def last_updated_date(self) -> str:
        return jsii.get(self, "lastUpdatedDate")

    @builtins.property
    @jsii.member(jsii_name="meshName")
    def mesh_name(self) -> str:
        return jsii.get(self, "meshName")

    @mesh_name.setter
    def mesh_name(self, value: str) -> None:
        jsii.set(self, "meshName", value)

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> str:
        return jsii.get(self, "name")

    @name.setter
    def name(self, value: str) -> None:
        jsii.set(self, "name", value)

    @builtins.property
    @jsii.member(jsii_name="spec")
    def spec(self) -> typing.List["AppmeshVirtualRouterSpec"]:
        return jsii.get(self, "spec")

    @spec.setter
    def spec(self, value: typing.List["AppmeshVirtualRouterSpec"]) -> None:
        jsii.set(self, "spec", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="tags")
    def tags(self) -> typing.Optional[typing.Mapping[str, str]]:
        return jsii.get(self, "tags")

    @tags.setter
    def tags(self, value: typing.Optional[typing.Mapping[str, str]]) -> None:
        jsii.set(self, "tags", value)


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AppmeshVirtualRouterConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "mesh_name": "meshName",
        "name": "name",
        "spec": "spec",
        "tags": "tags",
    },
)
class AppmeshVirtualRouterConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        mesh_name: str,
        name: str,
        spec: typing.List["AppmeshVirtualRouterSpec"],
        tags: typing.Optional[typing.Mapping[str, str]] = None,
    ) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param mesh_name: 
        :param name: 
        :param spec: spec block.
        :param tags: 
        """
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        self._values = {
            "mesh_name": mesh_name,
            "name": name,
            "spec": spec,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if tags is not None:
            self._values["tags"] = tags

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("count")

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.TerraformResource]]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("depends_on")

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("lifecycle")

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("provider")

    @builtins.property
    def mesh_name(self) -> str:
        return self._values.get("mesh_name")

    @builtins.property
    def name(self) -> str:
        return self._values.get("name")

    @builtins.property
    def spec(self) -> typing.List["AppmeshVirtualRouterSpec"]:
        """spec block."""
        return self._values.get("spec")

    @builtins.property
    def tags(self) -> typing.Optional[typing.Mapping[str, str]]:
        return self._values.get("tags")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppmeshVirtualRouterConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AppmeshVirtualRouterSpec",
    jsii_struct_bases=[],
    name_mapping={"listener": "listener", "service_names": "serviceNames"},
)
class AppmeshVirtualRouterSpec:
    def __init__(
        self,
        *,
        listener: typing.List["AppmeshVirtualRouterSpecListener"],
        service_names: typing.Optional[typing.List[str]] = None,
    ) -> None:
        """
        :param listener: listener block.
        :param service_names: 
        """
        self._values = {
            "listener": listener,
        }
        if service_names is not None:
            self._values["service_names"] = service_names

    @builtins.property
    def listener(self) -> typing.List["AppmeshVirtualRouterSpecListener"]:
        """listener block."""
        return self._values.get("listener")

    @builtins.property
    def service_names(self) -> typing.Optional[typing.List[str]]:
        return self._values.get("service_names")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppmeshVirtualRouterSpec(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AppmeshVirtualRouterSpecListener",
    jsii_struct_bases=[],
    name_mapping={"port_mapping": "portMapping"},
)
class AppmeshVirtualRouterSpecListener:
    def __init__(
        self,
        *,
        port_mapping: typing.List["AppmeshVirtualRouterSpecListenerPortMapping"],
    ) -> None:
        """
        :param port_mapping: port_mapping block.
        """
        self._values = {
            "port_mapping": port_mapping,
        }

    @builtins.property
    def port_mapping(
        self,
    ) -> typing.List["AppmeshVirtualRouterSpecListenerPortMapping"]:
        """port_mapping block."""
        return self._values.get("port_mapping")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppmeshVirtualRouterSpecListener(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AppmeshVirtualRouterSpecListenerPortMapping",
    jsii_struct_bases=[],
    name_mapping={"port": "port", "protocol": "protocol"},
)
class AppmeshVirtualRouterSpecListenerPortMapping:
    def __init__(self, *, port: jsii.Number, protocol: str) -> None:
        """
        :param port: 
        :param protocol: 
        """
        self._values = {
            "port": port,
            "protocol": protocol,
        }

    @builtins.property
    def port(self) -> jsii.Number:
        return self._values.get("port")

    @builtins.property
    def protocol(self) -> str:
        return self._values.get("protocol")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppmeshVirtualRouterSpecListenerPortMapping(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class AppmeshVirtualService(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="@skorfmann/cdktf-provider-aws.AppmeshVirtualService",
):
    def __init__(
        self,
        scope: constructs.Construct,
        id: str,
        *,
        mesh_name: str,
        name: str,
        spec: typing.List["AppmeshVirtualServiceSpec"],
        tags: typing.Optional[typing.Mapping[str, str]] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param mesh_name: 
        :param name: 
        :param spec: spec block.
        :param tags: 
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = AppmeshVirtualServiceConfig(
            mesh_name=mesh_name,
            name=name,
            spec=spec,
            tags=tags,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(AppmeshVirtualService, self, [scope, id, config])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property
    @jsii.member(jsii_name="arn")
    def arn(self) -> str:
        return jsii.get(self, "arn")

    @builtins.property
    @jsii.member(jsii_name="createdDate")
    def created_date(self) -> str:
        return jsii.get(self, "createdDate")

    @builtins.property
    @jsii.member(jsii_name="lastUpdatedDate")
    def last_updated_date(self) -> str:
        return jsii.get(self, "lastUpdatedDate")

    @builtins.property
    @jsii.member(jsii_name="meshName")
    def mesh_name(self) -> str:
        return jsii.get(self, "meshName")

    @mesh_name.setter
    def mesh_name(self, value: str) -> None:
        jsii.set(self, "meshName", value)

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> str:
        return jsii.get(self, "name")

    @name.setter
    def name(self, value: str) -> None:
        jsii.set(self, "name", value)

    @builtins.property
    @jsii.member(jsii_name="spec")
    def spec(self) -> typing.List["AppmeshVirtualServiceSpec"]:
        return jsii.get(self, "spec")

    @spec.setter
    def spec(self, value: typing.List["AppmeshVirtualServiceSpec"]) -> None:
        jsii.set(self, "spec", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="tags")
    def tags(self) -> typing.Optional[typing.Mapping[str, str]]:
        return jsii.get(self, "tags")

    @tags.setter
    def tags(self, value: typing.Optional[typing.Mapping[str, str]]) -> None:
        jsii.set(self, "tags", value)


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AppmeshVirtualServiceConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "mesh_name": "meshName",
        "name": "name",
        "spec": "spec",
        "tags": "tags",
    },
)
class AppmeshVirtualServiceConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        mesh_name: str,
        name: str,
        spec: typing.List["AppmeshVirtualServiceSpec"],
        tags: typing.Optional[typing.Mapping[str, str]] = None,
    ) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param mesh_name: 
        :param name: 
        :param spec: spec block.
        :param tags: 
        """
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        self._values = {
            "mesh_name": mesh_name,
            "name": name,
            "spec": spec,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if tags is not None:
            self._values["tags"] = tags

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("count")

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.TerraformResource]]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("depends_on")

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("lifecycle")

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("provider")

    @builtins.property
    def mesh_name(self) -> str:
        return self._values.get("mesh_name")

    @builtins.property
    def name(self) -> str:
        return self._values.get("name")

    @builtins.property
    def spec(self) -> typing.List["AppmeshVirtualServiceSpec"]:
        """spec block."""
        return self._values.get("spec")

    @builtins.property
    def tags(self) -> typing.Optional[typing.Mapping[str, str]]:
        return self._values.get("tags")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppmeshVirtualServiceConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AppmeshVirtualServiceSpec",
    jsii_struct_bases=[],
    name_mapping={"provider": "provider"},
)
class AppmeshVirtualServiceSpec:
    def __init__(
        self,
        *,
        provider: typing.Optional[
            typing.List["AppmeshVirtualServiceSpecProvider"]
        ] = None,
    ) -> None:
        """
        :param provider: provider block.
        """
        self._values = {}
        if provider is not None:
            self._values["provider"] = provider

    @builtins.property
    def provider(
        self,
    ) -> typing.Optional[typing.List["AppmeshVirtualServiceSpecProvider"]]:
        """provider block."""
        return self._values.get("provider")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppmeshVirtualServiceSpec(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AppmeshVirtualServiceSpecProvider",
    jsii_struct_bases=[],
    name_mapping={"virtual_node": "virtualNode", "virtual_router": "virtualRouter"},
)
class AppmeshVirtualServiceSpecProvider:
    def __init__(
        self,
        *,
        virtual_node: typing.Optional[
            typing.List["AppmeshVirtualServiceSpecProviderVirtualNode"]
        ] = None,
        virtual_router: typing.Optional[
            typing.List["AppmeshVirtualServiceSpecProviderVirtualRouter"]
        ] = None,
    ) -> None:
        """
        :param virtual_node: virtual_node block.
        :param virtual_router: virtual_router block.
        """
        self._values = {}
        if virtual_node is not None:
            self._values["virtual_node"] = virtual_node
        if virtual_router is not None:
            self._values["virtual_router"] = virtual_router

    @builtins.property
    def virtual_node(
        self,
    ) -> typing.Optional[typing.List["AppmeshVirtualServiceSpecProviderVirtualNode"]]:
        """virtual_node block."""
        return self._values.get("virtual_node")

    @builtins.property
    def virtual_router(
        self,
    ) -> typing.Optional[typing.List["AppmeshVirtualServiceSpecProviderVirtualRouter"]]:
        """virtual_router block."""
        return self._values.get("virtual_router")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppmeshVirtualServiceSpecProvider(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AppmeshVirtualServiceSpecProviderVirtualNode",
    jsii_struct_bases=[],
    name_mapping={"virtual_node_name": "virtualNodeName"},
)
class AppmeshVirtualServiceSpecProviderVirtualNode:
    def __init__(self, *, virtual_node_name: str) -> None:
        """
        :param virtual_node_name: 
        """
        self._values = {
            "virtual_node_name": virtual_node_name,
        }

    @builtins.property
    def virtual_node_name(self) -> str:
        return self._values.get("virtual_node_name")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppmeshVirtualServiceSpecProviderVirtualNode(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AppmeshVirtualServiceSpecProviderVirtualRouter",
    jsii_struct_bases=[],
    name_mapping={"virtual_router_name": "virtualRouterName"},
)
class AppmeshVirtualServiceSpecProviderVirtualRouter:
    def __init__(self, *, virtual_router_name: str) -> None:
        """
        :param virtual_router_name: 
        """
        self._values = {
            "virtual_router_name": virtual_router_name,
        }

    @builtins.property
    def virtual_router_name(self) -> str:
        return self._values.get("virtual_router_name")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppmeshVirtualServiceSpecProviderVirtualRouter(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class AppsyncApiKey(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="@skorfmann/cdktf-provider-aws.AppsyncApiKey",
):
    def __init__(
        self,
        scope: constructs.Construct,
        id: str,
        *,
        api_id: str,
        description: typing.Optional[str] = None,
        expires: typing.Optional[str] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param api_id: 
        :param description: 
        :param expires: 
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = AppsyncApiKeyConfig(
            api_id=api_id,
            description=description,
            expires=expires,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(AppsyncApiKey, self, [scope, id, config])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property
    @jsii.member(jsii_name="key")
    def key(self) -> str:
        return jsii.get(self, "key")

    @builtins.property
    @jsii.member(jsii_name="apiId")
    def api_id(self) -> str:
        return jsii.get(self, "apiId")

    @api_id.setter
    def api_id(self, value: str) -> None:
        jsii.set(self, "apiId", value)

    @builtins.property
    @jsii.member(jsii_name="description")
    def description(self) -> typing.Optional[str]:
        return jsii.get(self, "description")

    @description.setter
    def description(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "description", value)

    @builtins.property
    @jsii.member(jsii_name="expires")
    def expires(self) -> typing.Optional[str]:
        return jsii.get(self, "expires")

    @expires.setter
    def expires(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "expires", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AppsyncApiKeyConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "api_id": "apiId",
        "description": "description",
        "expires": "expires",
    },
)
class AppsyncApiKeyConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        api_id: str,
        description: typing.Optional[str] = None,
        expires: typing.Optional[str] = None,
    ) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param api_id: 
        :param description: 
        :param expires: 
        """
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        self._values = {
            "api_id": api_id,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if description is not None:
            self._values["description"] = description
        if expires is not None:
            self._values["expires"] = expires

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("count")

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.TerraformResource]]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("depends_on")

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("lifecycle")

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("provider")

    @builtins.property
    def api_id(self) -> str:
        return self._values.get("api_id")

    @builtins.property
    def description(self) -> typing.Optional[str]:
        return self._values.get("description")

    @builtins.property
    def expires(self) -> typing.Optional[str]:
        return self._values.get("expires")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppsyncApiKeyConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class AppsyncDatasource(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="@skorfmann/cdktf-provider-aws.AppsyncDatasource",
):
    def __init__(
        self,
        scope: constructs.Construct,
        id: str,
        *,
        api_id: str,
        name: str,
        type: str,
        description: typing.Optional[str] = None,
        dynamodb_config: typing.Optional[
            typing.List["AppsyncDatasourceDynamodbConfig"]
        ] = None,
        elasticsearch_config: typing.Optional[
            typing.List["AppsyncDatasourceElasticsearchConfig"]
        ] = None,
        http_config: typing.Optional[typing.List["AppsyncDatasourceHttpConfig"]] = None,
        lambda_config: typing.Optional[
            typing.List["AppsyncDatasourceLambdaConfig"]
        ] = None,
        service_role_arn: typing.Optional[str] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param api_id: 
        :param name: 
        :param type: 
        :param description: 
        :param dynamodb_config: dynamodb_config block.
        :param elasticsearch_config: elasticsearch_config block.
        :param http_config: http_config block.
        :param lambda_config: lambda_config block.
        :param service_role_arn: 
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = AppsyncDatasourceConfig(
            api_id=api_id,
            name=name,
            type=type,
            description=description,
            dynamodb_config=dynamodb_config,
            elasticsearch_config=elasticsearch_config,
            http_config=http_config,
            lambda_config=lambda_config,
            service_role_arn=service_role_arn,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(AppsyncDatasource, self, [scope, id, config])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property
    @jsii.member(jsii_name="arn")
    def arn(self) -> str:
        return jsii.get(self, "arn")

    @builtins.property
    @jsii.member(jsii_name="apiId")
    def api_id(self) -> str:
        return jsii.get(self, "apiId")

    @api_id.setter
    def api_id(self, value: str) -> None:
        jsii.set(self, "apiId", value)

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> str:
        return jsii.get(self, "name")

    @name.setter
    def name(self, value: str) -> None:
        jsii.set(self, "name", value)

    @builtins.property
    @jsii.member(jsii_name="type")
    def type(self) -> str:
        return jsii.get(self, "type")

    @type.setter
    def type(self, value: str) -> None:
        jsii.set(self, "type", value)

    @builtins.property
    @jsii.member(jsii_name="description")
    def description(self) -> typing.Optional[str]:
        return jsii.get(self, "description")

    @description.setter
    def description(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "description", value)

    @builtins.property
    @jsii.member(jsii_name="dynamodbConfig")
    def dynamodb_config(
        self,
    ) -> typing.Optional[typing.List["AppsyncDatasourceDynamodbConfig"]]:
        return jsii.get(self, "dynamodbConfig")

    @dynamodb_config.setter
    def dynamodb_config(
        self, value: typing.Optional[typing.List["AppsyncDatasourceDynamodbConfig"]]
    ) -> None:
        jsii.set(self, "dynamodbConfig", value)

    @builtins.property
    @jsii.member(jsii_name="elasticsearchConfig")
    def elasticsearch_config(
        self,
    ) -> typing.Optional[typing.List["AppsyncDatasourceElasticsearchConfig"]]:
        return jsii.get(self, "elasticsearchConfig")

    @elasticsearch_config.setter
    def elasticsearch_config(
        self,
        value: typing.Optional[typing.List["AppsyncDatasourceElasticsearchConfig"]],
    ) -> None:
        jsii.set(self, "elasticsearchConfig", value)

    @builtins.property
    @jsii.member(jsii_name="httpConfig")
    def http_config(
        self,
    ) -> typing.Optional[typing.List["AppsyncDatasourceHttpConfig"]]:
        return jsii.get(self, "httpConfig")

    @http_config.setter
    def http_config(
        self, value: typing.Optional[typing.List["AppsyncDatasourceHttpConfig"]]
    ) -> None:
        jsii.set(self, "httpConfig", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="lambdaConfig")
    def lambda_config(
        self,
    ) -> typing.Optional[typing.List["AppsyncDatasourceLambdaConfig"]]:
        return jsii.get(self, "lambdaConfig")

    @lambda_config.setter
    def lambda_config(
        self, value: typing.Optional[typing.List["AppsyncDatasourceLambdaConfig"]]
    ) -> None:
        jsii.set(self, "lambdaConfig", value)

    @builtins.property
    @jsii.member(jsii_name="serviceRoleArn")
    def service_role_arn(self) -> typing.Optional[str]:
        return jsii.get(self, "serviceRoleArn")

    @service_role_arn.setter
    def service_role_arn(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "serviceRoleArn", value)


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AppsyncDatasourceConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "api_id": "apiId",
        "name": "name",
        "type": "type",
        "description": "description",
        "dynamodb_config": "dynamodbConfig",
        "elasticsearch_config": "elasticsearchConfig",
        "http_config": "httpConfig",
        "lambda_config": "lambdaConfig",
        "service_role_arn": "serviceRoleArn",
    },
)
class AppsyncDatasourceConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        api_id: str,
        name: str,
        type: str,
        description: typing.Optional[str] = None,
        dynamodb_config: typing.Optional[
            typing.List["AppsyncDatasourceDynamodbConfig"]
        ] = None,
        elasticsearch_config: typing.Optional[
            typing.List["AppsyncDatasourceElasticsearchConfig"]
        ] = None,
        http_config: typing.Optional[typing.List["AppsyncDatasourceHttpConfig"]] = None,
        lambda_config: typing.Optional[
            typing.List["AppsyncDatasourceLambdaConfig"]
        ] = None,
        service_role_arn: typing.Optional[str] = None,
    ) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param api_id: 
        :param name: 
        :param type: 
        :param description: 
        :param dynamodb_config: dynamodb_config block.
        :param elasticsearch_config: elasticsearch_config block.
        :param http_config: http_config block.
        :param lambda_config: lambda_config block.
        :param service_role_arn: 
        """
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        self._values = {
            "api_id": api_id,
            "name": name,
            "type": type,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if description is not None:
            self._values["description"] = description
        if dynamodb_config is not None:
            self._values["dynamodb_config"] = dynamodb_config
        if elasticsearch_config is not None:
            self._values["elasticsearch_config"] = elasticsearch_config
        if http_config is not None:
            self._values["http_config"] = http_config
        if lambda_config is not None:
            self._values["lambda_config"] = lambda_config
        if service_role_arn is not None:
            self._values["service_role_arn"] = service_role_arn

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("count")

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.TerraformResource]]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("depends_on")

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("lifecycle")

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("provider")

    @builtins.property
    def api_id(self) -> str:
        return self._values.get("api_id")

    @builtins.property
    def name(self) -> str:
        return self._values.get("name")

    @builtins.property
    def type(self) -> str:
        return self._values.get("type")

    @builtins.property
    def description(self) -> typing.Optional[str]:
        return self._values.get("description")

    @builtins.property
    def dynamodb_config(
        self,
    ) -> typing.Optional[typing.List["AppsyncDatasourceDynamodbConfig"]]:
        """dynamodb_config block."""
        return self._values.get("dynamodb_config")

    @builtins.property
    def elasticsearch_config(
        self,
    ) -> typing.Optional[typing.List["AppsyncDatasourceElasticsearchConfig"]]:
        """elasticsearch_config block."""
        return self._values.get("elasticsearch_config")

    @builtins.property
    def http_config(
        self,
    ) -> typing.Optional[typing.List["AppsyncDatasourceHttpConfig"]]:
        """http_config block."""
        return self._values.get("http_config")

    @builtins.property
    def lambda_config(
        self,
    ) -> typing.Optional[typing.List["AppsyncDatasourceLambdaConfig"]]:
        """lambda_config block."""
        return self._values.get("lambda_config")

    @builtins.property
    def service_role_arn(self) -> typing.Optional[str]:
        return self._values.get("service_role_arn")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppsyncDatasourceConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AppsyncDatasourceDynamodbConfig",
    jsii_struct_bases=[],
    name_mapping={
        "table_name": "tableName",
        "region": "region",
        "use_caller_credentials": "useCallerCredentials",
    },
)
class AppsyncDatasourceDynamodbConfig:
    def __init__(
        self,
        *,
        table_name: str,
        region: typing.Optional[str] = None,
        use_caller_credentials: typing.Optional[bool] = None,
    ) -> None:
        """
        :param table_name: 
        :param region: 
        :param use_caller_credentials: 
        """
        self._values = {
            "table_name": table_name,
        }
        if region is not None:
            self._values["region"] = region
        if use_caller_credentials is not None:
            self._values["use_caller_credentials"] = use_caller_credentials

    @builtins.property
    def table_name(self) -> str:
        return self._values.get("table_name")

    @builtins.property
    def region(self) -> typing.Optional[str]:
        return self._values.get("region")

    @builtins.property
    def use_caller_credentials(self) -> typing.Optional[bool]:
        return self._values.get("use_caller_credentials")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppsyncDatasourceDynamodbConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AppsyncDatasourceElasticsearchConfig",
    jsii_struct_bases=[],
    name_mapping={"endpoint": "endpoint", "region": "region"},
)
class AppsyncDatasourceElasticsearchConfig:
    def __init__(self, *, endpoint: str, region: typing.Optional[str] = None) -> None:
        """
        :param endpoint: 
        :param region: 
        """
        self._values = {
            "endpoint": endpoint,
        }
        if region is not None:
            self._values["region"] = region

    @builtins.property
    def endpoint(self) -> str:
        return self._values.get("endpoint")

    @builtins.property
    def region(self) -> typing.Optional[str]:
        return self._values.get("region")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppsyncDatasourceElasticsearchConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AppsyncDatasourceHttpConfig",
    jsii_struct_bases=[],
    name_mapping={"endpoint": "endpoint"},
)
class AppsyncDatasourceHttpConfig:
    def __init__(self, *, endpoint: str) -> None:
        """
        :param endpoint: 
        """
        self._values = {
            "endpoint": endpoint,
        }

    @builtins.property
    def endpoint(self) -> str:
        return self._values.get("endpoint")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppsyncDatasourceHttpConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AppsyncDatasourceLambdaConfig",
    jsii_struct_bases=[],
    name_mapping={"function_arn": "functionArn"},
)
class AppsyncDatasourceLambdaConfig:
    def __init__(self, *, function_arn: str) -> None:
        """
        :param function_arn: 
        """
        self._values = {
            "function_arn": function_arn,
        }

    @builtins.property
    def function_arn(self) -> str:
        return self._values.get("function_arn")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppsyncDatasourceLambdaConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class AppsyncFunction(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="@skorfmann/cdktf-provider-aws.AppsyncFunction",
):
    def __init__(
        self,
        scope: constructs.Construct,
        id: str,
        *,
        api_id: str,
        data_source: str,
        name: str,
        request_mapping_template: str,
        response_mapping_template: str,
        description: typing.Optional[str] = None,
        function_version: typing.Optional[str] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param api_id: 
        :param data_source: 
        :param name: 
        :param request_mapping_template: 
        :param response_mapping_template: 
        :param description: 
        :param function_version: 
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = AppsyncFunctionConfig(
            api_id=api_id,
            data_source=data_source,
            name=name,
            request_mapping_template=request_mapping_template,
            response_mapping_template=response_mapping_template,
            description=description,
            function_version=function_version,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(AppsyncFunction, self, [scope, id, config])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property
    @jsii.member(jsii_name="arn")
    def arn(self) -> str:
        return jsii.get(self, "arn")

    @builtins.property
    @jsii.member(jsii_name="functionId")
    def function_id(self) -> str:
        return jsii.get(self, "functionId")

    @builtins.property
    @jsii.member(jsii_name="apiId")
    def api_id(self) -> str:
        return jsii.get(self, "apiId")

    @api_id.setter
    def api_id(self, value: str) -> None:
        jsii.set(self, "apiId", value)

    @builtins.property
    @jsii.member(jsii_name="dataSource")
    def data_source(self) -> str:
        return jsii.get(self, "dataSource")

    @data_source.setter
    def data_source(self, value: str) -> None:
        jsii.set(self, "dataSource", value)

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> str:
        return jsii.get(self, "name")

    @name.setter
    def name(self, value: str) -> None:
        jsii.set(self, "name", value)

    @builtins.property
    @jsii.member(jsii_name="requestMappingTemplate")
    def request_mapping_template(self) -> str:
        return jsii.get(self, "requestMappingTemplate")

    @request_mapping_template.setter
    def request_mapping_template(self, value: str) -> None:
        jsii.set(self, "requestMappingTemplate", value)

    @builtins.property
    @jsii.member(jsii_name="responseMappingTemplate")
    def response_mapping_template(self) -> str:
        return jsii.get(self, "responseMappingTemplate")

    @response_mapping_template.setter
    def response_mapping_template(self, value: str) -> None:
        jsii.set(self, "responseMappingTemplate", value)

    @builtins.property
    @jsii.member(jsii_name="description")
    def description(self) -> typing.Optional[str]:
        return jsii.get(self, "description")

    @description.setter
    def description(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "description", value)

    @builtins.property
    @jsii.member(jsii_name="functionVersion")
    def function_version(self) -> typing.Optional[str]:
        return jsii.get(self, "functionVersion")

    @function_version.setter
    def function_version(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "functionVersion", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AppsyncFunctionConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "api_id": "apiId",
        "data_source": "dataSource",
        "name": "name",
        "request_mapping_template": "requestMappingTemplate",
        "response_mapping_template": "responseMappingTemplate",
        "description": "description",
        "function_version": "functionVersion",
    },
)
class AppsyncFunctionConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        api_id: str,
        data_source: str,
        name: str,
        request_mapping_template: str,
        response_mapping_template: str,
        description: typing.Optional[str] = None,
        function_version: typing.Optional[str] = None,
    ) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param api_id: 
        :param data_source: 
        :param name: 
        :param request_mapping_template: 
        :param response_mapping_template: 
        :param description: 
        :param function_version: 
        """
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        self._values = {
            "api_id": api_id,
            "data_source": data_source,
            "name": name,
            "request_mapping_template": request_mapping_template,
            "response_mapping_template": response_mapping_template,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if description is not None:
            self._values["description"] = description
        if function_version is not None:
            self._values["function_version"] = function_version

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("count")

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.TerraformResource]]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("depends_on")

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("lifecycle")

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("provider")

    @builtins.property
    def api_id(self) -> str:
        return self._values.get("api_id")

    @builtins.property
    def data_source(self) -> str:
        return self._values.get("data_source")

    @builtins.property
    def name(self) -> str:
        return self._values.get("name")

    @builtins.property
    def request_mapping_template(self) -> str:
        return self._values.get("request_mapping_template")

    @builtins.property
    def response_mapping_template(self) -> str:
        return self._values.get("response_mapping_template")

    @builtins.property
    def description(self) -> typing.Optional[str]:
        return self._values.get("description")

    @builtins.property
    def function_version(self) -> typing.Optional[str]:
        return self._values.get("function_version")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppsyncFunctionConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class AppsyncGraphqlApi(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="@skorfmann/cdktf-provider-aws.AppsyncGraphqlApi",
):
    def __init__(
        self,
        scope: constructs.Construct,
        id: str,
        *,
        authentication_type: str,
        name: str,
        additional_authentication_provider: typing.Optional[
            typing.List["AppsyncGraphqlApiAdditionalAuthenticationProvider"]
        ] = None,
        log_config: typing.Optional[typing.List["AppsyncGraphqlApiLogConfig"]] = None,
        openid_connect_config: typing.Optional[
            typing.List["AppsyncGraphqlApiOpenidConnectConfig"]
        ] = None,
        schema: typing.Optional[str] = None,
        tags: typing.Optional[typing.Mapping[str, str]] = None,
        user_pool_config: typing.Optional[
            typing.List["AppsyncGraphqlApiUserPoolConfig"]
        ] = None,
        xray_enabled: typing.Optional[bool] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param authentication_type: 
        :param name: 
        :param additional_authentication_provider: additional_authentication_provider block.
        :param log_config: log_config block.
        :param openid_connect_config: openid_connect_config block.
        :param schema: 
        :param tags: 
        :param user_pool_config: user_pool_config block.
        :param xray_enabled: 
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = AppsyncGraphqlApiConfig(
            authentication_type=authentication_type,
            name=name,
            additional_authentication_provider=additional_authentication_provider,
            log_config=log_config,
            openid_connect_config=openid_connect_config,
            schema=schema,
            tags=tags,
            user_pool_config=user_pool_config,
            xray_enabled=xray_enabled,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(AppsyncGraphqlApi, self, [scope, id, config])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @jsii.member(jsii_name="uris")
    def uris(self, key: str) -> str:
        """
        :param key: -
        """
        return jsii.invoke(self, "uris", [key])

    @builtins.property
    @jsii.member(jsii_name="arn")
    def arn(self) -> str:
        return jsii.get(self, "arn")

    @builtins.property
    @jsii.member(jsii_name="authenticationType")
    def authentication_type(self) -> str:
        return jsii.get(self, "authenticationType")

    @authentication_type.setter
    def authentication_type(self, value: str) -> None:
        jsii.set(self, "authenticationType", value)

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> str:
        return jsii.get(self, "name")

    @name.setter
    def name(self, value: str) -> None:
        jsii.set(self, "name", value)

    @builtins.property
    @jsii.member(jsii_name="additionalAuthenticationProvider")
    def additional_authentication_provider(
        self,
    ) -> typing.Optional[
        typing.List["AppsyncGraphqlApiAdditionalAuthenticationProvider"]
    ]:
        return jsii.get(self, "additionalAuthenticationProvider")

    @additional_authentication_provider.setter
    def additional_authentication_provider(
        self,
        value: typing.Optional[
            typing.List["AppsyncGraphqlApiAdditionalAuthenticationProvider"]
        ],
    ) -> None:
        jsii.set(self, "additionalAuthenticationProvider", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="logConfig")
    def log_config(self) -> typing.Optional[typing.List["AppsyncGraphqlApiLogConfig"]]:
        return jsii.get(self, "logConfig")

    @log_config.setter
    def log_config(
        self, value: typing.Optional[typing.List["AppsyncGraphqlApiLogConfig"]]
    ) -> None:
        jsii.set(self, "logConfig", value)

    @builtins.property
    @jsii.member(jsii_name="openidConnectConfig")
    def openid_connect_config(
        self,
    ) -> typing.Optional[typing.List["AppsyncGraphqlApiOpenidConnectConfig"]]:
        return jsii.get(self, "openidConnectConfig")

    @openid_connect_config.setter
    def openid_connect_config(
        self,
        value: typing.Optional[typing.List["AppsyncGraphqlApiOpenidConnectConfig"]],
    ) -> None:
        jsii.set(self, "openidConnectConfig", value)

    @builtins.property
    @jsii.member(jsii_name="schema")
    def schema(self) -> typing.Optional[str]:
        return jsii.get(self, "schema")

    @schema.setter
    def schema(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "schema", value)

    @builtins.property
    @jsii.member(jsii_name="tags")
    def tags(self) -> typing.Optional[typing.Mapping[str, str]]:
        return jsii.get(self, "tags")

    @tags.setter
    def tags(self, value: typing.Optional[typing.Mapping[str, str]]) -> None:
        jsii.set(self, "tags", value)

    @builtins.property
    @jsii.member(jsii_name="userPoolConfig")
    def user_pool_config(
        self,
    ) -> typing.Optional[typing.List["AppsyncGraphqlApiUserPoolConfig"]]:
        return jsii.get(self, "userPoolConfig")

    @user_pool_config.setter
    def user_pool_config(
        self, value: typing.Optional[typing.List["AppsyncGraphqlApiUserPoolConfig"]]
    ) -> None:
        jsii.set(self, "userPoolConfig", value)

    @builtins.property
    @jsii.member(jsii_name="xrayEnabled")
    def xray_enabled(self) -> typing.Optional[bool]:
        return jsii.get(self, "xrayEnabled")

    @xray_enabled.setter
    def xray_enabled(self, value: typing.Optional[bool]) -> None:
        jsii.set(self, "xrayEnabled", value)


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AppsyncGraphqlApiAdditionalAuthenticationProvider",
    jsii_struct_bases=[],
    name_mapping={
        "authentication_type": "authenticationType",
        "openid_connect_config": "openidConnectConfig",
        "user_pool_config": "userPoolConfig",
    },
)
class AppsyncGraphqlApiAdditionalAuthenticationProvider:
    def __init__(
        self,
        *,
        authentication_type: str,
        openid_connect_config: typing.Optional[
            typing.List[
                "AppsyncGraphqlApiAdditionalAuthenticationProviderOpenidConnectConfig"
            ]
        ] = None,
        user_pool_config: typing.Optional[
            typing.List[
                "AppsyncGraphqlApiAdditionalAuthenticationProviderUserPoolConfig"
            ]
        ] = None,
    ) -> None:
        """
        :param authentication_type: 
        :param openid_connect_config: openid_connect_config block.
        :param user_pool_config: user_pool_config block.
        """
        self._values = {
            "authentication_type": authentication_type,
        }
        if openid_connect_config is not None:
            self._values["openid_connect_config"] = openid_connect_config
        if user_pool_config is not None:
            self._values["user_pool_config"] = user_pool_config

    @builtins.property
    def authentication_type(self) -> str:
        return self._values.get("authentication_type")

    @builtins.property
    def openid_connect_config(
        self,
    ) -> typing.Optional[
        typing.List[
            "AppsyncGraphqlApiAdditionalAuthenticationProviderOpenidConnectConfig"
        ]
    ]:
        """openid_connect_config block."""
        return self._values.get("openid_connect_config")

    @builtins.property
    def user_pool_config(
        self,
    ) -> typing.Optional[
        typing.List["AppsyncGraphqlApiAdditionalAuthenticationProviderUserPoolConfig"]
    ]:
        """user_pool_config block."""
        return self._values.get("user_pool_config")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppsyncGraphqlApiAdditionalAuthenticationProvider(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AppsyncGraphqlApiAdditionalAuthenticationProviderOpenidConnectConfig",
    jsii_struct_bases=[],
    name_mapping={
        "issuer": "issuer",
        "auth_ttl": "authTtl",
        "client_id": "clientId",
        "iat_ttl": "iatTtl",
    },
)
class AppsyncGraphqlApiAdditionalAuthenticationProviderOpenidConnectConfig:
    def __init__(
        self,
        *,
        issuer: str,
        auth_ttl: typing.Optional[jsii.Number] = None,
        client_id: typing.Optional[str] = None,
        iat_ttl: typing.Optional[jsii.Number] = None,
    ) -> None:
        """
        :param issuer: 
        :param auth_ttl: 
        :param client_id: 
        :param iat_ttl: 
        """
        self._values = {
            "issuer": issuer,
        }
        if auth_ttl is not None:
            self._values["auth_ttl"] = auth_ttl
        if client_id is not None:
            self._values["client_id"] = client_id
        if iat_ttl is not None:
            self._values["iat_ttl"] = iat_ttl

    @builtins.property
    def issuer(self) -> str:
        return self._values.get("issuer")

    @builtins.property
    def auth_ttl(self) -> typing.Optional[jsii.Number]:
        return self._values.get("auth_ttl")

    @builtins.property
    def client_id(self) -> typing.Optional[str]:
        return self._values.get("client_id")

    @builtins.property
    def iat_ttl(self) -> typing.Optional[jsii.Number]:
        return self._values.get("iat_ttl")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return (
            "AppsyncGraphqlApiAdditionalAuthenticationProviderOpenidConnectConfig(%s)"
            % ", ".join(k + "=" + repr(v) for k, v in self._values.items())
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AppsyncGraphqlApiAdditionalAuthenticationProviderUserPoolConfig",
    jsii_struct_bases=[],
    name_mapping={
        "user_pool_id": "userPoolId",
        "app_id_client_regex": "appIdClientRegex",
        "aws_region": "awsRegion",
    },
)
class AppsyncGraphqlApiAdditionalAuthenticationProviderUserPoolConfig:
    def __init__(
        self,
        *,
        user_pool_id: str,
        app_id_client_regex: typing.Optional[str] = None,
        aws_region: typing.Optional[str] = None,
    ) -> None:
        """
        :param user_pool_id: 
        :param app_id_client_regex: 
        :param aws_region: 
        """
        self._values = {
            "user_pool_id": user_pool_id,
        }
        if app_id_client_regex is not None:
            self._values["app_id_client_regex"] = app_id_client_regex
        if aws_region is not None:
            self._values["aws_region"] = aws_region

    @builtins.property
    def user_pool_id(self) -> str:
        return self._values.get("user_pool_id")

    @builtins.property
    def app_id_client_regex(self) -> typing.Optional[str]:
        return self._values.get("app_id_client_regex")

    @builtins.property
    def aws_region(self) -> typing.Optional[str]:
        return self._values.get("aws_region")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return (
            "AppsyncGraphqlApiAdditionalAuthenticationProviderUserPoolConfig(%s)"
            % ", ".join(k + "=" + repr(v) for k, v in self._values.items())
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AppsyncGraphqlApiConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "authentication_type": "authenticationType",
        "name": "name",
        "additional_authentication_provider": "additionalAuthenticationProvider",
        "log_config": "logConfig",
        "openid_connect_config": "openidConnectConfig",
        "schema": "schema",
        "tags": "tags",
        "user_pool_config": "userPoolConfig",
        "xray_enabled": "xrayEnabled",
    },
)
class AppsyncGraphqlApiConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        authentication_type: str,
        name: str,
        additional_authentication_provider: typing.Optional[
            typing.List["AppsyncGraphqlApiAdditionalAuthenticationProvider"]
        ] = None,
        log_config: typing.Optional[typing.List["AppsyncGraphqlApiLogConfig"]] = None,
        openid_connect_config: typing.Optional[
            typing.List["AppsyncGraphqlApiOpenidConnectConfig"]
        ] = None,
        schema: typing.Optional[str] = None,
        tags: typing.Optional[typing.Mapping[str, str]] = None,
        user_pool_config: typing.Optional[
            typing.List["AppsyncGraphqlApiUserPoolConfig"]
        ] = None,
        xray_enabled: typing.Optional[bool] = None,
    ) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param authentication_type: 
        :param name: 
        :param additional_authentication_provider: additional_authentication_provider block.
        :param log_config: log_config block.
        :param openid_connect_config: openid_connect_config block.
        :param schema: 
        :param tags: 
        :param user_pool_config: user_pool_config block.
        :param xray_enabled: 
        """
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        self._values = {
            "authentication_type": authentication_type,
            "name": name,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if additional_authentication_provider is not None:
            self._values[
                "additional_authentication_provider"
            ] = additional_authentication_provider
        if log_config is not None:
            self._values["log_config"] = log_config
        if openid_connect_config is not None:
            self._values["openid_connect_config"] = openid_connect_config
        if schema is not None:
            self._values["schema"] = schema
        if tags is not None:
            self._values["tags"] = tags
        if user_pool_config is not None:
            self._values["user_pool_config"] = user_pool_config
        if xray_enabled is not None:
            self._values["xray_enabled"] = xray_enabled

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("count")

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.TerraformResource]]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("depends_on")

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("lifecycle")

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("provider")

    @builtins.property
    def authentication_type(self) -> str:
        return self._values.get("authentication_type")

    @builtins.property
    def name(self) -> str:
        return self._values.get("name")

    @builtins.property
    def additional_authentication_provider(
        self,
    ) -> typing.Optional[
        typing.List["AppsyncGraphqlApiAdditionalAuthenticationProvider"]
    ]:
        """additional_authentication_provider block."""
        return self._values.get("additional_authentication_provider")

    @builtins.property
    def log_config(self) -> typing.Optional[typing.List["AppsyncGraphqlApiLogConfig"]]:
        """log_config block."""
        return self._values.get("log_config")

    @builtins.property
    def openid_connect_config(
        self,
    ) -> typing.Optional[typing.List["AppsyncGraphqlApiOpenidConnectConfig"]]:
        """openid_connect_config block."""
        return self._values.get("openid_connect_config")

    @builtins.property
    def schema(self) -> typing.Optional[str]:
        return self._values.get("schema")

    @builtins.property
    def tags(self) -> typing.Optional[typing.Mapping[str, str]]:
        return self._values.get("tags")

    @builtins.property
    def user_pool_config(
        self,
    ) -> typing.Optional[typing.List["AppsyncGraphqlApiUserPoolConfig"]]:
        """user_pool_config block."""
        return self._values.get("user_pool_config")

    @builtins.property
    def xray_enabled(self) -> typing.Optional[bool]:
        return self._values.get("xray_enabled")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppsyncGraphqlApiConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AppsyncGraphqlApiLogConfig",
    jsii_struct_bases=[],
    name_mapping={
        "cloudwatch_logs_role_arn": "cloudwatchLogsRoleArn",
        "field_log_level": "fieldLogLevel",
        "exclude_verbose_content": "excludeVerboseContent",
    },
)
class AppsyncGraphqlApiLogConfig:
    def __init__(
        self,
        *,
        cloudwatch_logs_role_arn: str,
        field_log_level: str,
        exclude_verbose_content: typing.Optional[bool] = None,
    ) -> None:
        """
        :param cloudwatch_logs_role_arn: 
        :param field_log_level: 
        :param exclude_verbose_content: 
        """
        self._values = {
            "cloudwatch_logs_role_arn": cloudwatch_logs_role_arn,
            "field_log_level": field_log_level,
        }
        if exclude_verbose_content is not None:
            self._values["exclude_verbose_content"] = exclude_verbose_content

    @builtins.property
    def cloudwatch_logs_role_arn(self) -> str:
        return self._values.get("cloudwatch_logs_role_arn")

    @builtins.property
    def field_log_level(self) -> str:
        return self._values.get("field_log_level")

    @builtins.property
    def exclude_verbose_content(self) -> typing.Optional[bool]:
        return self._values.get("exclude_verbose_content")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppsyncGraphqlApiLogConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AppsyncGraphqlApiOpenidConnectConfig",
    jsii_struct_bases=[],
    name_mapping={
        "issuer": "issuer",
        "auth_ttl": "authTtl",
        "client_id": "clientId",
        "iat_ttl": "iatTtl",
    },
)
class AppsyncGraphqlApiOpenidConnectConfig:
    def __init__(
        self,
        *,
        issuer: str,
        auth_ttl: typing.Optional[jsii.Number] = None,
        client_id: typing.Optional[str] = None,
        iat_ttl: typing.Optional[jsii.Number] = None,
    ) -> None:
        """
        :param issuer: 
        :param auth_ttl: 
        :param client_id: 
        :param iat_ttl: 
        """
        self._values = {
            "issuer": issuer,
        }
        if auth_ttl is not None:
            self._values["auth_ttl"] = auth_ttl
        if client_id is not None:
            self._values["client_id"] = client_id
        if iat_ttl is not None:
            self._values["iat_ttl"] = iat_ttl

    @builtins.property
    def issuer(self) -> str:
        return self._values.get("issuer")

    @builtins.property
    def auth_ttl(self) -> typing.Optional[jsii.Number]:
        return self._values.get("auth_ttl")

    @builtins.property
    def client_id(self) -> typing.Optional[str]:
        return self._values.get("client_id")

    @builtins.property
    def iat_ttl(self) -> typing.Optional[jsii.Number]:
        return self._values.get("iat_ttl")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppsyncGraphqlApiOpenidConnectConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AppsyncGraphqlApiUserPoolConfig",
    jsii_struct_bases=[],
    name_mapping={
        "default_action": "defaultAction",
        "user_pool_id": "userPoolId",
        "app_id_client_regex": "appIdClientRegex",
        "aws_region": "awsRegion",
    },
)
class AppsyncGraphqlApiUserPoolConfig:
    def __init__(
        self,
        *,
        default_action: str,
        user_pool_id: str,
        app_id_client_regex: typing.Optional[str] = None,
        aws_region: typing.Optional[str] = None,
    ) -> None:
        """
        :param default_action: 
        :param user_pool_id: 
        :param app_id_client_regex: 
        :param aws_region: 
        """
        self._values = {
            "default_action": default_action,
            "user_pool_id": user_pool_id,
        }
        if app_id_client_regex is not None:
            self._values["app_id_client_regex"] = app_id_client_regex
        if aws_region is not None:
            self._values["aws_region"] = aws_region

    @builtins.property
    def default_action(self) -> str:
        return self._values.get("default_action")

    @builtins.property
    def user_pool_id(self) -> str:
        return self._values.get("user_pool_id")

    @builtins.property
    def app_id_client_regex(self) -> typing.Optional[str]:
        return self._values.get("app_id_client_regex")

    @builtins.property
    def aws_region(self) -> typing.Optional[str]:
        return self._values.get("aws_region")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppsyncGraphqlApiUserPoolConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class AppsyncResolver(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="@skorfmann/cdktf-provider-aws.AppsyncResolver",
):
    def __init__(
        self,
        scope: constructs.Construct,
        id: str,
        *,
        api_id: str,
        field: str,
        request_template: str,
        response_template: str,
        type: str,
        caching_config: typing.Optional[
            typing.List["AppsyncResolverCachingConfig"]
        ] = None,
        data_source: typing.Optional[str] = None,
        kind: typing.Optional[str] = None,
        pipeline_config: typing.Optional[
            typing.List["AppsyncResolverPipelineConfig"]
        ] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param api_id: 
        :param field: 
        :param request_template: 
        :param response_template: 
        :param type: 
        :param caching_config: caching_config block.
        :param data_source: 
        :param kind: 
        :param pipeline_config: pipeline_config block.
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = AppsyncResolverConfig(
            api_id=api_id,
            field=field,
            request_template=request_template,
            response_template=response_template,
            type=type,
            caching_config=caching_config,
            data_source=data_source,
            kind=kind,
            pipeline_config=pipeline_config,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(AppsyncResolver, self, [scope, id, config])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property
    @jsii.member(jsii_name="arn")
    def arn(self) -> str:
        return jsii.get(self, "arn")

    @builtins.property
    @jsii.member(jsii_name="apiId")
    def api_id(self) -> str:
        return jsii.get(self, "apiId")

    @api_id.setter
    def api_id(self, value: str) -> None:
        jsii.set(self, "apiId", value)

    @builtins.property
    @jsii.member(jsii_name="field")
    def field(self) -> str:
        return jsii.get(self, "field")

    @field.setter
    def field(self, value: str) -> None:
        jsii.set(self, "field", value)

    @builtins.property
    @jsii.member(jsii_name="requestTemplate")
    def request_template(self) -> str:
        return jsii.get(self, "requestTemplate")

    @request_template.setter
    def request_template(self, value: str) -> None:
        jsii.set(self, "requestTemplate", value)

    @builtins.property
    @jsii.member(jsii_name="responseTemplate")
    def response_template(self) -> str:
        return jsii.get(self, "responseTemplate")

    @response_template.setter
    def response_template(self, value: str) -> None:
        jsii.set(self, "responseTemplate", value)

    @builtins.property
    @jsii.member(jsii_name="type")
    def type(self) -> str:
        return jsii.get(self, "type")

    @type.setter
    def type(self, value: str) -> None:
        jsii.set(self, "type", value)

    @builtins.property
    @jsii.member(jsii_name="cachingConfig")
    def caching_config(
        self,
    ) -> typing.Optional[typing.List["AppsyncResolverCachingConfig"]]:
        return jsii.get(self, "cachingConfig")

    @caching_config.setter
    def caching_config(
        self, value: typing.Optional[typing.List["AppsyncResolverCachingConfig"]]
    ) -> None:
        jsii.set(self, "cachingConfig", value)

    @builtins.property
    @jsii.member(jsii_name="dataSource")
    def data_source(self) -> typing.Optional[str]:
        return jsii.get(self, "dataSource")

    @data_source.setter
    def data_source(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "dataSource", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="kind")
    def kind(self) -> typing.Optional[str]:
        return jsii.get(self, "kind")

    @kind.setter
    def kind(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "kind", value)

    @builtins.property
    @jsii.member(jsii_name="pipelineConfig")
    def pipeline_config(
        self,
    ) -> typing.Optional[typing.List["AppsyncResolverPipelineConfig"]]:
        return jsii.get(self, "pipelineConfig")

    @pipeline_config.setter
    def pipeline_config(
        self, value: typing.Optional[typing.List["AppsyncResolverPipelineConfig"]]
    ) -> None:
        jsii.set(self, "pipelineConfig", value)


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AppsyncResolverCachingConfig",
    jsii_struct_bases=[],
    name_mapping={"caching_keys": "cachingKeys", "ttl": "ttl"},
)
class AppsyncResolverCachingConfig:
    def __init__(
        self,
        *,
        caching_keys: typing.Optional[typing.List[str]] = None,
        ttl: typing.Optional[jsii.Number] = None,
    ) -> None:
        """
        :param caching_keys: 
        :param ttl: 
        """
        self._values = {}
        if caching_keys is not None:
            self._values["caching_keys"] = caching_keys
        if ttl is not None:
            self._values["ttl"] = ttl

    @builtins.property
    def caching_keys(self) -> typing.Optional[typing.List[str]]:
        return self._values.get("caching_keys")

    @builtins.property
    def ttl(self) -> typing.Optional[jsii.Number]:
        return self._values.get("ttl")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppsyncResolverCachingConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AppsyncResolverConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "api_id": "apiId",
        "field": "field",
        "request_template": "requestTemplate",
        "response_template": "responseTemplate",
        "type": "type",
        "caching_config": "cachingConfig",
        "data_source": "dataSource",
        "kind": "kind",
        "pipeline_config": "pipelineConfig",
    },
)
class AppsyncResolverConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        api_id: str,
        field: str,
        request_template: str,
        response_template: str,
        type: str,
        caching_config: typing.Optional[
            typing.List["AppsyncResolverCachingConfig"]
        ] = None,
        data_source: typing.Optional[str] = None,
        kind: typing.Optional[str] = None,
        pipeline_config: typing.Optional[
            typing.List["AppsyncResolverPipelineConfig"]
        ] = None,
    ) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param api_id: 
        :param field: 
        :param request_template: 
        :param response_template: 
        :param type: 
        :param caching_config: caching_config block.
        :param data_source: 
        :param kind: 
        :param pipeline_config: pipeline_config block.
        """
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        self._values = {
            "api_id": api_id,
            "field": field,
            "request_template": request_template,
            "response_template": response_template,
            "type": type,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if caching_config is not None:
            self._values["caching_config"] = caching_config
        if data_source is not None:
            self._values["data_source"] = data_source
        if kind is not None:
            self._values["kind"] = kind
        if pipeline_config is not None:
            self._values["pipeline_config"] = pipeline_config

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("count")

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.TerraformResource]]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("depends_on")

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("lifecycle")

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("provider")

    @builtins.property
    def api_id(self) -> str:
        return self._values.get("api_id")

    @builtins.property
    def field(self) -> str:
        return self._values.get("field")

    @builtins.property
    def request_template(self) -> str:
        return self._values.get("request_template")

    @builtins.property
    def response_template(self) -> str:
        return self._values.get("response_template")

    @builtins.property
    def type(self) -> str:
        return self._values.get("type")

    @builtins.property
    def caching_config(
        self,
    ) -> typing.Optional[typing.List["AppsyncResolverCachingConfig"]]:
        """caching_config block."""
        return self._values.get("caching_config")

    @builtins.property
    def data_source(self) -> typing.Optional[str]:
        return self._values.get("data_source")

    @builtins.property
    def kind(self) -> typing.Optional[str]:
        return self._values.get("kind")

    @builtins.property
    def pipeline_config(
        self,
    ) -> typing.Optional[typing.List["AppsyncResolverPipelineConfig"]]:
        """pipeline_config block."""
        return self._values.get("pipeline_config")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppsyncResolverConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AppsyncResolverPipelineConfig",
    jsii_struct_bases=[],
    name_mapping={"functions": "functions"},
)
class AppsyncResolverPipelineConfig:
    def __init__(self, *, functions: typing.Optional[typing.List[str]] = None) -> None:
        """
        :param functions: 
        """
        self._values = {}
        if functions is not None:
            self._values["functions"] = functions

    @builtins.property
    def functions(self) -> typing.Optional[typing.List[str]]:
        return self._values.get("functions")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AppsyncResolverPipelineConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class AthenaDatabase(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="@skorfmann/cdktf-provider-aws.AthenaDatabase",
):
    def __init__(
        self,
        scope: constructs.Construct,
        id: str,
        *,
        bucket: str,
        name: str,
        encryption_configuration: typing.Optional[
            typing.List["AthenaDatabaseEncryptionConfiguration"]
        ] = None,
        force_destroy: typing.Optional[bool] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param bucket: 
        :param name: 
        :param encryption_configuration: encryption_configuration block.
        :param force_destroy: 
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = AthenaDatabaseConfig(
            bucket=bucket,
            name=name,
            encryption_configuration=encryption_configuration,
            force_destroy=force_destroy,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(AthenaDatabase, self, [scope, id, config])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property
    @jsii.member(jsii_name="bucket")
    def bucket(self) -> str:
        return jsii.get(self, "bucket")

    @bucket.setter
    def bucket(self, value: str) -> None:
        jsii.set(self, "bucket", value)

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> str:
        return jsii.get(self, "name")

    @name.setter
    def name(self, value: str) -> None:
        jsii.set(self, "name", value)

    @builtins.property
    @jsii.member(jsii_name="encryptionConfiguration")
    def encryption_configuration(
        self,
    ) -> typing.Optional[typing.List["AthenaDatabaseEncryptionConfiguration"]]:
        return jsii.get(self, "encryptionConfiguration")

    @encryption_configuration.setter
    def encryption_configuration(
        self,
        value: typing.Optional[typing.List["AthenaDatabaseEncryptionConfiguration"]],
    ) -> None:
        jsii.set(self, "encryptionConfiguration", value)

    @builtins.property
    @jsii.member(jsii_name="forceDestroy")
    def force_destroy(self) -> typing.Optional[bool]:
        return jsii.get(self, "forceDestroy")

    @force_destroy.setter
    def force_destroy(self, value: typing.Optional[bool]) -> None:
        jsii.set(self, "forceDestroy", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AthenaDatabaseConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "bucket": "bucket",
        "name": "name",
        "encryption_configuration": "encryptionConfiguration",
        "force_destroy": "forceDestroy",
    },
)
class AthenaDatabaseConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        bucket: str,
        name: str,
        encryption_configuration: typing.Optional[
            typing.List["AthenaDatabaseEncryptionConfiguration"]
        ] = None,
        force_destroy: typing.Optional[bool] = None,
    ) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param bucket: 
        :param name: 
        :param encryption_configuration: encryption_configuration block.
        :param force_destroy: 
        """
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        self._values = {
            "bucket": bucket,
            "name": name,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if encryption_configuration is not None:
            self._values["encryption_configuration"] = encryption_configuration
        if force_destroy is not None:
            self._values["force_destroy"] = force_destroy

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("count")

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.TerraformResource]]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("depends_on")

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("lifecycle")

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("provider")

    @builtins.property
    def bucket(self) -> str:
        return self._values.get("bucket")

    @builtins.property
    def name(self) -> str:
        return self._values.get("name")

    @builtins.property
    def encryption_configuration(
        self,
    ) -> typing.Optional[typing.List["AthenaDatabaseEncryptionConfiguration"]]:
        """encryption_configuration block."""
        return self._values.get("encryption_configuration")

    @builtins.property
    def force_destroy(self) -> typing.Optional[bool]:
        return self._values.get("force_destroy")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AthenaDatabaseConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AthenaDatabaseEncryptionConfiguration",
    jsii_struct_bases=[],
    name_mapping={"encryption_option": "encryptionOption", "kms_key": "kmsKey"},
)
class AthenaDatabaseEncryptionConfiguration:
    def __init__(
        self, *, encryption_option: str, kms_key: typing.Optional[str] = None
    ) -> None:
        """
        :param encryption_option: 
        :param kms_key: 
        """
        self._values = {
            "encryption_option": encryption_option,
        }
        if kms_key is not None:
            self._values["kms_key"] = kms_key

    @builtins.property
    def encryption_option(self) -> str:
        return self._values.get("encryption_option")

    @builtins.property
    def kms_key(self) -> typing.Optional[str]:
        return self._values.get("kms_key")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AthenaDatabaseEncryptionConfiguration(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class AthenaNamedQuery(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="@skorfmann/cdktf-provider-aws.AthenaNamedQuery",
):
    def __init__(
        self,
        scope: constructs.Construct,
        id: str,
        *,
        database: str,
        name: str,
        query: str,
        description: typing.Optional[str] = None,
        workgroup: typing.Optional[str] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param database: 
        :param name: 
        :param query: 
        :param description: 
        :param workgroup: 
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = AthenaNamedQueryConfig(
            database=database,
            name=name,
            query=query,
            description=description,
            workgroup=workgroup,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(AthenaNamedQuery, self, [scope, id, config])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property
    @jsii.member(jsii_name="database")
    def database(self) -> str:
        return jsii.get(self, "database")

    @database.setter
    def database(self, value: str) -> None:
        jsii.set(self, "database", value)

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> str:
        return jsii.get(self, "name")

    @name.setter
    def name(self, value: str) -> None:
        jsii.set(self, "name", value)

    @builtins.property
    @jsii.member(jsii_name="query")
    def query(self) -> str:
        return jsii.get(self, "query")

    @query.setter
    def query(self, value: str) -> None:
        jsii.set(self, "query", value)

    @builtins.property
    @jsii.member(jsii_name="description")
    def description(self) -> typing.Optional[str]:
        return jsii.get(self, "description")

    @description.setter
    def description(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "description", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="workgroup")
    def workgroup(self) -> typing.Optional[str]:
        return jsii.get(self, "workgroup")

    @workgroup.setter
    def workgroup(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "workgroup", value)


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AthenaNamedQueryConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "database": "database",
        "name": "name",
        "query": "query",
        "description": "description",
        "workgroup": "workgroup",
    },
)
class AthenaNamedQueryConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        database: str,
        name: str,
        query: str,
        description: typing.Optional[str] = None,
        workgroup: typing.Optional[str] = None,
    ) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param database: 
        :param name: 
        :param query: 
        :param description: 
        :param workgroup: 
        """
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        self._values = {
            "database": database,
            "name": name,
            "query": query,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if description is not None:
            self._values["description"] = description
        if workgroup is not None:
            self._values["workgroup"] = workgroup

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("count")

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.TerraformResource]]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("depends_on")

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("lifecycle")

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("provider")

    @builtins.property
    def database(self) -> str:
        return self._values.get("database")

    @builtins.property
    def name(self) -> str:
        return self._values.get("name")

    @builtins.property
    def query(self) -> str:
        return self._values.get("query")

    @builtins.property
    def description(self) -> typing.Optional[str]:
        return self._values.get("description")

    @builtins.property
    def workgroup(self) -> typing.Optional[str]:
        return self._values.get("workgroup")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AthenaNamedQueryConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class AthenaWorkgroup(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="@skorfmann/cdktf-provider-aws.AthenaWorkgroup",
):
    def __init__(
        self,
        scope: constructs.Construct,
        id: str,
        *,
        name: str,
        configuration: typing.Optional[
            typing.List["AthenaWorkgroupConfiguration"]
        ] = None,
        description: typing.Optional[str] = None,
        force_destroy: typing.Optional[bool] = None,
        state: typing.Optional[str] = None,
        tags: typing.Optional[typing.Mapping[str, str]] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param name: 
        :param configuration: configuration block.
        :param description: 
        :param force_destroy: 
        :param state: 
        :param tags: 
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = AthenaWorkgroupConfig(
            name=name,
            configuration=configuration,
            description=description,
            force_destroy=force_destroy,
            state=state,
            tags=tags,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(AthenaWorkgroup, self, [scope, id, config])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property
    @jsii.member(jsii_name="arn")
    def arn(self) -> str:
        return jsii.get(self, "arn")

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> str:
        return jsii.get(self, "name")

    @name.setter
    def name(self, value: str) -> None:
        jsii.set(self, "name", value)

    @builtins.property
    @jsii.member(jsii_name="configuration")
    def configuration(
        self,
    ) -> typing.Optional[typing.List["AthenaWorkgroupConfiguration"]]:
        return jsii.get(self, "configuration")

    @configuration.setter
    def configuration(
        self, value: typing.Optional[typing.List["AthenaWorkgroupConfiguration"]]
    ) -> None:
        jsii.set(self, "configuration", value)

    @builtins.property
    @jsii.member(jsii_name="description")
    def description(self) -> typing.Optional[str]:
        return jsii.get(self, "description")

    @description.setter
    def description(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "description", value)

    @builtins.property
    @jsii.member(jsii_name="forceDestroy")
    def force_destroy(self) -> typing.Optional[bool]:
        return jsii.get(self, "forceDestroy")

    @force_destroy.setter
    def force_destroy(self, value: typing.Optional[bool]) -> None:
        jsii.set(self, "forceDestroy", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="state")
    def state(self) -> typing.Optional[str]:
        return jsii.get(self, "state")

    @state.setter
    def state(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "state", value)

    @builtins.property
    @jsii.member(jsii_name="tags")
    def tags(self) -> typing.Optional[typing.Mapping[str, str]]:
        return jsii.get(self, "tags")

    @tags.setter
    def tags(self, value: typing.Optional[typing.Mapping[str, str]]) -> None:
        jsii.set(self, "tags", value)


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AthenaWorkgroupConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "name": "name",
        "configuration": "configuration",
        "description": "description",
        "force_destroy": "forceDestroy",
        "state": "state",
        "tags": "tags",
    },
)
class AthenaWorkgroupConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        name: str,
        configuration: typing.Optional[
            typing.List["AthenaWorkgroupConfiguration"]
        ] = None,
        description: typing.Optional[str] = None,
        force_destroy: typing.Optional[bool] = None,
        state: typing.Optional[str] = None,
        tags: typing.Optional[typing.Mapping[str, str]] = None,
    ) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param name: 
        :param configuration: configuration block.
        :param description: 
        :param force_destroy: 
        :param state: 
        :param tags: 
        """
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        self._values = {
            "name": name,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if configuration is not None:
            self._values["configuration"] = configuration
        if description is not None:
            self._values["description"] = description
        if force_destroy is not None:
            self._values["force_destroy"] = force_destroy
        if state is not None:
            self._values["state"] = state
        if tags is not None:
            self._values["tags"] = tags

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("count")

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.TerraformResource]]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("depends_on")

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("lifecycle")

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("provider")

    @builtins.property
    def name(self) -> str:
        return self._values.get("name")

    @builtins.property
    def configuration(
        self,
    ) -> typing.Optional[typing.List["AthenaWorkgroupConfiguration"]]:
        """configuration block."""
        return self._values.get("configuration")

    @builtins.property
    def description(self) -> typing.Optional[str]:
        return self._values.get("description")

    @builtins.property
    def force_destroy(self) -> typing.Optional[bool]:
        return self._values.get("force_destroy")

    @builtins.property
    def state(self) -> typing.Optional[str]:
        return self._values.get("state")

    @builtins.property
    def tags(self) -> typing.Optional[typing.Mapping[str, str]]:
        return self._values.get("tags")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AthenaWorkgroupConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AthenaWorkgroupConfiguration",
    jsii_struct_bases=[],
    name_mapping={
        "bytes_scanned_cutoff_per_query": "bytesScannedCutoffPerQuery",
        "enforce_workgroup_configuration": "enforceWorkgroupConfiguration",
        "publish_cloudwatch_metrics_enabled": "publishCloudwatchMetricsEnabled",
        "result_configuration": "resultConfiguration",
    },
)
class AthenaWorkgroupConfiguration:
    def __init__(
        self,
        *,
        bytes_scanned_cutoff_per_query: typing.Optional[jsii.Number] = None,
        enforce_workgroup_configuration: typing.Optional[bool] = None,
        publish_cloudwatch_metrics_enabled: typing.Optional[bool] = None,
        result_configuration: typing.Optional[
            typing.List["AthenaWorkgroupConfigurationResultConfiguration"]
        ] = None,
    ) -> None:
        """
        :param bytes_scanned_cutoff_per_query: 
        :param enforce_workgroup_configuration: 
        :param publish_cloudwatch_metrics_enabled: 
        :param result_configuration: result_configuration block.
        """
        self._values = {}
        if bytes_scanned_cutoff_per_query is not None:
            self._values[
                "bytes_scanned_cutoff_per_query"
            ] = bytes_scanned_cutoff_per_query
        if enforce_workgroup_configuration is not None:
            self._values[
                "enforce_workgroup_configuration"
            ] = enforce_workgroup_configuration
        if publish_cloudwatch_metrics_enabled is not None:
            self._values[
                "publish_cloudwatch_metrics_enabled"
            ] = publish_cloudwatch_metrics_enabled
        if result_configuration is not None:
            self._values["result_configuration"] = result_configuration

    @builtins.property
    def bytes_scanned_cutoff_per_query(self) -> typing.Optional[jsii.Number]:
        return self._values.get("bytes_scanned_cutoff_per_query")

    @builtins.property
    def enforce_workgroup_configuration(self) -> typing.Optional[bool]:
        return self._values.get("enforce_workgroup_configuration")

    @builtins.property
    def publish_cloudwatch_metrics_enabled(self) -> typing.Optional[bool]:
        return self._values.get("publish_cloudwatch_metrics_enabled")

    @builtins.property
    def result_configuration(
        self,
    ) -> typing.Optional[
        typing.List["AthenaWorkgroupConfigurationResultConfiguration"]
    ]:
        """result_configuration block."""
        return self._values.get("result_configuration")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AthenaWorkgroupConfiguration(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AthenaWorkgroupConfigurationResultConfiguration",
    jsii_struct_bases=[],
    name_mapping={
        "encryption_configuration": "encryptionConfiguration",
        "output_location": "outputLocation",
    },
)
class AthenaWorkgroupConfigurationResultConfiguration:
    def __init__(
        self,
        *,
        encryption_configuration: typing.Optional[
            typing.List[
                "AthenaWorkgroupConfigurationResultConfigurationEncryptionConfiguration"
            ]
        ] = None,
        output_location: typing.Optional[str] = None,
    ) -> None:
        """
        :param encryption_configuration: encryption_configuration block.
        :param output_location: 
        """
        self._values = {}
        if encryption_configuration is not None:
            self._values["encryption_configuration"] = encryption_configuration
        if output_location is not None:
            self._values["output_location"] = output_location

    @builtins.property
    def encryption_configuration(
        self,
    ) -> typing.Optional[
        typing.List[
            "AthenaWorkgroupConfigurationResultConfigurationEncryptionConfiguration"
        ]
    ]:
        """encryption_configuration block."""
        return self._values.get("encryption_configuration")

    @builtins.property
    def output_location(self) -> typing.Optional[str]:
        return self._values.get("output_location")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AthenaWorkgroupConfigurationResultConfiguration(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AthenaWorkgroupConfigurationResultConfigurationEncryptionConfiguration",
    jsii_struct_bases=[],
    name_mapping={"encryption_option": "encryptionOption", "kms_key_arn": "kmsKeyArn"},
)
class AthenaWorkgroupConfigurationResultConfigurationEncryptionConfiguration:
    def __init__(
        self,
        *,
        encryption_option: typing.Optional[str] = None,
        kms_key_arn: typing.Optional[str] = None,
    ) -> None:
        """
        :param encryption_option: 
        :param kms_key_arn: 
        """
        self._values = {}
        if encryption_option is not None:
            self._values["encryption_option"] = encryption_option
        if kms_key_arn is not None:
            self._values["kms_key_arn"] = kms_key_arn

    @builtins.property
    def encryption_option(self) -> typing.Optional[str]:
        return self._values.get("encryption_option")

    @builtins.property
    def kms_key_arn(self) -> typing.Optional[str]:
        return self._values.get("kms_key_arn")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return (
            "AthenaWorkgroupConfigurationResultConfigurationEncryptionConfiguration(%s)"
            % ", ".join(k + "=" + repr(v) for k, v in self._values.items())
        )


class AutoscalingAttachment(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="@skorfmann/cdktf-provider-aws.AutoscalingAttachment",
):
    def __init__(
        self,
        scope: constructs.Construct,
        id: str,
        *,
        autoscaling_group_name: str,
        alb_target_group_arn: typing.Optional[str] = None,
        elb: typing.Optional[str] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param autoscaling_group_name: 
        :param alb_target_group_arn: 
        :param elb: 
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = AutoscalingAttachmentConfig(
            autoscaling_group_name=autoscaling_group_name,
            alb_target_group_arn=alb_target_group_arn,
            elb=elb,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(AutoscalingAttachment, self, [scope, id, config])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property
    @jsii.member(jsii_name="autoscalingGroupName")
    def autoscaling_group_name(self) -> str:
        return jsii.get(self, "autoscalingGroupName")

    @autoscaling_group_name.setter
    def autoscaling_group_name(self, value: str) -> None:
        jsii.set(self, "autoscalingGroupName", value)

    @builtins.property
    @jsii.member(jsii_name="albTargetGroupArn")
    def alb_target_group_arn(self) -> typing.Optional[str]:
        return jsii.get(self, "albTargetGroupArn")

    @alb_target_group_arn.setter
    def alb_target_group_arn(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "albTargetGroupArn", value)

    @builtins.property
    @jsii.member(jsii_name="elb")
    def elb(self) -> typing.Optional[str]:
        return jsii.get(self, "elb")

    @elb.setter
    def elb(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "elb", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AutoscalingAttachmentConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "autoscaling_group_name": "autoscalingGroupName",
        "alb_target_group_arn": "albTargetGroupArn",
        "elb": "elb",
    },
)
class AutoscalingAttachmentConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        autoscaling_group_name: str,
        alb_target_group_arn: typing.Optional[str] = None,
        elb: typing.Optional[str] = None,
    ) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param autoscaling_group_name: 
        :param alb_target_group_arn: 
        :param elb: 
        """
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        self._values = {
            "autoscaling_group_name": autoscaling_group_name,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if alb_target_group_arn is not None:
            self._values["alb_target_group_arn"] = alb_target_group_arn
        if elb is not None:
            self._values["elb"] = elb

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("count")

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.TerraformResource]]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("depends_on")

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("lifecycle")

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("provider")

    @builtins.property
    def autoscaling_group_name(self) -> str:
        return self._values.get("autoscaling_group_name")

    @builtins.property
    def alb_target_group_arn(self) -> typing.Optional[str]:
        return self._values.get("alb_target_group_arn")

    @builtins.property
    def elb(self) -> typing.Optional[str]:
        return self._values.get("elb")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AutoscalingAttachmentConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class AutoscalingGroup(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="@skorfmann/cdktf-provider-aws.AutoscalingGroup",
):
    def __init__(
        self,
        scope: constructs.Construct,
        id: str,
        *,
        max_size: jsii.Number,
        min_size: jsii.Number,
        availability_zones: typing.Optional[typing.List[str]] = None,
        default_cooldown: typing.Optional[jsii.Number] = None,
        desired_capacity: typing.Optional[jsii.Number] = None,
        enabled_metrics: typing.Optional[typing.List[str]] = None,
        force_delete: typing.Optional[bool] = None,
        health_check_grace_period: typing.Optional[jsii.Number] = None,
        health_check_type: typing.Optional[str] = None,
        initial_lifecycle_hook: typing.Optional[
            typing.List["AutoscalingGroupInitialLifecycleHook"]
        ] = None,
        launch_configuration: typing.Optional[str] = None,
        launch_template: typing.Optional[
            typing.List["AutoscalingGroupLaunchTemplate"]
        ] = None,
        load_balancers: typing.Optional[typing.List[str]] = None,
        max_instance_lifetime: typing.Optional[jsii.Number] = None,
        metrics_granularity: typing.Optional[str] = None,
        min_elb_capacity: typing.Optional[jsii.Number] = None,
        mixed_instances_policy: typing.Optional[
            typing.List["AutoscalingGroupMixedInstancesPolicy"]
        ] = None,
        name: typing.Optional[str] = None,
        name_prefix: typing.Optional[str] = None,
        placement_group: typing.Optional[str] = None,
        protect_from_scale_in: typing.Optional[bool] = None,
        service_linked_role_arn: typing.Optional[str] = None,
        suspended_processes: typing.Optional[typing.List[str]] = None,
        tag: typing.Optional[typing.List["AutoscalingGroupTag"]] = None,
        tags: typing.Optional[typing.Mapping[str, str]] = None,
        target_group_arns: typing.Optional[typing.List[str]] = None,
        termination_policies: typing.Optional[typing.List[str]] = None,
        timeouts: typing.Optional["AutoscalingGroupTimeouts"] = None,
        vpc_zone_identifier: typing.Optional[typing.List[str]] = None,
        wait_for_capacity_timeout: typing.Optional[str] = None,
        wait_for_elb_capacity: typing.Optional[jsii.Number] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param max_size: 
        :param min_size: 
        :param availability_zones: 
        :param default_cooldown: 
        :param desired_capacity: 
        :param enabled_metrics: 
        :param force_delete: 
        :param health_check_grace_period: 
        :param health_check_type: 
        :param initial_lifecycle_hook: initial_lifecycle_hook block.
        :param launch_configuration: 
        :param launch_template: launch_template block.
        :param load_balancers: 
        :param max_instance_lifetime: 
        :param metrics_granularity: 
        :param min_elb_capacity: 
        :param mixed_instances_policy: mixed_instances_policy block.
        :param name: 
        :param name_prefix: 
        :param placement_group: 
        :param protect_from_scale_in: 
        :param service_linked_role_arn: 
        :param suspended_processes: 
        :param tag: tag block.
        :param tags: 
        :param target_group_arns: 
        :param termination_policies: 
        :param timeouts: timeouts block.
        :param vpc_zone_identifier: 
        :param wait_for_capacity_timeout: 
        :param wait_for_elb_capacity: 
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = AutoscalingGroupConfig(
            max_size=max_size,
            min_size=min_size,
            availability_zones=availability_zones,
            default_cooldown=default_cooldown,
            desired_capacity=desired_capacity,
            enabled_metrics=enabled_metrics,
            force_delete=force_delete,
            health_check_grace_period=health_check_grace_period,
            health_check_type=health_check_type,
            initial_lifecycle_hook=initial_lifecycle_hook,
            launch_configuration=launch_configuration,
            launch_template=launch_template,
            load_balancers=load_balancers,
            max_instance_lifetime=max_instance_lifetime,
            metrics_granularity=metrics_granularity,
            min_elb_capacity=min_elb_capacity,
            mixed_instances_policy=mixed_instances_policy,
            name=name,
            name_prefix=name_prefix,
            placement_group=placement_group,
            protect_from_scale_in=protect_from_scale_in,
            service_linked_role_arn=service_linked_role_arn,
            suspended_processes=suspended_processes,
            tag=tag,
            tags=tags,
            target_group_arns=target_group_arns,
            termination_policies=termination_policies,
            timeouts=timeouts,
            vpc_zone_identifier=vpc_zone_identifier,
            wait_for_capacity_timeout=wait_for_capacity_timeout,
            wait_for_elb_capacity=wait_for_elb_capacity,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(AutoscalingGroup, self, [scope, id, config])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property
    @jsii.member(jsii_name="arn")
    def arn(self) -> str:
        return jsii.get(self, "arn")

    @builtins.property
    @jsii.member(jsii_name="maxSize")
    def max_size(self) -> jsii.Number:
        return jsii.get(self, "maxSize")

    @max_size.setter
    def max_size(self, value: jsii.Number) -> None:
        jsii.set(self, "maxSize", value)

    @builtins.property
    @jsii.member(jsii_name="minSize")
    def min_size(self) -> jsii.Number:
        return jsii.get(self, "minSize")

    @min_size.setter
    def min_size(self, value: jsii.Number) -> None:
        jsii.set(self, "minSize", value)

    @builtins.property
    @jsii.member(jsii_name="availabilityZones")
    def availability_zones(self) -> typing.Optional[typing.List[str]]:
        return jsii.get(self, "availabilityZones")

    @availability_zones.setter
    def availability_zones(self, value: typing.Optional[typing.List[str]]) -> None:
        jsii.set(self, "availabilityZones", value)

    @builtins.property
    @jsii.member(jsii_name="defaultCooldown")
    def default_cooldown(self) -> typing.Optional[jsii.Number]:
        return jsii.get(self, "defaultCooldown")

    @default_cooldown.setter
    def default_cooldown(self, value: typing.Optional[jsii.Number]) -> None:
        jsii.set(self, "defaultCooldown", value)

    @builtins.property
    @jsii.member(jsii_name="desiredCapacity")
    def desired_capacity(self) -> typing.Optional[jsii.Number]:
        return jsii.get(self, "desiredCapacity")

    @desired_capacity.setter
    def desired_capacity(self, value: typing.Optional[jsii.Number]) -> None:
        jsii.set(self, "desiredCapacity", value)

    @builtins.property
    @jsii.member(jsii_name="enabledMetrics")
    def enabled_metrics(self) -> typing.Optional[typing.List[str]]:
        return jsii.get(self, "enabledMetrics")

    @enabled_metrics.setter
    def enabled_metrics(self, value: typing.Optional[typing.List[str]]) -> None:
        jsii.set(self, "enabledMetrics", value)

    @builtins.property
    @jsii.member(jsii_name="forceDelete")
    def force_delete(self) -> typing.Optional[bool]:
        return jsii.get(self, "forceDelete")

    @force_delete.setter
    def force_delete(self, value: typing.Optional[bool]) -> None:
        jsii.set(self, "forceDelete", value)

    @builtins.property
    @jsii.member(jsii_name="healthCheckGracePeriod")
    def health_check_grace_period(self) -> typing.Optional[jsii.Number]:
        return jsii.get(self, "healthCheckGracePeriod")

    @health_check_grace_period.setter
    def health_check_grace_period(self, value: typing.Optional[jsii.Number]) -> None:
        jsii.set(self, "healthCheckGracePeriod", value)

    @builtins.property
    @jsii.member(jsii_name="healthCheckType")
    def health_check_type(self) -> typing.Optional[str]:
        return jsii.get(self, "healthCheckType")

    @health_check_type.setter
    def health_check_type(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "healthCheckType", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="initialLifecycleHook")
    def initial_lifecycle_hook(
        self,
    ) -> typing.Optional[typing.List["AutoscalingGroupInitialLifecycleHook"]]:
        return jsii.get(self, "initialLifecycleHook")

    @initial_lifecycle_hook.setter
    def initial_lifecycle_hook(
        self,
        value: typing.Optional[typing.List["AutoscalingGroupInitialLifecycleHook"]],
    ) -> None:
        jsii.set(self, "initialLifecycleHook", value)

    @builtins.property
    @jsii.member(jsii_name="launchConfiguration")
    def launch_configuration(self) -> typing.Optional[str]:
        return jsii.get(self, "launchConfiguration")

    @launch_configuration.setter
    def launch_configuration(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "launchConfiguration", value)

    @builtins.property
    @jsii.member(jsii_name="launchTemplate")
    def launch_template(
        self,
    ) -> typing.Optional[typing.List["AutoscalingGroupLaunchTemplate"]]:
        return jsii.get(self, "launchTemplate")

    @launch_template.setter
    def launch_template(
        self, value: typing.Optional[typing.List["AutoscalingGroupLaunchTemplate"]]
    ) -> None:
        jsii.set(self, "launchTemplate", value)

    @builtins.property
    @jsii.member(jsii_name="loadBalancers")
    def load_balancers(self) -> typing.Optional[typing.List[str]]:
        return jsii.get(self, "loadBalancers")

    @load_balancers.setter
    def load_balancers(self, value: typing.Optional[typing.List[str]]) -> None:
        jsii.set(self, "loadBalancers", value)

    @builtins.property
    @jsii.member(jsii_name="maxInstanceLifetime")
    def max_instance_lifetime(self) -> typing.Optional[jsii.Number]:
        return jsii.get(self, "maxInstanceLifetime")

    @max_instance_lifetime.setter
    def max_instance_lifetime(self, value: typing.Optional[jsii.Number]) -> None:
        jsii.set(self, "maxInstanceLifetime", value)

    @builtins.property
    @jsii.member(jsii_name="metricsGranularity")
    def metrics_granularity(self) -> typing.Optional[str]:
        return jsii.get(self, "metricsGranularity")

    @metrics_granularity.setter
    def metrics_granularity(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "metricsGranularity", value)

    @builtins.property
    @jsii.member(jsii_name="minElbCapacity")
    def min_elb_capacity(self) -> typing.Optional[jsii.Number]:
        return jsii.get(self, "minElbCapacity")

    @min_elb_capacity.setter
    def min_elb_capacity(self, value: typing.Optional[jsii.Number]) -> None:
        jsii.set(self, "minElbCapacity", value)

    @builtins.property
    @jsii.member(jsii_name="mixedInstancesPolicy")
    def mixed_instances_policy(
        self,
    ) -> typing.Optional[typing.List["AutoscalingGroupMixedInstancesPolicy"]]:
        return jsii.get(self, "mixedInstancesPolicy")

    @mixed_instances_policy.setter
    def mixed_instances_policy(
        self,
        value: typing.Optional[typing.List["AutoscalingGroupMixedInstancesPolicy"]],
    ) -> None:
        jsii.set(self, "mixedInstancesPolicy", value)

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> typing.Optional[str]:
        return jsii.get(self, "name")

    @name.setter
    def name(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "name", value)

    @builtins.property
    @jsii.member(jsii_name="namePrefix")
    def name_prefix(self) -> typing.Optional[str]:
        return jsii.get(self, "namePrefix")

    @name_prefix.setter
    def name_prefix(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "namePrefix", value)

    @builtins.property
    @jsii.member(jsii_name="placementGroup")
    def placement_group(self) -> typing.Optional[str]:
        return jsii.get(self, "placementGroup")

    @placement_group.setter
    def placement_group(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "placementGroup", value)

    @builtins.property
    @jsii.member(jsii_name="protectFromScaleIn")
    def protect_from_scale_in(self) -> typing.Optional[bool]:
        return jsii.get(self, "protectFromScaleIn")

    @protect_from_scale_in.setter
    def protect_from_scale_in(self, value: typing.Optional[bool]) -> None:
        jsii.set(self, "protectFromScaleIn", value)

    @builtins.property
    @jsii.member(jsii_name="serviceLinkedRoleArn")
    def service_linked_role_arn(self) -> typing.Optional[str]:
        return jsii.get(self, "serviceLinkedRoleArn")

    @service_linked_role_arn.setter
    def service_linked_role_arn(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "serviceLinkedRoleArn", value)

    @builtins.property
    @jsii.member(jsii_name="suspendedProcesses")
    def suspended_processes(self) -> typing.Optional[typing.List[str]]:
        return jsii.get(self, "suspendedProcesses")

    @suspended_processes.setter
    def suspended_processes(self, value: typing.Optional[typing.List[str]]) -> None:
        jsii.set(self, "suspendedProcesses", value)

    @builtins.property
    @jsii.member(jsii_name="tag")
    def tag(self) -> typing.Optional[typing.List["AutoscalingGroupTag"]]:
        return jsii.get(self, "tag")

    @tag.setter
    def tag(self, value: typing.Optional[typing.List["AutoscalingGroupTag"]]) -> None:
        jsii.set(self, "tag", value)

    @builtins.property
    @jsii.member(jsii_name="tags")
    def tags(self) -> typing.Optional[typing.Mapping[str, str]]:
        return jsii.get(self, "tags")

    @tags.setter
    def tags(self, value: typing.Optional[typing.Mapping[str, str]]) -> None:
        jsii.set(self, "tags", value)

    @builtins.property
    @jsii.member(jsii_name="targetGroupArns")
    def target_group_arns(self) -> typing.Optional[typing.List[str]]:
        return jsii.get(self, "targetGroupArns")

    @target_group_arns.setter
    def target_group_arns(self, value: typing.Optional[typing.List[str]]) -> None:
        jsii.set(self, "targetGroupArns", value)

    @builtins.property
    @jsii.member(jsii_name="terminationPolicies")
    def termination_policies(self) -> typing.Optional[typing.List[str]]:
        return jsii.get(self, "terminationPolicies")

    @termination_policies.setter
    def termination_policies(self, value: typing.Optional[typing.List[str]]) -> None:
        jsii.set(self, "terminationPolicies", value)

    @builtins.property
    @jsii.member(jsii_name="timeouts")
    def timeouts(self) -> typing.Optional["AutoscalingGroupTimeouts"]:
        return jsii.get(self, "timeouts")

    @timeouts.setter
    def timeouts(self, value: typing.Optional["AutoscalingGroupTimeouts"]) -> None:
        jsii.set(self, "timeouts", value)

    @builtins.property
    @jsii.member(jsii_name="vpcZoneIdentifier")
    def vpc_zone_identifier(self) -> typing.Optional[typing.List[str]]:
        return jsii.get(self, "vpcZoneIdentifier")

    @vpc_zone_identifier.setter
    def vpc_zone_identifier(self, value: typing.Optional[typing.List[str]]) -> None:
        jsii.set(self, "vpcZoneIdentifier", value)

    @builtins.property
    @jsii.member(jsii_name="waitForCapacityTimeout")
    def wait_for_capacity_timeout(self) -> typing.Optional[str]:
        return jsii.get(self, "waitForCapacityTimeout")

    @wait_for_capacity_timeout.setter
    def wait_for_capacity_timeout(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "waitForCapacityTimeout", value)

    @builtins.property
    @jsii.member(jsii_name="waitForElbCapacity")
    def wait_for_elb_capacity(self) -> typing.Optional[jsii.Number]:
        return jsii.get(self, "waitForElbCapacity")

    @wait_for_elb_capacity.setter
    def wait_for_elb_capacity(self, value: typing.Optional[jsii.Number]) -> None:
        jsii.set(self, "waitForElbCapacity", value)


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AutoscalingGroupConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "max_size": "maxSize",
        "min_size": "minSize",
        "availability_zones": "availabilityZones",
        "default_cooldown": "defaultCooldown",
        "desired_capacity": "desiredCapacity",
        "enabled_metrics": "enabledMetrics",
        "force_delete": "forceDelete",
        "health_check_grace_period": "healthCheckGracePeriod",
        "health_check_type": "healthCheckType",
        "initial_lifecycle_hook": "initialLifecycleHook",
        "launch_configuration": "launchConfiguration",
        "launch_template": "launchTemplate",
        "load_balancers": "loadBalancers",
        "max_instance_lifetime": "maxInstanceLifetime",
        "metrics_granularity": "metricsGranularity",
        "min_elb_capacity": "minElbCapacity",
        "mixed_instances_policy": "mixedInstancesPolicy",
        "name": "name",
        "name_prefix": "namePrefix",
        "placement_group": "placementGroup",
        "protect_from_scale_in": "protectFromScaleIn",
        "service_linked_role_arn": "serviceLinkedRoleArn",
        "suspended_processes": "suspendedProcesses",
        "tag": "tag",
        "tags": "tags",
        "target_group_arns": "targetGroupArns",
        "termination_policies": "terminationPolicies",
        "timeouts": "timeouts",
        "vpc_zone_identifier": "vpcZoneIdentifier",
        "wait_for_capacity_timeout": "waitForCapacityTimeout",
        "wait_for_elb_capacity": "waitForElbCapacity",
    },
)
class AutoscalingGroupConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        max_size: jsii.Number,
        min_size: jsii.Number,
        availability_zones: typing.Optional[typing.List[str]] = None,
        default_cooldown: typing.Optional[jsii.Number] = None,
        desired_capacity: typing.Optional[jsii.Number] = None,
        enabled_metrics: typing.Optional[typing.List[str]] = None,
        force_delete: typing.Optional[bool] = None,
        health_check_grace_period: typing.Optional[jsii.Number] = None,
        health_check_type: typing.Optional[str] = None,
        initial_lifecycle_hook: typing.Optional[
            typing.List["AutoscalingGroupInitialLifecycleHook"]
        ] = None,
        launch_configuration: typing.Optional[str] = None,
        launch_template: typing.Optional[
            typing.List["AutoscalingGroupLaunchTemplate"]
        ] = None,
        load_balancers: typing.Optional[typing.List[str]] = None,
        max_instance_lifetime: typing.Optional[jsii.Number] = None,
        metrics_granularity: typing.Optional[str] = None,
        min_elb_capacity: typing.Optional[jsii.Number] = None,
        mixed_instances_policy: typing.Optional[
            typing.List["AutoscalingGroupMixedInstancesPolicy"]
        ] = None,
        name: typing.Optional[str] = None,
        name_prefix: typing.Optional[str] = None,
        placement_group: typing.Optional[str] = None,
        protect_from_scale_in: typing.Optional[bool] = None,
        service_linked_role_arn: typing.Optional[str] = None,
        suspended_processes: typing.Optional[typing.List[str]] = None,
        tag: typing.Optional[typing.List["AutoscalingGroupTag"]] = None,
        tags: typing.Optional[typing.Mapping[str, str]] = None,
        target_group_arns: typing.Optional[typing.List[str]] = None,
        termination_policies: typing.Optional[typing.List[str]] = None,
        timeouts: typing.Optional["AutoscalingGroupTimeouts"] = None,
        vpc_zone_identifier: typing.Optional[typing.List[str]] = None,
        wait_for_capacity_timeout: typing.Optional[str] = None,
        wait_for_elb_capacity: typing.Optional[jsii.Number] = None,
    ) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param max_size: 
        :param min_size: 
        :param availability_zones: 
        :param default_cooldown: 
        :param desired_capacity: 
        :param enabled_metrics: 
        :param force_delete: 
        :param health_check_grace_period: 
        :param health_check_type: 
        :param initial_lifecycle_hook: initial_lifecycle_hook block.
        :param launch_configuration: 
        :param launch_template: launch_template block.
        :param load_balancers: 
        :param max_instance_lifetime: 
        :param metrics_granularity: 
        :param min_elb_capacity: 
        :param mixed_instances_policy: mixed_instances_policy block.
        :param name: 
        :param name_prefix: 
        :param placement_group: 
        :param protect_from_scale_in: 
        :param service_linked_role_arn: 
        :param suspended_processes: 
        :param tag: tag block.
        :param tags: 
        :param target_group_arns: 
        :param termination_policies: 
        :param timeouts: timeouts block.
        :param vpc_zone_identifier: 
        :param wait_for_capacity_timeout: 
        :param wait_for_elb_capacity: 
        """
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        if isinstance(timeouts, dict):
            timeouts = AutoscalingGroupTimeouts(**timeouts)
        self._values = {
            "max_size": max_size,
            "min_size": min_size,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if availability_zones is not None:
            self._values["availability_zones"] = availability_zones
        if default_cooldown is not None:
            self._values["default_cooldown"] = default_cooldown
        if desired_capacity is not None:
            self._values["desired_capacity"] = desired_capacity
        if enabled_metrics is not None:
            self._values["enabled_metrics"] = enabled_metrics
        if force_delete is not None:
            self._values["force_delete"] = force_delete
        if health_check_grace_period is not None:
            self._values["health_check_grace_period"] = health_check_grace_period
        if health_check_type is not None:
            self._values["health_check_type"] = health_check_type
        if initial_lifecycle_hook is not None:
            self._values["initial_lifecycle_hook"] = initial_lifecycle_hook
        if launch_configuration is not None:
            self._values["launch_configuration"] = launch_configuration
        if launch_template is not None:
            self._values["launch_template"] = launch_template
        if load_balancers is not None:
            self._values["load_balancers"] = load_balancers
        if max_instance_lifetime is not None:
            self._values["max_instance_lifetime"] = max_instance_lifetime
        if metrics_granularity is not None:
            self._values["metrics_granularity"] = metrics_granularity
        if min_elb_capacity is not None:
            self._values["min_elb_capacity"] = min_elb_capacity
        if mixed_instances_policy is not None:
            self._values["mixed_instances_policy"] = mixed_instances_policy
        if name is not None:
            self._values["name"] = name
        if name_prefix is not None:
            self._values["name_prefix"] = name_prefix
        if placement_group is not None:
            self._values["placement_group"] = placement_group
        if protect_from_scale_in is not None:
            self._values["protect_from_scale_in"] = protect_from_scale_in
        if service_linked_role_arn is not None:
            self._values["service_linked_role_arn"] = service_linked_role_arn
        if suspended_processes is not None:
            self._values["suspended_processes"] = suspended_processes
        if tag is not None:
            self._values["tag"] = tag
        if tags is not None:
            self._values["tags"] = tags
        if target_group_arns is not None:
            self._values["target_group_arns"] = target_group_arns
        if termination_policies is not None:
            self._values["termination_policies"] = termination_policies
        if timeouts is not None:
            self._values["timeouts"] = timeouts
        if vpc_zone_identifier is not None:
            self._values["vpc_zone_identifier"] = vpc_zone_identifier
        if wait_for_capacity_timeout is not None:
            self._values["wait_for_capacity_timeout"] = wait_for_capacity_timeout
        if wait_for_elb_capacity is not None:
            self._values["wait_for_elb_capacity"] = wait_for_elb_capacity

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("count")

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.TerraformResource]]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("depends_on")

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("lifecycle")

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("provider")

    @builtins.property
    def max_size(self) -> jsii.Number:
        return self._values.get("max_size")

    @builtins.property
    def min_size(self) -> jsii.Number:
        return self._values.get("min_size")

    @builtins.property
    def availability_zones(self) -> typing.Optional[typing.List[str]]:
        return self._values.get("availability_zones")

    @builtins.property
    def default_cooldown(self) -> typing.Optional[jsii.Number]:
        return self._values.get("default_cooldown")

    @builtins.property
    def desired_capacity(self) -> typing.Optional[jsii.Number]:
        return self._values.get("desired_capacity")

    @builtins.property
    def enabled_metrics(self) -> typing.Optional[typing.List[str]]:
        return self._values.get("enabled_metrics")

    @builtins.property
    def force_delete(self) -> typing.Optional[bool]:
        return self._values.get("force_delete")

    @builtins.property
    def health_check_grace_period(self) -> typing.Optional[jsii.Number]:
        return self._values.get("health_check_grace_period")

    @builtins.property
    def health_check_type(self) -> typing.Optional[str]:
        return self._values.get("health_check_type")

    @builtins.property
    def initial_lifecycle_hook(
        self,
    ) -> typing.Optional[typing.List["AutoscalingGroupInitialLifecycleHook"]]:
        """initial_lifecycle_hook block."""
        return self._values.get("initial_lifecycle_hook")

    @builtins.property
    def launch_configuration(self) -> typing.Optional[str]:
        return self._values.get("launch_configuration")

    @builtins.property
    def launch_template(
        self,
    ) -> typing.Optional[typing.List["AutoscalingGroupLaunchTemplate"]]:
        """launch_template block."""
        return self._values.get("launch_template")

    @builtins.property
    def load_balancers(self) -> typing.Optional[typing.List[str]]:
        return self._values.get("load_balancers")

    @builtins.property
    def max_instance_lifetime(self) -> typing.Optional[jsii.Number]:
        return self._values.get("max_instance_lifetime")

    @builtins.property
    def metrics_granularity(self) -> typing.Optional[str]:
        return self._values.get("metrics_granularity")

    @builtins.property
    def min_elb_capacity(self) -> typing.Optional[jsii.Number]:
        return self._values.get("min_elb_capacity")

    @builtins.property
    def mixed_instances_policy(
        self,
    ) -> typing.Optional[typing.List["AutoscalingGroupMixedInstancesPolicy"]]:
        """mixed_instances_policy block."""
        return self._values.get("mixed_instances_policy")

    @builtins.property
    def name(self) -> typing.Optional[str]:
        return self._values.get("name")

    @builtins.property
    def name_prefix(self) -> typing.Optional[str]:
        return self._values.get("name_prefix")

    @builtins.property
    def placement_group(self) -> typing.Optional[str]:
        return self._values.get("placement_group")

    @builtins.property
    def protect_from_scale_in(self) -> typing.Optional[bool]:
        return self._values.get("protect_from_scale_in")

    @builtins.property
    def service_linked_role_arn(self) -> typing.Optional[str]:
        return self._values.get("service_linked_role_arn")

    @builtins.property
    def suspended_processes(self) -> typing.Optional[typing.List[str]]:
        return self._values.get("suspended_processes")

    @builtins.property
    def tag(self) -> typing.Optional[typing.List["AutoscalingGroupTag"]]:
        """tag block."""
        return self._values.get("tag")

    @builtins.property
    def tags(self) -> typing.Optional[typing.Mapping[str, str]]:
        return self._values.get("tags")

    @builtins.property
    def target_group_arns(self) -> typing.Optional[typing.List[str]]:
        return self._values.get("target_group_arns")

    @builtins.property
    def termination_policies(self) -> typing.Optional[typing.List[str]]:
        return self._values.get("termination_policies")

    @builtins.property
    def timeouts(self) -> typing.Optional["AutoscalingGroupTimeouts"]:
        """timeouts block."""
        return self._values.get("timeouts")

    @builtins.property
    def vpc_zone_identifier(self) -> typing.Optional[typing.List[str]]:
        return self._values.get("vpc_zone_identifier")

    @builtins.property
    def wait_for_capacity_timeout(self) -> typing.Optional[str]:
        return self._values.get("wait_for_capacity_timeout")

    @builtins.property
    def wait_for_elb_capacity(self) -> typing.Optional[jsii.Number]:
        return self._values.get("wait_for_elb_capacity")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AutoscalingGroupConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AutoscalingGroupInitialLifecycleHook",
    jsii_struct_bases=[],
    name_mapping={
        "lifecycle_transition": "lifecycleTransition",
        "name": "name",
        "default_result": "defaultResult",
        "heartbeat_timeout": "heartbeatTimeout",
        "notification_metadata": "notificationMetadata",
        "notification_target_arn": "notificationTargetArn",
        "role_arn": "roleArn",
    },
)
class AutoscalingGroupInitialLifecycleHook:
    def __init__(
        self,
        *,
        lifecycle_transition: str,
        name: str,
        default_result: typing.Optional[str] = None,
        heartbeat_timeout: typing.Optional[jsii.Number] = None,
        notification_metadata: typing.Optional[str] = None,
        notification_target_arn: typing.Optional[str] = None,
        role_arn: typing.Optional[str] = None,
    ) -> None:
        """
        :param lifecycle_transition: 
        :param name: 
        :param default_result: 
        :param heartbeat_timeout: 
        :param notification_metadata: 
        :param notification_target_arn: 
        :param role_arn: 
        """
        self._values = {
            "lifecycle_transition": lifecycle_transition,
            "name": name,
        }
        if default_result is not None:
            self._values["default_result"] = default_result
        if heartbeat_timeout is not None:
            self._values["heartbeat_timeout"] = heartbeat_timeout
        if notification_metadata is not None:
            self._values["notification_metadata"] = notification_metadata
        if notification_target_arn is not None:
            self._values["notification_target_arn"] = notification_target_arn
        if role_arn is not None:
            self._values["role_arn"] = role_arn

    @builtins.property
    def lifecycle_transition(self) -> str:
        return self._values.get("lifecycle_transition")

    @builtins.property
    def name(self) -> str:
        return self._values.get("name")

    @builtins.property
    def default_result(self) -> typing.Optional[str]:
        return self._values.get("default_result")

    @builtins.property
    def heartbeat_timeout(self) -> typing.Optional[jsii.Number]:
        return self._values.get("heartbeat_timeout")

    @builtins.property
    def notification_metadata(self) -> typing.Optional[str]:
        return self._values.get("notification_metadata")

    @builtins.property
    def notification_target_arn(self) -> typing.Optional[str]:
        return self._values.get("notification_target_arn")

    @builtins.property
    def role_arn(self) -> typing.Optional[str]:
        return self._values.get("role_arn")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AutoscalingGroupInitialLifecycleHook(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AutoscalingGroupLaunchTemplate",
    jsii_struct_bases=[],
    name_mapping={"id": "id", "name": "name", "version": "version"},
)
class AutoscalingGroupLaunchTemplate:
    def __init__(
        self,
        *,
        id: typing.Optional[str] = None,
        name: typing.Optional[str] = None,
        version: typing.Optional[str] = None,
    ) -> None:
        """
        :param id: 
        :param name: 
        :param version: 
        """
        self._values = {}
        if id is not None:
            self._values["id"] = id
        if name is not None:
            self._values["name"] = name
        if version is not None:
            self._values["version"] = version

    @builtins.property
    def id(self) -> typing.Optional[str]:
        return self._values.get("id")

    @builtins.property
    def name(self) -> typing.Optional[str]:
        return self._values.get("name")

    @builtins.property
    def version(self) -> typing.Optional[str]:
        return self._values.get("version")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AutoscalingGroupLaunchTemplate(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AutoscalingGroupMixedInstancesPolicy",
    jsii_struct_bases=[],
    name_mapping={
        "launch_template": "launchTemplate",
        "instances_distribution": "instancesDistribution",
    },
)
class AutoscalingGroupMixedInstancesPolicy:
    def __init__(
        self,
        *,
        launch_template: typing.List[
            "AutoscalingGroupMixedInstancesPolicyLaunchTemplate"
        ],
        instances_distribution: typing.Optional[
            typing.List["AutoscalingGroupMixedInstancesPolicyInstancesDistribution"]
        ] = None,
    ) -> None:
        """
        :param launch_template: launch_template block.
        :param instances_distribution: instances_distribution block.
        """
        self._values = {
            "launch_template": launch_template,
        }
        if instances_distribution is not None:
            self._values["instances_distribution"] = instances_distribution

    @builtins.property
    def launch_template(
        self,
    ) -> typing.List["AutoscalingGroupMixedInstancesPolicyLaunchTemplate"]:
        """launch_template block."""
        return self._values.get("launch_template")

    @builtins.property
    def instances_distribution(
        self,
    ) -> typing.Optional[
        typing.List["AutoscalingGroupMixedInstancesPolicyInstancesDistribution"]
    ]:
        """instances_distribution block."""
        return self._values.get("instances_distribution")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AutoscalingGroupMixedInstancesPolicy(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AutoscalingGroupMixedInstancesPolicyInstancesDistribution",
    jsii_struct_bases=[],
    name_mapping={
        "on_demand_allocation_strategy": "onDemandAllocationStrategy",
        "on_demand_base_capacity": "onDemandBaseCapacity",
        "on_demand_percentage_above_base_capacity": "onDemandPercentageAboveBaseCapacity",
        "spot_allocation_strategy": "spotAllocationStrategy",
        "spot_instance_pools": "spotInstancePools",
        "spot_max_price": "spotMaxPrice",
    },
)
class AutoscalingGroupMixedInstancesPolicyInstancesDistribution:
    def __init__(
        self,
        *,
        on_demand_allocation_strategy: typing.Optional[str] = None,
        on_demand_base_capacity: typing.Optional[jsii.Number] = None,
        on_demand_percentage_above_base_capacity: typing.Optional[jsii.Number] = None,
        spot_allocation_strategy: typing.Optional[str] = None,
        spot_instance_pools: typing.Optional[jsii.Number] = None,
        spot_max_price: typing.Optional[str] = None,
    ) -> None:
        """
        :param on_demand_allocation_strategy: 
        :param on_demand_base_capacity: 
        :param on_demand_percentage_above_base_capacity: 
        :param spot_allocation_strategy: 
        :param spot_instance_pools: 
        :param spot_max_price: 
        """
        self._values = {}
        if on_demand_allocation_strategy is not None:
            self._values[
                "on_demand_allocation_strategy"
            ] = on_demand_allocation_strategy
        if on_demand_base_capacity is not None:
            self._values["on_demand_base_capacity"] = on_demand_base_capacity
        if on_demand_percentage_above_base_capacity is not None:
            self._values[
                "on_demand_percentage_above_base_capacity"
            ] = on_demand_percentage_above_base_capacity
        if spot_allocation_strategy is not None:
            self._values["spot_allocation_strategy"] = spot_allocation_strategy
        if spot_instance_pools is not None:
            self._values["spot_instance_pools"] = spot_instance_pools
        if spot_max_price is not None:
            self._values["spot_max_price"] = spot_max_price

    @builtins.property
    def on_demand_allocation_strategy(self) -> typing.Optional[str]:
        return self._values.get("on_demand_allocation_strategy")

    @builtins.property
    def on_demand_base_capacity(self) -> typing.Optional[jsii.Number]:
        return self._values.get("on_demand_base_capacity")

    @builtins.property
    def on_demand_percentage_above_base_capacity(self) -> typing.Optional[jsii.Number]:
        return self._values.get("on_demand_percentage_above_base_capacity")

    @builtins.property
    def spot_allocation_strategy(self) -> typing.Optional[str]:
        return self._values.get("spot_allocation_strategy")

    @builtins.property
    def spot_instance_pools(self) -> typing.Optional[jsii.Number]:
        return self._values.get("spot_instance_pools")

    @builtins.property
    def spot_max_price(self) -> typing.Optional[str]:
        return self._values.get("spot_max_price")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return (
            "AutoscalingGroupMixedInstancesPolicyInstancesDistribution(%s)"
            % ", ".join(k + "=" + repr(v) for k, v in self._values.items())
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AutoscalingGroupMixedInstancesPolicyLaunchTemplate",
    jsii_struct_bases=[],
    name_mapping={
        "launch_template_specification": "launchTemplateSpecification",
        "override": "override",
    },
)
class AutoscalingGroupMixedInstancesPolicyLaunchTemplate:
    def __init__(
        self,
        *,
        launch_template_specification: typing.List[
            "AutoscalingGroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecification"
        ],
        override: typing.Optional[
            typing.List["AutoscalingGroupMixedInstancesPolicyLaunchTemplateOverride"]
        ] = None,
    ) -> None:
        """
        :param launch_template_specification: launch_template_specification block.
        :param override: override block.
        """
        self._values = {
            "launch_template_specification": launch_template_specification,
        }
        if override is not None:
            self._values["override"] = override

    @builtins.property
    def launch_template_specification(
        self,
    ) -> typing.List[
        "AutoscalingGroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecification"
    ]:
        """launch_template_specification block."""
        return self._values.get("launch_template_specification")

    @builtins.property
    def override(
        self,
    ) -> typing.Optional[
        typing.List["AutoscalingGroupMixedInstancesPolicyLaunchTemplateOverride"]
    ]:
        """override block."""
        return self._values.get("override")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AutoscalingGroupMixedInstancesPolicyLaunchTemplate(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AutoscalingGroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecification",
    jsii_struct_bases=[],
    name_mapping={
        "launch_template_id": "launchTemplateId",
        "launch_template_name": "launchTemplateName",
        "version": "version",
    },
)
class AutoscalingGroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecification:
    def __init__(
        self,
        *,
        launch_template_id: typing.Optional[str] = None,
        launch_template_name: typing.Optional[str] = None,
        version: typing.Optional[str] = None,
    ) -> None:
        """
        :param launch_template_id: 
        :param launch_template_name: 
        :param version: 
        """
        self._values = {}
        if launch_template_id is not None:
            self._values["launch_template_id"] = launch_template_id
        if launch_template_name is not None:
            self._values["launch_template_name"] = launch_template_name
        if version is not None:
            self._values["version"] = version

    @builtins.property
    def launch_template_id(self) -> typing.Optional[str]:
        return self._values.get("launch_template_id")

    @builtins.property
    def launch_template_name(self) -> typing.Optional[str]:
        return self._values.get("launch_template_name")

    @builtins.property
    def version(self) -> typing.Optional[str]:
        return self._values.get("version")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return (
            "AutoscalingGroupMixedInstancesPolicyLaunchTemplateLaunchTemplateSpecification(%s)"
            % ", ".join(k + "=" + repr(v) for k, v in self._values.items())
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AutoscalingGroupMixedInstancesPolicyLaunchTemplateOverride",
    jsii_struct_bases=[],
    name_mapping={
        "instance_type": "instanceType",
        "weighted_capacity": "weightedCapacity",
    },
)
class AutoscalingGroupMixedInstancesPolicyLaunchTemplateOverride:
    def __init__(
        self,
        *,
        instance_type: typing.Optional[str] = None,
        weighted_capacity: typing.Optional[str] = None,
    ) -> None:
        """
        :param instance_type: 
        :param weighted_capacity: 
        """
        self._values = {}
        if instance_type is not None:
            self._values["instance_type"] = instance_type
        if weighted_capacity is not None:
            self._values["weighted_capacity"] = weighted_capacity

    @builtins.property
    def instance_type(self) -> typing.Optional[str]:
        return self._values.get("instance_type")

    @builtins.property
    def weighted_capacity(self) -> typing.Optional[str]:
        return self._values.get("weighted_capacity")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return (
            "AutoscalingGroupMixedInstancesPolicyLaunchTemplateOverride(%s)"
            % ", ".join(k + "=" + repr(v) for k, v in self._values.items())
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AutoscalingGroupTag",
    jsii_struct_bases=[],
    name_mapping={
        "key": "key",
        "propagate_at_launch": "propagateAtLaunch",
        "value": "value",
    },
)
class AutoscalingGroupTag:
    def __init__(self, *, key: str, propagate_at_launch: bool, value: str) -> None:
        """
        :param key: 
        :param propagate_at_launch: 
        :param value: 
        """
        self._values = {
            "key": key,
            "propagate_at_launch": propagate_at_launch,
            "value": value,
        }

    @builtins.property
    def key(self) -> str:
        return self._values.get("key")

    @builtins.property
    def propagate_at_launch(self) -> bool:
        return self._values.get("propagate_at_launch")

    @builtins.property
    def value(self) -> str:
        return self._values.get("value")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AutoscalingGroupTag(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AutoscalingGroupTimeouts",
    jsii_struct_bases=[],
    name_mapping={"delete": "delete"},
)
class AutoscalingGroupTimeouts:
    def __init__(self, *, delete: typing.Optional[str] = None) -> None:
        """
        :param delete: 
        """
        self._values = {}
        if delete is not None:
            self._values["delete"] = delete

    @builtins.property
    def delete(self) -> typing.Optional[str]:
        return self._values.get("delete")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AutoscalingGroupTimeouts(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class AutoscalingLifecycleHook(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="@skorfmann/cdktf-provider-aws.AutoscalingLifecycleHook",
):
    def __init__(
        self,
        scope: constructs.Construct,
        id: str,
        *,
        autoscaling_group_name: str,
        lifecycle_transition: str,
        name: str,
        default_result: typing.Optional[str] = None,
        heartbeat_timeout: typing.Optional[jsii.Number] = None,
        notification_metadata: typing.Optional[str] = None,
        notification_target_arn: typing.Optional[str] = None,
        role_arn: typing.Optional[str] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param autoscaling_group_name: 
        :param lifecycle_transition: 
        :param name: 
        :param default_result: 
        :param heartbeat_timeout: 
        :param notification_metadata: 
        :param notification_target_arn: 
        :param role_arn: 
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = AutoscalingLifecycleHookConfig(
            autoscaling_group_name=autoscaling_group_name,
            lifecycle_transition=lifecycle_transition,
            name=name,
            default_result=default_result,
            heartbeat_timeout=heartbeat_timeout,
            notification_metadata=notification_metadata,
            notification_target_arn=notification_target_arn,
            role_arn=role_arn,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(AutoscalingLifecycleHook, self, [scope, id, config])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property
    @jsii.member(jsii_name="autoscalingGroupName")
    def autoscaling_group_name(self) -> str:
        return jsii.get(self, "autoscalingGroupName")

    @autoscaling_group_name.setter
    def autoscaling_group_name(self, value: str) -> None:
        jsii.set(self, "autoscalingGroupName", value)

    @builtins.property
    @jsii.member(jsii_name="lifecycleTransition")
    def lifecycle_transition(self) -> str:
        return jsii.get(self, "lifecycleTransition")

    @lifecycle_transition.setter
    def lifecycle_transition(self, value: str) -> None:
        jsii.set(self, "lifecycleTransition", value)

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> str:
        return jsii.get(self, "name")

    @name.setter
    def name(self, value: str) -> None:
        jsii.set(self, "name", value)

    @builtins.property
    @jsii.member(jsii_name="defaultResult")
    def default_result(self) -> typing.Optional[str]:
        return jsii.get(self, "defaultResult")

    @default_result.setter
    def default_result(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "defaultResult", value)

    @builtins.property
    @jsii.member(jsii_name="heartbeatTimeout")
    def heartbeat_timeout(self) -> typing.Optional[jsii.Number]:
        return jsii.get(self, "heartbeatTimeout")

    @heartbeat_timeout.setter
    def heartbeat_timeout(self, value: typing.Optional[jsii.Number]) -> None:
        jsii.set(self, "heartbeatTimeout", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="notificationMetadata")
    def notification_metadata(self) -> typing.Optional[str]:
        return jsii.get(self, "notificationMetadata")

    @notification_metadata.setter
    def notification_metadata(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "notificationMetadata", value)

    @builtins.property
    @jsii.member(jsii_name="notificationTargetArn")
    def notification_target_arn(self) -> typing.Optional[str]:
        return jsii.get(self, "notificationTargetArn")

    @notification_target_arn.setter
    def notification_target_arn(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "notificationTargetArn", value)

    @builtins.property
    @jsii.member(jsii_name="roleArn")
    def role_arn(self) -> typing.Optional[str]:
        return jsii.get(self, "roleArn")

    @role_arn.setter
    def role_arn(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "roleArn", value)


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AutoscalingLifecycleHookConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "autoscaling_group_name": "autoscalingGroupName",
        "lifecycle_transition": "lifecycleTransition",
        "name": "name",
        "default_result": "defaultResult",
        "heartbeat_timeout": "heartbeatTimeout",
        "notification_metadata": "notificationMetadata",
        "notification_target_arn": "notificationTargetArn",
        "role_arn": "roleArn",
    },
)
class AutoscalingLifecycleHookConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        autoscaling_group_name: str,
        lifecycle_transition: str,
        name: str,
        default_result: typing.Optional[str] = None,
        heartbeat_timeout: typing.Optional[jsii.Number] = None,
        notification_metadata: typing.Optional[str] = None,
        notification_target_arn: typing.Optional[str] = None,
        role_arn: typing.Optional[str] = None,
    ) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param autoscaling_group_name: 
        :param lifecycle_transition: 
        :param name: 
        :param default_result: 
        :param heartbeat_timeout: 
        :param notification_metadata: 
        :param notification_target_arn: 
        :param role_arn: 
        """
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        self._values = {
            "autoscaling_group_name": autoscaling_group_name,
            "lifecycle_transition": lifecycle_transition,
            "name": name,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if default_result is not None:
            self._values["default_result"] = default_result
        if heartbeat_timeout is not None:
            self._values["heartbeat_timeout"] = heartbeat_timeout
        if notification_metadata is not None:
            self._values["notification_metadata"] = notification_metadata
        if notification_target_arn is not None:
            self._values["notification_target_arn"] = notification_target_arn
        if role_arn is not None:
            self._values["role_arn"] = role_arn

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("count")

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.TerraformResource]]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("depends_on")

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("lifecycle")

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("provider")

    @builtins.property
    def autoscaling_group_name(self) -> str:
        return self._values.get("autoscaling_group_name")

    @builtins.property
    def lifecycle_transition(self) -> str:
        return self._values.get("lifecycle_transition")

    @builtins.property
    def name(self) -> str:
        return self._values.get("name")

    @builtins.property
    def default_result(self) -> typing.Optional[str]:
        return self._values.get("default_result")

    @builtins.property
    def heartbeat_timeout(self) -> typing.Optional[jsii.Number]:
        return self._values.get("heartbeat_timeout")

    @builtins.property
    def notification_metadata(self) -> typing.Optional[str]:
        return self._values.get("notification_metadata")

    @builtins.property
    def notification_target_arn(self) -> typing.Optional[str]:
        return self._values.get("notification_target_arn")

    @builtins.property
    def role_arn(self) -> typing.Optional[str]:
        return self._values.get("role_arn")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AutoscalingLifecycleHookConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class AutoscalingNotification(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="@skorfmann/cdktf-provider-aws.AutoscalingNotification",
):
    def __init__(
        self,
        scope: constructs.Construct,
        id: str,
        *,
        group_names: typing.List[str],
        notifications: typing.List[str],
        topic_arn: str,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param group_names: 
        :param notifications: 
        :param topic_arn: 
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = AutoscalingNotificationConfig(
            group_names=group_names,
            notifications=notifications,
            topic_arn=topic_arn,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(AutoscalingNotification, self, [scope, id, config])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property
    @jsii.member(jsii_name="groupNames")
    def group_names(self) -> typing.List[str]:
        return jsii.get(self, "groupNames")

    @group_names.setter
    def group_names(self, value: typing.List[str]) -> None:
        jsii.set(self, "groupNames", value)

    @builtins.property
    @jsii.member(jsii_name="notifications")
    def notifications(self) -> typing.List[str]:
        return jsii.get(self, "notifications")

    @notifications.setter
    def notifications(self, value: typing.List[str]) -> None:
        jsii.set(self, "notifications", value)

    @builtins.property
    @jsii.member(jsii_name="topicArn")
    def topic_arn(self) -> str:
        return jsii.get(self, "topicArn")

    @topic_arn.setter
    def topic_arn(self, value: str) -> None:
        jsii.set(self, "topicArn", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AutoscalingNotificationConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "group_names": "groupNames",
        "notifications": "notifications",
        "topic_arn": "topicArn",
    },
)
class AutoscalingNotificationConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        group_names: typing.List[str],
        notifications: typing.List[str],
        topic_arn: str,
    ) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param group_names: 
        :param notifications: 
        :param topic_arn: 
        """
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        self._values = {
            "group_names": group_names,
            "notifications": notifications,
            "topic_arn": topic_arn,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("count")

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.TerraformResource]]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("depends_on")

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("lifecycle")

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("provider")

    @builtins.property
    def group_names(self) -> typing.List[str]:
        return self._values.get("group_names")

    @builtins.property
    def notifications(self) -> typing.List[str]:
        return self._values.get("notifications")

    @builtins.property
    def topic_arn(self) -> str:
        return self._values.get("topic_arn")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AutoscalingNotificationConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class AutoscalingPolicy(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="@skorfmann/cdktf-provider-aws.AutoscalingPolicy",
):
    def __init__(
        self,
        scope: constructs.Construct,
        id: str,
        *,
        autoscaling_group_name: str,
        name: str,
        adjustment_type: typing.Optional[str] = None,
        cooldown: typing.Optional[jsii.Number] = None,
        estimated_instance_warmup: typing.Optional[jsii.Number] = None,
        metric_aggregation_type: typing.Optional[str] = None,
        min_adjustment_magnitude: typing.Optional[jsii.Number] = None,
        min_adjustment_step: typing.Optional[jsii.Number] = None,
        policy_type: typing.Optional[str] = None,
        scaling_adjustment: typing.Optional[jsii.Number] = None,
        step_adjustment: typing.Optional[
            typing.List["AutoscalingPolicyStepAdjustment"]
        ] = None,
        target_tracking_configuration: typing.Optional[
            typing.List["AutoscalingPolicyTargetTrackingConfiguration"]
        ] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param autoscaling_group_name: 
        :param name: 
        :param adjustment_type: 
        :param cooldown: 
        :param estimated_instance_warmup: 
        :param metric_aggregation_type: 
        :param min_adjustment_magnitude: 
        :param min_adjustment_step: 
        :param policy_type: 
        :param scaling_adjustment: 
        :param step_adjustment: step_adjustment block.
        :param target_tracking_configuration: target_tracking_configuration block.
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = AutoscalingPolicyConfig(
            autoscaling_group_name=autoscaling_group_name,
            name=name,
            adjustment_type=adjustment_type,
            cooldown=cooldown,
            estimated_instance_warmup=estimated_instance_warmup,
            metric_aggregation_type=metric_aggregation_type,
            min_adjustment_magnitude=min_adjustment_magnitude,
            min_adjustment_step=min_adjustment_step,
            policy_type=policy_type,
            scaling_adjustment=scaling_adjustment,
            step_adjustment=step_adjustment,
            target_tracking_configuration=target_tracking_configuration,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(AutoscalingPolicy, self, [scope, id, config])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property
    @jsii.member(jsii_name="arn")
    def arn(self) -> str:
        return jsii.get(self, "arn")

    @builtins.property
    @jsii.member(jsii_name="autoscalingGroupName")
    def autoscaling_group_name(self) -> str:
        return jsii.get(self, "autoscalingGroupName")

    @autoscaling_group_name.setter
    def autoscaling_group_name(self, value: str) -> None:
        jsii.set(self, "autoscalingGroupName", value)

    @builtins.property
    @jsii.member(jsii_name="name")
    def name(self) -> str:
        return jsii.get(self, "name")

    @name.setter
    def name(self, value: str) -> None:
        jsii.set(self, "name", value)

    @builtins.property
    @jsii.member(jsii_name="adjustmentType")
    def adjustment_type(self) -> typing.Optional[str]:
        return jsii.get(self, "adjustmentType")

    @adjustment_type.setter
    def adjustment_type(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "adjustmentType", value)

    @builtins.property
    @jsii.member(jsii_name="cooldown")
    def cooldown(self) -> typing.Optional[jsii.Number]:
        return jsii.get(self, "cooldown")

    @cooldown.setter
    def cooldown(self, value: typing.Optional[jsii.Number]) -> None:
        jsii.set(self, "cooldown", value)

    @builtins.property
    @jsii.member(jsii_name="estimatedInstanceWarmup")
    def estimated_instance_warmup(self) -> typing.Optional[jsii.Number]:
        return jsii.get(self, "estimatedInstanceWarmup")

    @estimated_instance_warmup.setter
    def estimated_instance_warmup(self, value: typing.Optional[jsii.Number]) -> None:
        jsii.set(self, "estimatedInstanceWarmup", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="metricAggregationType")
    def metric_aggregation_type(self) -> typing.Optional[str]:
        return jsii.get(self, "metricAggregationType")

    @metric_aggregation_type.setter
    def metric_aggregation_type(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "metricAggregationType", value)

    @builtins.property
    @jsii.member(jsii_name="minAdjustmentMagnitude")
    def min_adjustment_magnitude(self) -> typing.Optional[jsii.Number]:
        return jsii.get(self, "minAdjustmentMagnitude")

    @min_adjustment_magnitude.setter
    def min_adjustment_magnitude(self, value: typing.Optional[jsii.Number]) -> None:
        jsii.set(self, "minAdjustmentMagnitude", value)

    @builtins.property
    @jsii.member(jsii_name="minAdjustmentStep")
    def min_adjustment_step(self) -> typing.Optional[jsii.Number]:
        return jsii.get(self, "minAdjustmentStep")

    @min_adjustment_step.setter
    def min_adjustment_step(self, value: typing.Optional[jsii.Number]) -> None:
        jsii.set(self, "minAdjustmentStep", value)

    @builtins.property
    @jsii.member(jsii_name="policyType")
    def policy_type(self) -> typing.Optional[str]:
        return jsii.get(self, "policyType")

    @policy_type.setter
    def policy_type(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "policyType", value)

    @builtins.property
    @jsii.member(jsii_name="scalingAdjustment")
    def scaling_adjustment(self) -> typing.Optional[jsii.Number]:
        return jsii.get(self, "scalingAdjustment")

    @scaling_adjustment.setter
    def scaling_adjustment(self, value: typing.Optional[jsii.Number]) -> None:
        jsii.set(self, "scalingAdjustment", value)

    @builtins.property
    @jsii.member(jsii_name="stepAdjustment")
    def step_adjustment(
        self,
    ) -> typing.Optional[typing.List["AutoscalingPolicyStepAdjustment"]]:
        return jsii.get(self, "stepAdjustment")

    @step_adjustment.setter
    def step_adjustment(
        self, value: typing.Optional[typing.List["AutoscalingPolicyStepAdjustment"]]
    ) -> None:
        jsii.set(self, "stepAdjustment", value)

    @builtins.property
    @jsii.member(jsii_name="targetTrackingConfiguration")
    def target_tracking_configuration(
        self,
    ) -> typing.Optional[typing.List["AutoscalingPolicyTargetTrackingConfiguration"]]:
        return jsii.get(self, "targetTrackingConfiguration")

    @target_tracking_configuration.setter
    def target_tracking_configuration(
        self,
        value: typing.Optional[
            typing.List["AutoscalingPolicyTargetTrackingConfiguration"]
        ],
    ) -> None:
        jsii.set(self, "targetTrackingConfiguration", value)


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AutoscalingPolicyConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "autoscaling_group_name": "autoscalingGroupName",
        "name": "name",
        "adjustment_type": "adjustmentType",
        "cooldown": "cooldown",
        "estimated_instance_warmup": "estimatedInstanceWarmup",
        "metric_aggregation_type": "metricAggregationType",
        "min_adjustment_magnitude": "minAdjustmentMagnitude",
        "min_adjustment_step": "minAdjustmentStep",
        "policy_type": "policyType",
        "scaling_adjustment": "scalingAdjustment",
        "step_adjustment": "stepAdjustment",
        "target_tracking_configuration": "targetTrackingConfiguration",
    },
)
class AutoscalingPolicyConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        autoscaling_group_name: str,
        name: str,
        adjustment_type: typing.Optional[str] = None,
        cooldown: typing.Optional[jsii.Number] = None,
        estimated_instance_warmup: typing.Optional[jsii.Number] = None,
        metric_aggregation_type: typing.Optional[str] = None,
        min_adjustment_magnitude: typing.Optional[jsii.Number] = None,
        min_adjustment_step: typing.Optional[jsii.Number] = None,
        policy_type: typing.Optional[str] = None,
        scaling_adjustment: typing.Optional[jsii.Number] = None,
        step_adjustment: typing.Optional[
            typing.List["AutoscalingPolicyStepAdjustment"]
        ] = None,
        target_tracking_configuration: typing.Optional[
            typing.List["AutoscalingPolicyTargetTrackingConfiguration"]
        ] = None,
    ) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param autoscaling_group_name: 
        :param name: 
        :param adjustment_type: 
        :param cooldown: 
        :param estimated_instance_warmup: 
        :param metric_aggregation_type: 
        :param min_adjustment_magnitude: 
        :param min_adjustment_step: 
        :param policy_type: 
        :param scaling_adjustment: 
        :param step_adjustment: step_adjustment block.
        :param target_tracking_configuration: target_tracking_configuration block.
        """
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        self._values = {
            "autoscaling_group_name": autoscaling_group_name,
            "name": name,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if adjustment_type is not None:
            self._values["adjustment_type"] = adjustment_type
        if cooldown is not None:
            self._values["cooldown"] = cooldown
        if estimated_instance_warmup is not None:
            self._values["estimated_instance_warmup"] = estimated_instance_warmup
        if metric_aggregation_type is not None:
            self._values["metric_aggregation_type"] = metric_aggregation_type
        if min_adjustment_magnitude is not None:
            self._values["min_adjustment_magnitude"] = min_adjustment_magnitude
        if min_adjustment_step is not None:
            self._values["min_adjustment_step"] = min_adjustment_step
        if policy_type is not None:
            self._values["policy_type"] = policy_type
        if scaling_adjustment is not None:
            self._values["scaling_adjustment"] = scaling_adjustment
        if step_adjustment is not None:
            self._values["step_adjustment"] = step_adjustment
        if target_tracking_configuration is not None:
            self._values[
                "target_tracking_configuration"
            ] = target_tracking_configuration

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("count")

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.TerraformResource]]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("depends_on")

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("lifecycle")

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("provider")

    @builtins.property
    def autoscaling_group_name(self) -> str:
        return self._values.get("autoscaling_group_name")

    @builtins.property
    def name(self) -> str:
        return self._values.get("name")

    @builtins.property
    def adjustment_type(self) -> typing.Optional[str]:
        return self._values.get("adjustment_type")

    @builtins.property
    def cooldown(self) -> typing.Optional[jsii.Number]:
        return self._values.get("cooldown")

    @builtins.property
    def estimated_instance_warmup(self) -> typing.Optional[jsii.Number]:
        return self._values.get("estimated_instance_warmup")

    @builtins.property
    def metric_aggregation_type(self) -> typing.Optional[str]:
        return self._values.get("metric_aggregation_type")

    @builtins.property
    def min_adjustment_magnitude(self) -> typing.Optional[jsii.Number]:
        return self._values.get("min_adjustment_magnitude")

    @builtins.property
    def min_adjustment_step(self) -> typing.Optional[jsii.Number]:
        return self._values.get("min_adjustment_step")

    @builtins.property
    def policy_type(self) -> typing.Optional[str]:
        return self._values.get("policy_type")

    @builtins.property
    def scaling_adjustment(self) -> typing.Optional[jsii.Number]:
        return self._values.get("scaling_adjustment")

    @builtins.property
    def step_adjustment(
        self,
    ) -> typing.Optional[typing.List["AutoscalingPolicyStepAdjustment"]]:
        """step_adjustment block."""
        return self._values.get("step_adjustment")

    @builtins.property
    def target_tracking_configuration(
        self,
    ) -> typing.Optional[typing.List["AutoscalingPolicyTargetTrackingConfiguration"]]:
        """target_tracking_configuration block."""
        return self._values.get("target_tracking_configuration")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AutoscalingPolicyConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AutoscalingPolicyStepAdjustment",
    jsii_struct_bases=[],
    name_mapping={
        "scaling_adjustment": "scalingAdjustment",
        "metric_interval_lower_bound": "metricIntervalLowerBound",
        "metric_interval_upper_bound": "metricIntervalUpperBound",
    },
)
class AutoscalingPolicyStepAdjustment:
    def __init__(
        self,
        *,
        scaling_adjustment: jsii.Number,
        metric_interval_lower_bound: typing.Optional[str] = None,
        metric_interval_upper_bound: typing.Optional[str] = None,
    ) -> None:
        """
        :param scaling_adjustment: 
        :param metric_interval_lower_bound: 
        :param metric_interval_upper_bound: 
        """
        self._values = {
            "scaling_adjustment": scaling_adjustment,
        }
        if metric_interval_lower_bound is not None:
            self._values["metric_interval_lower_bound"] = metric_interval_lower_bound
        if metric_interval_upper_bound is not None:
            self._values["metric_interval_upper_bound"] = metric_interval_upper_bound

    @builtins.property
    def scaling_adjustment(self) -> jsii.Number:
        return self._values.get("scaling_adjustment")

    @builtins.property
    def metric_interval_lower_bound(self) -> typing.Optional[str]:
        return self._values.get("metric_interval_lower_bound")

    @builtins.property
    def metric_interval_upper_bound(self) -> typing.Optional[str]:
        return self._values.get("metric_interval_upper_bound")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AutoscalingPolicyStepAdjustment(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AutoscalingPolicyTargetTrackingConfiguration",
    jsii_struct_bases=[],
    name_mapping={
        "target_value": "targetValue",
        "customized_metric_specification": "customizedMetricSpecification",
        "disable_scale_in": "disableScaleIn",
        "predefined_metric_specification": "predefinedMetricSpecification",
    },
)
class AutoscalingPolicyTargetTrackingConfiguration:
    def __init__(
        self,
        *,
        target_value: jsii.Number,
        customized_metric_specification: typing.Optional[
            typing.List[
                "AutoscalingPolicyTargetTrackingConfigurationCustomizedMetricSpecification"
            ]
        ] = None,
        disable_scale_in: typing.Optional[bool] = None,
        predefined_metric_specification: typing.Optional[
            typing.List[
                "AutoscalingPolicyTargetTrackingConfigurationPredefinedMetricSpecification"
            ]
        ] = None,
    ) -> None:
        """
        :param target_value: 
        :param customized_metric_specification: customized_metric_specification block.
        :param disable_scale_in: 
        :param predefined_metric_specification: predefined_metric_specification block.
        """
        self._values = {
            "target_value": target_value,
        }
        if customized_metric_specification is not None:
            self._values[
                "customized_metric_specification"
            ] = customized_metric_specification
        if disable_scale_in is not None:
            self._values["disable_scale_in"] = disable_scale_in
        if predefined_metric_specification is not None:
            self._values[
                "predefined_metric_specification"
            ] = predefined_metric_specification

    @builtins.property
    def target_value(self) -> jsii.Number:
        return self._values.get("target_value")

    @builtins.property
    def customized_metric_specification(
        self,
    ) -> typing.Optional[
        typing.List[
            "AutoscalingPolicyTargetTrackingConfigurationCustomizedMetricSpecification"
        ]
    ]:
        """customized_metric_specification block."""
        return self._values.get("customized_metric_specification")

    @builtins.property
    def disable_scale_in(self) -> typing.Optional[bool]:
        return self._values.get("disable_scale_in")

    @builtins.property
    def predefined_metric_specification(
        self,
    ) -> typing.Optional[
        typing.List[
            "AutoscalingPolicyTargetTrackingConfigurationPredefinedMetricSpecification"
        ]
    ]:
        """predefined_metric_specification block."""
        return self._values.get("predefined_metric_specification")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AutoscalingPolicyTargetTrackingConfiguration(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AutoscalingPolicyTargetTrackingConfigurationCustomizedMetricSpecification",
    jsii_struct_bases=[],
    name_mapping={
        "metric_name": "metricName",
        "namespace": "namespace",
        "statistic": "statistic",
        "metric_dimension": "metricDimension",
        "unit": "unit",
    },
)
class AutoscalingPolicyTargetTrackingConfigurationCustomizedMetricSpecification:
    def __init__(
        self,
        *,
        metric_name: str,
        namespace: str,
        statistic: str,
        metric_dimension: typing.Optional[
            typing.List[
                "AutoscalingPolicyTargetTrackingConfigurationCustomizedMetricSpecificationMetricDimension"
            ]
        ] = None,
        unit: typing.Optional[str] = None,
    ) -> None:
        """
        :param metric_name: 
        :param namespace: 
        :param statistic: 
        :param metric_dimension: metric_dimension block.
        :param unit: 
        """
        self._values = {
            "metric_name": metric_name,
            "namespace": namespace,
            "statistic": statistic,
        }
        if metric_dimension is not None:
            self._values["metric_dimension"] = metric_dimension
        if unit is not None:
            self._values["unit"] = unit

    @builtins.property
    def metric_name(self) -> str:
        return self._values.get("metric_name")

    @builtins.property
    def namespace(self) -> str:
        return self._values.get("namespace")

    @builtins.property
    def statistic(self) -> str:
        return self._values.get("statistic")

    @builtins.property
    def metric_dimension(
        self,
    ) -> typing.Optional[
        typing.List[
            "AutoscalingPolicyTargetTrackingConfigurationCustomizedMetricSpecificationMetricDimension"
        ]
    ]:
        """metric_dimension block."""
        return self._values.get("metric_dimension")

    @builtins.property
    def unit(self) -> typing.Optional[str]:
        return self._values.get("unit")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return (
            "AutoscalingPolicyTargetTrackingConfigurationCustomizedMetricSpecification(%s)"
            % ", ".join(k + "=" + repr(v) for k, v in self._values.items())
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AutoscalingPolicyTargetTrackingConfigurationCustomizedMetricSpecificationMetricDimension",
    jsii_struct_bases=[],
    name_mapping={"name": "name", "value": "value"},
)
class AutoscalingPolicyTargetTrackingConfigurationCustomizedMetricSpecificationMetricDimension:
    def __init__(self, *, name: str, value: str) -> None:
        """
        :param name: 
        :param value: 
        """
        self._values = {
            "name": name,
            "value": value,
        }

    @builtins.property
    def name(self) -> str:
        return self._values.get("name")

    @builtins.property
    def value(self) -> str:
        return self._values.get("value")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return (
            "AutoscalingPolicyTargetTrackingConfigurationCustomizedMetricSpecificationMetricDimension(%s)"
            % ", ".join(k + "=" + repr(v) for k, v in self._values.items())
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AutoscalingPolicyTargetTrackingConfigurationPredefinedMetricSpecification",
    jsii_struct_bases=[],
    name_mapping={
        "predefined_metric_type": "predefinedMetricType",
        "resource_label": "resourceLabel",
    },
)
class AutoscalingPolicyTargetTrackingConfigurationPredefinedMetricSpecification:
    def __init__(
        self,
        *,
        predefined_metric_type: str,
        resource_label: typing.Optional[str] = None,
    ) -> None:
        """
        :param predefined_metric_type: 
        :param resource_label: 
        """
        self._values = {
            "predefined_metric_type": predefined_metric_type,
        }
        if resource_label is not None:
            self._values["resource_label"] = resource_label

    @builtins.property
    def predefined_metric_type(self) -> str:
        return self._values.get("predefined_metric_type")

    @builtins.property
    def resource_label(self) -> typing.Optional[str]:
        return self._values.get("resource_label")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return (
            "AutoscalingPolicyTargetTrackingConfigurationPredefinedMetricSpecification(%s)"
            % ", ".join(k + "=" + repr(v) for k, v in self._values.items())
        )


class AutoscalingSchedule(
    cdktf.TerraformResource,
    metaclass=jsii.JSIIMeta,
    jsii_type="@skorfmann/cdktf-provider-aws.AutoscalingSchedule",
):
    def __init__(
        self,
        scope: constructs.Construct,
        id: str,
        *,
        autoscaling_group_name: str,
        scheduled_action_name: str,
        desired_capacity: typing.Optional[jsii.Number] = None,
        end_time: typing.Optional[str] = None,
        max_size: typing.Optional[jsii.Number] = None,
        min_size: typing.Optional[jsii.Number] = None,
        recurrence: typing.Optional[str] = None,
        start_time: typing.Optional[str] = None,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param autoscaling_group_name: 
        :param scheduled_action_name: 
        :param desired_capacity: 
        :param end_time: 
        :param max_size: 
        :param min_size: 
        :param recurrence: 
        :param start_time: 
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        """
        config = AutoscalingScheduleConfig(
            autoscaling_group_name=autoscaling_group_name,
            scheduled_action_name=scheduled_action_name,
            desired_capacity=desired_capacity,
            end_time=end_time,
            max_size=max_size,
            min_size=min_size,
            recurrence=recurrence,
            start_time=start_time,
            count=count,
            depends_on=depends_on,
            lifecycle=lifecycle,
            provider=provider,
        )

        jsii.create(AutoscalingSchedule, self, [scope, id, config])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property
    @jsii.member(jsii_name="arn")
    def arn(self) -> str:
        return jsii.get(self, "arn")

    @builtins.property
    @jsii.member(jsii_name="autoscalingGroupName")
    def autoscaling_group_name(self) -> str:
        return jsii.get(self, "autoscalingGroupName")

    @autoscaling_group_name.setter
    def autoscaling_group_name(self, value: str) -> None:
        jsii.set(self, "autoscalingGroupName", value)

    @builtins.property
    @jsii.member(jsii_name="scheduledActionName")
    def scheduled_action_name(self) -> str:
        return jsii.get(self, "scheduledActionName")

    @scheduled_action_name.setter
    def scheduled_action_name(self, value: str) -> None:
        jsii.set(self, "scheduledActionName", value)

    @builtins.property
    @jsii.member(jsii_name="desiredCapacity")
    def desired_capacity(self) -> typing.Optional[jsii.Number]:
        return jsii.get(self, "desiredCapacity")

    @desired_capacity.setter
    def desired_capacity(self, value: typing.Optional[jsii.Number]) -> None:
        jsii.set(self, "desiredCapacity", value)

    @builtins.property
    @jsii.member(jsii_name="endTime")
    def end_time(self) -> typing.Optional[str]:
        return jsii.get(self, "endTime")

    @end_time.setter
    def end_time(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "endTime", value)

    @builtins.property
    @jsii.member(jsii_name="id")
    def id(self) -> typing.Optional[str]:
        return jsii.get(self, "id")

    @id.setter
    def id(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "id", value)

    @builtins.property
    @jsii.member(jsii_name="maxSize")
    def max_size(self) -> typing.Optional[jsii.Number]:
        return jsii.get(self, "maxSize")

    @max_size.setter
    def max_size(self, value: typing.Optional[jsii.Number]) -> None:
        jsii.set(self, "maxSize", value)

    @builtins.property
    @jsii.member(jsii_name="minSize")
    def min_size(self) -> typing.Optional[jsii.Number]:
        return jsii.get(self, "minSize")

    @min_size.setter
    def min_size(self, value: typing.Optional[jsii.Number]) -> None:
        jsii.set(self, "minSize", value)

    @builtins.property
    @jsii.member(jsii_name="recurrence")
    def recurrence(self) -> typing.Optional[str]:
        return jsii.get(self, "recurrence")

    @recurrence.setter
    def recurrence(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "recurrence", value)

    @builtins.property
    @jsii.member(jsii_name="startTime")
    def start_time(self) -> typing.Optional[str]:
        return jsii.get(self, "startTime")

    @start_time.setter
    def start_time(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "startTime", value)


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AutoscalingScheduleConfig",
    jsii_struct_bases=[cdktf.TerraformMetaArguments],
    name_mapping={
        "count": "count",
        "depends_on": "dependsOn",
        "lifecycle": "lifecycle",
        "provider": "provider",
        "autoscaling_group_name": "autoscalingGroupName",
        "scheduled_action_name": "scheduledActionName",
        "desired_capacity": "desiredCapacity",
        "end_time": "endTime",
        "max_size": "maxSize",
        "min_size": "minSize",
        "recurrence": "recurrence",
        "start_time": "startTime",
    },
)
class AutoscalingScheduleConfig(cdktf.TerraformMetaArguments):
    def __init__(
        self,
        *,
        count: typing.Optional[jsii.Number] = None,
        depends_on: typing.Optional[typing.List[cdktf.TerraformResource]] = None,
        lifecycle: typing.Optional[cdktf.TerraformResourceLifecycle] = None,
        provider: typing.Optional[cdktf.TerraformProvider] = None,
        autoscaling_group_name: str,
        scheduled_action_name: str,
        desired_capacity: typing.Optional[jsii.Number] = None,
        end_time: typing.Optional[str] = None,
        max_size: typing.Optional[jsii.Number] = None,
        min_size: typing.Optional[jsii.Number] = None,
        recurrence: typing.Optional[str] = None,
        start_time: typing.Optional[str] = None,
    ) -> None:
        """
        :param count: 
        :param depends_on: 
        :param lifecycle: 
        :param provider: 
        :param autoscaling_group_name: 
        :param scheduled_action_name: 
        :param desired_capacity: 
        :param end_time: 
        :param max_size: 
        :param min_size: 
        :param recurrence: 
        :param start_time: 
        """
        if isinstance(lifecycle, dict):
            lifecycle = cdktf.TerraformResourceLifecycle(**lifecycle)
        self._values = {
            "autoscaling_group_name": autoscaling_group_name,
            "scheduled_action_name": scheduled_action_name,
        }
        if count is not None:
            self._values["count"] = count
        if depends_on is not None:
            self._values["depends_on"] = depends_on
        if lifecycle is not None:
            self._values["lifecycle"] = lifecycle
        if provider is not None:
            self._values["provider"] = provider
        if desired_capacity is not None:
            self._values["desired_capacity"] = desired_capacity
        if end_time is not None:
            self._values["end_time"] = end_time
        if max_size is not None:
            self._values["max_size"] = max_size
        if min_size is not None:
            self._values["min_size"] = min_size
        if recurrence is not None:
            self._values["recurrence"] = recurrence
        if start_time is not None:
            self._values["start_time"] = start_time

    @builtins.property
    def count(self) -> typing.Optional[jsii.Number]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("count")

    @builtins.property
    def depends_on(self) -> typing.Optional[typing.List[cdktf.TerraformResource]]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("depends_on")

    @builtins.property
    def lifecycle(self) -> typing.Optional[cdktf.TerraformResourceLifecycle]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("lifecycle")

    @builtins.property
    def provider(self) -> typing.Optional[cdktf.TerraformProvider]:
        """
        stability
        :stability: experimental
        """
        return self._values.get("provider")

    @builtins.property
    def autoscaling_group_name(self) -> str:
        return self._values.get("autoscaling_group_name")

    @builtins.property
    def scheduled_action_name(self) -> str:
        return self._values.get("scheduled_action_name")

    @builtins.property
    def desired_capacity(self) -> typing.Optional[jsii.Number]:
        return self._values.get("desired_capacity")

    @builtins.property
    def end_time(self) -> typing.Optional[str]:
        return self._values.get("end_time")

    @builtins.property
    def max_size(self) -> typing.Optional[jsii.Number]:
        return self._values.get("max_size")

    @builtins.property
    def min_size(self) -> typing.Optional[jsii.Number]:
        return self._values.get("min_size")

    @builtins.property
    def recurrence(self) -> typing.Optional[str]:
        return self._values.get("recurrence")

    @builtins.property
    def start_time(self) -> typing.Optional[str]:
        return self._values.get("start_time")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AutoscalingScheduleConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


class AwsProvider(
    cdktf.TerraformProvider,
    metaclass=jsii.JSIIMeta,
    jsii_type="@skorfmann/cdktf-provider-aws.AwsProvider",
):
    def __init__(
        self,
        scope: constructs.Construct,
        id: str,
        *,
        region: str,
        access_key: typing.Optional[str] = None,
        alias: typing.Optional[str] = None,
        allowed_account_ids: typing.Optional[typing.List[str]] = None,
        assume_role: typing.Optional[typing.List["AwsProviderAssumeRole"]] = None,
        endpoints: typing.Optional[typing.List["AwsProviderEndpoints"]] = None,
        forbidden_account_ids: typing.Optional[typing.List[str]] = None,
        ignore_tags: typing.Optional[typing.List["AwsProviderIgnoreTags"]] = None,
        insecure: typing.Optional[bool] = None,
        max_retries: typing.Optional[jsii.Number] = None,
        profile: typing.Optional[str] = None,
        s3_force_path_style: typing.Optional[bool] = None,
        secret_key: typing.Optional[str] = None,
        shared_credentials_file: typing.Optional[str] = None,
        skip_credentials_validation: typing.Optional[bool] = None,
        skip_get_ec2_platforms: typing.Optional[bool] = None,
        skip_metadata_api_check: typing.Optional[bool] = None,
        skip_region_validation: typing.Optional[bool] = None,
        skip_requesting_account_id: typing.Optional[bool] = None,
        token: typing.Optional[str] = None,
    ) -> None:
        """
        :param scope: -
        :param id: -
        :param region: The region where AWS operations will take place. Examples are us-east-1, us-west-2, etc.
        :param access_key: The access key for API operations. You can retrieve this from the 'Security & Credentials' section of the AWS console.
        :param alias: Alias name.
        :param allowed_account_ids: 
        :param assume_role: assume_role block.
        :param endpoints: endpoints block.
        :param forbidden_account_ids: 
        :param ignore_tags: ignore_tags block.
        :param insecure: Explicitly allow the provider to perform "insecure" SSL requests. If omitted,default value is ``false``
        :param max_retries: The maximum number of times an AWS API request is being executed. If the API request still fails, an error is thrown.
        :param profile: The profile for API operations. If not set, the default profile created with ``aws configure`` will be used.
        :param s3_force_path_style: Set this to true to force the request to use path-style addressing, i.e., http://s3.amazonaws.com/BUCKET/KEY. By default, the S3 client will use virtual hosted bucket addressing when possible (http://BUCKET.s3.amazonaws.com/KEY). Specific to the Amazon S3 service.
        :param secret_key: The secret key for API operations. You can retrieve this from the 'Security & Credentials' section of the AWS console.
        :param shared_credentials_file: The path to the shared credentials file. If not set this defaults to ~/.aws/credentials.
        :param skip_credentials_validation: Skip the credentials validation via STS API. Used for AWS API implementations that do not have STS available/implemented.
        :param skip_get_ec2_platforms: Skip getting the supported EC2 platforms. Used by users that don't have ec2:DescribeAccountAttributes permissions.
        :param skip_metadata_api_check: 
        :param skip_region_validation: Skip static validation of region name. Used by users of alternative AWS-like APIs or users w/ access to regions that are not public (yet).
        :param skip_requesting_account_id: Skip requesting the account ID. Used for AWS API implementations that do not have IAM/STS API and/or metadata API.
        :param token: session token. A session token is only required if you are using temporary security credentials.
        """
        config = AwsProviderConfig(
            region=region,
            access_key=access_key,
            alias=alias,
            allowed_account_ids=allowed_account_ids,
            assume_role=assume_role,
            endpoints=endpoints,
            forbidden_account_ids=forbidden_account_ids,
            ignore_tags=ignore_tags,
            insecure=insecure,
            max_retries=max_retries,
            profile=profile,
            s3_force_path_style=s3_force_path_style,
            secret_key=secret_key,
            shared_credentials_file=shared_credentials_file,
            skip_credentials_validation=skip_credentials_validation,
            skip_get_ec2_platforms=skip_get_ec2_platforms,
            skip_metadata_api_check=skip_metadata_api_check,
            skip_region_validation=skip_region_validation,
            skip_requesting_account_id=skip_requesting_account_id,
            token=token,
        )

        jsii.create(AwsProvider, self, [scope, id, config])

    @jsii.member(jsii_name="synthesizeAttributes")
    def synthesize_attributes(self) -> typing.Mapping[str, typing.Any]:
        return jsii.invoke(self, "synthesizeAttributes", [])

    @builtins.property
    @jsii.member(jsii_name="region")
    def region(self) -> str:
        return jsii.get(self, "region")

    @region.setter
    def region(self, value: str) -> None:
        jsii.set(self, "region", value)

    @builtins.property
    @jsii.member(jsii_name="accessKey")
    def access_key(self) -> typing.Optional[str]:
        return jsii.get(self, "accessKey")

    @access_key.setter
    def access_key(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "accessKey", value)

    @builtins.property
    @jsii.member(jsii_name="alias")
    def alias(self) -> typing.Optional[str]:
        return jsii.get(self, "alias")

    @alias.setter
    def alias(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "alias", value)

    @builtins.property
    @jsii.member(jsii_name="allowedAccountIds")
    def allowed_account_ids(self) -> typing.Optional[typing.List[str]]:
        return jsii.get(self, "allowedAccountIds")

    @allowed_account_ids.setter
    def allowed_account_ids(self, value: typing.Optional[typing.List[str]]) -> None:
        jsii.set(self, "allowedAccountIds", value)

    @builtins.property
    @jsii.member(jsii_name="assumeRole")
    def assume_role(self) -> typing.Optional[typing.List["AwsProviderAssumeRole"]]:
        return jsii.get(self, "assumeRole")

    @assume_role.setter
    def assume_role(
        self, value: typing.Optional[typing.List["AwsProviderAssumeRole"]]
    ) -> None:
        jsii.set(self, "assumeRole", value)

    @builtins.property
    @jsii.member(jsii_name="endpoints")
    def endpoints(self) -> typing.Optional[typing.List["AwsProviderEndpoints"]]:
        return jsii.get(self, "endpoints")

    @endpoints.setter
    def endpoints(
        self, value: typing.Optional[typing.List["AwsProviderEndpoints"]]
    ) -> None:
        jsii.set(self, "endpoints", value)

    @builtins.property
    @jsii.member(jsii_name="forbiddenAccountIds")
    def forbidden_account_ids(self) -> typing.Optional[typing.List[str]]:
        return jsii.get(self, "forbiddenAccountIds")

    @forbidden_account_ids.setter
    def forbidden_account_ids(self, value: typing.Optional[typing.List[str]]) -> None:
        jsii.set(self, "forbiddenAccountIds", value)

    @builtins.property
    @jsii.member(jsii_name="ignoreTags")
    def ignore_tags(self) -> typing.Optional[typing.List["AwsProviderIgnoreTags"]]:
        return jsii.get(self, "ignoreTags")

    @ignore_tags.setter
    def ignore_tags(
        self, value: typing.Optional[typing.List["AwsProviderIgnoreTags"]]
    ) -> None:
        jsii.set(self, "ignoreTags", value)

    @builtins.property
    @jsii.member(jsii_name="insecure")
    def insecure(self) -> typing.Optional[bool]:
        return jsii.get(self, "insecure")

    @insecure.setter
    def insecure(self, value: typing.Optional[bool]) -> None:
        jsii.set(self, "insecure", value)

    @builtins.property
    @jsii.member(jsii_name="maxRetries")
    def max_retries(self) -> typing.Optional[jsii.Number]:
        return jsii.get(self, "maxRetries")

    @max_retries.setter
    def max_retries(self, value: typing.Optional[jsii.Number]) -> None:
        jsii.set(self, "maxRetries", value)

    @builtins.property
    @jsii.member(jsii_name="profile")
    def profile(self) -> typing.Optional[str]:
        return jsii.get(self, "profile")

    @profile.setter
    def profile(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "profile", value)

    @builtins.property
    @jsii.member(jsii_name="s3ForcePathStyle")
    def s3_force_path_style(self) -> typing.Optional[bool]:
        return jsii.get(self, "s3ForcePathStyle")

    @s3_force_path_style.setter
    def s3_force_path_style(self, value: typing.Optional[bool]) -> None:
        jsii.set(self, "s3ForcePathStyle", value)

    @builtins.property
    @jsii.member(jsii_name="secretKey")
    def secret_key(self) -> typing.Optional[str]:
        return jsii.get(self, "secretKey")

    @secret_key.setter
    def secret_key(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "secretKey", value)

    @builtins.property
    @jsii.member(jsii_name="sharedCredentialsFile")
    def shared_credentials_file(self) -> typing.Optional[str]:
        return jsii.get(self, "sharedCredentialsFile")

    @shared_credentials_file.setter
    def shared_credentials_file(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "sharedCredentialsFile", value)

    @builtins.property
    @jsii.member(jsii_name="skipCredentialsValidation")
    def skip_credentials_validation(self) -> typing.Optional[bool]:
        return jsii.get(self, "skipCredentialsValidation")

    @skip_credentials_validation.setter
    def skip_credentials_validation(self, value: typing.Optional[bool]) -> None:
        jsii.set(self, "skipCredentialsValidation", value)

    @builtins.property
    @jsii.member(jsii_name="skipGetEc2Platforms")
    def skip_get_ec2_platforms(self) -> typing.Optional[bool]:
        return jsii.get(self, "skipGetEc2Platforms")

    @skip_get_ec2_platforms.setter
    def skip_get_ec2_platforms(self, value: typing.Optional[bool]) -> None:
        jsii.set(self, "skipGetEc2Platforms", value)

    @builtins.property
    @jsii.member(jsii_name="skipMetadataApiCheck")
    def skip_metadata_api_check(self) -> typing.Optional[bool]:
        return jsii.get(self, "skipMetadataApiCheck")

    @skip_metadata_api_check.setter
    def skip_metadata_api_check(self, value: typing.Optional[bool]) -> None:
        jsii.set(self, "skipMetadataApiCheck", value)

    @builtins.property
    @jsii.member(jsii_name="skipRegionValidation")
    def skip_region_validation(self) -> typing.Optional[bool]:
        return jsii.get(self, "skipRegionValidation")

    @skip_region_validation.setter
    def skip_region_validation(self, value: typing.Optional[bool]) -> None:
        jsii.set(self, "skipRegionValidation", value)

    @builtins.property
    @jsii.member(jsii_name="skipRequestingAccountId")
    def skip_requesting_account_id(self) -> typing.Optional[bool]:
        return jsii.get(self, "skipRequestingAccountId")

    @skip_requesting_account_id.setter
    def skip_requesting_account_id(self, value: typing.Optional[bool]) -> None:
        jsii.set(self, "skipRequestingAccountId", value)

    @builtins.property
    @jsii.member(jsii_name="token")
    def token(self) -> typing.Optional[str]:
        return jsii.get(self, "token")

    @token.setter
    def token(self, value: typing.Optional[str]) -> None:
        jsii.set(self, "token", value)


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AwsProviderAssumeRole",
    jsii_struct_bases=[],
    name_mapping={
        "external_id": "externalId",
        "policy": "policy",
        "role_arn": "roleArn",
        "session_name": "sessionName",
    },
)
class AwsProviderAssumeRole:
    def __init__(
        self,
        *,
        external_id: typing.Optional[str] = None,
        policy: typing.Optional[str] = None,
        role_arn: typing.Optional[str] = None,
        session_name: typing.Optional[str] = None,
    ) -> None:
        """
        :param external_id: The external ID to use when assuming the role. If omitted, no external ID is passed to the AssumeRole call.
        :param policy: The permissions applied when assuming a role. You cannot use, this policy to grant further permissions that are in excess to those of the, role that is being assumed.
        :param role_arn: The ARN of an IAM role to assume prior to making API calls.
        :param session_name: The session name to use when assuming the role. If omitted, no session name is passed to the AssumeRole call.
        """
        self._values = {}
        if external_id is not None:
            self._values["external_id"] = external_id
        if policy is not None:
            self._values["policy"] = policy
        if role_arn is not None:
            self._values["role_arn"] = role_arn
        if session_name is not None:
            self._values["session_name"] = session_name

    @builtins.property
    def external_id(self) -> typing.Optional[str]:
        """The external ID to use when assuming the role.

        If omitted, no external ID is passed to the AssumeRole call.
        """
        return self._values.get("external_id")

    @builtins.property
    def policy(self) -> typing.Optional[str]:
        """The permissions applied when assuming a role.

        You cannot use, this policy to grant further permissions that are in excess to those of the,  role that is being assumed.
        """
        return self._values.get("policy")

    @builtins.property
    def role_arn(self) -> typing.Optional[str]:
        """The ARN of an IAM role to assume prior to making API calls."""
        return self._values.get("role_arn")

    @builtins.property
    def session_name(self) -> typing.Optional[str]:
        """The session name to use when assuming the role.

        If omitted, no session name is passed to the AssumeRole call.
        """
        return self._values.get("session_name")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AwsProviderAssumeRole(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AwsProviderConfig",
    jsii_struct_bases=[],
    name_mapping={
        "region": "region",
        "access_key": "accessKey",
        "alias": "alias",
        "allowed_account_ids": "allowedAccountIds",
        "assume_role": "assumeRole",
        "endpoints": "endpoints",
        "forbidden_account_ids": "forbiddenAccountIds",
        "ignore_tags": "ignoreTags",
        "insecure": "insecure",
        "max_retries": "maxRetries",
        "profile": "profile",
        "s3_force_path_style": "s3ForcePathStyle",
        "secret_key": "secretKey",
        "shared_credentials_file": "sharedCredentialsFile",
        "skip_credentials_validation": "skipCredentialsValidation",
        "skip_get_ec2_platforms": "skipGetEc2Platforms",
        "skip_metadata_api_check": "skipMetadataApiCheck",
        "skip_region_validation": "skipRegionValidation",
        "skip_requesting_account_id": "skipRequestingAccountId",
        "token": "token",
    },
)
class AwsProviderConfig:
    def __init__(
        self,
        *,
        region: str,
        access_key: typing.Optional[str] = None,
        alias: typing.Optional[str] = None,
        allowed_account_ids: typing.Optional[typing.List[str]] = None,
        assume_role: typing.Optional[typing.List["AwsProviderAssumeRole"]] = None,
        endpoints: typing.Optional[typing.List["AwsProviderEndpoints"]] = None,
        forbidden_account_ids: typing.Optional[typing.List[str]] = None,
        ignore_tags: typing.Optional[typing.List["AwsProviderIgnoreTags"]] = None,
        insecure: typing.Optional[bool] = None,
        max_retries: typing.Optional[jsii.Number] = None,
        profile: typing.Optional[str] = None,
        s3_force_path_style: typing.Optional[bool] = None,
        secret_key: typing.Optional[str] = None,
        shared_credentials_file: typing.Optional[str] = None,
        skip_credentials_validation: typing.Optional[bool] = None,
        skip_get_ec2_platforms: typing.Optional[bool] = None,
        skip_metadata_api_check: typing.Optional[bool] = None,
        skip_region_validation: typing.Optional[bool] = None,
        skip_requesting_account_id: typing.Optional[bool] = None,
        token: typing.Optional[str] = None,
    ) -> None:
        """
        :param region: The region where AWS operations will take place. Examples are us-east-1, us-west-2, etc.
        :param access_key: The access key for API operations. You can retrieve this from the 'Security & Credentials' section of the AWS console.
        :param alias: Alias name.
        :param allowed_account_ids: 
        :param assume_role: assume_role block.
        :param endpoints: endpoints block.
        :param forbidden_account_ids: 
        :param ignore_tags: ignore_tags block.
        :param insecure: Explicitly allow the provider to perform "insecure" SSL requests. If omitted,default value is ``false``
        :param max_retries: The maximum number of times an AWS API request is being executed. If the API request still fails, an error is thrown.
        :param profile: The profile for API operations. If not set, the default profile created with ``aws configure`` will be used.
        :param s3_force_path_style: Set this to true to force the request to use path-style addressing, i.e., http://s3.amazonaws.com/BUCKET/KEY. By default, the S3 client will use virtual hosted bucket addressing when possible (http://BUCKET.s3.amazonaws.com/KEY). Specific to the Amazon S3 service.
        :param secret_key: The secret key for API operations. You can retrieve this from the 'Security & Credentials' section of the AWS console.
        :param shared_credentials_file: The path to the shared credentials file. If not set this defaults to ~/.aws/credentials.
        :param skip_credentials_validation: Skip the credentials validation via STS API. Used for AWS API implementations that do not have STS available/implemented.
        :param skip_get_ec2_platforms: Skip getting the supported EC2 platforms. Used by users that don't have ec2:DescribeAccountAttributes permissions.
        :param skip_metadata_api_check: 
        :param skip_region_validation: Skip static validation of region name. Used by users of alternative AWS-like APIs or users w/ access to regions that are not public (yet).
        :param skip_requesting_account_id: Skip requesting the account ID. Used for AWS API implementations that do not have IAM/STS API and/or metadata API.
        :param token: session token. A session token is only required if you are using temporary security credentials.
        """
        self._values = {
            "region": region,
        }
        if access_key is not None:
            self._values["access_key"] = access_key
        if alias is not None:
            self._values["alias"] = alias
        if allowed_account_ids is not None:
            self._values["allowed_account_ids"] = allowed_account_ids
        if assume_role is not None:
            self._values["assume_role"] = assume_role
        if endpoints is not None:
            self._values["endpoints"] = endpoints
        if forbidden_account_ids is not None:
            self._values["forbidden_account_ids"] = forbidden_account_ids
        if ignore_tags is not None:
            self._values["ignore_tags"] = ignore_tags
        if insecure is not None:
            self._values["insecure"] = insecure
        if max_retries is not None:
            self._values["max_retries"] = max_retries
        if profile is not None:
            self._values["profile"] = profile
        if s3_force_path_style is not None:
            self._values["s3_force_path_style"] = s3_force_path_style
        if secret_key is not None:
            self._values["secret_key"] = secret_key
        if shared_credentials_file is not None:
            self._values["shared_credentials_file"] = shared_credentials_file
        if skip_credentials_validation is not None:
            self._values["skip_credentials_validation"] = skip_credentials_validation
        if skip_get_ec2_platforms is not None:
            self._values["skip_get_ec2_platforms"] = skip_get_ec2_platforms
        if skip_metadata_api_check is not None:
            self._values["skip_metadata_api_check"] = skip_metadata_api_check
        if skip_region_validation is not None:
            self._values["skip_region_validation"] = skip_region_validation
        if skip_requesting_account_id is not None:
            self._values["skip_requesting_account_id"] = skip_requesting_account_id
        if token is not None:
            self._values["token"] = token

    @builtins.property
    def region(self) -> str:
        """The region where AWS operations will take place.

        Examples
        are us-east-1, us-west-2, etc.
        """
        return self._values.get("region")

    @builtins.property
    def access_key(self) -> typing.Optional[str]:
        """The access key for API operations.

        You can retrieve this
        from the 'Security & Credentials' section of the AWS console.
        """
        return self._values.get("access_key")

    @builtins.property
    def alias(self) -> typing.Optional[str]:
        """Alias name."""
        return self._values.get("alias")

    @builtins.property
    def allowed_account_ids(self) -> typing.Optional[typing.List[str]]:
        return self._values.get("allowed_account_ids")

    @builtins.property
    def assume_role(self) -> typing.Optional[typing.List["AwsProviderAssumeRole"]]:
        """assume_role block."""
        return self._values.get("assume_role")

    @builtins.property
    def endpoints(self) -> typing.Optional[typing.List["AwsProviderEndpoints"]]:
        """endpoints block."""
        return self._values.get("endpoints")

    @builtins.property
    def forbidden_account_ids(self) -> typing.Optional[typing.List[str]]:
        return self._values.get("forbidden_account_ids")

    @builtins.property
    def ignore_tags(self) -> typing.Optional[typing.List["AwsProviderIgnoreTags"]]:
        """ignore_tags block."""
        return self._values.get("ignore_tags")

    @builtins.property
    def insecure(self) -> typing.Optional[bool]:
        """Explicitly allow the provider to perform "insecure" SSL requests.

        If omitted,default value is ``false``
        """
        return self._values.get("insecure")

    @builtins.property
    def max_retries(self) -> typing.Optional[jsii.Number]:
        """The maximum number of times an AWS API request is being executed.

        If the API request still fails, an error is
        thrown.
        """
        return self._values.get("max_retries")

    @builtins.property
    def profile(self) -> typing.Optional[str]:
        """The profile for API operations.

        If not set, the default profile
        created with ``aws configure`` will be used.
        """
        return self._values.get("profile")

    @builtins.property
    def s3_force_path_style(self) -> typing.Optional[bool]:
        """Set this to true to force the request to use path-style addressing, i.e., http://s3.amazonaws.com/BUCKET/KEY. By default, the S3 client will use virtual hosted bucket addressing when possible (http://BUCKET.s3.amazonaws.com/KEY). Specific to the Amazon S3 service."""
        return self._values.get("s3_force_path_style")

    @builtins.property
    def secret_key(self) -> typing.Optional[str]:
        """The secret key for API operations.

        You can retrieve this
        from the 'Security & Credentials' section of the AWS console.
        """
        return self._values.get("secret_key")

    @builtins.property
    def shared_credentials_file(self) -> typing.Optional[str]:
        """The path to the shared credentials file.

        If not set
        this defaults to ~/.aws/credentials.
        """
        return self._values.get("shared_credentials_file")

    @builtins.property
    def skip_credentials_validation(self) -> typing.Optional[bool]:
        """Skip the credentials validation via STS API.

        Used for AWS API implementations that do not have STS available/implemented.
        """
        return self._values.get("skip_credentials_validation")

    @builtins.property
    def skip_get_ec2_platforms(self) -> typing.Optional[bool]:
        """Skip getting the supported EC2 platforms.

        Used by users that don't have ec2:DescribeAccountAttributes permissions.
        """
        return self._values.get("skip_get_ec2_platforms")

    @builtins.property
    def skip_metadata_api_check(self) -> typing.Optional[bool]:
        return self._values.get("skip_metadata_api_check")

    @builtins.property
    def skip_region_validation(self) -> typing.Optional[bool]:
        """Skip static validation of region name.

        Used by users of alternative AWS-like APIs or users w/ access to regions that are not public (yet).
        """
        return self._values.get("skip_region_validation")

    @builtins.property
    def skip_requesting_account_id(self) -> typing.Optional[bool]:
        """Skip requesting the account ID.

        Used for AWS API implementations that do not have IAM/STS API and/or metadata API.
        """
        return self._values.get("skip_requesting_account_id")

    @builtins.property
    def token(self) -> typing.Optional[str]:
        """session token.

        A session token is only required if you are
        using temporary security credentials.
        """
        return self._values.get("token")

    def __eq__(self, rhs) -> bool:
        return isinstance(rhs, self.__class__) and rhs._values == self._values

    def __ne__(self, rhs) -> bool:
        return not (rhs == self)

    def __repr__(self) -> str:
        return "AwsProviderConfig(%s)" % ", ".join(
            k + "=" + repr(v) for k, v in self._values.items()
        )


@jsii.data_type(
    jsii_type="@skorfmann/cdktf-provider-aws.AwsProviderEndpoints",
    jsii_struct_bases=[],
    name_mapping={
        "accessanalyzer": "accessanalyzer",
        "acm": "acm",
        "acmpca": "acmpca",
        "amplify": "amplify",
        "apigateway": "apigateway",
        "applicationautoscaling": "applicationautoscaling",
        "applicationinsights": "applicationinsights",
        "appmesh": "appmesh",
        "appstream": "appstream",
        "appsync": "appsync",
        "athena": "athena",
        "autoscaling": "autoscaling",
        "autoscalingplans": "autoscalingplans",
        "backup": "backup",
        "batch": "batch",
        "budgets": "budgets",
        "cloud9": "cloud9",
        "cloudformation": "cloudformation",
        "cloudfront": "cloudfront",
        "cloudhsm": "cloudhsm",
        "cloudsearch": "cloudsearch",
        "cloudtrail": "cloudtrail",
        "cloudwatch": "cloudwatch",
        "cloudwatchevents": "cloudwatchevents",
        "cloudwatchlogs": "cloudwatchlogs",
        "codeartifact": "codeartifact",
        "codebuild": "codebuild",
        "codecommit": "codecommit",
        "codedeploy": "codedeploy",
        "codepipeline": "codepipeline",
        "cognitoidentity": "cognitoidentity",
        "cognitoidp": "cognitoidp",
        "configservice": "configservice",
        "cur": "cur",
        "dataexchange": "dataexchange",
        "datapipeline": "datapipeline",
        "datasync": "datasync",
        "dax": "dax",
        "devicefarm": "devicefarm",
        "directconnect": "directconnect",
        "dlm": "dlm",
        "dms": "dms",
        "docdb": "docdb",
        "ds": "ds",
        "dynamodb": "dynamodb",
        "ec2": "ec2",
        "ecr": "ecr",
        "ecs": "ecs",
        "efs": "efs",
        "eks": "eks",
        "elasticache": "elasticache",
        "elasticbeanstalk": "elasticbeanstalk",
        "elastictranscoder": "elastictranscoder",
        "elb": "elb",
        "emr": "emr",
        "es": "es",
        "firehose": "firehose",
        "fms": "fms",
        "forecast": "forecast",
        "fsx": "fsx",
        "gamelift": "gamelift",
        "glacier": "glacier",
        "globalaccelerator": "globalaccelerator",
        "glue": "glue",
        "greengrass": "greengrass",
        "guardduty": "guardduty",
        "iam": "iam",
        "imagebuilder": "imagebuilder",
        "inspector": "inspector",
        "iot": "iot",
        "iotanalytics": "iotanalytics",
        "iotevents": "iotevents",
        "kafka": "kafka",
        "kinesis": "kinesis",
        "kinesisanalytics": "kinesisanalytics",
        "kinesis_analytics": "kinesisAnalytics",
        "kinesisanalyticsv2": "kinesisanalyticsv2",
        "kinesisvideo": "kinesisvideo",
        "kms": "kms",
        "lakeformation": "lakeformation",
        "lambda_": "lambda",
        "lexmodels": "lexmodels",
        "licensemanager": "licensemanager",
        "lightsail": "lightsail",
        "macie": "macie",
        "managedblockchain": "managedblockchain",
        "marketplacecatalog": "marketplacecatalog",
        "mediaconnect": "mediaconnect",
        "mediaconvert": "mediaconvert",
        "medialive": "medialive",
        "mediapackage": "mediapackage",
        "mediastore": "mediastore",
        "mediastoredata": "mediastoredata",
        "mq": "mq",
        "neptune": "neptune",
        "networkmanager": "networkmanager",
        "opsworks": "opsworks",
        "organizations": "organizations",
        "outposts": "outposts",
        "personalize": "personalize",
        "pinpoint": "pinpoint",
        "pricing": "pricing",
        "qldb": "qldb",
        "quicksight": "quicksight",
        "r53": "r53",
        "ram": "ram",
        "rds": "rds",
        "redshift": "redshift",
        "resourcegroups": "resourcegroups",
        "resourcegroupstaggingapi": "resourcegroupstaggingapi",
        "route53": "route53",
        "route53_domains": "route53Domains",
        "route53_resolver": "route53Resolver",
        "s3": "s3",
        "s3_control": "s3Control",
        "sagemaker": "sagemaker",
        "sdb": "sdb",
        "secretsmanager": "secretsmanager",
        "securityhub": "securityhub",
        "serverlessrepo": "serverlessrepo",
        "servicecatalog": "servicecatalog",
        "servicediscovery": "servicediscovery",
        "servicequotas": "servicequotas",
        "ses": "ses",
        "shield": "shield",
        "sns": "sns",
        "sqs": "sqs",
        "ssm": "ssm",
        "stepfunctions": "stepfunctions",
        "storagegateway": "storagegateway",
        "sts": "sts",
        "swf": "swf",
        "synthetics": "synthetics",
        "transfer": "transfer",
        "waf": "waf",
        "wafregional": "wafregional",
        "wafv2": "wafv2",
        "worklink": "worklink",
        "workmail": "workmail",
        "workspaces": "workspaces",
        "xray": "xray",
    },
)
class AwsProviderEndpoints:
    def __init__(
        self,
        *,
        accessanalyzer: typing.Optional[str] = None,
        acm: typing.Optional[str] = None,
        acmpca: typing.Optional[str] = None,
        amplify: typing.Optional[str] = None,
        apigateway: typing.Optional[str] = None,
        applicationautoscaling: typing.Optional[str] = None,
        applicationinsights: typing.Optional[str] = None,
        appmesh: typing.Optional[str] = None,
        appstream: typing.Optional[str] = None,
        appsync: typing.Optional[str] = None,
        athena: typing.Optional[str] = None,
        autoscaling: typing.Optional[str] = None,
        autoscalingplans: typing.Optional[str] = None,
        backup: typing.Optional[str] = None,
        batch: typing.Optional[str] = None,
        budgets: typing.Optional[str] = None,
        cloud9: typing.Optional[str] = None,
        cloudformation: typing.Optional[str] = None,
        cloudfront: typing.Optional[str] = None,
        cloudhsm: typing.Optional[str] = None,
        cloudsearch: typing.Optional[str] = None,
        cloudtrail: typing.Optional[str] = None,
        cloudwatch: typing.Optional[str] = None,
        cloudwatchevents: typing.Optional[str] = None,
        cloudwatchlogs: typing.Optional[str] = None,
        codeartifact: typing.Optional[str] = None,
        codebuild: typing.Optional[str] = None,
        codecommit: typing.Optional[str] = None,
        codedeploy: typing.Optional[str] = None,
        codepipeline: typing.Optional[str] = None,
        cognitoidentity: typing.Optional[str] = None,
        cognitoidp: typing.Optional[str] = None,
        configservice: typing.Optional[str] = None,
        cur: typing.Optional[str] = None,
        dataexchange: typing.Optional[str] = None,
        datapipeline: typing.Optional[str] = None,
        datasync: typing.Optional[str] = None,
        dax: typing.Optional[str] = None,
        devicefarm: typing.Optional[str] = None,
        directconnect: typing.Optional[str] = None,
        dlm: typing.Optional[str] = None,
        dms: typing.Optional[str] = None,
        docdb: typing.Optional[str] = None,
        ds: typing.Optional[str] = None,
        dynamodb: typing.Optional[str] = None,
        ec2: typing.Optional[str] = None,
        ecr: typing.Optional[str] = None,
        ecs: typing.Optional[str] = None,
        efs: typing.Optional[str] = None,
        eks: typing.Optional[str] = None,
        elasticache: typing.Optional[str] = None,
        elasticbeanstalk: typing.Optional[str] = None,
        elastictranscoder: typing.Optional[str] = None,
        elb: typing.Optional[str] = None,
        emr: typing.Optional[str] = None,
        es: typing.Optional[str] = None,
        firehose: typing.Optional[str] = None,
        fms: typing.Optional[str] = None,
        forecast: typing.Optional[str] = None,
        fsx: typing.Optional[str] = None,
        gamelift: typing.Optional[str] = None,
        glacier: typing.Optional[str] = None,
        globalaccelerator: typing.Optional[str] = None,
        glue: typing.Optional[str] = None,
        greengrass: typing.Optional[str] = None,
        guardduty: typing.Optional[str] = None,
        iam: typing.Optional[str] = None,
        imagebuilder: typing.Optional[str] = None,
        inspector: typing.Optional[str] = None,
        iot: typing.Optional[str] = None,
        iotanalytics: typing.Optional[str] = None,
        iotevents: typing.Optional[str] = None,
        kafka: typing.Optional[str] = None,
        kinesis: typing.Optional[str] = None,
        kinesisanalytics: typing.Optional[str] = None,
        kinesis_analytics: typing.Optional[str] = None,
        kinesisanalyticsv2: typing.Optional[str] = None,
        kinesisvideo: typing.Optional[str] = None,
        kms: typing.Optional[str] = None,
        lakeformation: typing.Optional[str] = None,
        lambda_: typing.Optional[str] = None,
        lexmodels: typing.Optional[str] = None,
        licensemanager: typing.Optional[str] = None,
        lightsail: typing.Optional[str] = None,
        macie: typing.Optional[str] = None,
        managedblockchain: typing.Optional[str] = None,
        marketplacecatalog: typing.Optional[str] = None,
        mediaconnect: typing.Optional[str] = None,
        mediaconvert: typing.Optional[str] = None,
        medialive: typing.Optional[str] = None,
        mediapackage: typing.Optional[str] = None,
        mediastore: typing.Optional[str] = None,
        mediastoredata: typing.Optional[str] = None,
        mq: typing.Optional[str] = None,
        neptune: typing.Optional[str] = None,
        networkmanager: typing.Optional[str] = None,
        opsworks: typing.Optional[str] = None,
        organizations: typing.Optional[str] = None,
        outposts: typing.Optional[str] = None,
        personalize: typing.Optional[str] = None,
        pinpoint: typing.Optional[str] = None,
        pricing: typing.Optional[str] = None,
        qldb: typing.Optional[str] = None,
        quicksight: typing.Optional[str] = None,
        r53: typing.Optional[str] = None,
        ram: typing.Optional[str] = None,
        rds: typing.Optional[str] = None,
        redshift: typing.Optional[str] = None,
        resourcegroups: typing.Optional[str] = None,
        resourcegroupstaggingapi: typing.Optional[str] = None,
        route53: typing.Optional[str] = None,
        route53_domains: typing.Optional[str] = None,
        route53_resolver: typing.Optional[str] = None,
        s3: typing.Optional[str] = None,
        s3_control: typing.Optional[str] = None,
        sagemaker: typing.Optional[str] = None,
        sdb: typing.Optional[str] = None,
        secretsmanager: typing.Optional[str] = None,
        securityhub: typing.Optional[str] = None,
        serverlessrepo: typing.Optional[str] = None,
        servicecatalog: typing.Optional[str] = None,
        servicediscovery: typing.Optional[str] = None,
        servicequotas: typing.Optional[str] = None,
        ses: typing.Optional[str] = None,
        shield: typing.Optional[str] = None,
        sns: typing.Optional[str] = None,
        sqs: typing.Optional[str] = None,
        ssm: typing.Optional[str] = None,
        stepfunctions: typing.Optional[str] = None,
        storagegateway: typing.Optional[str] = None,
        sts: typing.Optional[str] = None,
        swf: typing.Optional[str] = None,
        synthetics: typing.Optional[str] = None,
        transfer: typing.Optional[str] = None,
        waf: typing.Optional[str] = None,
        wafregional: typing.Optional[str] = None,
        wafv2: typing.Optional[str] = None,
        worklink: typing.Optional[str] = None,
        workmail: typing.Optional[str] = None,
        workspaces: typing.Optional[str] = None,
        xray: typing.Optional[str] = None,
    ) -> None:
        """
        :param accessanalyzer: Use this to override the default service endpoint URL.
        :param acm: Use this to override the default service endpoint URL.
        :param acmpca: Use this to override the default service endpoint URL.
        :param amplify: Use this to override the default service endpoint URL.
        :param apigateway: Use this to override the default service endpoint URL.
        :param applicationautoscaling: Use this to override the default service endpoint URL.
        :param applicationinsights: Use this to override the default service endpoint URL.
        :param appmesh: Use this to override the default service endpoint URL.
        :param appstream: Use this to override the default service endpoint URL.
        :param appsync: Use this to override the default service endpoint URL.
        :param athena: Use this to override the default service endpoint URL.
        :param autoscaling: Use this to override the default service endpoint URL.
        :param autoscalingplans: Use this to override the default service endpoint URL.
        :param backup: Use this to override the default service endpoint URL.
        :param batch: Use this to override the default service endpoint URL.
        :param budgets: Use this to override the default service endpoint URL.
        :param cloud9: Use this to override the default service endpoint URL.
        :param cloudformation: Use this to override the default service endpoint URL.
        :param cloudfront: Use this to override the default service endpoint URL.
        :param cloudhsm: Use this to override the default service endpoint URL.
        :param cloudsearch: Use this to override the default service endpoint URL.
        :param cloudtrail: Use this to override the default service endpoint URL.
        :param cloudwatch: Use this to override the default service endpoint URL.
        :param cloudwatchevents: Use this to override the default service endpoint URL.
        :param cloudwatchlogs: Use this to override the default service endpoint URL.
        :param codeartifact: Use this to override the default service endpoint URL.
        :param codebuild: Use this to override the default service endpoint URL.
        :param codecommit: Use this to override the default service endpoint URL.
        :param codedeploy: Use this to override the default service endpoint URL.
        :param codepipeline: Use this to override the default service endpoint URL.
        :param cognitoidentity: Use this to override the default service endpoint URL.
        :param cognitoidp: Use this to override the default service endpoint URL.
        :param configservice: Use this to override the default service endpoint URL.
        :param cur: Use this to override the default service endpoint URL.
        :param dataexchange: Use this to override the default service endpoint URL.
        :param datapipeline: Use this to override the default service endpoint URL.
        :param datasync: Use this to override the default service endpoint URL.
        :param dax: Use this to override the default service endpoint URL.
        :param devicefarm: Use this to override the default service endpoint URL.
        :param directconnect: Use this to override the default service endpoint URL.
        :param dlm: Use this to override the default service endpoint URL.
        :param dms: Use this to override the default service endpoint URL.
        :param docdb: Use this to override the default service endpoint URL.
        :param ds: Use this to override the default service endpoint URL.
        :param dynamodb: Use this to override the default service endpoint URL.
        :param ec2: Use this to override the default service endpoint URL.
        :param ecr: Use this to override the default service endpoint URL.
        :param ecs: Use this to override the default service endpoint URL.
        :param efs: Use this to override the default service endpoint URL.
        :param eks: Use this to override the default service endpoint URL.
        :param elasticache: Use this to override the default service endpoint URL.
        :param elasticbeanstalk: Use this to override the default service endpoint URL.
        :param elastictranscoder: Use this to override the default service endpoint URL.
        :param elb: Use this to override the default service endpoint URL.
        :param emr: Use this to override the default service endpoint URL.
        :param es: Use this to override the default service endpoint URL.
        :param firehose: Use this to override the default service endpoint URL.
        :param fms: Use this to override the default service endpoint URL.
        :param forecast: Use this to override the default service endpoint URL.
        :param fsx: Use this to override the default service endpoint URL.
        :param gamelift: Use this to override the default service endpoint URL.
        :param glacier: Use this to override the default service endpoint URL.
        :param globalaccelerator: Use this to override the default service endpoint URL.
        :param glue: Use this to override the default service endpoint URL.
        :param greengrass: Use this to override the default service endpoint URL.
        :param guardduty: Use this to override the default service endpoint URL.
        :param iam: Use this to override the default service endpoint URL.
        :param imagebuilder: Use this to override the default service endpoint URL.
        :param inspector: Use this to override the default service endpoint URL.
        :param iot: Use this to override the default service endpoint URL.
        :param iotanalytics: Use this to override the default service endpoint URL.
        :param iotevents: Use this to override the default service endpoint URL.
        :param kafka: Use this to override the default service endpoint URL.
        :param kinesis: Use this to override the default service endpoint URL.
        :param kinesisanalytics: Use this to override the default service endpoint URL.
        :param kinesis_analytics: Use this to override the default service endpoint URL.
        :param kinesisanalyticsv2: Use this to override the default service endpoint URL.
        :param kinesisvideo: Use this to override the default service endpoint URL.
        :param kms: Use this to override the default service endpoint URL.
        :param lakeformation: Use this to override the default service endpoint URL.
        :param lambda_: Use this to override the default service endpoint URL.
        :param lexmodels: Use this to override the default service endpoint URL.
        :param licensemanager: Use this to override the default service endpoint URL.
        :param lightsail: Use this to override the default service endpoint URL.
        :param macie: Use this to override the default service endpoint URL.
        :param managedblockchain: Use this to override the default service endpoint URL.
        :param marketplacecatalog: Use this to override the default service endpoint URL.
        :param mediaconnect: Use this to override the default service endpoint URL.
        :param mediaconvert: Use this to override the default service endpoint URL.
        :param medialive: Use this to override the default service endpoint URL.
        :param mediapackage: Use this to override the default service endpoint URL.
        :param mediastore: Use this to override the default service endpoint URL.
        :param mediastoredata: Use this to override the default service endpoint URL.
        :param mq: Use this to override the default service endpoint URL.
        :param neptune: Use this to override the default service endpoint URL.
        :param networkmanager: Use this to override the default service endpoint URL.
        :param opsworks: Use this to override the default service endpoint URL.
        :param organizations: Use this to override the default service endpoint URL.
        :param outposts: Use this to override the default service endpoint URL.
        :param personalize: Use this to override the default service endpoint URL.
        :param pinpoint: Use this to override the default service endpoint URL.
        :param pricing: Use this to override the default service endpoint URL.
        :param qldb: Use this to override the default service endpoint URL.
        :param quicksight: Use this to override the default service endpoint URL.
        :param r53: Use this to override the default service endpoint URL.
        :param ram: Use this to override the default service endpoint URL.
        :param rds: Use this to override the default service endpoint URL.
        :param redshift: Use this to override the default service endpoint URL.
        :param resourcegroups: Use this to override the default service endpoint URL.
        :param resourcegroupstaggingapi: Use this to override the default service endpoint URL.
        :param route53: Use this to override the default service endpoint URL.
        :param route53_domains: Use this to override the default service endpoint URL.
        :param route53_resolver: Use this to override the default service endpoint URL.
        :param s3: Use this to override the default service endpoint URL.
        :param s3_control: Use this to override the default service endpoint URL.
        :param sagemaker: Use this to override the default service endpoint URL.
        :param sdb: Use this to override the default service endpoint URL.
        :param secretsmanager: Use this to override the default service endpoint URL.
        :param securityhub: Use this to override the default service endpoint URL.
        :param serverlessrepo: Use this to override the default service endpoint URL.
        :param servicecatalog: Use this to override the default service endpoint URL.
        :param servicediscovery: Use this to override the default service endpoint URL.
        :param servicequotas: Use this to override the default service endpoint URL.
        :param ses: Use this to override the default service endpoint URL.
        :param shield: Use this to override the default service endpoint URL.
        :param sns: Use this to override the default service endpoint URL.
        :param sqs: Use this to override the default service endpoint URL.
        :param ssm: Use this to override the default service endpoint URL.
        :param stepfunctions: Use this to override the default service endpoint URL.
        :param storagegateway: Use this to override the default service endpoint URL.
        :param sts: Use this to override the default service endpoint URL.
        :param swf: Use this to override the default service endpoint URL.
        :param synthetics: Use this to override the default service endpoint URL.
        :param transfer: Use this to override the default service endpoint URL.
        :param waf: Use this to override the default service endpoint URL.
        :param wafregional: Use this to override the default service endpoint URL.
        :param wafv2: Use this to override the default service endpoint URL.
        :param worklink: Use this to override the default service endpoint URL.
        :param workmail: Use this to override the default service endpoint URL.
        :param workspaces: Use this to override the default service endpoint URL.
        :param xray: Use this to override the default service endpoint URL.
        """
        self._values = {}
        if accessanalyzer is not None:
            self._values["accessanalyzer"] = accessanalyzer
        if acm is not None:
            self._values["acm"] = acm
        if acmpca is not None:
            self._values["acmpca"] = acmpca
        if amplify is not None:
            self._values["amplify"] = amplify
        if apigateway is not None:
            self._values["apigateway"] = apigateway
        if applicationautoscaling is not None:
            self._values["applicationautoscaling"] = applicationautoscaling
        if applicationinsights is not None:
            self._values["applicationinsights"] = applicationinsights
        if appmesh is not None:
            self._values["appmesh"] = appmesh
        if appstream is not None:
            self._values["appstream"] = appstream
        if appsync is not None:
            self._values["appsync"] = appsync
        if athena is not None:
            self._values["athena"] = athena
        if autoscaling is not None:
            self._values["autoscaling"] = autoscaling
        if autoscalingplans is not None:
            self._values["autoscalingplans"] = autoscalingplans
        if backup is not None:
            self._values["backup"] = backup
        if batch is not None:
            self._values["batch"] = batch
        if budgets is not None:
            self._values["budgets"] = budgets
        if cloud9 is not None:
            self._values["cloud9"] = cloud9
        if cloudformation is not None:
            self._values["cloudformation"] = cloudformation
        if cloudfront is not None:
            self._values["cloudfront"] = cloudfront
        if cloudhsm is not None:
            self._values["cloudhsm"] = cloudhsm
        if cloudsearch is not None:
            self._values["cloudsearch"] = cloudsearch
        if cloudtrail is not None:
            self._values["cloudtrail"] = cloudtrail
        if cloudwatch is not None:
            self._values["cloudwatch"] = cloudwatch
        if cloudwatchevents is not None:
            self._values["cloudwatchevents"] = cloudwatchevents
        if cloudwatchlogs is not None:
            self._values["cloudwatchlogs"] = cloudwatchlogs
        if codeartifact is not None:
            self._values["codeartifact"] = codeartifact
        if codebuild is not None:
            self._values["codebuild"] = codebuild
        if codecommit is not None:
            self._values["codecommit"] = codecommit
        if codedeploy is not None:
            self._values["codedeploy"] = codedeploy
        if codepipeline is not None:
            self._values["codepipeline"] = codepipeline
        if cognitoidentity is not None:
            self._values["cognitoidentity"] = cognitoidentity
        if cognitoidp is not None:
            self._values["cognitoidp"] = cognitoidp
        if configservice is not None:
            self._values["configservice"] = configservice
        if cur is not None:
            self._values["cur"] = cur
        if dataexchange is not None:
            self._values["dataexchange"] = dataexchange
        if datapipeline is not None:
            self._values["datapipeline"] = datapipeline
        if datasync is not None:
            self._values["datasync"] = datasync
        if dax is not None:
            self._values["dax"] = dax
        if devicefarm is not None:
            self._values["devicefarm"] = devicefarm
        if directconnect is not None:
            self._values["directconnect"] = directconnect
        if dlm is not None:
            self._values["dlm"] = dlm
        if dms is not None:
            self._values["dms"] = dms
        if docdb is not None:
            self._values["docdb"] = docdb
        if ds is not None:
            self._values["ds"] = ds
        if dynamodb is not None:
            self._values["dynamodb"] = dynamodb
        if ec2 is not None:
            self._values["ec2"] = ec2
        if ecr is not None:
            self._values["ecr"] = ecr
        if ecs is not None:
            self._values["ecs"] = ecs
        if efs is not None:
            self._values["efs"] = efs
        if eks is not None:
            self._values["eks"] = eks
        if elasticache is not None:
            self._values["elasticache"] = elasticache
        if elasticbeanstalk is not None:
            self._values["elasticbeanstalk"] = elasticbeanstalk
        if elastictranscoder is not None:
            self._values["elastictranscoder"] = elastictranscoder
        if elb is not None:
            self._values["elb"] = elb
        if emr is not None:
            self._values["emr"] = emr
        if es is not None:
            self._values["es"] = es
        if firehose is not None:
            self._values["firehose"] = firehose
        if fms is not None:
            self._values["fms"] = fms
        if forecast is not None:
            self._values["forecast"] = forecast
        if fsx is not None:
            self._values["fsx"] = fsx
        if gamelift is not None:
            self._values["gamelift"] = gamelift
        if glacier is not None:
            self._values["glacier"] = glacier
        if globalaccelerator is not None:
            self._values["globalaccelerator"] = globalaccelerator
        if glue is not None:
            self._values["glue"] = glue
        if greengrass is not None:
            self._values["greengrass"] = greengrass
        if guardduty is not None:
            self._values["guardduty"] = guardduty
        if iam is not None:
            self._values["iam"] = iam
        if imagebuilder is not None:
            self._values["imagebuilder"] = imagebuilder
        if inspector is not None:
            self._values["inspector"] = inspector
        if iot is not None:
            self._values["iot"] = iot
        if iotanalytics is not None:
            self._values["iotanalytics"] = iotanalytics
        if iotevents is not None:
            self._values["iotevents"] = iotevents
        if kafka is not None:
            self._values["kafka"] = kafka
        if kinesis is not None:
            self._values["kinesis"] = kinesis
        if kinesisanalytics is not None:
            self._values["kinesisanalytics"] = kinesisanalytics
        if kinesis_analytics is not None:
            self._values["kinesis_analytics"] = kinesis_analytics
        if kinesisanalyticsv2 is not None:
            self._values["kinesisanalyticsv2"] = kinesisanalyticsv2
        if kinesisvideo is not None:
            self._values["kinesisvideo"] = kinesisvideo
        if kms is not None:
            self._values["kms"] = kms
        if lakeformation is not None:
            self._values["lakeformation"] = lakeformation
        if lambda_ is not None:
            self._values["lambda_"] = lambda_
        if lexmodels is not None:
            self._values["lexmodels"] = lexmodels
        if licensemanager is not None:
            self._values["licensemanager"] = licensemanager
        if lightsail is not None:
            self._values["lightsail"] = lightsail
        if macie is not None:
            self._values["macie"] = macie
        if managedblockchain is not None:
            self._values["managedblockchain"] = managedblockchain
        if marketplacecatalog is not None:
            self._values["marketplacecatalog"] = marketplacecatalog
        if mediaconnect is not None:
            self._values["mediaconnect"] = mediaconnect
        if mediaconvert is not None:
            self._values["mediaconvert"] = mediaconvert
        if medialive is not None:
            self._values["medialive"] = medialive
        if mediapackage is not None:
            self._values["mediapackage"] = mediapackage
        if mediastore is not None:
            self._values["mediastore"] = mediastore
        if mediastoredata is not None:
            self._values["mediastoredata"] = mediastoredata
        if mq is not None:
            self._values["mq"] = mq
        if neptune is not None:
            self._values["neptune"] = neptune
        if networkmanager is not None:
            self._values["networkmanager"] = networkmanager
        if opsworks is not None:
            self._values["opsworks"] = opsworks
        if organizations is not None:
            self._values["organizations"] = organizations
        if outposts is not None:
            self._values["outposts"] = outposts
        if personalize is not None:
            self._values["personalize"] = personalize
        if pinpoint is not None:
            self._values["pinpoint"] = pinpoint
        if pricing is not None:
            self._values["pricing"] = pricing
        if qldb is not None:
            self._values["qldb"] = qldb
        if quicksight is not None:
            self._values["quicksight"] = quicksight
        if r53 is not None:
            self._values["r53"] = r53
        if ram is not None:
            self._values["ram"] = ram
        if rds is not None:
            self._values["rds"] = rds
        if redshift is not None:
            self._values["redshift"] = redshift
        if resourcegroups is not None:
            self._values["resourcegroups"] = resourcegroups
        if resourcegroupstaggingapi is not None:
            self._values["resourcegroupstaggingapi"] = resourcegroupstaggingapi
        if route53 is not None:
            self._values["route53"] = route53
        if route53_domains is not None:
            self._values["route53_domains"] = route53_domains
        if route53_resolver is not None:
            self._values["route53_resolver"] = route53_resolver
        if s3 is not None:
            self._values["s3"] = s3
        if s3_control is not None:
            self._values["s3_control"] = s3_control
        if sagemaker is not None:
            self._values["sagemaker"] = sagemaker
        if sdb is not None:
            self._values["sdb"] = sdb
        if secretsmanager is not None:
            self._values["secretsmanager"] = secretsmanager
        if securityhub is not None:
            self._values["securityhub"] = securityhub
        if serverlessrepo is not None:
            self._values["serverlessrepo"] = serverlessrepo
        if servicecatalog is not None:
            self._values["servicecatalog"] = servicecatalog
        if servicediscovery is not None:
            self._values["servicediscovery"] = servicediscovery
        if servicequotas is not None:
            self._values["servicequotas"] = servicequotas
        if ses is not None:
            self._values["ses"] = ses
        if shield is not None:
            self._values["shield"] = shield
        if sns is not None:
            self._values["sns"] = sns
        if sqs is not None:
            self._values["sqs"] = sqs
        if ssm is not None:
            self._values["ssm"] = ssm
        if stepfunctions is not None:
            self._values["stepfunctions"] = stepfunctions
        if storagegateway is not None:
            self._values["storagegateway"] = storagegateway
        if sts is not None:
            self._values["sts"] = sts
        if swf is not None:
            self._values["swf"] = swf
        if synthetics is not None:
            self._values["synthetics"] = synthetics
        if transfer is not None:
            self._values["transfer"] = transfer
        if waf is not None:
            self._values["waf"] = waf
        if wafregional is not None:
            self._values["wafregional"] = wafregional
        if wafv2 is not None:
            self._values["wafv2"] = wafv2
        if worklink is not None:
            self._values["worklink"] = worklink
        if workmail is not None:
            self._values["workmail"] = workmail
        if workspaces is not None:
            self._values["workspaces"] = workspaces
        if xray is not None:
            self._values["xray"] = xray

    @builtins.property
    def accessanalyzer(self) -> typing.Optional[str]:
        """Use this to override the default service endpoint URL."""
        return self._values.get("accessanalyzer")

    @builtins.property
    def acm(self) -> typing.Optional[str]:
        """Use this to override the default service endpoint URL."""
        return self._values.get("acm")

    @builtins.property
    def acmpca(self) -> typing.Optional[str]:
        """Use this to override the default service endpoint URL."""
        return self._values.get("acmpca")

    @builtins.property
    def amplify(self) -> typing.Optional[str]:
        """Use this to override the default service endpoint URL."""
        return self._values.get("amplify")

    @builtins.property
    def apigateway(self) -> typing.Optional[str]:
        """Use this to override the default service endpoint URL."""
        return self._values.get("apigateway")

    @builtins.property
    def applicationautoscaling(self) -> typing.Optional[str]:
        """Use this to override the default service endpoint URL."""
        return self._values.get("applicationautoscaling")

    @builtins.property
    def applicationinsights(self) -> typing.Optional[str]:
        """Use this to override the default service endpoint URL."""
        return self._values.get("applicationinsights")

    @builtins.property
    def appmesh(self) -> typing.Optional[str]:
        """Use this to override the default service endpoint URL."""
        return self._values.get("appmesh")

    @builtins.property
    def appstream(self) -> typing.Optional[str]:
        """Use this to override the default service endpoint URL."""
        return self._values.get("appstream")

    @builtins.property
    def appsync(self) -> typing.Optional[str]:
        """Use this to override the default service endpoint URL."""
        return self._values.get("appsync")

    @builtins.property
    def athena(self) -> typing.Optional[str]:
        """Use this to override the default service endpoint URL."""
        return self._values.get("athena")

    @builtins.property
    def autoscaling(self) -> typing.Optional[str]:
        """Use this to override the default service endpoint URL."""
        return self._values.get("autoscaling")

    @builtins.property
    def autoscalingplans(self) -> typing.Optional[str]:
        """Use this to override the default service endpoint URL."""
        return self._values.get("autoscalingplans")

    @builtins.property
    def backup(self) -> typing.Optional[str]:
        """Use this to override the default service endpoint URL."""
        return self._values.get("backup")

    @builtins.property
    def batch(self) -> typing.Optional[str]:
        """Use this to override the default service endpoint URL."""
        return self._values.get("batch")

    @builtins.property
    def budgets(self) -> typing.Optional[str]:
        """Use this to override the default service endpoint URL."""
        return self._values.get("budgets")

    @builtins.property
    def cloud9(self) -> typing.Optional[str]:
        """Use this to override the default service endpoint URL."""
        return self._values.get("cloud9")

    @builtins.property
    def cloudformation(self) -> typing.Optional[str]:
        """Use this to override the default service endpoint URL."""
        return self._values.get("cloudformation")

    @builtins.property
    def cloudfront(self) -> typing.Optional[str]:
        """Use this to override the default service endpoint URL."""
        return self._values.get("cloudfront")

    @builtins.property
    def cloudhsm(self) -> typing.Optional[str]:
        """Use this to override the default service endpoint URL."""
        return self._values.get("cloudhsm")

    @builtins.property
    def cloudsearch(self) -> typing.Optional[str]:
        """Use this to override the default service endpoint URL."""
        return self._values.get("cloudsearch")

    @builtins.property
    def cloudtrail(self) -> typing.Optional[str]:
        """Use this to override the default service endpoint URL."""
        return self._values.get("cloudtrail")

    @builtins.property
    def cloudwatch(self) -> typing.Optional[str]:
        """Use this to override the default service endpoint URL."""
        return self._values.get("cloudwatch")

    @builtins.property
    def cloudwatchevents(self) -> typing.Optional[str]:
        """Use this to override the default service endpoint URL."""
        return self._values.get("cloudwatchevents")

    @builtins.property
    def cloudwatchlogs(self) -> typing.Optional[str]:
        """Use this to override the default service endpoint URL."""
        return self._values.get("cloudwatchlogs")

    @builtins.property
    def codeartifact(self) -> typing.Optional[str]:
        """Use this to override the default service endpoint URL."""
        return self._values.get("codeartifact")

    @builtins.property
    def codebuild(self) -> typing.Optional[str]:
        """Use this to override the default service endpoint URL."""
        return self._values.get("codebuild")

    @builtins.property
    def codecommit(self) -> typing.Optional[str]:
        """Use this to override the default service endpoint URL."""
        return self._values.get("codecommit")

    @builtins.property
    def codedeploy(self) -> typing.Optional[str]:
        """Use this to override the default service endpoint URL."""
        return self._values.get("codedeploy")

    @builtins.property
    def codepipeline(self) -> typing.Optional[str]:
        """Use this to override the default service endpoint URL."""
        return self._values.get("codepipeline")

    @builtins.property
    def cognitoidentity(self) -> typing.Optional[str]:
        """Use this to override the default service endpoint URL."""
        return self._values.get("cognitoidentity")

    @builtins.property
    def cognitoidp(self) -> typing.Optional[str]:
        """Use this to override the default service endpoint URL."""
        return self._values.get("cognitoidp")

    @builtins.property
    def configservice(self) -> typing.Optional[str]:
        """Use this to override the default service endpoint URL."""
        return self._values.get("configservice")

    @builtins.property
    def cur(self) -> typing.Optional[str]:
        """Use this to override the default service endpoint URL."""
        return self._values.get("cur")

    @builtins.property
    def dataexchange(self) -> typing.Optional[str]:
        """Use this to override the default service endpoint URL."""
        return self._values.get("dataexchange")

    @builtins.property
    def datapipeline(self) -> typing.Optional[str]:
        """Use this to override the default service endpoint URL."""
        return self._values.get("datapipeline")

    @builtins.property
    def datasync(self) -> typing.Optional[str]:
        """Use this to override the default service endpoint URL."""
        return self._values.get("datasync")

    @builtins.property
    def dax(self) -> typing.Optional[str]:
        """Use this to override the default service endpoint URL."""
        return self._values.get("dax")

    @builtins.property
    def devicefarm(self) -> typing.Optional[str]:
        """Use this to override the default service endpoint URL."""
        return self._values.get("devicefarm")

    @builtins.property
    def directconnect(self) -> typing.Optional[str]:
        """Use this to override the default service endpoint URL."""
        return self._values.get("directconnect")

    @builtins.property
    def dlm(self) -> typing.Optional[str]:
        """Use this to override the default service endpoint URL."""
        return self._values.get("dlm")

    @builtins.property
    def dms(self) -> typing.Optional[str]:
        """Use this to override the default service endpoint URL."""
        return self._values.get("dms")

    @builtins.property
    def docdb(self) -> typing.Optional[str]:
        """Use this to override the default service endpoint URL."""
        return self._values.get("docdb")

    @builtins.property
    def ds(self) -> typing.Optional[str]:
        """Use this to override the default service endpoint URL."""
        return self._values.get("ds")

    @builtins.property
    def dynamodb(self) -> typing.Optional[str]:
        """Use this to override the default service endpoint URL."""
        return self._values.get("dynamodb")

    @builtins.property
    def ec2(self) -> typing.Optional[str]:
        """Use this to override the default service endpoint URL."""
        return self._values.get("ec2")

    @builtins.property
    def ecr(self) -> typing.Optional[str]:
        """Use this to override the default service endpoint URL."""
        return self._values.get("ecr")

    @builtins.property
    def ecs(self) -> typing.Optional[str]:
        """Use this to override the default service endpoint URL."""
        return self._values.get("ecs")

    @builtins.property
    def efs(self) -> typing.Optional[str]:
        """Use this to override the default service endpoint URL."""
        return self._values.get("efs")

    @builtins.property
    def eks(self) -> typing.Optional[str]:
        """Use this to override the default service endpoint URL."""
        return self._values.get("eks")

    @builtins.property
    def elasticache(self) -> typing.Optional[str]:
        """Use this to override the default service endpoint URL."""
        return self._values.get("elasticache")

    @builtins.property
    def elasticbeanstalk(self) -> typing.Optional[str]:
        """Use this to override the default service endpoint URL."""
        return self._values.get("elasticbeanstalk")

    @builtins.property
    def elastictranscoder(self) -> typing.Optional[str]:
        """Use this to override the default service endpoint URL."""
        return self._values.get("elastictranscoder")

    @builtins.property
    def elb(self) -> typing.Optional[str]:
        """Use this to override the default service endpoint URL."""
        return self._values.get("elb")

    @builtins.property
    def emr(self) -> typing.Optional[str]:
        """Use this to override the default service endpoint URL."""
        return self._values.get("emr")

    @builtins.property
    def es(self) -> typing.Optional[str]:
        """Use this to override the default service endpoint URL."""
        return self._values.get("es")

    @builtins.property
    def firehose(self) -> typing.Optional[str]:
        """Use this to override the default service endpoint URL."""
        return self._values.get("firehose")

    @builtins.property
    def fms(self) -> typing.Optional[str]:
        """Use this to override the default service endpoint URL."""
        return self._values.get("fms")

    @builtins.property
    def forecast(self) -> typing.Optional[str]:
        """Use this to override the default service endpoint URL."""
        return self._values.get("forecast")

    @builtins.property
    def fsx(self) -> typing.Optional[str]:
        """Use this to override the default service endpoint URL."""
        return self._values.get("fsx")

    @builtins.property
    def gamelift(self) -> typing.Optional[str]:
        """Use this to override the default service endpoint URL."""
        return self._values.get("gamelift")

    @builtins.property
    def glacier(self) -> typing.Optional[str]:
        """Use this to override the default service endpoint URL."""
        return self._values.get("glacier")

    @builtins.property
    def globalaccelerator(self) -> typing.Optional[str]:
        """Use this to override the default service endpoint URL."""
        return self._values.get("globalaccelerator")

    @builtins.property
    def glue(self) -> typing.Optional[str]:
        """Use this to override the default service endpoint URL."""
        return self._values.get("glue")

    @builtins.property
    def greengrass(self) -> typing.Optional[str]:
        """Use this to override the default service endpoint URL."""
        return self._values.get("greengrass")

    @builtins.property
    def guardduty(self) -> typing.Optional[str]:
        """Use this to override the default service endpoint URL."""
        return self._values.get("guardduty")

    @builtins.property
    def iam(self) -> typing.Optional[str]:
        """Use this to override the default service endpoint URL."""
        return self._values.get("iam")

    @builtins.property
    def imagebuilder(self) -> typing.Optional[str]:
        """Use this to override the default service endpoint URL."""
        return self._values.get("imagebuilder")

    @builtins.property
    def inspector(self) -> typing.Optional[str]:
        """Use this to override the default service endpoint URL."""
        return self._values.get("inspector")

    @builtins.property
    def iot(self) -> typing.Optional[str]:
        """Use this to override the default service endpoint URL."""
        return self._values.get("iot")

    @builtins.property
    def iotanalytics(self) -> typing.Optional[str]:
        """Use this to override the default service endpoint URL."""
        return self._values.get("iotanalytics")

    @builtins.property
    def iotevents(self) -> typing.Optional[str]:
        """Use this to override the default service endpoint URL."""
        return self._values.get("iotevents")

    @builtins.property
    def kafka(self) -> typing.Optional[str]:
        """Use this to override the default service endpoint URL."""
        return self._values.get("kafka")

    @builtins.property
    def kinesis(self) -> typing.Optional[str]:
        """Use this to override the default service endpoint URL."""
        return self._values.get("kinesis")

    @builtins.property
    def kinesisanalytics(self) -> typing.Optional[str]:
        """Use this to override the default service endpoint URL."""
        return self._values.get("kinesisanalytics")

    @builtins.property
    def kinesis_analytics(self) -> typing.Optional[str]:
        """Use this to override the default service endpoint URL."""
        return self._values.get("kinesis_analytics")

    @builtins.property
    def kinesisanalyticsv2(self) -> typing.Optional[str]:
        """Use this to override the default service endpoint URL."""
        return self._values.get("kinesisanalyticsv2")

    @builtins.property
    def kinesisvideo(self) -> typing.Optional[str]:
        """Use this to override the default service endpoint URL."""
        return self._values.get("kinesisvideo")

    @builtins.property
    def kms(self) -> typing.Optional[str]:
        """Use this to override the default service endpoint URL."""
        return self._values.get("kms")

    @builtins.property
    def lakeformation(self) -> typing.Optional[str]:
        """Use this to override the default service endpoint URL."""
        return self._values.get("lakeformation")

    @builtins.property
    def lambda_(self) -> typing.Optional[str]:
        """Use this to override the default service endpoint URL."""
        return self._values.get("lambda_")

    @builtins.property
    def lexmodels(self) -> typing.Optional[str]:
        """Use this to override the default service endpoint URL."""
        return self._values.get("lexmodels")

    @builtins.property
    def licensemanager(self) -> typing.Optional[str]:
        """Use this to override the default service endpoint URL."""
        return self._values.get("licensemanager")

    @builtins.property
    def lightsail(self) -> typing.Optional[str]:
        """Use this to override the default service endpoint URL."""
        return self._values.get("lightsail")

    @builtins.property
    def macie(self) -> typing.Optional[str]:
        """Use this to override the default service endpoint URL."""
        return self._values.get("macie")

    @builtins.property
    def managedblockchain(self) -> typing.Optional[str]:
        """Use this to override the default service endpoint URL."""
        return self._values.get("managedblockchain")

    @builtins.property
    def marketplacecatalog(self) -> typing.Optional[str]:
        """Use this to override the default service endpoint URL."""
        return self._values.get("marketplacecatalog")

    @builtins.property
    def mediaconnect(self) -> typing.Optional[str]:
        """Use this to override the default service endpoint URL."""
        return self._values.get("mediaconnect")

    @builtins.property
    def mediaconvert(self) -> typing.Optional[str]:
        """Use this to override the default service endpoint URL."""
        return self._values.get("mediaconvert")

    @builtins.property
    def medialive(self) -> typing.Optional[str]:
        """Use this to override the default service endpoint URL."""
        return self._values.get("medialive")

    @builtins.property
    def mediapackage(self) -> typing.Optional[str]:
        """Use this to override the default service endpoint URL."""
        return self.