<p align="center">
  <a href="https://hotbox.corletti.xyz"><img src="./img/logo.png" alt="hotbox"></a>
</p>
<p align="center">
    <em>🚀 Run your code 📦 on Firecracker MicroVMs 🔥 in the cloud ☁️</em>
</p>
<p align="center">
<a href="https://github.com/anthonycorletti/hotbox/actions?query=workflow%3Atest" target="_blank">
    <img src="https://github.com/anthonycorletti/hotbox/workflows/test/badge.svg" alt="Test">
</a>
<a href="https://github.com/anthonycorletti/hotbox/actions?query=workflow%3Apublish" target="_blank">
    <img src="https://github.com/anthonycorletti/hotbox/workflows/publish/badge.svg" alt="publish">
</a>
<a href="https://codecov.io/gh/anthonycorletti/hotbox" target="_blank">
    <img src="https://img.shields.io/codecov/c/github/anthonycorletti/hotbox?color=%2334D058" alt="Coverage">
</a>
<a href="https://pypi.org/project/hotbox/" target="_blank">
    <img alt="PyPI" src="https://img.shields.io/pypi/v/hotbox?color=blue">
</a>
</p>

---

**Documentation**: <a href="https://hotbox.corletti.xyz" target="_blank">https://hotbox.corletti.xyz</a>

**Source Code**: <a href="https://github.com/anthonycorletti/hotbox" target="_blank">https://github.com/anthonycorletti/hotbox</a>

---

🚀 Run your code 📦 on Firecracker MicroVMs 🔥 in the cloud ☁️

## 👨‍💻 Who is this for?

- Developers who want to run:
    - Apps in the cloud, but don't want to deal with the complexity of Kubernetes (which is awesome)
    - Apps in a sandboxed environment
    - Apps in a serverless-style environment
    - CI environments in the cloud on their own servers

## 💡 What is this for?

- Learning about MicroVMs
- Rapid prototyping
- Running your own CI environments
- Running Cron jobs, backend APIs, etc (_really anything you can run in a Docker container can be run in a Firecracker MicroVM, deployed with hotbox!_)
- Making your own serverless platform
- Definitely not production... yet!

## 🎉 Featuring

Coming soon!

## 📝 Requirements

- Python 3.10+
- An AWS Account

## ⚙️ Installation

```sh
pip install hotbox
```

## 🏎️ A Quick Example

Coming soon!

## 🫶 How can I help?

- [Star the repo ⭐️ on GitHub!](https://github.com/anthonycorletti/hotbox)
- Open an [issue](https://github.com/anthonycorletti/hotbox/issues/new/choose) if you have a question, comment, feature request, or bug to report.
- Open a [pull request](https://github.com/anthonycorletti/hotbox/compare) on GitHub. I'm happy to review and merge your contributions!

## 📲 Contact

Reach out to Anthony directly on [Twitter](https://twitter.com/anthonycorletti) if you'd like to get in touch.

&nbsp;

&nbsp;
